package pt.digitalis.dif.dem.managers.impl.model.data;

import pt.digitalis.utils.common.AttributeDefinition;
import pt.digitalis.dif.model.utils.AbstractBeanAttributesDefinition;

import java.sql.Timestamp;
import java.sql.Blob;
import java.util.Date;
import java.math.BigDecimal;

import java.util.Arrays;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pt.digitalis.utils.common.collections.CaseInsensitiveHashMap;

import org.hibernate.Session;


/**
 *  Field definitions for data object {@link UserDataRequest}
 *
 * NOTE: This file is auto generated and will be overwritten in a future file generation.
 */
public class UserDataRequestFieldAttributes extends AbstractBeanAttributesDefinition{

    /** closeDate (Database column: CLOSE_DATE - When the request was closed) */
    static public AttributeDefinition closeDate =
        new AttributeDefinition("closeDate")
                .setDescription("When the request was closed")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("USER_DATA_REQUEST")
                .setDatabaseId("CLOSE_DATE")
                .setMandatory(true)
                .setMaxSize(7)
                .setType(Timestamp.class);

    /** configId (Database column: CONFIG_ID - Configuration ID (each application can have a diferent set of consents)) */
    static public AttributeDefinition configId =
        new AttributeDefinition("configId")
                .setDescription("Configuration ID (each application can have a diferent set of consents)")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("USER_DATA_REQUEST")
                .setDatabaseId("CONFIG_ID")
                .setMandatory(true)
                .setMaxSize(255)
                .setType(String.class);

    /** dataConsentUser (Database column: DATA_CONSENT_USER_ID - The user ID) */
    static public AttributeDefinition dataConsentUser =
        new AttributeDefinition("dataConsentUser")
                .setDescription("The user ID")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("USER_DATA_REQUEST")
                .setDatabaseId("DATA_CONSENT_USER_ID")
                .setMandatory(true)
                .setMaxSize(255)
                .setType(pt.digitalis.dif.dem.managers.impl.model.data.DataConsentUser.class);

    /** handlerUserId (Database column: HANDLER_USER_ID - The user that is handling the request) */
    static public AttributeDefinition handlerUserId =
        new AttributeDefinition("handlerUserId")
                .setDescription("The user that is handling the request")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("USER_DATA_REQUEST")
                .setDatabaseId("HANDLER_USER_ID")
                .setMandatory(true)
                .setMaxSize(255)
                .setType(String.class);

    /** id (Database column: ID - ID) */
    static public AttributeDefinition id =
        new AttributeDefinition("id")
                .setDescription("ID")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("USER_DATA_REQUEST")
                .setDatabaseId("ID")
                .setMandatory(true)
                .setMaxSize(255)
                .setType(Long.class);

    /** requestDate (Database column: REQUEST_DATE - The request date) */
    static public AttributeDefinition requestDate =
        new AttributeDefinition("requestDate")
                .setDescription("The request date")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("USER_DATA_REQUEST")
                .setDatabaseId("REQUEST_DATE")
                .setMandatory(true)
                .setMaxSize(7)
                .setType(Timestamp.class);

    /** requestType (Database column: REQUEST_TYPE - The request type) */
    static public AttributeDefinition requestType =
        new AttributeDefinition("requestType")
                .setDescription("The request type")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("USER_DATA_REQUEST")
                .setDatabaseId("REQUEST_TYPE")
                .setMandatory(true)
                .setMaxSize(10)
                .setType(String.class);

    /** responseDocumentId (Database column: RESPONSE_DOCUMENT_ID - The response document if any) */
    static public AttributeDefinition responseDocumentId =
        new AttributeDefinition("responseDocumentId")
                .setDescription("The response document if any")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("USER_DATA_REQUEST")
                .setDatabaseId("RESPONSE_DOCUMENT_ID")
                .setMandatory(true)
                .setMaxSize(255)
                .setType(Long.class);

    /** state (Database column: STATE - The request state) */
    static public AttributeDefinition state =
        new AttributeDefinition("state")
                .setDescription("The request state")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("USER_DATA_REQUEST")
                .setDatabaseId("STATE")
                .setMandatory(true)
                .setMaxSize(1)
                .setType(String.class);

    /**
    * Create definitions map map.
    *
    * @return the map
    */
    @Override protected CaseInsensitiveHashMap<AttributeDefinition> createDefinitionsMap(){
        CaseInsensitiveHashMap<AttributeDefinition> map = new CaseInsensitiveHashMap<AttributeDefinition>();
        map.put(closeDate.getName(),closeDate);
        map.put(configId.getName(),configId);
        map.put(dataConsentUser.getName(),dataConsentUser);
        map.put(handlerUserId.getName(),handlerUserId);
        map.put(id.getName(),id);
        map.put(requestDate.getName(),requestDate);
        map.put(requestType.getName(),requestType);
        map.put(responseDocumentId.getName(),responseDocumentId);
        map.put(state.getName(),state);

        return map;
    }
}