package pt.digitalis.dif.dem.managers.impl.model.data;


import java.util.ArrayList;
import java.util.List;
import org.hibernate.Session;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.hibernate.HibernateUtil;
import pt.digitalis.dif.model.utils.AbstractBeanRelationsAttributes;
import pt.digitalis.dif.model.utils.IBeanAttributesDataSet;

/**
 * UserGroups
* Generated on ORM Generator
* DIF build process for the Model layer
*
*/
@SuppressWarnings("serial")
public class UserGroups extends AbstractBeanRelationsAttributes implements java.io.Serializable, IBeanAttributesDataSet<UserGroups> {

    /** UserGroups attributes enumeration */
    public static class Fields
    {
        /** id column */
        public static final String ID ="id";

        /**
         * List of existing fields
         *
         * @return list of field names
         */
        public static List<String> values()
        {
            ArrayList<String> list = new ArrayList<String>();
            list.add("id");

            return list;
        }
    }

    /** Field attributes */
    public static UserGroupsFieldAttributes FieldAttributes=new UserGroupsFieldAttributes();

    /**
    * @return the field attributes definitions
    */
    @Override public UserGroupsFieldAttributes getDefinitions()
    {
        return FieldAttributes;
    }

    /**
     * The Class Relations.
     */
    public class Relations extends AbstractBeanRelationsAttributes.AbstractRelations
    {

        /**
        * Instantiates a new relations.
        *
        * @param currentPath the current path
        */
        public Relations(String currentPath)
        {
            super(currentPath);
        }
        /**
         * groups relation.
         *
         * @return the groups bean relations attributes.
         */
        public Groups.Relations groups()
        {
            Groups c = new Groups();
            return c.new Relations(this.buildPath("groups"));
        }

        /**
         * users relation.
         *
         * @return the users bean relations attributes.
         */
        public Users.Relations users()
        {
            Users c = new Users();
            return c.new Relations(this.buildPath("users"));
        }

        /**
         * the ID path.
         *
         * @return the path
         */
        public String ID()
        {
            return buildPath(Fields.ID);
        }
    }

    /** The dummy obj. */
    private static UserGroups dummyObj=new UserGroups();

    /**
     * Get UserGroups Relations .
     *
     * @return the relations
     */
    public static Relations FK()
    {
        return dummyObj.new Relations(null);
    }

    /**
    * Gets a new dataSet object for this bean
    *
    * @return the dataSet
    */
    public IDataSet<UserGroups> getDataSet()
    {
        return new HibernateDataSet<UserGroups>(UserGroups.class, HibernateUtil.getSessionFactory("DIFRepository"),
            UserGroups.getPKFieldListAsString(), UserGroups.FieldAttributes);
    }

    /**
    * Gets a new dataSet object for this bean
    *
    * @return the dataSet
    */
    public static IDataSet<UserGroups> getDataSetInstance()
    {
        return new UserGroups().getDataSet();
    }

    /**
    * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeNoGraphNavigation(java.lang.String)
    */
    @Override protected Object getAttributeNoGraphNavigation(String attributeName)
    {
        if("id".equalsIgnoreCase(attributeName))
            return id;
        if("groups".equalsIgnoreCase(attributeName))
            return groups;
        if("users".equalsIgnoreCase(attributeName))
            return users;

        return null;
    }

    /**
    * @see pt.digitalis.utils.common.IBeanAttributes#setAttribute(java.lang.String, java.lang.Object)
    */
    public void setAttribute(String attributeName,Object attributeValue)
    {
        if("id".equalsIgnoreCase(attributeName))
            id =(Long)attributeValue;
        if("groups".equalsIgnoreCase(attributeName))
            groups =(Groups)attributeValue;
        if("users".equalsIgnoreCase(attributeName))
            users =(Users)attributeValue;
    }

    // Fields

    /** id private attribute */
    private Long id;

    /** groups private attribute */
    private Groups groups;

    /** users private attribute */
    private Users users;

    /** The pojo's primary key field list names */
    private static List<String> pkFieldList;

    /**
     * Get the table fields that compose the PK
     *
     * @return the PK field list
     */
     public synchronized static List<String> getPKFieldList()
     {
         if (pkFieldList == null)
         {
             pkFieldList = new ArrayList<String>();
             pkFieldList.add("id");
         }

         return pkFieldList;
     }

    /**
     * Get the table fields that compose the PK as a comma separated field name list
     *
     * @return the PK field list as a string
     */
     public static String getPKFieldListAsString()
     {
         StringBuffer buffer = new StringBuffer();

         for (int i = 0; i < getPKFieldList().size(); i++)
         {
             if (i != 0)
                 buffer.append(",");

             buffer.append(getPKFieldList().get(i));
         }

         return buffer.toString();
     }

    /**
     * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeAsString(java.lang.String)
     */
     @Override
     public String getAttributeAsString(String attributeName)
     {

        Object value = getAttribute(attributeName);

        if (value == null)
            return "";
        else {
            return value.toString().trim();
        }
     }

    // Constructors

    /**
     * default constructor
     */
    public UserGroups() {
    }


    /**
     * full constructor
	 *
     * @param groups the groups
     * @param users the users
     */
    public UserGroups(Groups groups, Users users) {
        this.groups = groups;
        this.users = users;
    }

    // Property accessors
    
    /**       
     * id getter method
     *
     * @return id method
     */
    public Long getId() {
        return this.id;
    }
    
    /**       
     * id setter method
     *
     * @param id the id
     *
     * @return UserGroups modified instance
     */
    public UserGroups setId(Long id) {
        this.id = id;
        
        return this;
    }
    /**       
     * groups getter method
     *
     * @return groups method
     */
    public Groups getGroups() {
        return this.groups;
    }
    
    /**       
     * groups setter method
     *
     * @param groups the groups
     *
     * @return UserGroups modified instance
     */
    public UserGroups setGroups(Groups groups) {
        this.groups = groups;
        
        return this;
    }
    /**       
     * users getter method
     *
     * @return users method
     */
    public Users getUsers() {
        return this.users;
    }
    
    /**       
     * users setter method
     *
     * @param users the users
     *
     * @return UserGroups modified instance
     */
    public UserGroups setUsers(Users users) {
        this.users = users;
        
        return this;
    }

    /**
     * Creates a String representation of the UserGroups object
     *
     * @return the compiled String
     */
    @Override
    public String toString() {
	    StringBuffer buffer = new StringBuffer();

        buffer.append(getClass().getName()).append("@").append(Integer.toHexString(hashCode())).append(" [");

        buffer.append("id").append("='").append(getId()).append("' ");			
        buffer.append("]");
      
        return buffer.toString();
    }

    /**
     * Compares the String representation of the UserGroups object
     *
     * @param other The object to compare to
     *
     * @return true of the objects are equal
     */
    public boolean equals(UserGroups other) {
        	return this.toString().equals(other.toString());
    }
    /**
     * @see pt.digitalis.utils.common.IBeanAttributes#setAttributeFromString(java.lang.String, java.lang.String)
     */
    public void setAttributeFromString(String attributeName, String attributeValue) {
        if ("id".equalsIgnoreCase(attributeName))
            this.id = Long.valueOf(attributeValue);

    }


    /**
     * Instanciates an Hibernate proxy data object (does not load it from the database, provides lazy load for that)
     *
     * @param session the session
     * @param id      the id
     *
     * @return the proxy
     */
    public static UserGroups getProxy(Session session, Long id)
    {
        return(UserGroups)session.load(UserGroups.class,id);
    }

    /**
    * Instanciates an Hibernate proxy data object (does not load it from the database, provides lazy load for that)
    *
    * @param id      the id
    *
    * @return the proxy
    */
    public static UserGroups getProxy(Long id)
    {
        Session session = HibernateUtil.getSessionFactory("DIFRepository").getCurrentSession();
        boolean wasActive = session.getTransaction().isActive();

        if (!wasActive)
            session.beginTransaction();

        UserGroups result = (UserGroups)session.load(UserGroups.class,id);

        if (!wasActive)
            session.getTransaction().commit();

        return result;
    }


    /**
     * Instanciates an Hibernate data object
     *
     * @param session the session
     * @param id      the id
     *
     * @return the instance
     */
    public static UserGroups getInstance(Session session, Long id)
    {
        return(UserGroups)session.get(UserGroups.class,id);
    }

    /**
    * Instanciates an Hibernate data object
    *
    * @param id      the id
    *
    * @return the instance
    */
    public static UserGroups getInstance(Long id)
    {
        Session session = HibernateUtil.getSessionFactory("DIFRepository").getCurrentSession();
        boolean wasActive = session.getTransaction().isActive();

        if (!wasActive)
            session.beginTransaction();

        UserGroups result = (UserGroups)session.get(UserGroups.class,id);

        if (!wasActive)
            session.getTransaction().commit();

        return result;
    }

}
