package pt.digitalis.dif.dem.managers.impl.model.data;


import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hibernate.Session;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.hibernate.HibernateUtil;
import pt.digitalis.dif.model.utils.AbstractBeanRelationsAttributes;
import pt.digitalis.dif.model.utils.IBeanAttributesDataSet;

/**
 * Workflow
* Generated on ORM Generator
* DIF build process for the Model layer
*
*/
@SuppressWarnings("serial")
public class Workflow extends AbstractBeanRelationsAttributes implements java.io.Serializable, IBeanAttributesDataSet<Workflow> {

    /** Workflow attributes enumeration */
    public static class Fields
    {
        /** id column */
        public static final String ID ="id";
        /** applicationId column */
        public static final String APPLICATIONID ="applicationId";
        /** name column */
        public static final String NAME ="name";
        /** description column */
        public static final String DESCRIPTION ="description";
        /** businessClassId column */
        public static final String BUSINESSCLASSID ="businessClassId";
        /** version column */
        public static final String VERSION ="version";
        /** businessVersion column */
        public static final String BUSINESSVERSION ="businessVersion";
        /** isCustomized column */
        public static final String ISCUSTOMIZED ="isCustomized";
        /** isActive column */
        public static final String ISACTIVE ="isActive";

        /**
         * List of existing fields
         *
         * @return list of field names
         */
        public static List<String> values()
        {
            ArrayList<String> list = new ArrayList<String>();
            list.add("id");
            list.add("applicationId");
            list.add("name");
            list.add("description");
            list.add("businessClassId");
            list.add("version");
            list.add("businessVersion");
            list.add("isCustomized");
            list.add("isActive");

            return list;
        }
    }

    /** Field attributes */
    public static WorkflowFieldAttributes FieldAttributes=new WorkflowFieldAttributes();

    /**
    * @return the field attributes definitions
    */
    @Override public WorkflowFieldAttributes getDefinitions()
    {
        return FieldAttributes;
    }

    /**
     * The Class Relations.
     */
    public class Relations extends AbstractBeanRelationsAttributes.AbstractRelations
    {

        /**
        * Instantiates a new relations.
        *
        * @param currentPath the current path
        */
        public Relations(String currentPath)
        {
            super(currentPath);
        }
        /**
         * fileBundle relation.
         *
         * @return the fileBundle bean relations attributes.
         */
        public FileBundle.Relations fileBundle()
        {
            FileBundle c = new FileBundle();
            return c.new Relations(this.buildPath("fileBundle"));
        }

        /**
         * workflowActionLists relation.
         *
         * @return the workflowActionLists bean relations attributes.
         */
        public WorkflowActionList.Relations workflowActionLists()
        {
            WorkflowActionList c = new WorkflowActionList();
            return c.new Relations(this.buildPath("workflowActionLists"));
        }

        /**
         * workflowInstances relation.
         *
         * @return the workflowInstances bean relations attributes.
         */
        public WorkflowInstance.Relations workflowInstances()
        {
            WorkflowInstance c = new WorkflowInstance();
            return c.new Relations(this.buildPath("workflowInstances"));
        }

        /**
         * workflowFileAcls relation.
         *
         * @return the workflowFileAcls bean relations attributes.
         */
        public WorkflowFileAcl.Relations workflowFileAcls()
        {
            WorkflowFileAcl c = new WorkflowFileAcl();
            return c.new Relations(this.buildPath("workflowFileAcls"));
        }

        /**
         * workflowStates relation.
         *
         * @return the workflowStates bean relations attributes.
         */
        public WorkflowState.Relations workflowStates()
        {
            WorkflowState c = new WorkflowState();
            return c.new Relations(this.buildPath("workflowStates"));
        }

        /**
         * workflowUserProfiles relation.
         *
         * @return the workflowUserProfiles bean relations attributes.
         */
        public WorkflowUserProfile.Relations workflowUserProfiles()
        {
            WorkflowUserProfile c = new WorkflowUserProfile();
            return c.new Relations(this.buildPath("workflowUserProfiles"));
        }

        /**
         * workflowCustomForms relation.
         *
         * @return the workflowCustomForms bean relations attributes.
         */
        public WorkflowCustomForm.Relations workflowCustomForms()
        {
            WorkflowCustomForm c = new WorkflowCustomForm();
            return c.new Relations(this.buildPath("workflowCustomForms"));
        }

        /**
         * the ID path.
         *
         * @return the path
         */
        public String ID()
        {
            return buildPath(Fields.ID);
        }
        /**
         * the APPLICATIONID path.
         *
         * @return the path
         */
        public String APPLICATIONID()
        {
            return buildPath(Fields.APPLICATIONID);
        }
        /**
         * the NAME path.
         *
         * @return the path
         */
        public String NAME()
        {
            return buildPath(Fields.NAME);
        }
        /**
         * the DESCRIPTION path.
         *
         * @return the path
         */
        public String DESCRIPTION()
        {
            return buildPath(Fields.DESCRIPTION);
        }
        /**
         * the BUSINESSCLASSID path.
         *
         * @return the path
         */
        public String BUSINESSCLASSID()
        {
            return buildPath(Fields.BUSINESSCLASSID);
        }
        /**
         * the VERSION path.
         *
         * @return the path
         */
        public String VERSION()
        {
            return buildPath(Fields.VERSION);
        }
        /**
         * the BUSINESSVERSION path.
         *
         * @return the path
         */
        public String BUSINESSVERSION()
        {
            return buildPath(Fields.BUSINESSVERSION);
        }
        /**
         * the ISCUSTOMIZED path.
         *
         * @return the path
         */
        public String ISCUSTOMIZED()
        {
            return buildPath(Fields.ISCUSTOMIZED);
        }
        /**
         * the ISACTIVE path.
         *
         * @return the path
         */
        public String ISACTIVE()
        {
            return buildPath(Fields.ISACTIVE);
        }
    }

    /** The dummy obj. */
    private static Workflow dummyObj=new Workflow();

    /**
     * Get Workflow Relations .
     *
     * @return the relations
     */
    public static Relations FK()
    {
        return dummyObj.new Relations(null);
    }

    /**
    * Gets a new dataSet object for this bean
    *
    * @return the dataSet
    */
    public IDataSet<Workflow> getDataSet()
    {
        return new HibernateDataSet<Workflow>(Workflow.class, HibernateUtil.getSessionFactory("DIFRepository"),
            Workflow.getPKFieldListAsString(), Workflow.FieldAttributes);
    }

    /**
    * Gets a new dataSet object for this bean
    *
    * @return the dataSet
    */
    public static IDataSet<Workflow> getDataSetInstance()
    {
        return new Workflow().getDataSet();
    }

    /**
    * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeNoGraphNavigation(java.lang.String)
    */
    @Override protected Object getAttributeNoGraphNavigation(String attributeName)
    {
        if("id".equalsIgnoreCase(attributeName))
            return id;
        if("fileBundle".equalsIgnoreCase(attributeName))
            return fileBundle;
        if("applicationId".equalsIgnoreCase(attributeName))
            return applicationId;
        if("name".equalsIgnoreCase(attributeName))
            return name;
        if("description".equalsIgnoreCase(attributeName))
            return description;
        if("businessClassId".equalsIgnoreCase(attributeName))
            return businessClassId;
        if("version".equalsIgnoreCase(attributeName))
            return version;
        if("businessVersion".equalsIgnoreCase(attributeName))
            return businessVersion;
        if("isCustomized".equalsIgnoreCase(attributeName))
            return isCustomized;
        if("isActive".equalsIgnoreCase(attributeName))
            return isActive;
        if("workflowActionLists".equalsIgnoreCase(attributeName))
            return workflowActionLists;
        if("workflowInstances".equalsIgnoreCase(attributeName))
            return workflowInstances;
        if("workflowFileAcls".equalsIgnoreCase(attributeName))
            return workflowFileAcls;
        if("workflowStates".equalsIgnoreCase(attributeName))
            return workflowStates;
        if("workflowUserProfiles".equalsIgnoreCase(attributeName))
            return workflowUserProfiles;
        if("workflowCustomForms".equalsIgnoreCase(attributeName))
            return workflowCustomForms;

        return null;
    }

    /**
    * @see pt.digitalis.utils.common.IBeanAttributes#setAttribute(java.lang.String, java.lang.Object)
    */
    public void setAttribute(String attributeName,Object attributeValue)
    {
        if("id".equalsIgnoreCase(attributeName))
            id =(Long)attributeValue;
        if("fileBundle".equalsIgnoreCase(attributeName))
            fileBundle =(FileBundle)attributeValue;
        if("applicationId".equalsIgnoreCase(attributeName))
            applicationId =(String)attributeValue;
        if("name".equalsIgnoreCase(attributeName))
            name =(String)attributeValue;
        if("description".equalsIgnoreCase(attributeName))
            description =(String)attributeValue;
        if("businessClassId".equalsIgnoreCase(attributeName))
            businessClassId =(String)attributeValue;
        if("version".equalsIgnoreCase(attributeName))
            version =(Long)attributeValue;
        if("businessVersion".equalsIgnoreCase(attributeName))
            businessVersion =(Long)attributeValue;
        if("isCustomized".equalsIgnoreCase(attributeName))
            isCustomized =(Boolean)attributeValue;
        if("isActive".equalsIgnoreCase(attributeName))
            isActive =(Boolean)attributeValue;
        if("workflowActionLists".equalsIgnoreCase(attributeName))
            workflowActionLists =(Set<WorkflowActionList>)attributeValue;
        if("workflowInstances".equalsIgnoreCase(attributeName))
            workflowInstances =(Set<WorkflowInstance>)attributeValue;
        if("workflowFileAcls".equalsIgnoreCase(attributeName))
            workflowFileAcls =(Set<WorkflowFileAcl>)attributeValue;
        if("workflowStates".equalsIgnoreCase(attributeName))
            workflowStates =(Set<WorkflowState>)attributeValue;
        if("workflowUserProfiles".equalsIgnoreCase(attributeName))
            workflowUserProfiles =(Set<WorkflowUserProfile>)attributeValue;
        if("workflowCustomForms".equalsIgnoreCase(attributeName))
            workflowCustomForms =(Set<WorkflowCustomForm>)attributeValue;
    }

    // Fields

    /** id private attribute */
    private Long id;

    /** fileBundle private attribute */
    private FileBundle fileBundle;

    /** applicationId private attribute */
    private String applicationId;

    /** name private attribute */
    private String name;

    /** description private attribute */
    private String description;

    /** businessClassId private attribute */
    private String businessClassId;

    /** version private attribute */
    private Long version;

    /** businessVersion private attribute */
    private Long businessVersion;

    /** isCustomized private attribute */
    private boolean isCustomized;

    /** isActive private attribute */
    private boolean isActive;

    /** workflowActionLists private attribute */
    private Set<WorkflowActionList> workflowActionLists = new HashSet<WorkflowActionList>(0);

    /** workflowInstances private attribute */
    private Set<WorkflowInstance> workflowInstances = new HashSet<WorkflowInstance>(0);

    /** workflowFileAcls private attribute */
    private Set<WorkflowFileAcl> workflowFileAcls = new HashSet<WorkflowFileAcl>(0);

    /** workflowStates private attribute */
    private Set<WorkflowState> workflowStates = new HashSet<WorkflowState>(0);

    /** workflowUserProfiles private attribute */
    private Set<WorkflowUserProfile> workflowUserProfiles = new HashSet<WorkflowUserProfile>(0);

    /** workflowCustomForms private attribute */
    private Set<WorkflowCustomForm> workflowCustomForms = new HashSet<WorkflowCustomForm>(0);

    /** The pojo's primary key field list names */
    private static List<String> pkFieldList;

    /**
     * Get the table fields that compose the PK
     *
     * @return the PK field list
     */
     public synchronized static List<String> getPKFieldList()
     {
         if (pkFieldList == null)
         {
             pkFieldList = new ArrayList<String>();
             pkFieldList.add("id");
         }

         return pkFieldList;
     }

    /**
     * Get the table fields that compose the PK as a comma separated field name list
     *
     * @return the PK field list as a string
     */
     public static String getPKFieldListAsString()
     {
         StringBuffer buffer = new StringBuffer();

         for (int i = 0; i < getPKFieldList().size(); i++)
         {
             if (i != 0)
                 buffer.append(",");

             buffer.append(getPKFieldList().get(i));
         }

         return buffer.toString();
     }

    /**
     * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeAsString(java.lang.String)
     */
     @Override
     public String getAttributeAsString(String attributeName)
     {

        Object value = getAttribute(attributeName);

        if (value == null)
            return "";
        else {
            return value.toString().trim();
        }
     }

    // Constructors

    /**
     * default constructor
     */
    public Workflow() {
    }

	/** 
	 * minimal constructor
	 *
     * @param applicationId the applicationId
     * @param name the name
    }
	 */
    public Workflow(String applicationId, String name) {
        this.applicationId = applicationId;
        this.name = name;
    }

    /**
     * full constructor
	 *
     * @param fileBundle the fileBundle
     * @param applicationId the applicationId
     * @param name the name
     * @param description the description
     * @param businessClassId the businessClassId
     * @param version the version
     * @param businessVersion the businessVersion
     * @param isCustomized the isCustomized
     * @param isActive the isActive
     * @param workflowActionLists the workflowActionLists
     * @param workflowInstances the workflowInstances
     * @param workflowFileAcls the workflowFileAcls
     * @param workflowStates the workflowStates
     * @param workflowUserProfiles the workflowUserProfiles
     * @param workflowCustomForms the workflowCustomForms
     */
    public Workflow(FileBundle fileBundle, String applicationId, String name, String description, String businessClassId, Long version, Long businessVersion, boolean isCustomized, boolean isActive, Set<WorkflowActionList> workflowActionLists, Set<WorkflowInstance> workflowInstances, Set<WorkflowFileAcl> workflowFileAcls, Set<WorkflowState> workflowStates, Set<WorkflowUserProfile> workflowUserProfiles, Set<WorkflowCustomForm> workflowCustomForms) {
        this.fileBundle = fileBundle;
        this.applicationId = applicationId;
        this.name = name;
        this.description = description;
        this.businessClassId = businessClassId;
        this.version = version;
        this.businessVersion = businessVersion;
        this.isCustomized = isCustomized;
        this.isActive = isActive;
        this.workflowActionLists = workflowActionLists;
        this.workflowInstances = workflowInstances;
        this.workflowFileAcls = workflowFileAcls;
        this.workflowStates = workflowStates;
        this.workflowUserProfiles = workflowUserProfiles;
        this.workflowCustomForms = workflowCustomForms;
    }

    // Property accessors
    
    /**       
     * id getter method
     *
     * @return id method
     */
    public Long getId() {
        return this.id;
    }
    
    /**       
     * id setter method
     *
     * @param id the id
     *
     * @return Workflow modified instance
     */
    public Workflow setId(Long id) {
        this.id = id;
        
        return this;
    }
    /**       
     * fileBundle getter method
     *
     * @return fileBundle method
     */
    public FileBundle getFileBundle() {
        return this.fileBundle;
    }
    
    /**       
     * fileBundle setter method
     *
     * @param fileBundle the fileBundle
     *
     * @return Workflow modified instance
     */
    public Workflow setFileBundle(FileBundle fileBundle) {
        this.fileBundle = fileBundle;
        
        return this;
    }
    /**       
     * applicationId getter method
     *
     * @return applicationId method
     */
    public String getApplicationId() {
        return this.applicationId;
    }
    
    /**       
     * applicationId setter method
     *
     * @param applicationId the applicationId
     *
     * @return Workflow modified instance
     */
    public Workflow setApplicationId(String applicationId) {
        this.applicationId = applicationId;
        
        return this;
    }
    /**       
     * name getter method
     *
     * @return name method
     */
    public String getName() {
        return this.name;
    }
    
    /**       
     * name setter method
     *
     * @param name the name
     *
     * @return Workflow modified instance
     */
    public Workflow setName(String name) {
        this.name = name;
        
        return this;
    }
    /**       
     * description getter method
     *
     * @return description method
     */
    public String getDescription() {
        return this.description;
    }
    
    /**       
     * description setter method
     *
     * @param description the description
     *
     * @return Workflow modified instance
     */
    public Workflow setDescription(String description) {
        this.description = description;
        
        return this;
    }
    /**       
     * businessClassId getter method
     *
     * @return businessClassId method
     */
    public String getBusinessClassId() {
        return this.businessClassId;
    }
    
    /**       
     * businessClassId setter method
     *
     * @param businessClassId the businessClassId
     *
     * @return Workflow modified instance
     */
    public Workflow setBusinessClassId(String businessClassId) {
        this.businessClassId = businessClassId;
        
        return this;
    }
    /**       
     * version getter method
     *
     * @return version method
     */
    public Long getVersion() {
        return this.version;
    }
    
    /**       
     * version setter method
     *
     * @param version the version
     *
     * @return Workflow modified instance
     */
    public Workflow setVersion(Long version) {
        this.version = version;
        
        return this;
    }
    /**       
     * businessVersion getter method
     *
     * @return businessVersion method
     */
    public Long getBusinessVersion() {
        return this.businessVersion;
    }
    
    /**       
     * businessVersion setter method
     *
     * @param businessVersion the businessVersion
     *
     * @return Workflow modified instance
     */
    public Workflow setBusinessVersion(Long businessVersion) {
        this.businessVersion = businessVersion;
        
        return this;
    }
    /**       
     * isCustomized getter method
     *
     * @return isCustomized method
     */
    public boolean isIsCustomized() {
        return this.isCustomized;
    }
    
    /**       
     * isCustomized setter method
     *
     * @param isCustomized the isCustomized
     *
     * @return Workflow modified instance
     */
    public Workflow setIsCustomized(boolean isCustomized) {
        this.isCustomized = isCustomized;
        
        return this;
    }
    /**       
     * isActive getter method
     *
     * @return isActive method
     */
    public boolean isIsActive() {
        return this.isActive;
    }
    
    /**       
     * isActive setter method
     *
     * @param isActive the isActive
     *
     * @return Workflow modified instance
     */
    public Workflow setIsActive(boolean isActive) {
        this.isActive = isActive;
        
        return this;
    }
    /**       
     * workflowActionLists getter method
     *
     * @return workflowActionLists method
     */
    public Set<WorkflowActionList> getWorkflowActionLists() {
        return this.workflowActionLists;
    }
    
    /**       
     * workflowActionLists setter method
     *
     * @param workflowActionLists the workflowActionLists
     *
     * @return Workflow modified instance
     */
    public Workflow setWorkflowActionLists(Set<WorkflowActionList> workflowActionLists) {
        this.workflowActionLists = workflowActionLists;
        
        return this;
    }
    /**       
     * workflowInstances getter method
     *
     * @return workflowInstances method
     */
    public Set<WorkflowInstance> getWorkflowInstances() {
        return this.workflowInstances;
    }
    
    /**       
     * workflowInstances setter method
     *
     * @param workflowInstances the workflowInstances
     *
     * @return Workflow modified instance
     */
    public Workflow setWorkflowInstances(Set<WorkflowInstance> workflowInstances) {
        this.workflowInstances = workflowInstances;
        
        return this;
    }
    /**       
     * workflowFileAcls getter method
     *
     * @return workflowFileAcls method
     */
    public Set<WorkflowFileAcl> getWorkflowFileAcls() {
        return this.workflowFileAcls;
    }
    
    /**       
     * workflowFileAcls setter method
     *
     * @param workflowFileAcls the workflowFileAcls
     *
     * @return Workflow modified instance
     */
    public Workflow setWorkflowFileAcls(Set<WorkflowFileAcl> workflowFileAcls) {
        this.workflowFileAcls = workflowFileAcls;
        
        return this;
    }
    /**       
     * workflowStates getter method
     *
     * @return workflowStates method
     */
    public Set<WorkflowState> getWorkflowStates() {
        return this.workflowStates;
    }
    
    /**       
     * workflowStates setter method
     *
     * @param workflowStates the workflowStates
     *
     * @return Workflow modified instance
     */
    public Workflow setWorkflowStates(Set<WorkflowState> workflowStates) {
        this.workflowStates = workflowStates;
        
        return this;
    }
    /**       
     * workflowUserProfiles getter method
     *
     * @return workflowUserProfiles method
     */
    public Set<WorkflowUserProfile> getWorkflowUserProfiles() {
        return this.workflowUserProfiles;
    }
    
    /**       
     * workflowUserProfiles setter method
     *
     * @param workflowUserProfiles the workflowUserProfiles
     *
     * @return Workflow modified instance
     */
    public Workflow setWorkflowUserProfiles(Set<WorkflowUserProfile> workflowUserProfiles) {
        this.workflowUserProfiles = workflowUserProfiles;
        
        return this;
    }
    /**       
     * workflowCustomForms getter method
     *
     * @return workflowCustomForms method
     */
    public Set<WorkflowCustomForm> getWorkflowCustomForms() {
        return this.workflowCustomForms;
    }
    
    /**       
     * workflowCustomForms setter method
     *
     * @param workflowCustomForms the workflowCustomForms
     *
     * @return Workflow modified instance
     */
    public Workflow setWorkflowCustomForms(Set<WorkflowCustomForm> workflowCustomForms) {
        this.workflowCustomForms = workflowCustomForms;
        
        return this;
    }

    /**
     * Creates a String representation of the Workflow object
     *
     * @return the compiled String
     */
    @Override
    public String toString() {
	    StringBuffer buffer = new StringBuffer();

        buffer.append(getClass().getName()).append("@").append(Integer.toHexString(hashCode())).append(" [");

        buffer.append("id").append("='").append(getId()).append("' ");			
        buffer.append("applicationId").append("='").append(getApplicationId()).append("' ");			
        buffer.append("name").append("='").append(getName()).append("' ");			
        buffer.append("description").append("='").append(getDescription()).append("' ");			
        buffer.append("businessClassId").append("='").append(getBusinessClassId()).append("' ");			
        buffer.append("version").append("='").append(getVersion()).append("' ");			
        buffer.append("businessVersion").append("='").append(getBusinessVersion()).append("' ");			
        buffer.append("isCustomized").append("='").append(isIsCustomized()).append("' ");			
        buffer.append("isActive").append("='").append(isIsActive()).append("' ");			
        buffer.append("]");
      
        return buffer.toString();
    }

    /**
     * Compares the String representation of the Workflow object
     *
     * @param other The object to compare to
     *
     * @return true of the objects are equal
     */
    public boolean equals(Workflow other) {
        	return this.toString().equals(other.toString());
    }
    /**
     * @see pt.digitalis.utils.common.IBeanAttributes#setAttributeFromString(java.lang.String, java.lang.String)
     */
    public void setAttributeFromString(String attributeName, String attributeValue) {
        if ("id".equalsIgnoreCase(attributeName))
            this.id = Long.valueOf(attributeValue);

        if ("applicationId".equalsIgnoreCase(attributeName))
        	this.applicationId = attributeValue;

        if ("name".equalsIgnoreCase(attributeName))
        	this.name = attributeValue;

        if ("description".equalsIgnoreCase(attributeName))
        	this.description = attributeValue;

        if ("businessClassId".equalsIgnoreCase(attributeName))
        	this.businessClassId = attributeValue;

        if ("version".equalsIgnoreCase(attributeName))
            this.version = Long.valueOf(attributeValue);

        if ("businessVersion".equalsIgnoreCase(attributeName))
            this.businessVersion = Long.valueOf(attributeValue);

        if ("isCustomized".equalsIgnoreCase(attributeName))
            this.isCustomized = Boolean.valueOf(attributeValue);

        if ("isActive".equalsIgnoreCase(attributeName))
            this.isActive = Boolean.valueOf(attributeValue);

    }


    /**
     * Instanciates an Hibernate proxy data object (does not load it from the database, provides lazy load for that)
     *
     * @param session the session
     * @param id      the id
     *
     * @return the proxy
     */
    public static Workflow getProxy(Session session, Long id)
    {
        return(Workflow)session.load(Workflow.class,id);
    }

    /**
    * Instanciates an Hibernate proxy data object (does not load it from the database, provides lazy load for that)
    *
    * @param id      the id
    *
    * @return the proxy
    */
    public static Workflow getProxy(Long id)
    {
        Session session = HibernateUtil.getSessionFactory("DIFRepository").getCurrentSession();
        boolean wasActive = session.getTransaction().isActive();

        if (!wasActive)
            session.beginTransaction();

        Workflow result = (Workflow)session.load(Workflow.class,id);

        if (!wasActive)
            session.getTransaction().commit();

        return result;
    }


    /**
     * Instanciates an Hibernate data object
     *
     * @param session the session
     * @param id      the id
     *
     * @return the instance
     */
    public static Workflow getInstance(Session session, Long id)
    {
        return(Workflow)session.get(Workflow.class,id);
    }

    /**
    * Instanciates an Hibernate data object
    *
    * @param id      the id
    *
    * @return the instance
    */
    public static Workflow getInstance(Long id)
    {
        Session session = HibernateUtil.getSessionFactory("DIFRepository").getCurrentSession();
        boolean wasActive = session.getTransaction().isActive();

        if (!wasActive)
            session.beginTransaction();

        Workflow result = (Workflow)session.get(Workflow.class,id);

        if (!wasActive)
            session.getTransaction().commit();

        return result;
    }

}
