package pt.digitalis.dif.dem.managers.impl.model.data;


import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hibernate.Session;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.hibernate.HibernateUtil;
import pt.digitalis.dif.model.utils.AbstractBeanRelationsAttributes;
import pt.digitalis.dif.model.utils.IBeanAttributesDataSet;

/**
 * WorkflowActionList
* Generated on ORM Generator
* DIF build process for the Model layer
*
*/
@SuppressWarnings("serial")
public class WorkflowActionList extends AbstractBeanRelationsAttributes implements java.io.Serializable, IBeanAttributesDataSet<WorkflowActionList> {

    /** WorkflowActionList attributes enumeration */
    public static class Fields
    {
        /** id column */
        public static final String ID ="id";
        /** name column */
        public static final String NAME ="name";

        /**
         * List of existing fields
         *
         * @return list of field names
         */
        public static List<String> values()
        {
            ArrayList<String> list = new ArrayList<String>();
            list.add("id");
            list.add("name");

            return list;
        }
    }

    /** Field attributes */
    public static WorkflowActionListFieldAttributes FieldAttributes=new WorkflowActionListFieldAttributes();

    /**
    * @return the field attributes definitions
    */
    @Override public WorkflowActionListFieldAttributes getDefinitions()
    {
        return FieldAttributes;
    }

    /**
     * The Class Relations.
     */
    public class Relations extends AbstractBeanRelationsAttributes.AbstractRelations
    {

        /**
        * Instantiates a new relations.
        *
        * @param currentPath the current path
        */
        public Relations(String currentPath)
        {
            super(currentPath);
        }
        /**
         * workflow relation.
         *
         * @return the workflow bean relations attributes.
         */
        public Workflow.Relations workflow()
        {
            Workflow c = new Workflow();
            return c.new Relations(this.buildPath("workflow"));
        }

        /**
         * workflowStateActions relation.
         *
         * @return the workflowStateActions bean relations attributes.
         */
        public WorkflowStateAction.Relations workflowStateActions()
        {
            WorkflowStateAction c = new WorkflowStateAction();
            return c.new Relations(this.buildPath("workflowStateActions"));
        }

        /**
         * workflowStatesForOnExitActionListId relation.
         *
         * @return the workflowStatesForOnExitActionListId bean relations attributes.
         */
        public WorkflowState.Relations workflowStatesForOnExitActionListId()
        {
            WorkflowState c = new WorkflowState();
            return c.new Relations(this.buildPath("workflowStatesForOnExitActionListId"));
        }

        /**
         * workflowActionListItems relation.
         *
         * @return the workflowActionListItems bean relations attributes.
         */
        public WorkflowActionListItem.Relations workflowActionListItems()
        {
            WorkflowActionListItem c = new WorkflowActionListItem();
            return c.new Relations(this.buildPath("workflowActionListItems"));
        }

        /**
         * workflowStatesForOnEnterActionListId relation.
         *
         * @return the workflowStatesForOnEnterActionListId bean relations attributes.
         */
        public WorkflowState.Relations workflowStatesForOnEnterActionListId()
        {
            WorkflowState c = new WorkflowState();
            return c.new Relations(this.buildPath("workflowStatesForOnEnterActionListId"));
        }

        /**
         * the ID path.
         *
         * @return the path
         */
        public String ID()
        {
            return buildPath(Fields.ID);
        }
        /**
         * the NAME path.
         *
         * @return the path
         */
        public String NAME()
        {
            return buildPath(Fields.NAME);
        }
    }

    /** The dummy obj. */
    private static WorkflowActionList dummyObj=new WorkflowActionList();

    /**
     * Get WorkflowActionList Relations .
     *
     * @return the relations
     */
    public static Relations FK()
    {
        return dummyObj.new Relations(null);
    }

    /**
    * Gets a new dataSet object for this bean
    *
    * @return the dataSet
    */
    public IDataSet<WorkflowActionList> getDataSet()
    {
        return new HibernateDataSet<WorkflowActionList>(WorkflowActionList.class, HibernateUtil.getSessionFactory("DIFRepository"),
            WorkflowActionList.getPKFieldListAsString(), WorkflowActionList.FieldAttributes);
    }

    /**
    * Gets a new dataSet object for this bean
    *
    * @return the dataSet
    */
    public static IDataSet<WorkflowActionList> getDataSetInstance()
    {
        return new WorkflowActionList().getDataSet();
    }

    /**
    * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeNoGraphNavigation(java.lang.String)
    */
    @Override protected Object getAttributeNoGraphNavigation(String attributeName)
    {
        if("id".equalsIgnoreCase(attributeName))
            return id;
        if("workflow".equalsIgnoreCase(attributeName))
            return workflow;
        if("name".equalsIgnoreCase(attributeName))
            return name;
        if("workflowStateActions".equalsIgnoreCase(attributeName))
            return workflowStateActions;
        if("workflowStatesForOnExitActionListId".equalsIgnoreCase(attributeName))
            return workflowStatesForOnExitActionListId;
        if("workflowActionListItems".equalsIgnoreCase(attributeName))
            return workflowActionListItems;
        if("workflowStatesForOnEnterActionListId".equalsIgnoreCase(attributeName))
            return workflowStatesForOnEnterActionListId;

        return null;
    }

    /**
    * @see pt.digitalis.utils.common.IBeanAttributes#setAttribute(java.lang.String, java.lang.Object)
    */
    public void setAttribute(String attributeName,Object attributeValue)
    {
        if("id".equalsIgnoreCase(attributeName))
            id =(Long)attributeValue;
        if("workflow".equalsIgnoreCase(attributeName))
            workflow =(Workflow)attributeValue;
        if("name".equalsIgnoreCase(attributeName))
            name =(String)attributeValue;
        if("workflowStateActions".equalsIgnoreCase(attributeName))
            workflowStateActions =(Set<WorkflowStateAction>)attributeValue;
        if("workflowStatesForOnExitActionListId".equalsIgnoreCase(attributeName))
            workflowStatesForOnExitActionListId =(Set<WorkflowState>)attributeValue;
        if("workflowActionListItems".equalsIgnoreCase(attributeName))
            workflowActionListItems =(Set<WorkflowActionListItem>)attributeValue;
        if("workflowStatesForOnEnterActionListId".equalsIgnoreCase(attributeName))
            workflowStatesForOnEnterActionListId =(Set<WorkflowState>)attributeValue;
    }

    // Fields

    /** id private attribute */
    private Long id;

    /** workflow private attribute */
    private Workflow workflow;

    /** name private attribute */
    private String name;

    /** workflowStateActions private attribute */
    private Set<WorkflowStateAction> workflowStateActions = new HashSet<WorkflowStateAction>(0);

    /** workflowStatesForOnExitActionListId private attribute */
    private Set<WorkflowState> workflowStatesForOnExitActionListId = new HashSet<WorkflowState>(0);

    /** workflowActionListItems private attribute */
    private Set<WorkflowActionListItem> workflowActionListItems = new HashSet<WorkflowActionListItem>(0);

    /** workflowStatesForOnEnterActionListId private attribute */
    private Set<WorkflowState> workflowStatesForOnEnterActionListId = new HashSet<WorkflowState>(0);

    /** The pojo's primary key field list names */
    private static List<String> pkFieldList;

    /**
     * Get the table fields that compose the PK
     *
     * @return the PK field list
     */
     public synchronized static List<String> getPKFieldList()
     {
         if (pkFieldList == null)
         {
             pkFieldList = new ArrayList<String>();
             pkFieldList.add("id");
         }

         return pkFieldList;
     }

    /**
     * Get the table fields that compose the PK as a comma separated field name list
     *
     * @return the PK field list as a string
     */
     public static String getPKFieldListAsString()
     {
         StringBuffer buffer = new StringBuffer();

         for (int i = 0; i < getPKFieldList().size(); i++)
         {
             if (i != 0)
                 buffer.append(",");

             buffer.append(getPKFieldList().get(i));
         }

         return buffer.toString();
     }

    /**
     * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeAsString(java.lang.String)
     */
     @Override
     public String getAttributeAsString(String attributeName)
     {

        Object value = getAttribute(attributeName);

        if (value == null)
            return "";
        else {
            return value.toString().trim();
        }
     }

    // Constructors

    /**
     * default constructor
     */
    public WorkflowActionList() {
    }

	/** 
	 * minimal constructor
	 *
     * @param workflow the workflow
     * @param name the name
    }
	 */
    public WorkflowActionList(Workflow workflow, String name) {
        this.workflow = workflow;
        this.name = name;
    }

    /**
     * full constructor
	 *
     * @param workflow the workflow
     * @param name the name
     * @param workflowStateActions the workflowStateActions
     * @param workflowStatesForOnExitActionListId the workflowStatesForOnExitActionListId
     * @param workflowActionListItems the workflowActionListItems
     * @param workflowStatesForOnEnterActionListId the workflowStatesForOnEnterActionListId
     */
    public WorkflowActionList(Workflow workflow, String name, Set<WorkflowStateAction> workflowStateActions, Set<WorkflowState> workflowStatesForOnExitActionListId, Set<WorkflowActionListItem> workflowActionListItems, Set<WorkflowState> workflowStatesForOnEnterActionListId) {
        this.workflow = workflow;
        this.name = name;
        this.workflowStateActions = workflowStateActions;
        this.workflowStatesForOnExitActionListId = workflowStatesForOnExitActionListId;
        this.workflowActionListItems = workflowActionListItems;
        this.workflowStatesForOnEnterActionListId = workflowStatesForOnEnterActionListId;
    }

    // Property accessors
    
    /**       
     * id getter method
     *
     * @return id method
     */
    public Long getId() {
        return this.id;
    }
    
    /**       
     * id setter method
     *
     * @param id the id
     *
     * @return WorkflowActionList modified instance
     */
    public WorkflowActionList setId(Long id) {
        this.id = id;
        
        return this;
    }
    /**       
     * workflow getter method
     *
     * @return workflow method
     */
    public Workflow getWorkflow() {
        return this.workflow;
    }
    
    /**       
     * workflow setter method
     *
     * @param workflow the workflow
     *
     * @return WorkflowActionList modified instance
     */
    public WorkflowActionList setWorkflow(Workflow workflow) {
        this.workflow = workflow;
        
        return this;
    }
    /**       
     * name getter method
     *
     * @return name method
     */
    public String getName() {
        return this.name;
    }
    
    /**       
     * name setter method
     *
     * @param name the name
     *
     * @return WorkflowActionList modified instance
     */
    public WorkflowActionList setName(String name) {
        this.name = name;
        
        return this;
    }
    /**       
     * workflowStateActions getter method
     *
     * @return workflowStateActions method
     */
    public Set<WorkflowStateAction> getWorkflowStateActions() {
        return this.workflowStateActions;
    }
    
    /**       
     * workflowStateActions setter method
     *
     * @param workflowStateActions the workflowStateActions
     *
     * @return WorkflowActionList modified instance
     */
    public WorkflowActionList setWorkflowStateActions(Set<WorkflowStateAction> workflowStateActions) {
        this.workflowStateActions = workflowStateActions;
        
        return this;
    }
    /**       
     * workflowStatesForOnExitActionListId getter method
     *
     * @return workflowStatesForOnExitActionListId method
     */
    public Set<WorkflowState> getWorkflowStatesForOnExitActionListId() {
        return this.workflowStatesForOnExitActionListId;
    }
    
    /**       
     * workflowStatesForOnExitActionListId setter method
     *
     * @param workflowStatesForOnExitActionListId the workflowStatesForOnExitActionListId
     *
     * @return WorkflowActionList modified instance
     */
    public WorkflowActionList setWorkflowStatesForOnExitActionListId(Set<WorkflowState> workflowStatesForOnExitActionListId) {
        this.workflowStatesForOnExitActionListId = workflowStatesForOnExitActionListId;
        
        return this;
    }
    /**       
     * workflowActionListItems getter method
     *
     * @return workflowActionListItems method
     */
    public Set<WorkflowActionListItem> getWorkflowActionListItems() {
        return this.workflowActionListItems;
    }
    
    /**       
     * workflowActionListItems setter method
     *
     * @param workflowActionListItems the workflowActionListItems
     *
     * @return WorkflowActionList modified instance
     */
    public WorkflowActionList setWorkflowActionListItems(Set<WorkflowActionListItem> workflowActionListItems) {
        this.workflowActionListItems = workflowActionListItems;
        
        return this;
    }
    /**       
     * workflowStatesForOnEnterActionListId getter method
     *
     * @return workflowStatesForOnEnterActionListId method
     */
    public Set<WorkflowState> getWorkflowStatesForOnEnterActionListId() {
        return this.workflowStatesForOnEnterActionListId;
    }
    
    /**       
     * workflowStatesForOnEnterActionListId setter method
     *
     * @param workflowStatesForOnEnterActionListId the workflowStatesForOnEnterActionListId
     *
     * @return WorkflowActionList modified instance
     */
    public WorkflowActionList setWorkflowStatesForOnEnterActionListId(Set<WorkflowState> workflowStatesForOnEnterActionListId) {
        this.workflowStatesForOnEnterActionListId = workflowStatesForOnEnterActionListId;
        
        return this;
    }

    /**
     * Creates a String representation of the WorkflowActionList object
     *
     * @return the compiled String
     */
    @Override
    public String toString() {
	    StringBuffer buffer = new StringBuffer();

        buffer.append(getClass().getName()).append("@").append(Integer.toHexString(hashCode())).append(" [");

        buffer.append("id").append("='").append(getId()).append("' ");			
        buffer.append("name").append("='").append(getName()).append("' ");			
        buffer.append("]");
      
        return buffer.toString();
    }

    /**
     * Compares the String representation of the WorkflowActionList object
     *
     * @param other The object to compare to
     *
     * @return true of the objects are equal
     */
    public boolean equals(WorkflowActionList other) {
        	return this.toString().equals(other.toString());
    }
    /**
     * @see pt.digitalis.utils.common.IBeanAttributes#setAttributeFromString(java.lang.String, java.lang.String)
     */
    public void setAttributeFromString(String attributeName, String attributeValue) {
        if ("id".equalsIgnoreCase(attributeName))
            this.id = Long.valueOf(attributeValue);

        if ("name".equalsIgnoreCase(attributeName))
        	this.name = attributeValue;

    }


    /**
     * Instanciates an Hibernate proxy data object (does not load it from the database, provides lazy load for that)
     *
     * @param session the session
     * @param id      the id
     *
     * @return the proxy
     */
    public static WorkflowActionList getProxy(Session session, Long id)
    {
        return(WorkflowActionList)session.load(WorkflowActionList.class,id);
    }

    /**
    * Instanciates an Hibernate proxy data object (does not load it from the database, provides lazy load for that)
    *
    * @param id      the id
    *
    * @return the proxy
    */
    public static WorkflowActionList getProxy(Long id)
    {
        Session session = HibernateUtil.getSessionFactory("DIFRepository").getCurrentSession();
        boolean wasActive = session.getTransaction().isActive();

        if (!wasActive)
            session.beginTransaction();

        WorkflowActionList result = (WorkflowActionList)session.load(WorkflowActionList.class,id);

        if (!wasActive)
            session.getTransaction().commit();

        return result;
    }


    /**
     * Instanciates an Hibernate data object
     *
     * @param session the session
     * @param id      the id
     *
     * @return the instance
     */
    public static WorkflowActionList getInstance(Session session, Long id)
    {
        return(WorkflowActionList)session.get(WorkflowActionList.class,id);
    }

    /**
    * Instanciates an Hibernate data object
    *
    * @param id      the id
    *
    * @return the instance
    */
    public static WorkflowActionList getInstance(Long id)
    {
        Session session = HibernateUtil.getSessionFactory("DIFRepository").getCurrentSession();
        boolean wasActive = session.getTransaction().isActive();

        if (!wasActive)
            session.beginTransaction();

        WorkflowActionList result = (WorkflowActionList)session.get(WorkflowActionList.class,id);

        if (!wasActive)
            session.getTransaction().commit();

        return result;
    }

}
