package pt.digitalis.dif.dem.managers.impl.model.data;


import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hibernate.Session;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.hibernate.HibernateUtil;
import pt.digitalis.dif.model.utils.AbstractBeanRelationsAttributes;
import pt.digitalis.dif.model.utils.IBeanAttributesDataSet;

/**
 * WorkflowActionListItem
* Generated on ORM Generator
* DIF build process for the Model layer
*
*/
@SuppressWarnings("serial")
public class WorkflowActionListItem extends AbstractBeanRelationsAttributes implements java.io.Serializable, IBeanAttributesDataSet<WorkflowActionListItem> {

    /** WorkflowActionListItem attributes enumeration */
    public static class Fields
    {
        /** id column */
        public static final String ID ="id";
        /** actionType column */
        public static final String ACTIONTYPE ="actionType";
        /** actionItemBusinessId column */
        public static final String ACTIONITEMBUSINESSID ="actionItemBusinessId";
        /** parameters column */
        public static final String PARAMETERS ="parameters";
        /** businessFlowActionId column */
        public static final String BUSINESSFLOWACTIONID ="businessFlowActionId";
        /** businessRuleExecutionId column */
        public static final String BUSINESSRULEEXECUTIONID ="businessRuleExecutionId";
        /** executionOrder column */
        public static final String EXECUTIONORDER ="executionOrder";
        /** failActionListOnError column */
        public static final String FAILACTIONLISTONERROR ="failActionListOnError";

        /**
         * List of existing fields
         *
         * @return list of field names
         */
        public static List<String> values()
        {
            ArrayList<String> list = new ArrayList<String>();
            list.add("id");
            list.add("actionType");
            list.add("actionItemBusinessId");
            list.add("parameters");
            list.add("businessFlowActionId");
            list.add("businessRuleExecutionId");
            list.add("executionOrder");
            list.add("failActionListOnError");

            return list;
        }
    }

    /** Field attributes */
    public static WorkflowActionListItemFieldAttributes FieldAttributes=new WorkflowActionListItemFieldAttributes();

    /**
    * @return the field attributes definitions
    */
    @Override public WorkflowActionListItemFieldAttributes getDefinitions()
    {
        return FieldAttributes;
    }

    /**
     * The Class Relations.
     */
    public class Relations extends AbstractBeanRelationsAttributes.AbstractRelations
    {

        /**
        * Instantiates a new relations.
        *
        * @param currentPath the current path
        */
        public Relations(String currentPath)
        {
            super(currentPath);
        }
        /**
         * workflowState relation.
         *
         * @return the workflowState bean relations attributes.
         */
        public WorkflowState.Relations workflowState()
        {
            WorkflowState c = new WorkflowState();
            return c.new Relations(this.buildPath("workflowState"));
        }

        /**
         * workflowActionList relation.
         *
         * @return the workflowActionList bean relations attributes.
         */
        public WorkflowActionList.Relations workflowActionList()
        {
            WorkflowActionList c = new WorkflowActionList();
            return c.new Relations(this.buildPath("workflowActionList"));
        }

        /**
         * workflowAliTargets relation.
         *
         * @return the workflowAliTargets bean relations attributes.
         */
        public WorkflowAliTarget.Relations workflowAliTargets()
        {
            WorkflowAliTarget c = new WorkflowAliTarget();
            return c.new Relations(this.buildPath("workflowAliTargets"));
        }

        /**
         * the ID path.
         *
         * @return the path
         */
        public String ID()
        {
            return buildPath(Fields.ID);
        }
        /**
         * the ACTIONTYPE path.
         *
         * @return the path
         */
        public String ACTIONTYPE()
        {
            return buildPath(Fields.ACTIONTYPE);
        }
        /**
         * the ACTIONITEMBUSINESSID path.
         *
         * @return the path
         */
        public String ACTIONITEMBUSINESSID()
        {
            return buildPath(Fields.ACTIONITEMBUSINESSID);
        }
        /**
         * the PARAMETERS path.
         *
         * @return the path
         */
        public String PARAMETERS()
        {
            return buildPath(Fields.PARAMETERS);
        }
        /**
         * the BUSINESSFLOWACTIONID path.
         *
         * @return the path
         */
        public String BUSINESSFLOWACTIONID()
        {
            return buildPath(Fields.BUSINESSFLOWACTIONID);
        }
        /**
         * the BUSINESSRULEEXECUTIONID path.
         *
         * @return the path
         */
        public String BUSINESSRULEEXECUTIONID()
        {
            return buildPath(Fields.BUSINESSRULEEXECUTIONID);
        }
        /**
         * the EXECUTIONORDER path.
         *
         * @return the path
         */
        public String EXECUTIONORDER()
        {
            return buildPath(Fields.EXECUTIONORDER);
        }
        /**
         * the FAILACTIONLISTONERROR path.
         *
         * @return the path
         */
        public String FAILACTIONLISTONERROR()
        {
            return buildPath(Fields.FAILACTIONLISTONERROR);
        }
    }

    /** The dummy obj. */
    private static WorkflowActionListItem dummyObj=new WorkflowActionListItem();

    /**
     * Get WorkflowActionListItem Relations .
     *
     * @return the relations
     */
    public static Relations FK()
    {
        return dummyObj.new Relations(null);
    }

    /**
    * Gets a new dataSet object for this bean
    *
    * @return the dataSet
    */
    public IDataSet<WorkflowActionListItem> getDataSet()
    {
        return new HibernateDataSet<WorkflowActionListItem>(WorkflowActionListItem.class, HibernateUtil.getSessionFactory("DIFRepository"),
            WorkflowActionListItem.getPKFieldListAsString(), WorkflowActionListItem.FieldAttributes);
    }

    /**
    * Gets a new dataSet object for this bean
    *
    * @return the dataSet
    */
    public static IDataSet<WorkflowActionListItem> getDataSetInstance()
    {
        return new WorkflowActionListItem().getDataSet();
    }

    /**
    * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeNoGraphNavigation(java.lang.String)
    */
    @Override protected Object getAttributeNoGraphNavigation(String attributeName)
    {
        if("id".equalsIgnoreCase(attributeName))
            return id;
        if("workflowState".equalsIgnoreCase(attributeName))
            return workflowState;
        if("workflowActionList".equalsIgnoreCase(attributeName))
            return workflowActionList;
        if("actionType".equalsIgnoreCase(attributeName))
            return actionType;
        if("actionItemBusinessId".equalsIgnoreCase(attributeName))
            return actionItemBusinessId;
        if("parameters".equalsIgnoreCase(attributeName))
            return parameters;
        if("businessFlowActionId".equalsIgnoreCase(attributeName))
            return businessFlowActionId;
        if("businessRuleExecutionId".equalsIgnoreCase(attributeName))
            return businessRuleExecutionId;
        if("executionOrder".equalsIgnoreCase(attributeName))
            return executionOrder;
        if("failActionListOnError".equalsIgnoreCase(attributeName))
            return failActionListOnError;
        if("workflowAliTargets".equalsIgnoreCase(attributeName))
            return workflowAliTargets;

        return null;
    }

    /**
    * @see pt.digitalis.utils.common.IBeanAttributes#setAttribute(java.lang.String, java.lang.Object)
    */
    public void setAttribute(String attributeName,Object attributeValue)
    {
        if("id".equalsIgnoreCase(attributeName))
            id =(Long)attributeValue;
        if("workflowState".equalsIgnoreCase(attributeName))
            workflowState =(WorkflowState)attributeValue;
        if("workflowActionList".equalsIgnoreCase(attributeName))
            workflowActionList =(WorkflowActionList)attributeValue;
        if("actionType".equalsIgnoreCase(attributeName))
            actionType =(String)attributeValue;
        if("actionItemBusinessId".equalsIgnoreCase(attributeName))
            actionItemBusinessId =(String)attributeValue;
        if("parameters".equalsIgnoreCase(attributeName))
            parameters =(String)attributeValue;
        if("businessFlowActionId".equalsIgnoreCase(attributeName))
            businessFlowActionId =(String)attributeValue;
        if("businessRuleExecutionId".equalsIgnoreCase(attributeName))
            businessRuleExecutionId =(String)attributeValue;
        if("executionOrder".equalsIgnoreCase(attributeName))
            executionOrder =(Long)attributeValue;
        if("failActionListOnError".equalsIgnoreCase(attributeName))
            failActionListOnError =(Boolean)attributeValue;
        if("workflowAliTargets".equalsIgnoreCase(attributeName))
            workflowAliTargets =(Set<WorkflowAliTarget>)attributeValue;
    }

    // Fields

    /** id private attribute */
    private Long id;

    /** workflowState private attribute */
    private WorkflowState workflowState;

    /** workflowActionList private attribute */
    private WorkflowActionList workflowActionList;

    /** actionType private attribute */
    private String actionType;

    /** actionItemBusinessId private attribute */
    private String actionItemBusinessId;

    /** parameters private attribute */
    private String parameters;

    /** businessFlowActionId private attribute */
    private String businessFlowActionId;

    /** businessRuleExecutionId private attribute */
    private String businessRuleExecutionId;

    /** executionOrder private attribute */
    private Long executionOrder;

    /** failActionListOnError private attribute */
    private boolean failActionListOnError;

    /** workflowAliTargets private attribute */
    private Set<WorkflowAliTarget> workflowAliTargets = new HashSet<WorkflowAliTarget>(0);

    /** The pojo's primary key field list names */
    private static List<String> pkFieldList;

    /**
     * Get the table fields that compose the PK
     *
     * @return the PK field list
     */
     public synchronized static List<String> getPKFieldList()
     {
         if (pkFieldList == null)
         {
             pkFieldList = new ArrayList<String>();
             pkFieldList.add("id");
         }

         return pkFieldList;
     }

    /**
     * Get the table fields that compose the PK as a comma separated field name list
     *
     * @return the PK field list as a string
     */
     public static String getPKFieldListAsString()
     {
         StringBuffer buffer = new StringBuffer();

         for (int i = 0; i < getPKFieldList().size(); i++)
         {
             if (i != 0)
                 buffer.append(",");

             buffer.append(getPKFieldList().get(i));
         }

         return buffer.toString();
     }

    /**
     * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeAsString(java.lang.String)
     */
     @Override
     public String getAttributeAsString(String attributeName)
     {

        Object value = getAttribute(attributeName);

        if (value == null)
            return "";
        else {
            return value.toString().trim();
        }
     }

    // Constructors

    /**
     * default constructor
     */
    public WorkflowActionListItem() {
    }

	/** 
	 * minimal constructor
	 *
     * @param workflowActionList the workflowActionList
     * @param executionOrder the executionOrder
    }
	 */
    public WorkflowActionListItem(WorkflowActionList workflowActionList, Long executionOrder) {
        this.workflowActionList = workflowActionList;
        this.executionOrder = executionOrder;
    }

    /**
     * full constructor
	 *
     * @param workflowState the workflowState
     * @param workflowActionList the workflowActionList
     * @param actionType the actionType
     * @param actionItemBusinessId the actionItemBusinessId
     * @param parameters the parameters
     * @param businessFlowActionId the businessFlowActionId
     * @param businessRuleExecutionId the businessRuleExecutionId
     * @param executionOrder the executionOrder
     * @param failActionListOnError the failActionListOnError
     * @param workflowAliTargets the workflowAliTargets
     */
    public WorkflowActionListItem(WorkflowState workflowState, WorkflowActionList workflowActionList, String actionType, String actionItemBusinessId, String parameters, String businessFlowActionId, String businessRuleExecutionId, Long executionOrder, boolean failActionListOnError, Set<WorkflowAliTarget> workflowAliTargets) {
        this.workflowState = workflowState;
        this.workflowActionList = workflowActionList;
        this.actionType = actionType;
        this.actionItemBusinessId = actionItemBusinessId;
        this.parameters = parameters;
        this.businessFlowActionId = businessFlowActionId;
        this.businessRuleExecutionId = businessRuleExecutionId;
        this.executionOrder = executionOrder;
        this.failActionListOnError = failActionListOnError;
        this.workflowAliTargets = workflowAliTargets;
    }

    // Property accessors
    
    /**       
     * id getter method
     *
     * @return id method
     */
    public Long getId() {
        return this.id;
    }
    
    /**       
     * id setter method
     *
     * @param id the id
     *
     * @return WorkflowActionListItem modified instance
     */
    public WorkflowActionListItem setId(Long id) {
        this.id = id;
        
        return this;
    }
    /**       
     * workflowState getter method
     *
     * @return workflowState method
     */
    public WorkflowState getWorkflowState() {
        return this.workflowState;
    }
    
    /**       
     * workflowState setter method
     *
     * @param workflowState the workflowState
     *
     * @return WorkflowActionListItem modified instance
     */
    public WorkflowActionListItem setWorkflowState(WorkflowState workflowState) {
        this.workflowState = workflowState;
        
        return this;
    }
    /**       
     * workflowActionList getter method
     *
     * @return workflowActionList method
     */
    public WorkflowActionList getWorkflowActionList() {
        return this.workflowActionList;
    }
    
    /**       
     * workflowActionList setter method
     *
     * @param workflowActionList the workflowActionList
     *
     * @return WorkflowActionListItem modified instance
     */
    public WorkflowActionListItem setWorkflowActionList(WorkflowActionList workflowActionList) {
        this.workflowActionList = workflowActionList;
        
        return this;
    }
    /**       
     * actionType getter method
     *
     * @return actionType method
     */
    public String getActionType() {
        return this.actionType;
    }
    
    /**       
     * actionType setter method
     *
     * @param actionType the actionType
     *
     * @return WorkflowActionListItem modified instance
     */
    public WorkflowActionListItem setActionType(String actionType) {
        this.actionType = actionType;
        
        return this;
    }
    /**       
     * actionItemBusinessId getter method
     *
     * @return actionItemBusinessId method
     */
    public String getActionItemBusinessId() {
        return this.actionItemBusinessId;
    }
    
    /**       
     * actionItemBusinessId setter method
     *
     * @param actionItemBusinessId the actionItemBusinessId
     *
     * @return WorkflowActionListItem modified instance
     */
    public WorkflowActionListItem setActionItemBusinessId(String actionItemBusinessId) {
        this.actionItemBusinessId = actionItemBusinessId;
        
        return this;
    }
    /**       
     * parameters getter method
     *
     * @return parameters method
     */
    public String getParameters() {
        return this.parameters;
    }
    
    /**       
     * parameters setter method
     *
     * @param parameters the parameters
     *
     * @return WorkflowActionListItem modified instance
     */
    public WorkflowActionListItem setParameters(String parameters) {
        this.parameters = parameters;
        
        return this;
    }
    /**       
     * businessFlowActionId getter method
     *
     * @return businessFlowActionId method
     */
    public String getBusinessFlowActionId() {
        return this.businessFlowActionId;
    }
    
    /**       
     * businessFlowActionId setter method
     *
     * @param businessFlowActionId the businessFlowActionId
     *
     * @return WorkflowActionListItem modified instance
     */
    public WorkflowActionListItem setBusinessFlowActionId(String businessFlowActionId) {
        this.businessFlowActionId = businessFlowActionId;
        
        return this;
    }
    /**       
     * businessRuleExecutionId getter method
     *
     * @return businessRuleExecutionId method
     */
    public String getBusinessRuleExecutionId() {
        return this.businessRuleExecutionId;
    }
    
    /**       
     * businessRuleExecutionId setter method
     *
     * @param businessRuleExecutionId the businessRuleExecutionId
     *
     * @return WorkflowActionListItem modified instance
     */
    public WorkflowActionListItem setBusinessRuleExecutionId(String businessRuleExecutionId) {
        this.businessRuleExecutionId = businessRuleExecutionId;
        
        return this;
    }
    /**       
     * executionOrder getter method
     *
     * @return executionOrder method
     */
    public Long getExecutionOrder() {
        return this.executionOrder;
    }
    
    /**       
     * executionOrder setter method
     *
     * @param executionOrder the executionOrder
     *
     * @return WorkflowActionListItem modified instance
     */
    public WorkflowActionListItem setExecutionOrder(Long executionOrder) {
        this.executionOrder = executionOrder;
        
        return this;
    }
    /**       
     * failActionListOnError getter method
     *
     * @return failActionListOnError method
     */
    public boolean isFailActionListOnError() {
        return this.failActionListOnError;
    }
    
    /**       
     * failActionListOnError setter method
     *
     * @param failActionListOnError the failActionListOnError
     *
     * @return WorkflowActionListItem modified instance
     */
    public WorkflowActionListItem setFailActionListOnError(boolean failActionListOnError) {
        this.failActionListOnError = failActionListOnError;
        
        return this;
    }
    /**       
     * workflowAliTargets getter method
     *
     * @return workflowAliTargets method
     */
    public Set<WorkflowAliTarget> getWorkflowAliTargets() {
        return this.workflowAliTargets;
    }
    
    /**       
     * workflowAliTargets setter method
     *
     * @param workflowAliTargets the workflowAliTargets
     *
     * @return WorkflowActionListItem modified instance
     */
    public WorkflowActionListItem setWorkflowAliTargets(Set<WorkflowAliTarget> workflowAliTargets) {
        this.workflowAliTargets = workflowAliTargets;
        
        return this;
    }

    /**
     * Creates a String representation of the WorkflowActionListItem object
     *
     * @return the compiled String
     */
    @Override
    public String toString() {
	    StringBuffer buffer = new StringBuffer();

        buffer.append(getClass().getName()).append("@").append(Integer.toHexString(hashCode())).append(" [");

        buffer.append("id").append("='").append(getId()).append("' ");			
        buffer.append("actionType").append("='").append(getActionType()).append("' ");			
        buffer.append("actionItemBusinessId").append("='").append(getActionItemBusinessId()).append("' ");			
        buffer.append("parameters").append("='").append(getParameters()).append("' ");			
        buffer.append("businessFlowActionId").append("='").append(getBusinessFlowActionId()).append("' ");			
        buffer.append("businessRuleExecutionId").append("='").append(getBusinessRuleExecutionId()).append("' ");			
        buffer.append("executionOrder").append("='").append(getExecutionOrder()).append("' ");			
        buffer.append("failActionListOnError").append("='").append(isFailActionListOnError()).append("' ");			
        buffer.append("]");
      
        return buffer.toString();
    }

    /**
     * Compares the String representation of the WorkflowActionListItem object
     *
     * @param other The object to compare to
     *
     * @return true of the objects are equal
     */
    public boolean equals(WorkflowActionListItem other) {
        	return this.toString().equals(other.toString());
    }
    /**
     * @see pt.digitalis.utils.common.IBeanAttributes#setAttributeFromString(java.lang.String, java.lang.String)
     */
    public void setAttributeFromString(String attributeName, String attributeValue) {
        if ("id".equalsIgnoreCase(attributeName))
            this.id = Long.valueOf(attributeValue);

        if ("actionType".equalsIgnoreCase(attributeName))
        	this.actionType = attributeValue;

        if ("actionItemBusinessId".equalsIgnoreCase(attributeName))
        	this.actionItemBusinessId = attributeValue;

        if ("parameters".equalsIgnoreCase(attributeName))
        	this.parameters = attributeValue;

        if ("businessFlowActionId".equalsIgnoreCase(attributeName))
        	this.businessFlowActionId = attributeValue;

        if ("businessRuleExecutionId".equalsIgnoreCase(attributeName))
        	this.businessRuleExecutionId = attributeValue;

        if ("executionOrder".equalsIgnoreCase(attributeName))
            this.executionOrder = Long.valueOf(attributeValue);

        if ("failActionListOnError".equalsIgnoreCase(attributeName))
            this.failActionListOnError = Boolean.valueOf(attributeValue);

    }


    /**
     * Instanciates an Hibernate proxy data object (does not load it from the database, provides lazy load for that)
     *
     * @param session the session
     * @param id      the id
     *
     * @return the proxy
     */
    public static WorkflowActionListItem getProxy(Session session, Long id)
    {
        return(WorkflowActionListItem)session.load(WorkflowActionListItem.class,id);
    }

    /**
    * Instanciates an Hibernate proxy data object (does not load it from the database, provides lazy load for that)
    *
    * @param id      the id
    *
    * @return the proxy
    */
    public static WorkflowActionListItem getProxy(Long id)
    {
        Session session = HibernateUtil.getSessionFactory("DIFRepository").getCurrentSession();
        boolean wasActive = session.getTransaction().isActive();

        if (!wasActive)
            session.beginTransaction();

        WorkflowActionListItem result = (WorkflowActionListItem)session.load(WorkflowActionListItem.class,id);

        if (!wasActive)
            session.getTransaction().commit();

        return result;
    }


    /**
     * Instanciates an Hibernate data object
     *
     * @param session the session
     * @param id      the id
     *
     * @return the instance
     */
    public static WorkflowActionListItem getInstance(Session session, Long id)
    {
        return(WorkflowActionListItem)session.get(WorkflowActionListItem.class,id);
    }

    /**
    * Instanciates an Hibernate data object
    *
    * @param id      the id
    *
    * @return the instance
    */
    public static WorkflowActionListItem getInstance(Long id)
    {
        Session session = HibernateUtil.getSessionFactory("DIFRepository").getCurrentSession();
        boolean wasActive = session.getTransaction().isActive();

        if (!wasActive)
            session.beginTransaction();

        WorkflowActionListItem result = (WorkflowActionListItem)session.get(WorkflowActionListItem.class,id);

        if (!wasActive)
            session.getTransaction().commit();

        return result;
    }

}
