package pt.digitalis.dif.dem.managers.impl.model.data;


import java.util.ArrayList;
import java.util.List;
import org.hibernate.Session;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.hibernate.HibernateUtil;
import pt.digitalis.dif.model.utils.AbstractBeanRelationsAttributes;
import pt.digitalis.dif.model.utils.IBeanAttributesDataSet;

/**
 * WorkflowAliTarget
* Generated on ORM Generator
* DIF build process for the Model layer
*
*/
@SuppressWarnings("serial")
public class WorkflowAliTarget extends AbstractBeanRelationsAttributes implements java.io.Serializable, IBeanAttributesDataSet<WorkflowAliTarget> {

    /** WorkflowAliTarget attributes enumeration */
    public static class Fields
    {
        /** id column */
        public static final String ID ="id";
        /** userId column */
        public static final String USERID ="userId";

        /**
         * List of existing fields
         *
         * @return list of field names
         */
        public static List<String> values()
        {
            ArrayList<String> list = new ArrayList<String>();
            list.add("id");
            list.add("userId");

            return list;
        }
    }

    /** Field attributes */
    public static WorkflowAliTargetFieldAttributes FieldAttributes=new WorkflowAliTargetFieldAttributes();

    /**
    * @return the field attributes definitions
    */
    @Override public WorkflowAliTargetFieldAttributes getDefinitions()
    {
        return FieldAttributes;
    }

    /**
     * The Class Relations.
     */
    public class Relations extends AbstractBeanRelationsAttributes.AbstractRelations
    {

        /**
        * Instantiates a new relations.
        *
        * @param currentPath the current path
        */
        public Relations(String currentPath)
        {
            super(currentPath);
        }
        /**
         * workflowUserProfile relation.
         *
         * @return the workflowUserProfile bean relations attributes.
         */
        public WorkflowUserProfile.Relations workflowUserProfile()
        {
            WorkflowUserProfile c = new WorkflowUserProfile();
            return c.new Relations(this.buildPath("workflowUserProfile"));
        }

        /**
         * workflowActionListItem relation.
         *
         * @return the workflowActionListItem bean relations attributes.
         */
        public WorkflowActionListItem.Relations workflowActionListItem()
        {
            WorkflowActionListItem c = new WorkflowActionListItem();
            return c.new Relations(this.buildPath("workflowActionListItem"));
        }

        /**
         * the ID path.
         *
         * @return the path
         */
        public String ID()
        {
            return buildPath(Fields.ID);
        }
        /**
         * the USERID path.
         *
         * @return the path
         */
        public String USERID()
        {
            return buildPath(Fields.USERID);
        }
    }

    /** The dummy obj. */
    private static WorkflowAliTarget dummyObj=new WorkflowAliTarget();

    /**
     * Get WorkflowAliTarget Relations .
     *
     * @return the relations
     */
    public static Relations FK()
    {
        return dummyObj.new Relations(null);
    }

    /**
    * Gets a new dataSet object for this bean
    *
    * @return the dataSet
    */
    public IDataSet<WorkflowAliTarget> getDataSet()
    {
        return new HibernateDataSet<WorkflowAliTarget>(WorkflowAliTarget.class, HibernateUtil.getSessionFactory("DIFRepository"),
            WorkflowAliTarget.getPKFieldListAsString(), WorkflowAliTarget.FieldAttributes);
    }

    /**
    * Gets a new dataSet object for this bean
    *
    * @return the dataSet
    */
    public static IDataSet<WorkflowAliTarget> getDataSetInstance()
    {
        return new WorkflowAliTarget().getDataSet();
    }

    /**
    * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeNoGraphNavigation(java.lang.String)
    */
    @Override protected Object getAttributeNoGraphNavigation(String attributeName)
    {
        if("id".equalsIgnoreCase(attributeName))
            return id;
        if("workflowUserProfile".equalsIgnoreCase(attributeName))
            return workflowUserProfile;
        if("workflowActionListItem".equalsIgnoreCase(attributeName))
            return workflowActionListItem;
        if("userId".equalsIgnoreCase(attributeName))
            return userId;

        return null;
    }

    /**
    * @see pt.digitalis.utils.common.IBeanAttributes#setAttribute(java.lang.String, java.lang.Object)
    */
    public void setAttribute(String attributeName,Object attributeValue)
    {
        if("id".equalsIgnoreCase(attributeName))
            id =(Long)attributeValue;
        if("workflowUserProfile".equalsIgnoreCase(attributeName))
            workflowUserProfile =(WorkflowUserProfile)attributeValue;
        if("workflowActionListItem".equalsIgnoreCase(attributeName))
            workflowActionListItem =(WorkflowActionListItem)attributeValue;
        if("userId".equalsIgnoreCase(attributeName))
            userId =(String)attributeValue;
    }

    // Fields

    /** id private attribute */
    private Long id;

    /** workflowUserProfile private attribute */
    private WorkflowUserProfile workflowUserProfile;

    /** workflowActionListItem private attribute */
    private WorkflowActionListItem workflowActionListItem;

    /** userId private attribute */
    private String userId;

    /** The pojo's primary key field list names */
    private static List<String> pkFieldList;

    /**
     * Get the table fields that compose the PK
     *
     * @return the PK field list
     */
     public synchronized static List<String> getPKFieldList()
     {
         if (pkFieldList == null)
         {
             pkFieldList = new ArrayList<String>();
             pkFieldList.add("id");
         }

         return pkFieldList;
     }

    /**
     * Get the table fields that compose the PK as a comma separated field name list
     *
     * @return the PK field list as a string
     */
     public static String getPKFieldListAsString()
     {
         StringBuffer buffer = new StringBuffer();

         for (int i = 0; i < getPKFieldList().size(); i++)
         {
             if (i != 0)
                 buffer.append(",");

             buffer.append(getPKFieldList().get(i));
         }

         return buffer.toString();
     }

    /**
     * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeAsString(java.lang.String)
     */
     @Override
     public String getAttributeAsString(String attributeName)
     {

        Object value = getAttribute(attributeName);

        if (value == null)
            return "";
        else {
            return value.toString().trim();
        }
     }

    // Constructors

    /**
     * default constructor
     */
    public WorkflowAliTarget() {
    }

	/** 
	 * minimal constructor
	 *
     * @param workflowActionListItem the workflowActionListItem
    }
	 */
    public WorkflowAliTarget(WorkflowActionListItem workflowActionListItem) {
        this.workflowActionListItem = workflowActionListItem;
    }

    /**
     * full constructor
	 *
     * @param workflowUserProfile the workflowUserProfile
     * @param workflowActionListItem the workflowActionListItem
     * @param userId the userId
     */
    public WorkflowAliTarget(WorkflowUserProfile workflowUserProfile, WorkflowActionListItem workflowActionListItem, String userId) {
        this.workflowUserProfile = workflowUserProfile;
        this.workflowActionListItem = workflowActionListItem;
        this.userId = userId;
    }

    // Property accessors
    
    /**       
     * id getter method
     *
     * @return id method
     */
    public Long getId() {
        return this.id;
    }
    
    /**       
     * id setter method
     *
     * @param id the id
     *
     * @return WorkflowAliTarget modified instance
     */
    public WorkflowAliTarget setId(Long id) {
        this.id = id;
        
        return this;
    }
    /**       
     * workflowUserProfile getter method
     *
     * @return workflowUserProfile method
     */
    public WorkflowUserProfile getWorkflowUserProfile() {
        return this.workflowUserProfile;
    }
    
    /**       
     * workflowUserProfile setter method
     *
     * @param workflowUserProfile the workflowUserProfile
     *
     * @return WorkflowAliTarget modified instance
     */
    public WorkflowAliTarget setWorkflowUserProfile(WorkflowUserProfile workflowUserProfile) {
        this.workflowUserProfile = workflowUserProfile;
        
        return this;
    }
    /**       
     * workflowActionListItem getter method
     *
     * @return workflowActionListItem method
     */
    public WorkflowActionListItem getWorkflowActionListItem() {
        return this.workflowActionListItem;
    }
    
    /**       
     * workflowActionListItem setter method
     *
     * @param workflowActionListItem the workflowActionListItem
     *
     * @return WorkflowAliTarget modified instance
     */
    public WorkflowAliTarget setWorkflowActionListItem(WorkflowActionListItem workflowActionListItem) {
        this.workflowActionListItem = workflowActionListItem;
        
        return this;
    }
    /**       
     * userId getter method
     *
     * @return userId method
     */
    public String getUserId() {
        return this.userId;
    }
    
    /**       
     * userId setter method
     *
     * @param userId the userId
     *
     * @return WorkflowAliTarget modified instance
     */
    public WorkflowAliTarget setUserId(String userId) {
        this.userId = userId;
        
        return this;
    }

    /**
     * Creates a String representation of the WorkflowAliTarget object
     *
     * @return the compiled String
     */
    @Override
    public String toString() {
	    StringBuffer buffer = new StringBuffer();

        buffer.append(getClass().getName()).append("@").append(Integer.toHexString(hashCode())).append(" [");

        buffer.append("id").append("='").append(getId()).append("' ");			
        buffer.append("userId").append("='").append(getUserId()).append("' ");			
        buffer.append("]");
      
        return buffer.toString();
    }

    /**
     * Compares the String representation of the WorkflowAliTarget object
     *
     * @param other The object to compare to
     *
     * @return true of the objects are equal
     */
    public boolean equals(WorkflowAliTarget other) {
        	return this.toString().equals(other.toString());
    }
    /**
     * @see pt.digitalis.utils.common.IBeanAttributes#setAttributeFromString(java.lang.String, java.lang.String)
     */
    public void setAttributeFromString(String attributeName, String attributeValue) {
        if ("id".equalsIgnoreCase(attributeName))
            this.id = Long.valueOf(attributeValue);

        if ("userId".equalsIgnoreCase(attributeName))
        	this.userId = attributeValue;

    }


    /**
     * Instanciates an Hibernate proxy data object (does not load it from the database, provides lazy load for that)
     *
     * @param session the session
     * @param id      the id
     *
     * @return the proxy
     */
    public static WorkflowAliTarget getProxy(Session session, Long id)
    {
        return(WorkflowAliTarget)session.load(WorkflowAliTarget.class,id);
    }

    /**
    * Instanciates an Hibernate proxy data object (does not load it from the database, provides lazy load for that)
    *
    * @param id      the id
    *
    * @return the proxy
    */
    public static WorkflowAliTarget getProxy(Long id)
    {
        Session session = HibernateUtil.getSessionFactory("DIFRepository").getCurrentSession();
        boolean wasActive = session.getTransaction().isActive();

        if (!wasActive)
            session.beginTransaction();

        WorkflowAliTarget result = (WorkflowAliTarget)session.load(WorkflowAliTarget.class,id);

        if (!wasActive)
            session.getTransaction().commit();

        return result;
    }


    /**
     * Instanciates an Hibernate data object
     *
     * @param session the session
     * @param id      the id
     *
     * @return the instance
     */
    public static WorkflowAliTarget getInstance(Session session, Long id)
    {
        return(WorkflowAliTarget)session.get(WorkflowAliTarget.class,id);
    }

    /**
    * Instanciates an Hibernate data object
    *
    * @param id      the id
    *
    * @return the instance
    */
    public static WorkflowAliTarget getInstance(Long id)
    {
        Session session = HibernateUtil.getSessionFactory("DIFRepository").getCurrentSession();
        boolean wasActive = session.getTransaction().isActive();

        if (!wasActive)
            session.beginTransaction();

        WorkflowAliTarget result = (WorkflowAliTarget)session.get(WorkflowAliTarget.class,id);

        if (!wasActive)
            session.getTransaction().commit();

        return result;
    }

}
