package pt.digitalis.dif.dem.managers.impl.model.data;


import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hibernate.Session;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.hibernate.HibernateUtil;
import pt.digitalis.dif.model.utils.AbstractBeanRelationsAttributes;
import pt.digitalis.dif.model.utils.IBeanAttributesDataSet;

/**
 * WorkflowCustomForm
* Generated on ORM Generator
* DIF build process for the Model layer
*
*/
@SuppressWarnings("serial")
public class WorkflowCustomForm extends AbstractBeanRelationsAttributes implements java.io.Serializable, IBeanAttributesDataSet<WorkflowCustomForm> {

    /** WorkflowCustomForm attributes enumeration */
    public static class Fields
    {
        /** id column */
        public static final String ID ="id";
        /** stageId column */
        public static final String STAGEID ="stageId";
        /** formName column */
        public static final String FORMNAME ="formName";
        /** name column */
        public static final String NAME ="name";

        /**
         * List of existing fields
         *
         * @return list of field names
         */
        public static List<String> values()
        {
            ArrayList<String> list = new ArrayList<String>();
            list.add("id");
            list.add("stageId");
            list.add("formName");
            list.add("name");

            return list;
        }
    }

    /** Field attributes */
    public static WorkflowCustomFormFieldAttributes FieldAttributes=new WorkflowCustomFormFieldAttributes();

    /**
    * @return the field attributes definitions
    */
    @Override public WorkflowCustomFormFieldAttributes getDefinitions()
    {
        return FieldAttributes;
    }

    /**
     * The Class Relations.
     */
    public class Relations extends AbstractBeanRelationsAttributes.AbstractRelations
    {

        /**
        * Instantiates a new relations.
        *
        * @param currentPath the current path
        */
        public Relations(String currentPath)
        {
            super(currentPath);
        }
        /**
         * workflow relation.
         *
         * @return the workflow bean relations attributes.
         */
        public Workflow.Relations workflow()
        {
            Workflow c = new Workflow();
            return c.new Relations(this.buildPath("workflow"));
        }

        /**
         * workflowCustomFormConfigs relation.
         *
         * @return the workflowCustomFormConfigs bean relations attributes.
         */
        public WorkflowCustomFormConfig.Relations workflowCustomFormConfigs()
        {
            WorkflowCustomFormConfig c = new WorkflowCustomFormConfig();
            return c.new Relations(this.buildPath("workflowCustomFormConfigs"));
        }

        /**
         * the ID path.
         *
         * @return the path
         */
        public String ID()
        {
            return buildPath(Fields.ID);
        }
        /**
         * the STAGEID path.
         *
         * @return the path
         */
        public String STAGEID()
        {
            return buildPath(Fields.STAGEID);
        }
        /**
         * the FORMNAME path.
         *
         * @return the path
         */
        public String FORMNAME()
        {
            return buildPath(Fields.FORMNAME);
        }
        /**
         * the NAME path.
         *
         * @return the path
         */
        public String NAME()
        {
            return buildPath(Fields.NAME);
        }
    }

    /** The dummy obj. */
    private static WorkflowCustomForm dummyObj=new WorkflowCustomForm();

    /**
     * Get WorkflowCustomForm Relations .
     *
     * @return the relations
     */
    public static Relations FK()
    {
        return dummyObj.new Relations(null);
    }

    /**
    * Gets a new dataSet object for this bean
    *
    * @return the dataSet
    */
    public IDataSet<WorkflowCustomForm> getDataSet()
    {
        return new HibernateDataSet<WorkflowCustomForm>(WorkflowCustomForm.class, HibernateUtil.getSessionFactory("DIFRepository"),
            WorkflowCustomForm.getPKFieldListAsString(), WorkflowCustomForm.FieldAttributes);
    }

    /**
    * Gets a new dataSet object for this bean
    *
    * @return the dataSet
    */
    public static IDataSet<WorkflowCustomForm> getDataSetInstance()
    {
        return new WorkflowCustomForm().getDataSet();
    }

    /**
    * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeNoGraphNavigation(java.lang.String)
    */
    @Override protected Object getAttributeNoGraphNavigation(String attributeName)
    {
        if("id".equalsIgnoreCase(attributeName))
            return id;
        if("workflow".equalsIgnoreCase(attributeName))
            return workflow;
        if("stageId".equalsIgnoreCase(attributeName))
            return stageId;
        if("formName".equalsIgnoreCase(attributeName))
            return formName;
        if("name".equalsIgnoreCase(attributeName))
            return name;
        if("workflowCustomFormConfigs".equalsIgnoreCase(attributeName))
            return workflowCustomFormConfigs;

        return null;
    }

    /**
    * @see pt.digitalis.utils.common.IBeanAttributes#setAttribute(java.lang.String, java.lang.Object)
    */
    public void setAttribute(String attributeName,Object attributeValue)
    {
        if("id".equalsIgnoreCase(attributeName))
            id =(Long)attributeValue;
        if("workflow".equalsIgnoreCase(attributeName))
            workflow =(Workflow)attributeValue;
        if("stageId".equalsIgnoreCase(attributeName))
            stageId =(String)attributeValue;
        if("formName".equalsIgnoreCase(attributeName))
            formName =(String)attributeValue;
        if("name".equalsIgnoreCase(attributeName))
            name =(String)attributeValue;
        if("workflowCustomFormConfigs".equalsIgnoreCase(attributeName))
            workflowCustomFormConfigs =(Set<WorkflowCustomFormConfig>)attributeValue;
    }

    // Fields

    /** id private attribute */
    private Long id;

    /** workflow private attribute */
    private Workflow workflow;

    /** stageId private attribute */
    private String stageId;

    /** formName private attribute */
    private String formName;

    /** name private attribute */
    private String name;

    /** workflowCustomFormConfigs private attribute */
    private Set<WorkflowCustomFormConfig> workflowCustomFormConfigs = new HashSet<WorkflowCustomFormConfig>(0);

    /** The pojo's primary key field list names */
    private static List<String> pkFieldList;

    /**
     * Get the table fields that compose the PK
     *
     * @return the PK field list
     */
     public synchronized static List<String> getPKFieldList()
     {
         if (pkFieldList == null)
         {
             pkFieldList = new ArrayList<String>();
             pkFieldList.add("id");
         }

         return pkFieldList;
     }

    /**
     * Get the table fields that compose the PK as a comma separated field name list
     *
     * @return the PK field list as a string
     */
     public static String getPKFieldListAsString()
     {
         StringBuffer buffer = new StringBuffer();

         for (int i = 0; i < getPKFieldList().size(); i++)
         {
             if (i != 0)
                 buffer.append(",");

             buffer.append(getPKFieldList().get(i));
         }

         return buffer.toString();
     }

    /**
     * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeAsString(java.lang.String)
     */
     @Override
     public String getAttributeAsString(String attributeName)
     {

        Object value = getAttribute(attributeName);

        if (value == null)
            return "";
        else {
            return value.toString().trim();
        }
     }

    // Constructors

    /**
     * default constructor
     */
    public WorkflowCustomForm() {
    }

	/** 
	 * minimal constructor
	 *
     * @param workflow the workflow
     * @param stageId the stageId
     * @param formName the formName
     * @param name the name
    }
	 */
    public WorkflowCustomForm(Workflow workflow, String stageId, String formName, String name) {
        this.workflow = workflow;
        this.stageId = stageId;
        this.formName = formName;
        this.name = name;
    }

    /**
     * full constructor
	 *
     * @param workflow the workflow
     * @param stageId the stageId
     * @param formName the formName
     * @param name the name
     * @param workflowCustomFormConfigs the workflowCustomFormConfigs
     */
    public WorkflowCustomForm(Workflow workflow, String stageId, String formName, String name, Set<WorkflowCustomFormConfig> workflowCustomFormConfigs) {
        this.workflow = workflow;
        this.stageId = stageId;
        this.formName = formName;
        this.name = name;
        this.workflowCustomFormConfigs = workflowCustomFormConfigs;
    }

    // Property accessors
    
    /**       
     * id getter method
     *
     * @return id method
     */
    public Long getId() {
        return this.id;
    }
    
    /**       
     * id setter method
     *
     * @param id the id
     *
     * @return WorkflowCustomForm modified instance
     */
    public WorkflowCustomForm setId(Long id) {
        this.id = id;
        
        return this;
    }
    /**       
     * workflow getter method
     *
     * @return workflow method
     */
    public Workflow getWorkflow() {
        return this.workflow;
    }
    
    /**       
     * workflow setter method
     *
     * @param workflow the workflow
     *
     * @return WorkflowCustomForm modified instance
     */
    public WorkflowCustomForm setWorkflow(Workflow workflow) {
        this.workflow = workflow;
        
        return this;
    }
    /**       
     * stageId getter method
     *
     * @return stageId method
     */
    public String getStageId() {
        return this.stageId;
    }
    
    /**       
     * stageId setter method
     *
     * @param stageId the stageId
     *
     * @return WorkflowCustomForm modified instance
     */
    public WorkflowCustomForm setStageId(String stageId) {
        this.stageId = stageId;
        
        return this;
    }
    /**       
     * formName getter method
     *
     * @return formName method
     */
    public String getFormName() {
        return this.formName;
    }
    
    /**       
     * formName setter method
     *
     * @param formName the formName
     *
     * @return WorkflowCustomForm modified instance
     */
    public WorkflowCustomForm setFormName(String formName) {
        this.formName = formName;
        
        return this;
    }
    /**       
     * name getter method
     *
     * @return name method
     */
    public String getName() {
        return this.name;
    }
    
    /**       
     * name setter method
     *
     * @param name the name
     *
     * @return WorkflowCustomForm modified instance
     */
    public WorkflowCustomForm setName(String name) {
        this.name = name;
        
        return this;
    }
    /**       
     * workflowCustomFormConfigs getter method
     *
     * @return workflowCustomFormConfigs method
     */
    public Set<WorkflowCustomFormConfig> getWorkflowCustomFormConfigs() {
        return this.workflowCustomFormConfigs;
    }
    
    /**       
     * workflowCustomFormConfigs setter method
     *
     * @param workflowCustomFormConfigs the workflowCustomFormConfigs
     *
     * @return WorkflowCustomForm modified instance
     */
    public WorkflowCustomForm setWorkflowCustomFormConfigs(Set<WorkflowCustomFormConfig> workflowCustomFormConfigs) {
        this.workflowCustomFormConfigs = workflowCustomFormConfigs;
        
        return this;
    }

    /**
     * Creates a String representation of the WorkflowCustomForm object
     *
     * @return the compiled String
     */
    @Override
    public String toString() {
	    StringBuffer buffer = new StringBuffer();

        buffer.append(getClass().getName()).append("@").append(Integer.toHexString(hashCode())).append(" [");

        buffer.append("id").append("='").append(getId()).append("' ");			
        buffer.append("stageId").append("='").append(getStageId()).append("' ");			
        buffer.append("formName").append("='").append(getFormName()).append("' ");			
        buffer.append("name").append("='").append(getName()).append("' ");			
        buffer.append("]");
      
        return buffer.toString();
    }

    /**
     * Compares the String representation of the WorkflowCustomForm object
     *
     * @param other The object to compare to
     *
     * @return true of the objects are equal
     */
    public boolean equals(WorkflowCustomForm other) {
        	return this.toString().equals(other.toString());
    }
    /**
     * @see pt.digitalis.utils.common.IBeanAttributes#setAttributeFromString(java.lang.String, java.lang.String)
     */
    public void setAttributeFromString(String attributeName, String attributeValue) {
        if ("id".equalsIgnoreCase(attributeName))
            this.id = Long.valueOf(attributeValue);

        if ("stageId".equalsIgnoreCase(attributeName))
        	this.stageId = attributeValue;

        if ("formName".equalsIgnoreCase(attributeName))
        	this.formName = attributeValue;

        if ("name".equalsIgnoreCase(attributeName))
        	this.name = attributeValue;

    }


    /**
     * Instanciates an Hibernate proxy data object (does not load it from the database, provides lazy load for that)
     *
     * @param session the session
     * @param id      the id
     *
     * @return the proxy
     */
    public static WorkflowCustomForm getProxy(Session session, Long id)
    {
        return(WorkflowCustomForm)session.load(WorkflowCustomForm.class,id);
    }

    /**
    * Instanciates an Hibernate proxy data object (does not load it from the database, provides lazy load for that)
    *
    * @param id      the id
    *
    * @return the proxy
    */
    public static WorkflowCustomForm getProxy(Long id)
    {
        Session session = HibernateUtil.getSessionFactory("DIFRepository").getCurrentSession();
        boolean wasActive = session.getTransaction().isActive();

        if (!wasActive)
            session.beginTransaction();

        WorkflowCustomForm result = (WorkflowCustomForm)session.load(WorkflowCustomForm.class,id);

        if (!wasActive)
            session.getTransaction().commit();

        return result;
    }


    /**
     * Instanciates an Hibernate data object
     *
     * @param session the session
     * @param id      the id
     *
     * @return the instance
     */
    public static WorkflowCustomForm getInstance(Session session, Long id)
    {
        return(WorkflowCustomForm)session.get(WorkflowCustomForm.class,id);
    }

    /**
    * Instanciates an Hibernate data object
    *
    * @param id      the id
    *
    * @return the instance
    */
    public static WorkflowCustomForm getInstance(Long id)
    {
        Session session = HibernateUtil.getSessionFactory("DIFRepository").getCurrentSession();
        boolean wasActive = session.getTransaction().isActive();

        if (!wasActive)
            session.beginTransaction();

        WorkflowCustomForm result = (WorkflowCustomForm)session.get(WorkflowCustomForm.class,id);

        if (!wasActive)
            session.getTransaction().commit();

        return result;
    }

}
