package pt.digitalis.dif.dem.managers.impl.model.data;


import java.util.ArrayList;
import java.util.List;
import org.hibernate.Session;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.hibernate.HibernateUtil;
import pt.digitalis.dif.model.utils.AbstractBeanRelationsAttributes;
import pt.digitalis.dif.model.utils.IBeanAttributesDataSet;

/**
 * WorkflowCustomFormConfig
* Generated on ORM Generator
* DIF build process for the Model layer
*
*/
@SuppressWarnings("serial")
public class WorkflowCustomFormConfig extends AbstractBeanRelationsAttributes implements java.io.Serializable, IBeanAttributesDataSet<WorkflowCustomFormConfig> {

    /** WorkflowCustomFormConfig attributes enumeration */
    public static class Fields
    {
        /** id column */
        public static final String ID ="id";

        /**
         * List of existing fields
         *
         * @return list of field names
         */
        public static List<String> values()
        {
            ArrayList<String> list = new ArrayList<String>();
            list.add("id");

            return list;
        }
    }

    /** Field attributes */
    public static WorkflowCustomFormConfigFieldAttributes FieldAttributes=new WorkflowCustomFormConfigFieldAttributes();

    /**
    * @return the field attributes definitions
    */
    @Override public WorkflowCustomFormConfigFieldAttributes getDefinitions()
    {
        return FieldAttributes;
    }

    /**
     * The Class Relations.
     */
    public class Relations extends AbstractBeanRelationsAttributes.AbstractRelations
    {

        /**
        * Instantiates a new relations.
        *
        * @param currentPath the current path
        */
        public Relations(String currentPath)
        {
            super(currentPath);
        }
        /**
         * workflowUserProfile relation.
         *
         * @return the workflowUserProfile bean relations attributes.
         */
        public WorkflowUserProfile.Relations workflowUserProfile()
        {
            WorkflowUserProfile c = new WorkflowUserProfile();
            return c.new Relations(this.buildPath("workflowUserProfile"));
        }

        /**
         * workflowCustomForm relation.
         *
         * @return the workflowCustomForm bean relations attributes.
         */
        public WorkflowCustomForm.Relations workflowCustomForm()
        {
            WorkflowCustomForm c = new WorkflowCustomForm();
            return c.new Relations(this.buildPath("workflowCustomForm"));
        }

        /**
         * workflowState relation.
         *
         * @return the workflowState bean relations attributes.
         */
        public WorkflowState.Relations workflowState()
        {
            WorkflowState c = new WorkflowState();
            return c.new Relations(this.buildPath("workflowState"));
        }

        /**
         * the ID path.
         *
         * @return the path
         */
        public String ID()
        {
            return buildPath(Fields.ID);
        }
    }

    /** The dummy obj. */
    private static WorkflowCustomFormConfig dummyObj=new WorkflowCustomFormConfig();

    /**
     * Get WorkflowCustomFormConfig Relations .
     *
     * @return the relations
     */
    public static Relations FK()
    {
        return dummyObj.new Relations(null);
    }

    /**
    * Gets a new dataSet object for this bean
    *
    * @return the dataSet
    */
    public IDataSet<WorkflowCustomFormConfig> getDataSet()
    {
        return new HibernateDataSet<WorkflowCustomFormConfig>(WorkflowCustomFormConfig.class, HibernateUtil.getSessionFactory("DIFRepository"),
            WorkflowCustomFormConfig.getPKFieldListAsString(), WorkflowCustomFormConfig.FieldAttributes);
    }

    /**
    * Gets a new dataSet object for this bean
    *
    * @return the dataSet
    */
    public static IDataSet<WorkflowCustomFormConfig> getDataSetInstance()
    {
        return new WorkflowCustomFormConfig().getDataSet();
    }

    /**
    * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeNoGraphNavigation(java.lang.String)
    */
    @Override protected Object getAttributeNoGraphNavigation(String attributeName)
    {
        if("id".equalsIgnoreCase(attributeName))
            return id;
        if("workflowUserProfile".equalsIgnoreCase(attributeName))
            return workflowUserProfile;
        if("workflowCustomForm".equalsIgnoreCase(attributeName))
            return workflowCustomForm;
        if("workflowState".equalsIgnoreCase(attributeName))
            return workflowState;

        return null;
    }

    /**
    * @see pt.digitalis.utils.common.IBeanAttributes#setAttribute(java.lang.String, java.lang.Object)
    */
    public void setAttribute(String attributeName,Object attributeValue)
    {
        if("id".equalsIgnoreCase(attributeName))
            id =(Long)attributeValue;
        if("workflowUserProfile".equalsIgnoreCase(attributeName))
            workflowUserProfile =(WorkflowUserProfile)attributeValue;
        if("workflowCustomForm".equalsIgnoreCase(attributeName))
            workflowCustomForm =(WorkflowCustomForm)attributeValue;
        if("workflowState".equalsIgnoreCase(attributeName))
            workflowState =(WorkflowState)attributeValue;
    }

    // Fields

    /** id private attribute */
    private Long id;

    /** workflowUserProfile private attribute */
    private WorkflowUserProfile workflowUserProfile;

    /** workflowCustomForm private attribute */
    private WorkflowCustomForm workflowCustomForm;

    /** workflowState private attribute */
    private WorkflowState workflowState;

    /** The pojo's primary key field list names */
    private static List<String> pkFieldList;

    /**
     * Get the table fields that compose the PK
     *
     * @return the PK field list
     */
     public synchronized static List<String> getPKFieldList()
     {
         if (pkFieldList == null)
         {
             pkFieldList = new ArrayList<String>();
             pkFieldList.add("id");
         }

         return pkFieldList;
     }

    /**
     * Get the table fields that compose the PK as a comma separated field name list
     *
     * @return the PK field list as a string
     */
     public static String getPKFieldListAsString()
     {
         StringBuffer buffer = new StringBuffer();

         for (int i = 0; i < getPKFieldList().size(); i++)
         {
             if (i != 0)
                 buffer.append(",");

             buffer.append(getPKFieldList().get(i));
         }

         return buffer.toString();
     }

    /**
     * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeAsString(java.lang.String)
     */
     @Override
     public String getAttributeAsString(String attributeName)
     {

        Object value = getAttribute(attributeName);

        if (value == null)
            return "";
        else {
            return value.toString().trim();
        }
     }

    // Constructors

    /**
     * default constructor
     */
    public WorkflowCustomFormConfig() {
    }

	/** 
	 * minimal constructor
	 *
     * @param workflowCustomForm the workflowCustomForm
    }
	 */
    public WorkflowCustomFormConfig(WorkflowCustomForm workflowCustomForm) {
        this.workflowCustomForm = workflowCustomForm;
    }

    /**
     * full constructor
	 *
     * @param workflowUserProfile the workflowUserProfile
     * @param workflowCustomForm the workflowCustomForm
     * @param workflowState the workflowState
     */
    public WorkflowCustomFormConfig(WorkflowUserProfile workflowUserProfile, WorkflowCustomForm workflowCustomForm, WorkflowState workflowState) {
        this.workflowUserProfile = workflowUserProfile;
        this.workflowCustomForm = workflowCustomForm;
        this.workflowState = workflowState;
    }

    // Property accessors
    
    /**       
     * id getter method
     *
     * @return id method
     */
    public Long getId() {
        return this.id;
    }
    
    /**       
     * id setter method
     *
     * @param id the id
     *
     * @return WorkflowCustomFormConfig modified instance
     */
    public WorkflowCustomFormConfig setId(Long id) {
        this.id = id;
        
        return this;
    }
    /**       
     * workflowUserProfile getter method
     *
     * @return workflowUserProfile method
     */
    public WorkflowUserProfile getWorkflowUserProfile() {
        return this.workflowUserProfile;
    }
    
    /**       
     * workflowUserProfile setter method
     *
     * @param workflowUserProfile the workflowUserProfile
     *
     * @return WorkflowCustomFormConfig modified instance
     */
    public WorkflowCustomFormConfig setWorkflowUserProfile(WorkflowUserProfile workflowUserProfile) {
        this.workflowUserProfile = workflowUserProfile;
        
        return this;
    }
    /**       
     * workflowCustomForm getter method
     *
     * @return workflowCustomForm method
     */
    public WorkflowCustomForm getWorkflowCustomForm() {
        return this.workflowCustomForm;
    }
    
    /**       
     * workflowCustomForm setter method
     *
     * @param workflowCustomForm the workflowCustomForm
     *
     * @return WorkflowCustomFormConfig modified instance
     */
    public WorkflowCustomFormConfig setWorkflowCustomForm(WorkflowCustomForm workflowCustomForm) {
        this.workflowCustomForm = workflowCustomForm;
        
        return this;
    }
    /**       
     * workflowState getter method
     *
     * @return workflowState method
     */
    public WorkflowState getWorkflowState() {
        return this.workflowState;
    }
    
    /**       
     * workflowState setter method
     *
     * @param workflowState the workflowState
     *
     * @return WorkflowCustomFormConfig modified instance
     */
    public WorkflowCustomFormConfig setWorkflowState(WorkflowState workflowState) {
        this.workflowState = workflowState;
        
        return this;
    }

    /**
     * Creates a String representation of the WorkflowCustomFormConfig object
     *
     * @return the compiled String
     */
    @Override
    public String toString() {
	    StringBuffer buffer = new StringBuffer();

        buffer.append(getClass().getName()).append("@").append(Integer.toHexString(hashCode())).append(" [");

        buffer.append("id").append("='").append(getId()).append("' ");			
        buffer.append("]");
      
        return buffer.toString();
    }

    /**
     * Compares the String representation of the WorkflowCustomFormConfig object
     *
     * @param other The object to compare to
     *
     * @return true of the objects are equal
     */
    public boolean equals(WorkflowCustomFormConfig other) {
        	return this.toString().equals(other.toString());
    }
    /**
     * @see pt.digitalis.utils.common.IBeanAttributes#setAttributeFromString(java.lang.String, java.lang.String)
     */
    public void setAttributeFromString(String attributeName, String attributeValue) {
        if ("id".equalsIgnoreCase(attributeName))
            this.id = Long.valueOf(attributeValue);

    }


    /**
     * Instanciates an Hibernate proxy data object (does not load it from the database, provides lazy load for that)
     *
     * @param session the session
     * @param id      the id
     *
     * @return the proxy
     */
    public static WorkflowCustomFormConfig getProxy(Session session, Long id)
    {
        return(WorkflowCustomFormConfig)session.load(WorkflowCustomFormConfig.class,id);
    }

    /**
    * Instanciates an Hibernate proxy data object (does not load it from the database, provides lazy load for that)
    *
    * @param id      the id
    *
    * @return the proxy
    */
    public static WorkflowCustomFormConfig getProxy(Long id)
    {
        Session session = HibernateUtil.getSessionFactory("DIFRepository").getCurrentSession();
        boolean wasActive = session.getTransaction().isActive();

        if (!wasActive)
            session.beginTransaction();

        WorkflowCustomFormConfig result = (WorkflowCustomFormConfig)session.load(WorkflowCustomFormConfig.class,id);

        if (!wasActive)
            session.getTransaction().commit();

        return result;
    }


    /**
     * Instanciates an Hibernate data object
     *
     * @param session the session
     * @param id      the id
     *
     * @return the instance
     */
    public static WorkflowCustomFormConfig getInstance(Session session, Long id)
    {
        return(WorkflowCustomFormConfig)session.get(WorkflowCustomFormConfig.class,id);
    }

    /**
    * Instanciates an Hibernate data object
    *
    * @param id      the id
    *
    * @return the instance
    */
    public static WorkflowCustomFormConfig getInstance(Long id)
    {
        Session session = HibernateUtil.getSessionFactory("DIFRepository").getCurrentSession();
        boolean wasActive = session.getTransaction().isActive();

        if (!wasActive)
            session.beginTransaction();

        WorkflowCustomFormConfig result = (WorkflowCustomFormConfig)session.get(WorkflowCustomFormConfig.class,id);

        if (!wasActive)
            session.getTransaction().commit();

        return result;
    }

}
