package pt.digitalis.dif.dem.managers.impl.model.data;


import java.util.ArrayList;
import java.util.List;
import org.hibernate.Session;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.hibernate.HibernateUtil;
import pt.digitalis.dif.model.utils.AbstractBeanRelationsAttributes;
import pt.digitalis.dif.model.utils.IBeanAttributesDataSet;

/**
 * WorkflowInstance
* Generated on ORM Generator
* DIF build process for the Model layer
*
*/
@SuppressWarnings("serial")
public class WorkflowInstance extends AbstractBeanRelationsAttributes implements java.io.Serializable, IBeanAttributesDataSet<WorkflowInstance> {

    /** WorkflowInstance attributes enumeration */
    public static class Fields
    {
        /** id column */
        public static final String ID ="id";
        /** businessId column */
        public static final String BUSINESSID ="businessId";
        /** creatorUserId column */
        public static final String CREATORUSERID ="creatorUserId";
        /** currentOwnerUserId column */
        public static final String CURRENTOWNERUSERID ="currentOwnerUserId";

        /**
         * List of existing fields
         *
         * @return list of field names
         */
        public static List<String> values()
        {
            ArrayList<String> list = new ArrayList<String>();
            list.add("id");
            list.add("businessId");
            list.add("creatorUserId");
            list.add("currentOwnerUserId");

            return list;
        }
    }

    /** Field attributes */
    public static WorkflowInstanceFieldAttributes FieldAttributes=new WorkflowInstanceFieldAttributes();

    /**
    * @return the field attributes definitions
    */
    @Override public WorkflowInstanceFieldAttributes getDefinitions()
    {
        return FieldAttributes;
    }

    /**
     * The Class Relations.
     */
    public class Relations extends AbstractBeanRelationsAttributes.AbstractRelations
    {

        /**
        * Instantiates a new relations.
        *
        * @param currentPath the current path
        */
        public Relations(String currentPath)
        {
            super(currentPath);
        }
        /**
         * fileBundleInstance relation.
         *
         * @return the fileBundleInstance bean relations attributes.
         */
        public FileBundleInstance.Relations fileBundleInstance()
        {
            FileBundleInstance c = new FileBundleInstance();
            return c.new Relations(this.buildPath("fileBundleInstance"));
        }

        /**
         * conversation relation.
         *
         * @return the conversation bean relations attributes.
         */
        public Conversation.Relations conversation()
        {
            Conversation c = new Conversation();
            return c.new Relations(this.buildPath("conversation"));
        }

        /**
         * workflowState relation.
         *
         * @return the workflowState bean relations attributes.
         */
        public WorkflowState.Relations workflowState()
        {
            WorkflowState c = new WorkflowState();
            return c.new Relations(this.buildPath("workflowState"));
        }

        /**
         * workflow relation.
         *
         * @return the workflow bean relations attributes.
         */
        public Workflow.Relations workflow()
        {
            Workflow c = new Workflow();
            return c.new Relations(this.buildPath("workflow"));
        }

        /**
         * the ID path.
         *
         * @return the path
         */
        public String ID()
        {
            return buildPath(Fields.ID);
        }
        /**
         * the BUSINESSID path.
         *
         * @return the path
         */
        public String BUSINESSID()
        {
            return buildPath(Fields.BUSINESSID);
        }
        /**
         * the CREATORUSERID path.
         *
         * @return the path
         */
        public String CREATORUSERID()
        {
            return buildPath(Fields.CREATORUSERID);
        }
        /**
         * the CURRENTOWNERUSERID path.
         *
         * @return the path
         */
        public String CURRENTOWNERUSERID()
        {
            return buildPath(Fields.CURRENTOWNERUSERID);
        }
    }

    /** The dummy obj. */
    private static WorkflowInstance dummyObj=new WorkflowInstance();

    /**
     * Get WorkflowInstance Relations .
     *
     * @return the relations
     */
    public static Relations FK()
    {
        return dummyObj.new Relations(null);
    }

    /**
    * Gets a new dataSet object for this bean
    *
    * @return the dataSet
    */
    public IDataSet<WorkflowInstance> getDataSet()
    {
        return new HibernateDataSet<WorkflowInstance>(WorkflowInstance.class, HibernateUtil.getSessionFactory("DIFRepository"),
            WorkflowInstance.getPKFieldListAsString(), WorkflowInstance.FieldAttributes);
    }

    /**
    * Gets a new dataSet object for this bean
    *
    * @return the dataSet
    */
    public static IDataSet<WorkflowInstance> getDataSetInstance()
    {
        return new WorkflowInstance().getDataSet();
    }

    /**
    * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeNoGraphNavigation(java.lang.String)
    */
    @Override protected Object getAttributeNoGraphNavigation(String attributeName)
    {
        if("id".equalsIgnoreCase(attributeName))
            return id;
        if("fileBundleInstance".equalsIgnoreCase(attributeName))
            return fileBundleInstance;
        if("conversation".equalsIgnoreCase(attributeName))
            return conversation;
        if("workflowState".equalsIgnoreCase(attributeName))
            return workflowState;
        if("workflow".equalsIgnoreCase(attributeName))
            return workflow;
        if("businessId".equalsIgnoreCase(attributeName))
            return businessId;
        if("creatorUserId".equalsIgnoreCase(attributeName))
            return creatorUserId;
        if("currentOwnerUserId".equalsIgnoreCase(attributeName))
            return currentOwnerUserId;

        return null;
    }

    /**
    * @see pt.digitalis.utils.common.IBeanAttributes#setAttribute(java.lang.String, java.lang.Object)
    */
    public void setAttribute(String attributeName,Object attributeValue)
    {
        if("id".equalsIgnoreCase(attributeName))
            id =(Long)attributeValue;
        if("fileBundleInstance".equalsIgnoreCase(attributeName))
            fileBundleInstance =(FileBundleInstance)attributeValue;
        if("conversation".equalsIgnoreCase(attributeName))
            conversation =(Conversation)attributeValue;
        if("workflowState".equalsIgnoreCase(attributeName))
            workflowState =(WorkflowState)attributeValue;
        if("workflow".equalsIgnoreCase(attributeName))
            workflow =(Workflow)attributeValue;
        if("businessId".equalsIgnoreCase(attributeName))
            businessId =(String)attributeValue;
        if("creatorUserId".equalsIgnoreCase(attributeName))
            creatorUserId =(String)attributeValue;
        if("currentOwnerUserId".equalsIgnoreCase(attributeName))
            currentOwnerUserId =(String)attributeValue;
    }

    // Fields

    /** id private attribute */
    private Long id;

    /** fileBundleInstance private attribute */
    private FileBundleInstance fileBundleInstance;

    /** conversation private attribute */
    private Conversation conversation;

    /** workflowState private attribute */
    private WorkflowState workflowState;

    /** workflow private attribute */
    private Workflow workflow;

    /** businessId private attribute */
    private String businessId;

    /** creatorUserId private attribute */
    private String creatorUserId;

    /** currentOwnerUserId private attribute */
    private String currentOwnerUserId;

    /** The pojo's primary key field list names */
    private static List<String> pkFieldList;

    /**
     * Get the table fields that compose the PK
     *
     * @return the PK field list
     */
     public synchronized static List<String> getPKFieldList()
     {
         if (pkFieldList == null)
         {
             pkFieldList = new ArrayList<String>();
             pkFieldList.add("id");
         }

         return pkFieldList;
     }

    /**
     * Get the table fields that compose the PK as a comma separated field name list
     *
     * @return the PK field list as a string
     */
     public static String getPKFieldListAsString()
     {
         StringBuffer buffer = new StringBuffer();

         for (int i = 0; i < getPKFieldList().size(); i++)
         {
             if (i != 0)
                 buffer.append(",");

             buffer.append(getPKFieldList().get(i));
         }

         return buffer.toString();
     }

    /**
     * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeAsString(java.lang.String)
     */
     @Override
     public String getAttributeAsString(String attributeName)
     {

        Object value = getAttribute(attributeName);

        if (value == null)
            return "";
        else {
            return value.toString().trim();
        }
     }

    // Constructors

    /**
     * default constructor
     */
    public WorkflowInstance() {
    }

	/** 
	 * minimal constructor
	 *
     * @param conversation the conversation
     * @param workflowState the workflowState
     * @param workflow the workflow
     * @param businessId the businessId
    }
	 */
    public WorkflowInstance(Conversation conversation, WorkflowState workflowState, Workflow workflow, String businessId) {
        this.conversation = conversation;
        this.workflowState = workflowState;
        this.workflow = workflow;
        this.businessId = businessId;
    }

    /**
     * full constructor
	 *
     * @param fileBundleInstance the fileBundleInstance
     * @param conversation the conversation
     * @param workflowState the workflowState
     * @param workflow the workflow
     * @param businessId the businessId
     * @param creatorUserId the creatorUserId
     * @param currentOwnerUserId the currentOwnerUserId
     */
    public WorkflowInstance(FileBundleInstance fileBundleInstance, Conversation conversation, WorkflowState workflowState, Workflow workflow, String businessId, String creatorUserId, String currentOwnerUserId) {
        this.fileBundleInstance = fileBundleInstance;
        this.conversation = conversation;
        this.workflowState = workflowState;
        this.workflow = workflow;
        this.businessId = businessId;
        this.creatorUserId = creatorUserId;
        this.currentOwnerUserId = currentOwnerUserId;
    }

    // Property accessors
    
    /**       
     * id getter method
     *
     * @return id method
     */
    public Long getId() {
        return this.id;
    }
    
    /**       
     * id setter method
     *
     * @param id the id
     *
     * @return WorkflowInstance modified instance
     */
    public WorkflowInstance setId(Long id) {
        this.id = id;
        
        return this;
    }
    /**       
     * fileBundleInstance getter method
     *
     * @return fileBundleInstance method
     */
    public FileBundleInstance getFileBundleInstance() {
        return this.fileBundleInstance;
    }
    
    /**       
     * fileBundleInstance setter method
     *
     * @param fileBundleInstance the fileBundleInstance
     *
     * @return WorkflowInstance modified instance
     */
    public WorkflowInstance setFileBundleInstance(FileBundleInstance fileBundleInstance) {
        this.fileBundleInstance = fileBundleInstance;
        
        return this;
    }
    /**       
     * conversation getter method
     *
     * @return conversation method
     */
    public Conversation getConversation() {
        return this.conversation;
    }
    
    /**       
     * conversation setter method
     *
     * @param conversation the conversation
     *
     * @return WorkflowInstance modified instance
     */
    public WorkflowInstance setConversation(Conversation conversation) {
        this.conversation = conversation;
        
        return this;
    }
    /**       
     * workflowState getter method
     *
     * @return workflowState method
     */
    public WorkflowState getWorkflowState() {
        return this.workflowState;
    }
    
    /**       
     * workflowState setter method
     *
     * @param workflowState the workflowState
     *
     * @return WorkflowInstance modified instance
     */
    public WorkflowInstance setWorkflowState(WorkflowState workflowState) {
        this.workflowState = workflowState;
        
        return this;
    }
    /**       
     * workflow getter method
     *
     * @return workflow method
     */
    public Workflow getWorkflow() {
        return this.workflow;
    }
    
    /**       
     * workflow setter method
     *
     * @param workflow the workflow
     *
     * @return WorkflowInstance modified instance
     */
    public WorkflowInstance setWorkflow(Workflow workflow) {
        this.workflow = workflow;
        
        return this;
    }
    /**       
     * businessId getter method
     *
     * @return businessId method
     */
    public String getBusinessId() {
        return this.businessId;
    }
    
    /**       
     * businessId setter method
     *
     * @param businessId the businessId
     *
     * @return WorkflowInstance modified instance
     */
    public WorkflowInstance setBusinessId(String businessId) {
        this.businessId = businessId;
        
        return this;
    }
    /**       
     * creatorUserId getter method
     *
     * @return creatorUserId method
     */
    public String getCreatorUserId() {
        return this.creatorUserId;
    }
    
    /**       
     * creatorUserId setter method
     *
     * @param creatorUserId the creatorUserId
     *
     * @return WorkflowInstance modified instance
     */
    public WorkflowInstance setCreatorUserId(String creatorUserId) {
        this.creatorUserId = creatorUserId;
        
        return this;
    }
    /**       
     * currentOwnerUserId getter method
     *
     * @return currentOwnerUserId method
     */
    public String getCurrentOwnerUserId() {
        return this.currentOwnerUserId;
    }
    
    /**       
     * currentOwnerUserId setter method
     *
     * @param currentOwnerUserId the currentOwnerUserId
     *
     * @return WorkflowInstance modified instance
     */
    public WorkflowInstance setCurrentOwnerUserId(String currentOwnerUserId) {
        this.currentOwnerUserId = currentOwnerUserId;
        
        return this;
    }

    /**
     * Creates a String representation of the WorkflowInstance object
     *
     * @return the compiled String
     */
    @Override
    public String toString() {
	    StringBuffer buffer = new StringBuffer();

        buffer.append(getClass().getName()).append("@").append(Integer.toHexString(hashCode())).append(" [");

        buffer.append("id").append("='").append(getId()).append("' ");			
        buffer.append("businessId").append("='").append(getBusinessId()).append("' ");			
        buffer.append("creatorUserId").append("='").append(getCreatorUserId()).append("' ");			
        buffer.append("currentOwnerUserId").append("='").append(getCurrentOwnerUserId()).append("' ");			
        buffer.append("]");
      
        return buffer.toString();
    }

    /**
     * Compares the String representation of the WorkflowInstance object
     *
     * @param other The object to compare to
     *
     * @return true of the objects are equal
     */
    public boolean equals(WorkflowInstance other) {
        	return this.toString().equals(other.toString());
    }
    /**
     * @see pt.digitalis.utils.common.IBeanAttributes#setAttributeFromString(java.lang.String, java.lang.String)
     */
    public void setAttributeFromString(String attributeName, String attributeValue) {
        if ("id".equalsIgnoreCase(attributeName))
            this.id = Long.valueOf(attributeValue);

        if ("businessId".equalsIgnoreCase(attributeName))
        	this.businessId = attributeValue;

        if ("creatorUserId".equalsIgnoreCase(attributeName))
        	this.creatorUserId = attributeValue;

        if ("currentOwnerUserId".equalsIgnoreCase(attributeName))
        	this.currentOwnerUserId = attributeValue;

    }


    /**
     * Instanciates an Hibernate proxy data object (does not load it from the database, provides lazy load for that)
     *
     * @param session the session
     * @param id      the id
     *
     * @return the proxy
     */
    public static WorkflowInstance getProxy(Session session, Long id)
    {
        return(WorkflowInstance)session.load(WorkflowInstance.class,id);
    }

    /**
    * Instanciates an Hibernate proxy data object (does not load it from the database, provides lazy load for that)
    *
    * @param id      the id
    *
    * @return the proxy
    */
    public static WorkflowInstance getProxy(Long id)
    {
        Session session = HibernateUtil.getSessionFactory("DIFRepository").getCurrentSession();
        boolean wasActive = session.getTransaction().isActive();

        if (!wasActive)
            session.beginTransaction();

        WorkflowInstance result = (WorkflowInstance)session.load(WorkflowInstance.class,id);

        if (!wasActive)
            session.getTransaction().commit();

        return result;
    }


    /**
     * Instanciates an Hibernate data object
     *
     * @param session the session
     * @param id      the id
     *
     * @return the instance
     */
    public static WorkflowInstance getInstance(Session session, Long id)
    {
        return(WorkflowInstance)session.get(WorkflowInstance.class,id);
    }

    /**
    * Instanciates an Hibernate data object
    *
    * @param id      the id
    *
    * @return the instance
    */
    public static WorkflowInstance getInstance(Long id)
    {
        Session session = HibernateUtil.getSessionFactory("DIFRepository").getCurrentSession();
        boolean wasActive = session.getTransaction().isActive();

        if (!wasActive)
            session.beginTransaction();

        WorkflowInstance result = (WorkflowInstance)session.get(WorkflowInstance.class,id);

        if (!wasActive)
            session.getTransaction().commit();

        return result;
    }

}
