package pt.digitalis.dif.dem.managers.impl.model.data;


import java.util.ArrayList;
import java.util.List;
import org.hibernate.Session;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.hibernate.HibernateUtil;
import pt.digitalis.dif.model.utils.AbstractBeanRelationsAttributes;
import pt.digitalis.dif.model.utils.IBeanAttributesDataSet;

/**
 * WorkflowStateActionAcl
* Generated on ORM Generator
* DIF build process for the Model layer
*
*/
@SuppressWarnings("serial")
public class WorkflowStateActionAcl extends AbstractBeanRelationsAttributes implements java.io.Serializable, IBeanAttributesDataSet<WorkflowStateActionAcl> {

    /** WorkflowStateActionAcl attributes enumeration */
    public static class Fields
    {
        /** id column */
        public static final String ID ="id";
        /** userId column */
        public static final String USERID ="userId";

        /**
         * List of existing fields
         *
         * @return list of field names
         */
        public static List<String> values()
        {
            ArrayList<String> list = new ArrayList<String>();
            list.add("id");
            list.add("userId");

            return list;
        }
    }

    /** Field attributes */
    public static WorkflowStateActionAclFieldAttributes FieldAttributes=new WorkflowStateActionAclFieldAttributes();

    /**
    * @return the field attributes definitions
    */
    @Override public WorkflowStateActionAclFieldAttributes getDefinitions()
    {
        return FieldAttributes;
    }

    /**
     * The Class Relations.
     */
    public class Relations extends AbstractBeanRelationsAttributes.AbstractRelations
    {

        /**
        * Instantiates a new relations.
        *
        * @param currentPath the current path
        */
        public Relations(String currentPath)
        {
            super(currentPath);
        }
        /**
         * workflowUserProfile relation.
         *
         * @return the workflowUserProfile bean relations attributes.
         */
        public WorkflowUserProfile.Relations workflowUserProfile()
        {
            WorkflowUserProfile c = new WorkflowUserProfile();
            return c.new Relations(this.buildPath("workflowUserProfile"));
        }

        /**
         * workflowStateAction relation.
         *
         * @return the workflowStateAction bean relations attributes.
         */
        public WorkflowStateAction.Relations workflowStateAction()
        {
            WorkflowStateAction c = new WorkflowStateAction();
            return c.new Relations(this.buildPath("workflowStateAction"));
        }

        /**
         * the ID path.
         *
         * @return the path
         */
        public String ID()
        {
            return buildPath(Fields.ID);
        }
        /**
         * the USERID path.
         *
         * @return the path
         */
        public String USERID()
        {
            return buildPath(Fields.USERID);
        }
    }

    /** The dummy obj. */
    private static WorkflowStateActionAcl dummyObj=new WorkflowStateActionAcl();

    /**
     * Get WorkflowStateActionAcl Relations .
     *
     * @return the relations
     */
    public static Relations FK()
    {
        return dummyObj.new Relations(null);
    }

    /**
    * Gets a new dataSet object for this bean
    *
    * @return the dataSet
    */
    public IDataSet<WorkflowStateActionAcl> getDataSet()
    {
        return new HibernateDataSet<WorkflowStateActionAcl>(WorkflowStateActionAcl.class, HibernateUtil.getSessionFactory("DIFRepository"),
            WorkflowStateActionAcl.getPKFieldListAsString(), WorkflowStateActionAcl.FieldAttributes);
    }

    /**
    * Gets a new dataSet object for this bean
    *
    * @return the dataSet
    */
    public static IDataSet<WorkflowStateActionAcl> getDataSetInstance()
    {
        return new WorkflowStateActionAcl().getDataSet();
    }

    /**
    * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeNoGraphNavigation(java.lang.String)
    */
    @Override protected Object getAttributeNoGraphNavigation(String attributeName)
    {
        if("id".equalsIgnoreCase(attributeName))
            return id;
        if("workflowUserProfile".equalsIgnoreCase(attributeName))
            return workflowUserProfile;
        if("workflowStateAction".equalsIgnoreCase(attributeName))
            return workflowStateAction;
        if("userId".equalsIgnoreCase(attributeName))
            return userId;

        return null;
    }

    /**
    * @see pt.digitalis.utils.common.IBeanAttributes#setAttribute(java.lang.String, java.lang.Object)
    */
    public void setAttribute(String attributeName,Object attributeValue)
    {
        if("id".equalsIgnoreCase(attributeName))
            id =(Long)attributeValue;
        if("workflowUserProfile".equalsIgnoreCase(attributeName))
            workflowUserProfile =(WorkflowUserProfile)attributeValue;
        if("workflowStateAction".equalsIgnoreCase(attributeName))
            workflowStateAction =(WorkflowStateAction)attributeValue;
        if("userId".equalsIgnoreCase(attributeName))
            userId =(String)attributeValue;
    }

    // Fields

    /** id private attribute */
    private Long id;

    /** workflowUserProfile private attribute */
    private WorkflowUserProfile workflowUserProfile;

    /** workflowStateAction private attribute */
    private WorkflowStateAction workflowStateAction;

    /** userId private attribute */
    private String userId;

    /** The pojo's primary key field list names */
    private static List<String> pkFieldList;

    /**
     * Get the table fields that compose the PK
     *
     * @return the PK field list
     */
     public synchronized static List<String> getPKFieldList()
     {
         if (pkFieldList == null)
         {
             pkFieldList = new ArrayList<String>();
             pkFieldList.add("id");
         }

         return pkFieldList;
     }

    /**
     * Get the table fields that compose the PK as a comma separated field name list
     *
     * @return the PK field list as a string
     */
     public static String getPKFieldListAsString()
     {
         StringBuffer buffer = new StringBuffer();

         for (int i = 0; i < getPKFieldList().size(); i++)
         {
             if (i != 0)
                 buffer.append(",");

             buffer.append(getPKFieldList().get(i));
         }

         return buffer.toString();
     }

    /**
     * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeAsString(java.lang.String)
     */
     @Override
     public String getAttributeAsString(String attributeName)
     {

        Object value = getAttribute(attributeName);

        if (value == null)
            return "";
        else {
            return value.toString().trim();
        }
     }

    // Constructors

    /**
     * default constructor
     */
    public WorkflowStateActionAcl() {
    }

	/** 
	 * minimal constructor
	 *
     * @param workflowStateAction the workflowStateAction
    }
	 */
    public WorkflowStateActionAcl(WorkflowStateAction workflowStateAction) {
        this.workflowStateAction = workflowStateAction;
    }

    /**
     * full constructor
	 *
     * @param workflowUserProfile the workflowUserProfile
     * @param workflowStateAction the workflowStateAction
     * @param userId the userId
     */
    public WorkflowStateActionAcl(WorkflowUserProfile workflowUserProfile, WorkflowStateAction workflowStateAction, String userId) {
        this.workflowUserProfile = workflowUserProfile;
        this.workflowStateAction = workflowStateAction;
        this.userId = userId;
    }

    // Property accessors
    
    /**       
     * id getter method
     *
     * @return id method
     */
    public Long getId() {
        return this.id;
    }
    
    /**       
     * id setter method
     *
     * @param id the id
     *
     * @return WorkflowStateActionAcl modified instance
     */
    public WorkflowStateActionAcl setId(Long id) {
        this.id = id;
        
        return this;
    }
    /**       
     * workflowUserProfile getter method
     *
     * @return workflowUserProfile method
     */
    public WorkflowUserProfile getWorkflowUserProfile() {
        return this.workflowUserProfile;
    }
    
    /**       
     * workflowUserProfile setter method
     *
     * @param workflowUserProfile the workflowUserProfile
     *
     * @return WorkflowStateActionAcl modified instance
     */
    public WorkflowStateActionAcl setWorkflowUserProfile(WorkflowUserProfile workflowUserProfile) {
        this.workflowUserProfile = workflowUserProfile;
        
        return this;
    }
    /**       
     * workflowStateAction getter method
     *
     * @return workflowStateAction method
     */
    public WorkflowStateAction getWorkflowStateAction() {
        return this.workflowStateAction;
    }
    
    /**       
     * workflowStateAction setter method
     *
     * @param workflowStateAction the workflowStateAction
     *
     * @return WorkflowStateActionAcl modified instance
     */
    public WorkflowStateActionAcl setWorkflowStateAction(WorkflowStateAction workflowStateAction) {
        this.workflowStateAction = workflowStateAction;
        
        return this;
    }
    /**       
     * userId getter method
     *
     * @return userId method
     */
    public String getUserId() {
        return this.userId;
    }
    
    /**       
     * userId setter method
     *
     * @param userId the userId
     *
     * @return WorkflowStateActionAcl modified instance
     */
    public WorkflowStateActionAcl setUserId(String userId) {
        this.userId = userId;
        
        return this;
    }

    /**
     * Creates a String representation of the WorkflowStateActionAcl object
     *
     * @return the compiled String
     */
    @Override
    public String toString() {
	    StringBuffer buffer = new StringBuffer();

        buffer.append(getClass().getName()).append("@").append(Integer.toHexString(hashCode())).append(" [");

        buffer.append("id").append("='").append(getId()).append("' ");			
        buffer.append("userId").append("='").append(getUserId()).append("' ");			
        buffer.append("]");
      
        return buffer.toString();
    }

    /**
     * Compares the String representation of the WorkflowStateActionAcl object
     *
     * @param other The object to compare to
     *
     * @return true of the objects are equal
     */
    public boolean equals(WorkflowStateActionAcl other) {
        	return this.toString().equals(other.toString());
    }
    /**
     * @see pt.digitalis.utils.common.IBeanAttributes#setAttributeFromString(java.lang.String, java.lang.String)
     */
    public void setAttributeFromString(String attributeName, String attributeValue) {
        if ("id".equalsIgnoreCase(attributeName))
            this.id = Long.valueOf(attributeValue);

        if ("userId".equalsIgnoreCase(attributeName))
        	this.userId = attributeValue;

    }


    /**
     * Instanciates an Hibernate proxy data object (does not load it from the database, provides lazy load for that)
     *
     * @param session the session
     * @param id      the id
     *
     * @return the proxy
     */
    public static WorkflowStateActionAcl getProxy(Session session, Long id)
    {
        return(WorkflowStateActionAcl)session.load(WorkflowStateActionAcl.class,id);
    }

    /**
    * Instanciates an Hibernate proxy data object (does not load it from the database, provides lazy load for that)
    *
    * @param id      the id
    *
    * @return the proxy
    */
    public static WorkflowStateActionAcl getProxy(Long id)
    {
        Session session = HibernateUtil.getSessionFactory("DIFRepository").getCurrentSession();
        boolean wasActive = session.getTransaction().isActive();

        if (!wasActive)
            session.beginTransaction();

        WorkflowStateActionAcl result = (WorkflowStateActionAcl)session.load(WorkflowStateActionAcl.class,id);

        if (!wasActive)
            session.getTransaction().commit();

        return result;
    }


    /**
     * Instanciates an Hibernate data object
     *
     * @param session the session
     * @param id      the id
     *
     * @return the instance
     */
    public static WorkflowStateActionAcl getInstance(Session session, Long id)
    {
        return(WorkflowStateActionAcl)session.get(WorkflowStateActionAcl.class,id);
    }

    /**
    * Instanciates an Hibernate data object
    *
    * @param id      the id
    *
    * @return the instance
    */
    public static WorkflowStateActionAcl getInstance(Long id)
    {
        Session session = HibernateUtil.getSessionFactory("DIFRepository").getCurrentSession();
        boolean wasActive = session.getTransaction().isActive();

        if (!wasActive)
            session.beginTransaction();

        WorkflowStateActionAcl result = (WorkflowStateActionAcl)session.get(WorkflowStateActionAcl.class,id);

        if (!wasActive)
            session.getTransaction().commit();

        return result;
    }

}
