package pt.digitalis.dif.dem.managers.impl.model.data;

import pt.digitalis.utils.common.AttributeDefinition;
import pt.digitalis.dif.model.utils.AbstractBeanAttributesDefinition;

import java.sql.Timestamp;
import java.sql.Blob;
import java.util.Date;
import java.math.BigDecimal;

import java.util.Arrays;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pt.digitalis.utils.common.collections.CaseInsensitiveHashMap;

import org.hibernate.Session;


/**
 *  Field definitions for data object {@link WorkflowStateAction}
 *
 * NOTE: This file is auto generated and will be overwritten in a future file generation.
 */
public class WorkflowStateActionFieldAttributes extends AbstractBeanAttributesDefinition{

    /** actionBusinessId (Database column: ACTION_BUSINESS_ID) */
    static public AttributeDefinition actionBusinessId =
        new AttributeDefinition("actionBusinessId")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("WORKFLOW_STATE_ACTION")
                .setDatabaseId("ACTION_BUSINESS_ID")
                .setMandatory(true)
                .setMaxSize(500)
                .setType(String.class);

    /** workflowActionList (Database column: ACTION_LIST_ID) */
    static public AttributeDefinition workflowActionList =
        new AttributeDefinition("workflowActionList")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("WORKFLOW_STATE_ACTION")
                .setDatabaseId("ACTION_LIST_ID")
                .setMandatory(true)
                .setMaxSize(255)
                .setLovDataClass(pt.digitalis.dif.dem.managers.impl.model.data.WorkflowActionList.class)
                .setLovDataClassKey("id")
                .setLovDataClassDescription("name")
                .setType(pt.digitalis.dif.dem.managers.impl.model.data.WorkflowActionList.class);

    /** businessRuleConditionId (Database column: BUSINESS_RULE_CONDITION_ID) */
    static public AttributeDefinition businessRuleConditionId =
        new AttributeDefinition("businessRuleConditionId")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("WORKFLOW_STATE_ACTION")
                .setDatabaseId("BUSINESS_RULE_CONDITION_ID")
                .setMandatory(true)
                .setMaxSize(1000)
                .setType(String.class);

    /** description (Database column: DESCRIPTION) */
    static public AttributeDefinition description =
        new AttributeDefinition("description")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("WORKFLOW_STATE_ACTION")
                .setDatabaseId("DESCRIPTION")
                .setMandatory(true)
                .setMaxSize(4000)
                .setType(String.class);

    /** iconImagePath (Database column: ICON_IMAGE_PATH) */
    static public AttributeDefinition iconImagePath =
        new AttributeDefinition("iconImagePath")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("WORKFLOW_STATE_ACTION")
                .setDatabaseId("ICON_IMAGE_PATH")
                .setMandatory(true)
                .setMaxSize(1000)
                .setType(String.class);

    /** id (Database column: ID) */
    static public AttributeDefinition id =
        new AttributeDefinition("id")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("WORKFLOW_STATE_ACTION")
                .setDatabaseId("ID")
                .setMandatory(true)
                .setMaxSize(255)
                .setType(Long.class);

    /** mustComment (Database column: MUST_COMMENT) */
    static public AttributeDefinition mustComment =
        new AttributeDefinition("mustComment")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("WORKFLOW_STATE_ACTION")
                .setDatabaseId("MUST_COMMENT")
                .setMandatory(true)
                .setMaxSize(255)
                .setDefaultValue("0")
                .setType(boolean.class);

    /** name (Database column: NAME) */
    static public AttributeDefinition name =
        new AttributeDefinition("name")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("WORKFLOW_STATE_ACTION")
                .setDatabaseId("NAME")
                .setMandatory(true)
                .setMaxSize(500)
                .setType(String.class);

    /** showIfConditionFails (Database column: SHOW_IF_CONDITION_FAILS) */
    static public AttributeDefinition showIfConditionFails =
        new AttributeDefinition("showIfConditionFails")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("WORKFLOW_STATE_ACTION")
                .setDatabaseId("SHOW_IF_CONDITION_FAILS")
                .setMandatory(true)
                .setMaxSize(255)
                .setDefaultValue("0")
                .setType(boolean.class);

    /** workflowState (Database column: WORKFLOW_STATE_ID) */
    static public AttributeDefinition workflowState =
        new AttributeDefinition("workflowState")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("WORKFLOW_STATE_ACTION")
                .setDatabaseId("WORKFLOW_STATE_ID")
                .setMandatory(true)
                .setMaxSize(255)
                .setLovDataClass(pt.digitalis.dif.dem.managers.impl.model.data.WorkflowState.class)
                .setLovDataClassKey("id")
                .setLovDataClassDescription("name")
                .setType(pt.digitalis.dif.dem.managers.impl.model.data.WorkflowState.class);

    /**
    * Create definitions map map.
    *
    * @return the map
    */
    @Override protected CaseInsensitiveHashMap<AttributeDefinition> createDefinitionsMap(){
        CaseInsensitiveHashMap<AttributeDefinition> map = new CaseInsensitiveHashMap<AttributeDefinition>();
        map.put(actionBusinessId.getName(),actionBusinessId);
        map.put(workflowActionList.getName(),workflowActionList);
        map.put(businessRuleConditionId.getName(),businessRuleConditionId);
        map.put(description.getName(),description);
        map.put(iconImagePath.getName(),iconImagePath);
        map.put(id.getName(),id);
        map.put(mustComment.getName(),mustComment);
        map.put(name.getName(),name);
        map.put(showIfConditionFails.getName(),showIfConditionFails);
        map.put(workflowState.getName(),workflowState);

        return map;
    }
}