package pt.digitalis.dif.dem.managers.impl.model.impl;

import pt.digitalis.dif.model.hibernate.HibernateUtil;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.HibernateDataSetLegacyNoPK;
import pt.digitalis.utils.common.IBeanAttributes;

import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.dem.managers.impl.model.IConversationsService;
import pt.digitalis.dif.dem.managers.impl.model.data.Conversation;
import pt.digitalis.dif.dem.managers.impl.model.data.ConversationMessage;

/**
* NOTE: This file is auto generated and will be overwrite in a future file generation.
*/
public class ConversationsServiceImpl implements IConversationsService {

    /**
     * Obtains a new DataSet for the Conversation entity
     *
     * @return A new HibernateDataSet instance
     */
    public HibernateDataSet<Conversation> getConversationDataSet() {
        return new HibernateDataSet<Conversation>(Conversation.class, HibernateUtil.getSessionFactory("DIFRepository"),
                Conversation.getPKFieldListAsString(), Conversation.FieldAttributes);
    }

    /**
     * Obtains a new DataSet for the ConversationMessage entity
     *
     * @return A new HibernateDataSet instance
     */
    public HibernateDataSet<ConversationMessage> getConversationMessageDataSet() {
        return new HibernateDataSet<ConversationMessage>(ConversationMessage.class, HibernateUtil.getSessionFactory("DIFRepository"),
                ConversationMessage.getPKFieldListAsString(), ConversationMessage.FieldAttributes);
    }

    /**
     * Obtains a IDataSet for the given entity class
     *
     * @param clazz
     *            the entity class
     * @return A new IDataSet instance
     */
    public HibernateDataSet<? extends IBeanAttributes> getDataSet(Class<? extends IBeanAttributes> clazz) {

        if (clazz == Conversation.class)
            return getConversationDataSet();

        if (clazz == ConversationMessage.class)
            return getConversationMessageDataSet();

        return null;
    }

    /**
     * Obtains a IDataSet for the given entity class
     *
     * @param entityName
     *            the entity class simple name
     * @return A new IDataSet instance
     */
    public HibernateDataSet<? extends IBeanAttributes> getDataSet(String entityName) {

        if (entityName.equalsIgnoreCase(Conversation.class.getSimpleName()))
            return getConversationDataSet();

        if (entityName.equalsIgnoreCase(ConversationMessage.class.getSimpleName()))
            return getConversationMessageDataSet();

        return null;
    }
}