package pt.digitalis.dif.dem.managers.impl.model.impl;

import pt.digitalis.dif.model.hibernate.HibernateUtil;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.HibernateDataSetLegacyNoPK;
import pt.digitalis.utils.common.IBeanAttributes;

import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.dem.managers.impl.model.IDDMService;
import pt.digitalis.dif.dem.managers.impl.model.data.Manager;
import pt.digitalis.dif.dem.managers.impl.model.data.Dashboard;
import pt.digitalis.dif.dem.managers.impl.model.data.Area;
import pt.digitalis.dif.dem.managers.impl.model.data.Indicator;
import pt.digitalis.dif.dem.managers.impl.model.data.DashboardIndicator;
import pt.digitalis.dif.dem.managers.impl.model.data.Filter;
import pt.digitalis.dif.dem.managers.impl.model.data.Serie;

/**
* NOTE: This file is auto generated and will be overwrite in a future file generation.
*/
public class DDMServiceImpl implements IDDMService {

    /**
     * Obtains a new DataSet for the Manager entity
     *
     * @return A new HibernateDataSet instance
     */
    public HibernateDataSet<Manager> getManagerDataSet() {
        return new HibernateDataSet<Manager>(Manager.class, HibernateUtil.getSessionFactory("DIFRepository"),
                Manager.getPKFieldListAsString(), Manager.FieldAttributes);
    }

    /**
     * Obtains a new DataSet for the Dashboard entity
     *
     * @return A new HibernateDataSet instance
     */
    public HibernateDataSet<Dashboard> getDashboardDataSet() {
        return new HibernateDataSet<Dashboard>(Dashboard.class, HibernateUtil.getSessionFactory("DIFRepository"),
                Dashboard.getPKFieldListAsString(), Dashboard.FieldAttributes);
    }

    /**
     * Obtains a new DataSet for the Area entity
     *
     * @return A new HibernateDataSet instance
     */
    public HibernateDataSet<Area> getAreaDataSet() {
        return new HibernateDataSet<Area>(Area.class, HibernateUtil.getSessionFactory("DIFRepository"),
                Area.getPKFieldListAsString(), Area.FieldAttributes);
    }

    /**
     * Obtains a new DataSet for the Indicator entity
     *
     * @return A new HibernateDataSet instance
     */
    public HibernateDataSet<Indicator> getIndicatorDataSet() {
        return new HibernateDataSet<Indicator>(Indicator.class, HibernateUtil.getSessionFactory("DIFRepository"),
                Indicator.getPKFieldListAsString(), Indicator.FieldAttributes);
    }

    /**
     * Obtains a new DataSet for the DashboardIndicator entity
     *
     * @return A new HibernateDataSet instance
     */
    public HibernateDataSet<DashboardIndicator> getDashboardIndicatorDataSet() {
        return new HibernateDataSet<DashboardIndicator>(DashboardIndicator.class, HibernateUtil.getSessionFactory("DIFRepository"),
                DashboardIndicator.getPKFieldListAsString(), DashboardIndicator.FieldAttributes);
    }

    /**
     * Obtains a new DataSet for the Filter entity
     *
     * @return A new HibernateDataSet instance
     */
    public HibernateDataSet<Filter> getFilterDataSet() {
        return new HibernateDataSet<Filter>(Filter.class, HibernateUtil.getSessionFactory("DIFRepository"),
                Filter.getPKFieldListAsString(), Filter.FieldAttributes);
    }

    /**
     * Obtains a new DataSet for the Serie entity
     *
     * @return A new HibernateDataSet instance
     */
    public HibernateDataSet<Serie> getSerieDataSet() {
        return new HibernateDataSet<Serie>(Serie.class, HibernateUtil.getSessionFactory("DIFRepository"),
                Serie.getPKFieldListAsString(), Serie.FieldAttributes);
    }

    /**
     * Obtains a IDataSet for the given entity class
     *
     * @param clazz
     *            the entity class
     * @return A new IDataSet instance
     */
    public HibernateDataSet<? extends IBeanAttributes> getDataSet(Class<? extends IBeanAttributes> clazz) {

        if (clazz == Manager.class)
            return getManagerDataSet();

        if (clazz == Dashboard.class)
            return getDashboardDataSet();

        if (clazz == Area.class)
            return getAreaDataSet();

        if (clazz == Indicator.class)
            return getIndicatorDataSet();

        if (clazz == DashboardIndicator.class)
            return getDashboardIndicatorDataSet();

        if (clazz == Filter.class)
            return getFilterDataSet();

        if (clazz == Serie.class)
            return getSerieDataSet();

        return null;
    }

    /**
     * Obtains a IDataSet for the given entity class
     *
     * @param entityName
     *            the entity class simple name
     * @return A new IDataSet instance
     */
    public HibernateDataSet<? extends IBeanAttributes> getDataSet(String entityName) {

        if (entityName.equalsIgnoreCase(Manager.class.getSimpleName()))
            return getManagerDataSet();

        if (entityName.equalsIgnoreCase(Dashboard.class.getSimpleName()))
            return getDashboardDataSet();

        if (entityName.equalsIgnoreCase(Area.class.getSimpleName()))
            return getAreaDataSet();

        if (entityName.equalsIgnoreCase(Indicator.class.getSimpleName()))
            return getIndicatorDataSet();

        if (entityName.equalsIgnoreCase(DashboardIndicator.class.getSimpleName()))
            return getDashboardIndicatorDataSet();

        if (entityName.equalsIgnoreCase(Filter.class.getSimpleName()))
            return getFilterDataSet();

        if (entityName.equalsIgnoreCase(Serie.class.getSimpleName()))
            return getSerieDataSet();

        return null;
    }
}