package pt.digitalis.dif.dem.managers.impl.model.impl;

import pt.digitalis.dif.model.hibernate.HibernateUtil;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.HibernateDataSetLegacyNoPK;
import pt.digitalis.utils.common.IBeanAttributes;

import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.dem.managers.impl.model.IDataIntegrationService;
import pt.digitalis.dif.dem.managers.impl.model.data.DataIntegrationSet;
import pt.digitalis.dif.dem.managers.impl.model.data.DataIntegrationRecord;
import pt.digitalis.dif.dem.managers.impl.model.data.DataIntegrationField;

/**
* NOTE: This file is auto generated and will be overwrite in a future file generation.
*/
public class DataIntegrationServiceImpl implements IDataIntegrationService {

    /**
     * Obtains a new DataSet for the DataIntegrationSet entity
     *
     * @return A new HibernateDataSet instance
     */
    public HibernateDataSet<DataIntegrationSet> getDataIntegrationSetDataSet() {
        return new HibernateDataSet<DataIntegrationSet>(DataIntegrationSet.class, HibernateUtil.getSessionFactory("DIFRepository"),
                DataIntegrationSet.getPKFieldListAsString(), DataIntegrationSet.FieldAttributes);
    }

    /**
     * Obtains a new DataSet for the DataIntegrationRecord entity
     *
     * @return A new HibernateDataSet instance
     */
    public HibernateDataSet<DataIntegrationRecord> getDataIntegrationRecordDataSet() {
        return new HibernateDataSet<DataIntegrationRecord>(DataIntegrationRecord.class, HibernateUtil.getSessionFactory("DIFRepository"),
                DataIntegrationRecord.getPKFieldListAsString(), DataIntegrationRecord.FieldAttributes);
    }

    /**
     * Obtains a new DataSet for the DataIntegrationField entity
     *
     * @return A new HibernateDataSet instance
     */
    public HibernateDataSet<DataIntegrationField> getDataIntegrationFieldDataSet() {
        return new HibernateDataSet<DataIntegrationField>(DataIntegrationField.class, HibernateUtil.getSessionFactory("DIFRepository"),
                DataIntegrationField.getPKFieldListAsString(), DataIntegrationField.FieldAttributes);
    }

    /**
     * Obtains a IDataSet for the given entity class
     *
     * @param clazz
     *            the entity class
     * @return A new IDataSet instance
     */
    public HibernateDataSet<? extends IBeanAttributes> getDataSet(Class<? extends IBeanAttributes> clazz) {

        if (clazz == DataIntegrationSet.class)
            return getDataIntegrationSetDataSet();

        if (clazz == DataIntegrationRecord.class)
            return getDataIntegrationRecordDataSet();

        if (clazz == DataIntegrationField.class)
            return getDataIntegrationFieldDataSet();

        return null;
    }

    /**
     * Obtains a IDataSet for the given entity class
     *
     * @param entityName
     *            the entity class simple name
     * @return A new IDataSet instance
     */
    public HibernateDataSet<? extends IBeanAttributes> getDataSet(String entityName) {

        if (entityName.equalsIgnoreCase(DataIntegrationSet.class.getSimpleName()))
            return getDataIntegrationSetDataSet();

        if (entityName.equalsIgnoreCase(DataIntegrationRecord.class.getSimpleName()))
            return getDataIntegrationRecordDataSet();

        if (entityName.equalsIgnoreCase(DataIntegrationField.class.getSimpleName()))
            return getDataIntegrationFieldDataSet();

        return null;
    }
}