package pt.digitalis.dif.dem.managers.impl.model.impl;

import pt.digitalis.dif.model.hibernate.HibernateUtil;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.HibernateDataSetLegacyNoPK;
import pt.digitalis.utils.common.IBeanAttributes;

import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.dem.managers.impl.model.IFileBundlesService;
import pt.digitalis.dif.dem.managers.impl.model.data.FileType;
import pt.digitalis.dif.dem.managers.impl.model.data.FileBundle;
import pt.digitalis.dif.dem.managers.impl.model.data.FileBundleFile;
import pt.digitalis.dif.dem.managers.impl.model.data.FileBundleInstanceFile;
import pt.digitalis.dif.dem.managers.impl.model.data.FileBundleHistory;

/**
* NOTE: This file is auto generated and will be overwrite in a future file generation.
*/
public class FileBundlesServiceImpl implements IFileBundlesService {

    /**
     * Obtains a new DataSet for the FileType entity
     *
     * @return A new HibernateDataSet instance
     */
    public HibernateDataSet<FileType> getFileTypeDataSet() {
        return new HibernateDataSet<FileType>(FileType.class, HibernateUtil.getSessionFactory("DIFRepository"),
                FileType.getPKFieldListAsString(), FileType.FieldAttributes);
    }

    /**
     * Obtains a new DataSet for the FileBundle entity
     *
     * @return A new HibernateDataSet instance
     */
    public HibernateDataSet<FileBundle> getFileBundleDataSet() {
        return new HibernateDataSet<FileBundle>(FileBundle.class, HibernateUtil.getSessionFactory("DIFRepository"),
                FileBundle.getPKFieldListAsString(), FileBundle.FieldAttributes);
    }

    /**
     * Obtains a new DataSet for the FileBundleFile entity
     *
     * @return A new HibernateDataSet instance
     */
    public HibernateDataSet<FileBundleFile> getFileBundleFileDataSet() {
        return new HibernateDataSet<FileBundleFile>(FileBundleFile.class, HibernateUtil.getSessionFactory("DIFRepository"),
                FileBundleFile.getPKFieldListAsString(), FileBundleFile.FieldAttributes);
    }

    /**
     * Obtains a new DataSet for the FileBundleInstanceFile entity
     *
     * @return A new HibernateDataSet instance
     */
    public HibernateDataSet<FileBundleInstanceFile> getFileBundleInstanceFileDataSet() {
        return new HibernateDataSet<FileBundleInstanceFile>(FileBundleInstanceFile.class, HibernateUtil.getSessionFactory("DIFRepository"),
                FileBundleInstanceFile.getPKFieldListAsString(), FileBundleInstanceFile.FieldAttributes);
    }

    /**
     * Obtains a new DataSet for the FileBundleHistory entity
     *
     * @return A new HibernateDataSet instance
     */
    public HibernateDataSet<FileBundleHistory> getFileBundleHistoryDataSet() {
        return new HibernateDataSet<FileBundleHistory>(FileBundleHistory.class, HibernateUtil.getSessionFactory("DIFRepository"),
                FileBundleHistory.getPKFieldListAsString(), FileBundleHistory.FieldAttributes);
    }

    /**
     * Obtains a IDataSet for the given entity class
     *
     * @param clazz
     *            the entity class
     * @return A new IDataSet instance
     */
    public HibernateDataSet<? extends IBeanAttributes> getDataSet(Class<? extends IBeanAttributes> clazz) {

        if (clazz == FileType.class)
            return getFileTypeDataSet();

        if (clazz == FileBundle.class)
            return getFileBundleDataSet();

        if (clazz == FileBundleFile.class)
            return getFileBundleFileDataSet();

        if (clazz == FileBundleInstanceFile.class)
            return getFileBundleInstanceFileDataSet();

        if (clazz == FileBundleHistory.class)
            return getFileBundleHistoryDataSet();

        return null;
    }

    /**
     * Obtains a IDataSet for the given entity class
     *
     * @param entityName
     *            the entity class simple name
     * @return A new IDataSet instance
     */
    public HibernateDataSet<? extends IBeanAttributes> getDataSet(String entityName) {

        if (entityName.equalsIgnoreCase(FileType.class.getSimpleName()))
            return getFileTypeDataSet();

        if (entityName.equalsIgnoreCase(FileBundle.class.getSimpleName()))
            return getFileBundleDataSet();

        if (entityName.equalsIgnoreCase(FileBundleFile.class.getSimpleName()))
            return getFileBundleFileDataSet();

        if (entityName.equalsIgnoreCase(FileBundleInstanceFile.class.getSimpleName()))
            return getFileBundleInstanceFileDataSet();

        if (entityName.equalsIgnoreCase(FileBundleHistory.class.getSimpleName()))
            return getFileBundleHistoryDataSet();

        return null;
    }
}