package pt.digitalis.dif.dem.managers.impl.model.data;


import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.Session;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.hibernate.HibernateUtil;
import pt.digitalis.dif.model.utils.AbstractBeanRelationsAttributes;
import pt.digitalis.dif.model.utils.IBeanAttributesDataSet;

/**
 * AccessLog
* Generated on ORM Generator
* DIF build process for the Model layer
*
*/
@SuppressWarnings("serial")
public class AccessLog extends AbstractBeanRelationsAttributes implements java.io.Serializable, IBeanAttributesDataSet<AccessLog> {

    /**
    * Constant with the session factory ID
    */
    public static String SESSION_FACTORY_NAME = "DIFRepository";

    /** AccessLog attributes enumeration */
    public static class Fields
    {
        /** id column */
        public static final String ID ="id";
        /** applicationId column */
        public static final String APPLICATIONID ="applicationId";
        /** serviceId column */
        public static final String SERVICEID ="serviceId";
        /** stageId column */
        public static final String STAGEID ="stageId";
        /** eventId column */
        public static final String EVENTID ="eventId";
        /** requestType column */
        public static final String REQUESTTYPE ="requestType";
        /** userId column */
        public static final String USERID ="userId";
        /** accessDate column */
        public static final String ACCESSDATE ="accessDate";
        /** executionTime column */
        public static final String EXECUTIONTIME ="executionTime";
        /** clientIp column */
        public static final String CLIENTIP ="clientIp";
        /** requestDump column */
        public static final String REQUESTDUMP ="requestDump";
        /** errorReport column */
        public static final String ERRORREPORT ="errorReport";

        /**
         * List of existing fields
         *
         * @return list of field names
         */
        public static List<String> values()
        {
            ArrayList<String> list = new ArrayList<String>();
            list.add("id");
            list.add("applicationId");
            list.add("serviceId");
            list.add("stageId");
            list.add("eventId");
            list.add("requestType");
            list.add("userId");
            list.add("accessDate");
            list.add("executionTime");
            list.add("clientIp");
            list.add("requestDump");
            list.add("errorReport");

            return list;
        }
    }

    /** Field attributes */
    public static AccessLogFieldAttributes FieldAttributes=new AccessLogFieldAttributes();

    /**
    * @return the field attributes definitions
    */
    @Override public AccessLogFieldAttributes getDefinitions()
    {
        return FieldAttributes;
    }

    /**
     * The Class Relations.
     */
    public class Relations extends AbstractBeanRelationsAttributes.AbstractRelations
    {

        /**
        * Instantiates a new relations.
        *
        * @param currentPath the current path
        */
        public Relations(String currentPath)
        {
            super(currentPath);
        }
        /**
         * the ID path.
         *
         * @return the path
         */
        public String ID()
        {
            return buildPath(Fields.ID);
        }
        /**
         * the APPLICATIONID path.
         *
         * @return the path
         */
        public String APPLICATIONID()
        {
            return buildPath(Fields.APPLICATIONID);
        }
        /**
         * the SERVICEID path.
         *
         * @return the path
         */
        public String SERVICEID()
        {
            return buildPath(Fields.SERVICEID);
        }
        /**
         * the STAGEID path.
         *
         * @return the path
         */
        public String STAGEID()
        {
            return buildPath(Fields.STAGEID);
        }
        /**
         * the EVENTID path.
         *
         * @return the path
         */
        public String EVENTID()
        {
            return buildPath(Fields.EVENTID);
        }
        /**
         * the REQUESTTYPE path.
         *
         * @return the path
         */
        public String REQUESTTYPE()
        {
            return buildPath(Fields.REQUESTTYPE);
        }
        /**
         * the USERID path.
         *
         * @return the path
         */
        public String USERID()
        {
            return buildPath(Fields.USERID);
        }
        /**
         * the ACCESSDATE path.
         *
         * @return the path
         */
        public String ACCESSDATE()
        {
            return buildPath(Fields.ACCESSDATE);
        }
        /**
         * the EXECUTIONTIME path.
         *
         * @return the path
         */
        public String EXECUTIONTIME()
        {
            return buildPath(Fields.EXECUTIONTIME);
        }
        /**
         * the CLIENTIP path.
         *
         * @return the path
         */
        public String CLIENTIP()
        {
            return buildPath(Fields.CLIENTIP);
        }
        /**
         * the REQUESTDUMP path.
         *
         * @return the path
         */
        public String REQUESTDUMP()
        {
            return buildPath(Fields.REQUESTDUMP);
        }
        /**
         * the ERRORREPORT path.
         *
         * @return the path
         */
        public String ERRORREPORT()
        {
            return buildPath(Fields.ERRORREPORT);
        }
    }

    /** The dummy obj. */
    private static AccessLog dummyObj=new AccessLog();

    /**
     * Get AccessLog Relations .
     *
     * @return the relations
     */
    public static Relations FK()
    {
        return dummyObj.new Relations(null);
    }

    /**
    * Gets a new dataSet object for this bean
    *
    * @return the dataSet
    */
    public IDataSet<AccessLog> getDataSet()
    {
        return getDataSetInstance();
    }

    /**
    * Gets a new dataSet object for this bean
    *
    * @return the dataSet
    */
    public static IDataSet<AccessLog> getDataSetInstance()
    {
        return new HibernateDataSet<AccessLog>(AccessLog.class, HibernateUtil.getSessionFactory(SESSION_FACTORY_NAME),
            AccessLog.getPKFieldListAsString(), AccessLog.FieldAttributes);
    }

    /**
    * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeNoGraphNavigation(java.lang.String)
    */
    @Override protected Object getAttributeNoGraphNavigation(String attributeName)
    {
        if("id".equalsIgnoreCase(attributeName))
            return id;
        if("applicationId".equalsIgnoreCase(attributeName))
            return applicationId;
        if("serviceId".equalsIgnoreCase(attributeName))
            return serviceId;
        if("stageId".equalsIgnoreCase(attributeName))
            return stageId;
        if("eventId".equalsIgnoreCase(attributeName))
            return eventId;
        if("requestType".equalsIgnoreCase(attributeName))
            return requestType;
        if("userId".equalsIgnoreCase(attributeName))
            return userId;
        if("accessDate".equalsIgnoreCase(attributeName))
            return accessDate;
        if("executionTime".equalsIgnoreCase(attributeName))
            return executionTime;
        if("clientIp".equalsIgnoreCase(attributeName))
            return clientIp;
        if("requestDump".equalsIgnoreCase(attributeName))
            return requestDump;
        if("errorReport".equalsIgnoreCase(attributeName))
            return errorReport;

        return null;
    }

    /**
    * @see pt.digitalis.utils.common.IBeanAttributes#setAttribute(java.lang.String, java.lang.Object)
    */
    public void setAttribute(String attributeName,Object attributeValue)
    {
        if("id".equalsIgnoreCase(attributeName))
            id =(Long)attributeValue;
        if("applicationId".equalsIgnoreCase(attributeName))
            applicationId =(String)attributeValue;
        if("serviceId".equalsIgnoreCase(attributeName))
            serviceId =(String)attributeValue;
        if("stageId".equalsIgnoreCase(attributeName))
            stageId =(String)attributeValue;
        if("eventId".equalsIgnoreCase(attributeName))
            eventId =(String)attributeValue;
        if("requestType".equalsIgnoreCase(attributeName))
            requestType =(Character)attributeValue;
        if("userId".equalsIgnoreCase(attributeName))
            userId =(String)attributeValue;
        if("accessDate".equalsIgnoreCase(attributeName))
            accessDate =(Timestamp)attributeValue;
        if("executionTime".equalsIgnoreCase(attributeName))
            executionTime =(Long)attributeValue;
        if("clientIp".equalsIgnoreCase(attributeName))
            clientIp =(String)attributeValue;
        if("requestDump".equalsIgnoreCase(attributeName))
            requestDump =(String)attributeValue;
        if("errorReport".equalsIgnoreCase(attributeName))
            errorReport =(String)attributeValue;
    }

    // Fields

    /** id private attribute */
    private Long id;

    /** applicationId private attribute */
    private String applicationId;

    /** serviceId private attribute */
    private String serviceId;

    /** stageId private attribute */
    private String stageId;

    /** eventId private attribute */
    private String eventId;

    /** requestType private attribute */
    private Character requestType;

    /** userId private attribute */
    private String userId;

    /** accessDate private attribute */
    private Timestamp accessDate;

    /** executionTime private attribute */
    private Long executionTime;

    /** clientIp private attribute */
    private String clientIp;

    /** requestDump private attribute */
    private String requestDump;

    /** errorReport private attribute */
    private String errorReport;

    /** The pojo's primary key field list names */
    private static List<String> pkFieldList;

    /**
     * Get the table fields that compose the PK
     *
     * @return the PK field list
     */
     public synchronized static List<String> getPKFieldList()
     {
         if (pkFieldList == null)
         {
             pkFieldList = new ArrayList<String>();
             pkFieldList.add("id");
         }

         return pkFieldList;
     }

    /**
     * Get the table fields that compose the PK as a comma separated field name list
     *
     * @return the PK field list as a string
     */
     public static String getPKFieldListAsString()
     {
         StringBuffer buffer = new StringBuffer();

         for (int i = 0; i < getPKFieldList().size(); i++)
         {
             if (i != 0)
                 buffer.append(",");

             buffer.append(getPKFieldList().get(i));
         }

         return buffer.toString();
     }

    /**
     * Gets description field.
     *
     * @return the description field
     */
    @Override
    public String getDescriptionField()
    {
        return FieldAttributes.getDescriptionField();
    }

    /**
     * Get the table fields that compose the PK
     *
     * @return the PK field list
     */
    @Override
    public List<String> getPKFields()
    {
        return getPKFieldList();
    }

    /**
     * Is composite PK.
     *
     * @return the boolean
     */
    @Override
    public boolean isCompositePK()
    {
        return this.getPKFieldList().size() > 1;
    }

    /**
     * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeAsString(java.lang.String)
     */
     @Override
     public String getAttributeAsString(String attributeName)
     {
        if (attributeName.contains("."))
        {
            return this.getAttributeAsStringParseBeanPath(attributeName);
        }
        else
        {
            Object value = getAttribute(attributeName);

            if (value == null)
                return "";
            else {
                return value.toString().trim();
            }
        }
     }

    // Constructors

    /**
     * default constructor
     */
    public AccessLog() {
    }

	/** 
	 * minimal constructor
	 *
     * @param applicationId the applicationId
     * @param serviceId the serviceId
     * @param stageId the stageId
     * @param requestType the requestType
     * @param accessDate the accessDate
     * @param executionTime the executionTime
     * @param clientIp the clientIp
    }
	 */
    public AccessLog(String applicationId, String serviceId, String stageId, Character requestType, Timestamp accessDate, Long executionTime, String clientIp) {
        this.applicationId = applicationId;
        this.serviceId = serviceId;
        this.stageId = stageId;
        this.requestType = requestType;
        this.accessDate = accessDate;
        this.executionTime = executionTime;
        this.clientIp = clientIp;
    }

    /**
     * full constructor
	 *
     * @param applicationId the applicationId
     * @param serviceId the serviceId
     * @param stageId the stageId
     * @param eventId the eventId
     * @param requestType the requestType
     * @param userId the userId
     * @param accessDate the accessDate
     * @param executionTime the executionTime
     * @param clientIp the clientIp
     * @param requestDump the requestDump
     * @param errorReport the errorReport
     */
    public AccessLog(String applicationId, String serviceId, String stageId, String eventId, Character requestType, String userId, Timestamp accessDate, Long executionTime, String clientIp, String requestDump, String errorReport) {
        this.applicationId = applicationId;
        this.serviceId = serviceId;
        this.stageId = stageId;
        this.eventId = eventId;
        this.requestType = requestType;
        this.userId = userId;
        this.accessDate = accessDate;
        this.executionTime = executionTime;
        this.clientIp = clientIp;
        this.requestDump = requestDump;
        this.errorReport = errorReport;
    }

    // Property accessors
    
    /**       
     * id getter method
     *
     * @return id method
     */
    public Long getId() {
        return this.id;
    }
    
    /**       
     * id setter method
     *
     * @param id the id
     *
     * @return AccessLog modified instance
     */
    public AccessLog setId(Long id) {
        this.id = id;
        
        return this;
    }
    /**       
     * applicationId getter method
     *
     * @return applicationId method
     */
    public String getApplicationId() {
        return this.applicationId;
    }
    
    /**       
     * applicationId setter method
     *
     * @param applicationId the applicationId
     *
     * @return AccessLog modified instance
     */
    public AccessLog setApplicationId(String applicationId) {
        this.applicationId = applicationId;
        
        return this;
    }
    /**       
     * serviceId getter method
     *
     * @return serviceId method
     */
    public String getServiceId() {
        return this.serviceId;
    }
    
    /**       
     * serviceId setter method
     *
     * @param serviceId the serviceId
     *
     * @return AccessLog modified instance
     */
    public AccessLog setServiceId(String serviceId) {
        this.serviceId = serviceId;
        
        return this;
    }
    /**       
     * stageId getter method
     *
     * @return stageId method
     */
    public String getStageId() {
        return this.stageId;
    }
    
    /**       
     * stageId setter method
     *
     * @param stageId the stageId
     *
     * @return AccessLog modified instance
     */
    public AccessLog setStageId(String stageId) {
        this.stageId = stageId;
        
        return this;
    }
    /**       
     * eventId getter method
     *
     * @return eventId method
     */
    public String getEventId() {
        return this.eventId;
    }
    
    /**       
     * eventId setter method
     *
     * @param eventId the eventId
     *
     * @return AccessLog modified instance
     */
    public AccessLog setEventId(String eventId) {
        this.eventId = eventId;
        
        return this;
    }
    /**       
     * requestType getter method
     *
     * @return requestType method
     */
    public Character getRequestType() {
        return this.requestType;
    }
    
    /**       
     * requestType setter method
     *
     * @param requestType the requestType
     *
     * @return AccessLog modified instance
     */
    public AccessLog setRequestType(Character requestType) {
        this.requestType = requestType;
        
        return this;
    }
    /**       
     * userId getter method
     *
     * @return userId method
     */
    public String getUserId() {
        return this.userId;
    }
    
    /**       
     * userId setter method
     *
     * @param userId the userId
     *
     * @return AccessLog modified instance
     */
    public AccessLog setUserId(String userId) {
        this.userId = userId;
        
        return this;
    }
    /**       
     * accessDate getter method
     *
     * @return accessDate method
     */
    public Timestamp getAccessDate() {
        return this.accessDate;
    }
    
    /**       
     * accessDate setter method
     *
     * @param accessDate the accessDate
     *
     * @return AccessLog modified instance
     */
    public AccessLog setAccessDate(Timestamp accessDate) {
        this.accessDate = accessDate;
        
        return this;
    }
    /**       
     * executionTime getter method
     *
     * @return executionTime method
     */
    public Long getExecutionTime() {
        return this.executionTime;
    }
    
    /**       
     * executionTime setter method
     *
     * @param executionTime the executionTime
     *
     * @return AccessLog modified instance
     */
    public AccessLog setExecutionTime(Long executionTime) {
        this.executionTime = executionTime;
        
        return this;
    }
    /**       
     * clientIp getter method
     *
     * @return clientIp method
     */
    public String getClientIp() {
        return this.clientIp;
    }
    
    /**       
     * clientIp setter method
     *
     * @param clientIp the clientIp
     *
     * @return AccessLog modified instance
     */
    public AccessLog setClientIp(String clientIp) {
        this.clientIp = clientIp;
        
        return this;
    }
    /**       
     * requestDump getter method
     *
     * @return requestDump method
     */
    public String getRequestDump() {
        return this.requestDump;
    }
    
    /**       
     * requestDump setter method
     *
     * @param requestDump the requestDump
     *
     * @return AccessLog modified instance
     */
    public AccessLog setRequestDump(String requestDump) {
        this.requestDump = requestDump;
        
        return this;
    }
    /**       
     * errorReport getter method
     *
     * @return errorReport method
     */
    public String getErrorReport() {
        return this.errorReport;
    }
    
    /**       
     * errorReport setter method
     *
     * @param errorReport the errorReport
     *
     * @return AccessLog modified instance
     */
    public AccessLog setErrorReport(String errorReport) {
        this.errorReport = errorReport;
        
        return this;
    }


    /**
     * Creates a String representation of the AccessLog object
     *
     * @return the compiled String
     */
    @Override
    public String toString() {
	    StringBuffer buffer = new StringBuffer();

        buffer.append(getClass().getName()).append("@").append(Integer.toHexString(hashCode())).append(" [");

        buffer.append("id").append("='").append(getId()).append("' ");			
        buffer.append("applicationId").append("='").append(getApplicationId()).append("' ");			
        buffer.append("serviceId").append("='").append(getServiceId()).append("' ");			
        buffer.append("stageId").append("='").append(getStageId()).append("' ");			
        buffer.append("eventId").append("='").append(getEventId()).append("' ");			
        buffer.append("requestType").append("='").append(getRequestType()).append("' ");			
        buffer.append("userId").append("='").append(getUserId()).append("' ");			
        buffer.append("accessDate").append("='").append(getAccessDate()).append("' ");			
        buffer.append("executionTime").append("='").append(getExecutionTime()).append("' ");			
        buffer.append("clientIp").append("='").append(getClientIp()).append("' ");			
        buffer.append("requestDump").append("='").append(getRequestDump()).append("' ");			
        buffer.append("errorReport").append("='").append(getErrorReport()).append("' ");			
        buffer.append("]");
      
        return buffer.toString();
    }

    /**
     * Compares the String representation of the AccessLog object
     *
     * @param other The object to compare to
     *
     * @return true of the objects are equal
     */
    public boolean equals(AccessLog other) {
        	return this.toString().equals(other.toString());
    }
    /**
     * @see pt.digitalis.utils.common.IBeanAttributes#setAttributeFromString(java.lang.String, java.lang.String)
     */
    public void setAttributeFromString(String attributeName, String attributeValue) {
        if ("id".equalsIgnoreCase(attributeName))
            this.id = Long.valueOf(attributeValue);

        if ("applicationId".equalsIgnoreCase(attributeName))
        	this.applicationId = attributeValue;

        if ("serviceId".equalsIgnoreCase(attributeName))
        	this.serviceId = attributeValue;

        if ("stageId".equalsIgnoreCase(attributeName))
        	this.stageId = attributeValue;

        if ("eventId".equalsIgnoreCase(attributeName))
        	this.eventId = attributeValue;

        if ("requestType".equalsIgnoreCase(attributeName))
            if (attributeValue != null && attributeValue.length() > 0)
                this.requestType = attributeValue.charAt(0);

        if ("userId".equalsIgnoreCase(attributeName))
        	this.userId = attributeValue;

        if ("accessDate".equalsIgnoreCase(attributeName))
            this.accessDate = Timestamp.valueOf(attributeValue);

        if ("executionTime".equalsIgnoreCase(attributeName))
            this.executionTime = Long.valueOf(attributeValue);

        if ("clientIp".equalsIgnoreCase(attributeName))
        	this.clientIp = attributeValue;

        if ("requestDump".equalsIgnoreCase(attributeName))
        	this.requestDump = attributeValue;

        if ("errorReport".equalsIgnoreCase(attributeName))
        	this.errorReport = attributeValue;

    }


    /**
     * Instanciates an Hibernate proxy data object (does not load it from the database, provides lazy load for that)
     *
     * @param session the session
     * @param id      the id
     *
     * @return the proxy
     */
    public static AccessLog getProxy(Session session, Long id)
    {
        return(AccessLog)session.load(AccessLog.class,id);
    }

    /**
    * Instanciates an Hibernate proxy data object (does not load it from the database, provides lazy load for that)
    *
    * @param id      the id
    *
    * @return the proxy
    */
    public static AccessLog getProxy(Long id)
    {
        Session session = HibernateUtil.getSessionFactory(SESSION_FACTORY_NAME).getCurrentSession();
        boolean wasActive = session.getTransaction().isActive();

        if (!wasActive)
            session.beginTransaction();

        AccessLog result = (AccessLog)session.load(AccessLog.class,id);

        if (!wasActive)
            session.getTransaction().commit();

        return result;
    }


    /**
     * Instanciates an Hibernate data object
     *
     * @param session the session
     * @param id      the id
     *
     * @return the instance
     */
    public static AccessLog getInstanceForSession(Session session, Long id)
    {
        return(AccessLog)session.get(AccessLog.class,id);
    }

    /**
    * Instanciates an Hibernate data object
    *
    * @param id      the id
    *
    * @return the instance
    */
    public static AccessLog getInstance(Long id)
    {
        Session session = HibernateUtil.getSessionFactory(SESSION_FACTORY_NAME).getCurrentSession();
        boolean wasActive = session.getTransaction().isActive();

        if (!wasActive)
            session.beginTransaction();

        AccessLog result = (AccessLog)session.get(AccessLog.class,id);

        if (!wasActive)
            session.getTransaction().commit();

        return result;
    }

}
