package pt.digitalis.dif.dem.managers.impl.model.data;

import pt.digitalis.utils.common.AttributeDefinition;
import pt.digitalis.dif.model.utils.AbstractBeanAttributesDefinition;

import java.sql.Timestamp;
import java.sql.Blob;
import java.util.Date;
import java.math.BigDecimal;

import java.util.Arrays;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pt.digitalis.utils.common.collections.CaseInsensitiveHashMap;

import org.hibernate.Session;


/**
 *  Field definitions for data object {@link AccessLog}
 *
 * NOTE: This file is auto generated and will be overwritten in a future file generation.
 */
public class AccessLogFieldAttributes extends AbstractBeanAttributesDefinition{

    /** accessDate (Database column: ACCESS_DATE - Request date/time) */
    static public AttributeDefinition accessDate =
        new AttributeDefinition("accessDate")
                .setDescription("Request date/time")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("ACCESS_LOG")
                .setDatabaseId("ACCESS_DATE")
                .setMandatory(true)
                .setMaxSize(7)
                .setType(Timestamp.class);

    /** applicationId (Database column: APPLICATION_ID - Aplication Identifier) */
    static public AttributeDefinition applicationId =
        new AttributeDefinition("applicationId")
                .setDescription("Aplication Identifier")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("ACCESS_LOG")
                .setDatabaseId("APPLICATION_ID")
                .setMandatory(true)
                .setMaxSize(100)
                .setType(String.class);

    /** clientIp (Database column: CLIENT_IP - The client IP that made the request) */
    static public AttributeDefinition clientIp =
        new AttributeDefinition("clientIp")
                .setDescription("The client IP that made the request")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("ACCESS_LOG")
                .setDatabaseId("CLIENT_IP")
                .setMandatory(true)
                .setMaxSize(40)
                .setType(String.class);

    /** errorReport (Database column: ERROR_REPORT) */
    static public AttributeDefinition errorReport =
        new AttributeDefinition("errorReport")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("ACCESS_LOG")
                .setDatabaseId("ERROR_REPORT")
                .setMandatory(false)
                .setMaxSize(4000)
                .setType(String.class);

    /** eventId (Database column: EVENT_ID - Event identifier (form submit, ajax event, document request...)) */
    static public AttributeDefinition eventId =
        new AttributeDefinition("eventId")
                .setDescription("Event identifier (form submit, ajax event, document request...)")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("ACCESS_LOG")
                .setDatabaseId("EVENT_ID")
                .setMandatory(false)
                .setMaxSize(100)
                .setType(String.class);

    /** executionTime (Database column: EXECUTION_TIME - Time the request took to execute (view not included)) */
    static public AttributeDefinition executionTime =
        new AttributeDefinition("executionTime")
                .setDescription("Time the request took to execute (view not included)")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("ACCESS_LOG")
                .setDatabaseId("EXECUTION_TIME")
                .setMandatory(true)
                .setMaxSize(10)
                .setType(Long.class);

    /** id (Database column: ID - ID column) */
    static public AttributeDefinition id =
        new AttributeDefinition("id")
                .setDescription("ID column")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("ACCESS_LOG")
                .setDatabaseId("ID")
                .setMandatory(true)
                .setMaxSize(22)
                .setType(Long.class);

    /** requestDump (Database column: REQUEST_DUMP - The DIF request (when trace logging is enabled)) */
    static public AttributeDefinition requestDump =
        new AttributeDefinition("requestDump")
                .setDescription("The DIF request (when trace logging is enabled)")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("ACCESS_LOG")
                .setDatabaseId("REQUEST_DUMP")
                .setMandatory(false)
                .setMaxSize(4000)
                .setType(String.class);

    /** requestType (Database column: REQUEST_TYPE - Request type ([S]ubmit, [A]jax, [D]ocument, [P]age)) */
    static public AttributeDefinition requestType =
        new AttributeDefinition("requestType")
                .setDescription("Request type ([S]ubmit, [A]jax, [D]ocument, [P]age)")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("ACCESS_LOG")
                .setDatabaseId("REQUEST_TYPE")
                .setMandatory(true)
                .setMaxSize(1)
                .setType(Character.class);

    /** serviceId (Database column: SERVICE_ID - Service Identifier) */
    static public AttributeDefinition serviceId =
        new AttributeDefinition("serviceId")
                .setDescription("Service Identifier")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("ACCESS_LOG")
                .setDatabaseId("SERVICE_ID")
                .setMandatory(true)
                .setMaxSize(100)
                .setType(String.class);

    /** stageId (Database column: STAGE_ID - Stage Identifier) */
    static public AttributeDefinition stageId =
        new AttributeDefinition("stageId")
                .setDescription("Stage Identifier")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("ACCESS_LOG")
                .setDatabaseId("STAGE_ID")
                .setMandatory(true)
                .setMaxSize(100)
                .setType(String.class);

    /** userId (Database column: USER_ID - User Identifier) */
    static public AttributeDefinition userId =
        new AttributeDefinition("userId")
                .setDescription("User Identifier")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("ACCESS_LOG")
                .setDatabaseId("USER_ID")
                .setMandatory(false)
                .setMaxSize(30)
                .setType(String.class);

    /**
     * Gets description field.
     *
     * @return the description field
     */
    public static String getDescriptionField()
    {
        return null;
    }

    /**
    * Create definitions map map.
    *
    * @return the map
    */
    @Override protected CaseInsensitiveHashMap<AttributeDefinition> createDefinitionsMap(){
        CaseInsensitiveHashMap<AttributeDefinition> map = new CaseInsensitiveHashMap<AttributeDefinition>();
        map.put(accessDate.getName(),accessDate);
        map.put(applicationId.getName(),applicationId);
        map.put(clientIp.getName(),clientIp);
        map.put(errorReport.getName(),errorReport);
        map.put(eventId.getName(),eventId);
        map.put(executionTime.getName(),executionTime);
        map.put(id.getName(),id);
        map.put(requestDump.getName(),requestDump);
        map.put(requestType.getName(),requestType);
        map.put(serviceId.getName(),serviceId);
        map.put(stageId.getName(),stageId);
        map.put(userId.getName(),userId);

        return map;
    }
}