package pt.digitalis.dif.dem.managers.impl.model.data;

import pt.digitalis.utils.common.AttributeDefinition;
import pt.digitalis.dif.model.utils.AbstractBeanAttributesDefinition;

import java.sql.Timestamp;
import java.sql.Blob;
import java.util.Date;
import java.math.BigDecimal;

import java.util.Arrays;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pt.digitalis.utils.common.collections.CaseInsensitiveHashMap;

import org.hibernate.Session;


/**
 *  Field definitions for data object {@link Area}
 *
 * NOTE: This file is auto generated and will be overwritten in a future file generation.
 */
public class AreaFieldAttributes extends AbstractBeanAttributesDefinition{

    /** databasePass (Database column: DATABASE_PASS - BD password to connect) */
    static public AttributeDefinition databasePass =
        new AttributeDefinition("databasePass")
                .setDescription("BD password to connect")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("AREA")
                .setDatabaseId("DATABASE_PASS")
                .setMandatory(false)
                .setMaxSize(100)
                .setType(String.class);

    /** databaseUrl (Database column: DATABASE_URL - BD URL to get data from) */
    static public AttributeDefinition databaseUrl =
        new AttributeDefinition("databaseUrl")
                .setDescription("BD URL to get data from")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("AREA")
                .setDatabaseId("DATABASE_URL")
                .setMandatory(false)
                .setMaxSize(2000)
                .setType(String.class);

    /** databaseUser (Database column: DATABASE_USER - BD username to connect) */
    static public AttributeDefinition databaseUser =
        new AttributeDefinition("databaseUser")
                .setDescription("BD username to connect")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("AREA")
                .setDatabaseId("DATABASE_USER")
                .setMandatory(false)
                .setMaxSize(500)
                .setType(String.class);

    /** id (Database column: ID - ID column) */
    static public AttributeDefinition id =
        new AttributeDefinition("id")
                .setDescription("ID column")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("AREA")
                .setDatabaseId("ID")
                .setMandatory(true)
                .setMaxSize(10)
                .setType(Long.class);

    /** isVisible (Database column: IS_VISIBLE - If the area is visible.) */
    static public AttributeDefinition isVisible =
        new AttributeDefinition("isVisible")
                .setDescription("If the area is visible.")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("AREA")
                .setDatabaseId("IS_VISIBLE")
                .setMandatory(true)
                .setMaxSize(1)
                .setTreatAsBoolean(true)
                .setBooleanFalseValue("0")
                .setBooleanTrueValue("1")
                .setLovFixedList(Arrays.asList(new String[]{"1","0"}))
                .setType(boolean.class);

    /** manager (Database column: MANAGER_ID - The parent manager ID) */
    static public AttributeDefinition manager =
        new AttributeDefinition("manager")
                .setDescription("The parent manager ID")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("AREA")
                .setDatabaseId("MANAGER_ID")
                .setMandatory(true)
                .setMaxSize(10)
                .setLovDataClass(pt.digitalis.dif.dem.managers.impl.model.data.Manager.class)
                .setLovDataClassKey("id")
                .setLovDataClassDescription("uniqueId")
                .setType(pt.digitalis.dif.dem.managers.impl.model.data.Manager.class);

    /** restrictGroups (Database column: RESTRICT_GROUPS - List of default groups to restrict access to all area indicators) */
    static public AttributeDefinition restrictGroups =
        new AttributeDefinition("restrictGroups")
                .setDescription("List of default groups to restrict access to all area indicators")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("AREA")
                .setDatabaseId("RESTRICT_GROUPS")
                .setMandatory(false)
                .setMaxSize(4000)
                .setType(String.class);

    /** restrictProfiles (Database column: RESTRICT_PROFILES - List of default profiles to restrict access to all area indicators) */
    static public AttributeDefinition restrictProfiles =
        new AttributeDefinition("restrictProfiles")
                .setDescription("List of default profiles to restrict access to all area indicators")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("AREA")
                .setDatabaseId("RESTRICT_PROFILES")
                .setMandatory(false)
                .setMaxSize(4000)
                .setType(String.class);

    /** title (Database column: TITLE - The area title) */
    static public AttributeDefinition title =
        new AttributeDefinition("title")
                .setDescription("The area title")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("AREA")
                .setDatabaseId("TITLE")
                .setMandatory(true)
                .setMaxSize(500)
                .setType(String.class);

    /** uniqueId (Database column: UNIQUE_ID - Business unique ID) */
    static public AttributeDefinition uniqueId =
        new AttributeDefinition("uniqueId")
                .setDescription("Business unique ID")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("AREA")
                .setDatabaseId("UNIQUE_ID")
                .setMandatory(true)
                .setMaxSize(200)
                .setType(String.class);

    /** visibleFor (Database column: VISIBLE_FOR - Configurations for wich the area is visible.) */
    static public AttributeDefinition visibleFor =
        new AttributeDefinition("visibleFor")
                .setDescription("Configurations for wich the area is visible.")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("AREA")
                .setDatabaseId("VISIBLE_FOR")
                .setMandatory(false)
                .setMaxSize(500)
                .setType(String.class);

    /**
     * Gets description field.
     *
     * @return the description field
     */
    public static String getDescriptionField()
    {
        return "title";
    }

    /**
    * Create definitions map map.
    *
    * @return the map
    */
    @Override protected CaseInsensitiveHashMap<AttributeDefinition> createDefinitionsMap(){
        CaseInsensitiveHashMap<AttributeDefinition> map = new CaseInsensitiveHashMap<AttributeDefinition>();
        map.put(databasePass.getName(),databasePass);
        map.put(databaseUrl.getName(),databaseUrl);
        map.put(databaseUser.getName(),databaseUser);
        map.put(id.getName(),id);
        map.put(isVisible.getName(),isVisible);
        map.put(manager.getName(),manager);
        map.put(restrictGroups.getName(),restrictGroups);
        map.put(restrictProfiles.getName(),restrictProfiles);
        map.put(title.getName(),title);
        map.put(uniqueId.getName(),uniqueId);
        map.put(visibleFor.getName(),visibleFor);

        return map;
    }
}