package pt.digitalis.dif.dem.managers.impl.model.data;


import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hibernate.Session;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.hibernate.HibernateUtil;
import pt.digitalis.dif.model.utils.AbstractBeanRelationsAttributes;
import pt.digitalis.dif.model.utils.IBeanAttributesDataSet;

/**
 * ConfigNode
* Generated on ORM Generator
* DIF build process for the Model layer
*
*/
@SuppressWarnings("serial")
public class ConfigNode extends AbstractBeanRelationsAttributes implements java.io.Serializable, IBeanAttributesDataSet<ConfigNode> {

    /**
    * Constant with the session factory ID
    */
    public static String SESSION_FACTORY_NAME = "DIFRepository";

    /** ConfigNode attributes enumeration */
    public static class Fields
    {
        /** id column */
        public static final String ID ="id";
        /** nodePath column */
        public static final String NODEPATH ="nodePath";

        /**
         * List of existing fields
         *
         * @return list of field names
         */
        public static List<String> values()
        {
            ArrayList<String> list = new ArrayList<String>();
            list.add("id");
            list.add("nodePath");

            return list;
        }
    }

    /** Field attributes */
    public static ConfigNodeFieldAttributes FieldAttributes=new ConfigNodeFieldAttributes();

    /**
    * @return the field attributes definitions
    */
    @Override public ConfigNodeFieldAttributes getDefinitions()
    {
        return FieldAttributes;
    }

    /**
     * The Class Relations.
     */
    public class Relations extends AbstractBeanRelationsAttributes.AbstractRelations
    {

        /**
        * Instantiates a new relations.
        *
        * @param currentPath the current path
        */
        public Relations(String currentPath)
        {
            super(currentPath);
        }
        /**
         * configSet relation.
         *
         * @return the configSet bean relations attributes.
         */
        public ConfigSet.Relations configSet()
        {
            ConfigSet c = new ConfigSet();
            return c.new Relations(this.buildPath("configSet"));
        }

        /**
         * configurations relation.
         *
         * @return the configurations bean relations attributes.
         */
        public Configuration.Relations configurations()
        {
            Configuration c = new Configuration();
            return c.new Relations(this.buildPath("configurations"));
        }

        /**
         * the ID path.
         *
         * @return the path
         */
        public String ID()
        {
            return buildPath(Fields.ID);
        }
        /**
         * the NODEPATH path.
         *
         * @return the path
         */
        public String NODEPATH()
        {
            return buildPath(Fields.NODEPATH);
        }
    }

    /** The dummy obj. */
    private static ConfigNode dummyObj=new ConfigNode();

    /**
     * Get ConfigNode Relations .
     *
     * @return the relations
     */
    public static Relations FK()
    {
        return dummyObj.new Relations(null);
    }

    /**
    * Gets a new dataSet object for this bean
    *
    * @return the dataSet
    */
    public IDataSet<ConfigNode> getDataSet()
    {
        return getDataSetInstance();
    }

    /**
    * Gets a new dataSet object for this bean
    *
    * @return the dataSet
    */
    public static IDataSet<ConfigNode> getDataSetInstance()
    {
        return new HibernateDataSet<ConfigNode>(ConfigNode.class, HibernateUtil.getSessionFactory(SESSION_FACTORY_NAME),
            ConfigNode.getPKFieldListAsString(), ConfigNode.FieldAttributes);
    }

    /**
    * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeNoGraphNavigation(java.lang.String)
    */
    @Override protected Object getAttributeNoGraphNavigation(String attributeName)
    {
        if("id".equalsIgnoreCase(attributeName))
            return id;
        if("configSet".equalsIgnoreCase(attributeName))
            return configSet;
        if("nodePath".equalsIgnoreCase(attributeName))
            return nodePath;
        if("configurations".equalsIgnoreCase(attributeName))
            return configurations;

        return null;
    }

    /**
    * @see pt.digitalis.utils.common.IBeanAttributes#setAttribute(java.lang.String, java.lang.Object)
    */
    public void setAttribute(String attributeName,Object attributeValue)
    {
        if("id".equalsIgnoreCase(attributeName))
            id =(Long)attributeValue;
        if("configSet".equalsIgnoreCase(attributeName))
            configSet =(ConfigSet)attributeValue;
        if("nodePath".equalsIgnoreCase(attributeName))
            nodePath =(String)attributeValue;
        if("configurations".equalsIgnoreCase(attributeName))
            configurations =(Set<Configuration>)attributeValue;
    }

    // Fields

    /** id private attribute */
    private Long id;

    /** configSet private attribute */
    private ConfigSet configSet;

    /** nodePath private attribute */
    private String nodePath;

    /** configurations private attribute */
    private Set<Configuration> configurations = new HashSet<Configuration>(0);

    /** The pojo's primary key field list names */
    private static List<String> pkFieldList;

    /**
     * Get the table fields that compose the PK
     *
     * @return the PK field list
     */
     public synchronized static List<String> getPKFieldList()
     {
         if (pkFieldList == null)
         {
             pkFieldList = new ArrayList<String>();
             pkFieldList.add("id");
         }

         return pkFieldList;
     }

    /**
     * Get the table fields that compose the PK as a comma separated field name list
     *
     * @return the PK field list as a string
     */
     public static String getPKFieldListAsString()
     {
         StringBuffer buffer = new StringBuffer();

         for (int i = 0; i < getPKFieldList().size(); i++)
         {
             if (i != 0)
                 buffer.append(",");

             buffer.append(getPKFieldList().get(i));
         }

         return buffer.toString();
     }

    /**
     * Gets description field.
     *
     * @return the description field
     */
    @Override
    public String getDescriptionField()
    {
        return FieldAttributes.getDescriptionField();
    }

    /**
     * Get the table fields that compose the PK
     *
     * @return the PK field list
     */
    @Override
    public List<String> getPKFields()
    {
        return getPKFieldList();
    }

    /**
     * Is composite PK.
     *
     * @return the boolean
     */
    @Override
    public boolean isCompositePK()
    {
        return this.getPKFieldList().size() > 1;
    }

    /**
     * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeAsString(java.lang.String)
     */
     @Override
     public String getAttributeAsString(String attributeName)
     {
        if (attributeName.contains("."))
        {
            return this.getAttributeAsStringParseBeanPath(attributeName);
        }
        else
        {
            Object value = getAttribute(attributeName);

            if (value == null)
                return "";
            else {
                return value.toString().trim();
            }
        }
     }

    // Constructors

    /**
     * default constructor
     */
    public ConfigNode() {
    }

	/** 
	 * minimal constructor
	 *
     * @param configSet the configSet
     * @param nodePath the nodePath
    }
	 */
    public ConfigNode(ConfigSet configSet, String nodePath) {
        this.configSet = configSet;
        this.nodePath = nodePath;
    }

    /**
     * full constructor
	 *
     * @param configSet the configSet
     * @param nodePath the nodePath
     * @param configurations the configurations
     */
    public ConfigNode(ConfigSet configSet, String nodePath, Set<Configuration> configurations) {
        this.configSet = configSet;
        this.nodePath = nodePath;
        this.configurations = configurations;
    }

    // Property accessors
    
    /**       
     * id getter method
     *
     * @return id method
     */
    public Long getId() {
        return this.id;
    }
    
    /**       
     * id setter method
     *
     * @param id the id
     *
     * @return ConfigNode modified instance
     */
    public ConfigNode setId(Long id) {
        this.id = id;
        
        return this;
    }
    /**       
     * configSet getter method
     *
     * @return configSet method
     */
    public ConfigSet getConfigSet() {
        return this.configSet;
    }
    
    /**       
     * configSet setter method
     *
     * @param configSet the configSet
     *
     * @return ConfigNode modified instance
     */
    public ConfigNode setConfigSet(ConfigSet configSet) {
        this.configSet = configSet;
        
        return this;
    }
    /**       
     * nodePath getter method
     *
     * @return nodePath method
     */
    public String getNodePath() {
        return this.nodePath;
    }
    
    /**       
     * nodePath setter method
     *
     * @param nodePath the nodePath
     *
     * @return ConfigNode modified instance
     */
    public ConfigNode setNodePath(String nodePath) {
        this.nodePath = nodePath;
        
        return this;
    }
    /**       
     * configurations getter method
     *
     * @return configurations method
     */
    public Set<Configuration> getConfigurations() {
        return this.configurations;
    }
    
    /**       
     * configurations setter method
     *
     * @param configurations the configurations
     *
     * @return ConfigNode modified instance
     */
    public ConfigNode setConfigurations(Set<Configuration> configurations) {
        this.configurations = configurations;
        
        return this;
    }

    /**
     * configSet id getter method
     *
     * @return configSet id method
     */
    public Long getConfigSetId() {
        if (this.configSet == null)
            return null;
        else
            return this.configSet.getId();
    }

    /**
     * ConfigSet proxy setter method from id.
     *
     * @return ConfigNode modified instance
     */
    public ConfigNode setConfigSetProxyFromId(Long id)
    {
        if (id == null || id.equals(-1L))
            this.configSet = null;
        else
            this.configSet = ConfigSet.getProxy(id);

        return this;
    }

    /**
     * ConfigSet instance setter method from id.
     *
     * @return ConfigNode modified instance
     */
    public ConfigNode setConfigSetInstanceFromId(Long id)
    {
        if (id == null || id.equals(-1L))
            this.configSet = null;
        else
            this.configSet = ConfigSet.getInstance(id);

        return this;
    }

    /**
     * Creates a String representation of the ConfigNode object
     *
     * @return the compiled String
     */
    @Override
    public String toString() {
	    StringBuffer buffer = new StringBuffer();

        buffer.append(getClass().getName()).append("@").append(Integer.toHexString(hashCode())).append(" [");

        buffer.append("id").append("='").append(getId()).append("' ");			
        buffer.append("nodePath").append("='").append(getNodePath()).append("' ");			
        buffer.append("]");
      
        return buffer.toString();
    }

    /**
     * Compares the String representation of the ConfigNode object
     *
     * @param other The object to compare to
     *
     * @return true of the objects are equal
     */
    public boolean equals(ConfigNode other) {
        	return this.toString().equals(other.toString());
    }
    /**
     * @see pt.digitalis.utils.common.IBeanAttributes#setAttributeFromString(java.lang.String, java.lang.String)
     */
    public void setAttributeFromString(String attributeName, String attributeValue) {
        if ("id".equalsIgnoreCase(attributeName))
            this.id = Long.valueOf(attributeValue);

        if ("nodePath".equalsIgnoreCase(attributeName))
        	this.nodePath = attributeValue;

    }


    /**
     * Instanciates an Hibernate proxy data object (does not load it from the database, provides lazy load for that)
     *
     * @param session the session
     * @param id      the id
     *
     * @return the proxy
     */
    public static ConfigNode getProxy(Session session, Long id)
    {
        return(ConfigNode)session.load(ConfigNode.class,id);
    }

    /**
    * Instanciates an Hibernate proxy data object (does not load it from the database, provides lazy load for that)
    *
    * @param id      the id
    *
    * @return the proxy
    */
    public static ConfigNode getProxy(Long id)
    {
        Session session = HibernateUtil.getSessionFactory(SESSION_FACTORY_NAME).getCurrentSession();
        boolean wasActive = session.getTransaction().isActive();

        if (!wasActive)
            session.beginTransaction();

        ConfigNode result = (ConfigNode)session.load(ConfigNode.class,id);

        if (!wasActive)
            session.getTransaction().commit();

        return result;
    }


    /**
     * Instanciates an Hibernate data object
     *
     * @param session the session
     * @param id      the id
     *
     * @return the instance
     */
    public static ConfigNode getInstanceForSession(Session session, Long id)
    {
        return(ConfigNode)session.get(ConfigNode.class,id);
    }

    /**
    * Instanciates an Hibernate data object
    *
    * @param id      the id
    *
    * @return the instance
    */
    public static ConfigNode getInstance(Long id)
    {
        Session session = HibernateUtil.getSessionFactory(SESSION_FACTORY_NAME).getCurrentSession();
        boolean wasActive = session.getTransaction().isActive();

        if (!wasActive)
            session.beginTransaction();

        ConfigNode result = (ConfigNode)session.get(ConfigNode.class,id);

        if (!wasActive)
            session.getTransaction().commit();

        return result;
    }

}
