package pt.digitalis.dif.dem.managers.impl.model.data;

import pt.digitalis.utils.common.AttributeDefinition;
import pt.digitalis.dif.model.utils.AbstractBeanAttributesDefinition;

import java.sql.Timestamp;
import java.sql.Blob;
import java.util.Date;
import java.math.BigDecimal;

import java.util.Arrays;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pt.digitalis.utils.common.collections.CaseInsensitiveHashMap;

import org.hibernate.Session;


/**
 *  Field definitions for data object {@link ConfigNode}
 *
 * NOTE: This file is auto generated and will be overwritten in a future file generation.
 */
public class ConfigNodeFieldAttributes extends AbstractBeanAttributesDefinition{

    /** configSet (Database column: CONFIG_SET_ID - The Set ID (each application can have a diferent set of configurations, or share configuration sets)) */
    static public AttributeDefinition configSet =
        new AttributeDefinition("configSet")
                .setDescription("The Set ID (each application can have a diferent set of configurations, or share configuration sets)")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("CONFIG_NODE")
                .setDatabaseId("CONFIG_SET_ID")
                .setMandatory(true)
                .setMaxSize(10)
                .setLovDataClass(pt.digitalis.dif.dem.managers.impl.model.data.ConfigSet.class)
                .setLovDataClassKey("id")
                .setLovDataClassDescription("name")
                .setType(pt.digitalis.dif.dem.managers.impl.model.data.ConfigSet.class);

    /** id (Database column: ID - ID) */
    static public AttributeDefinition id =
        new AttributeDefinition("id")
                .setDescription("ID")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("CONFIG_NODE")
                .setDatabaseId("ID")
                .setMandatory(true)
                .setMaxSize(10)
                .setType(Long.class);

    /** nodePath (Database column: NODE_PATH - The node path) */
    static public AttributeDefinition nodePath =
        new AttributeDefinition("nodePath")
                .setDescription("The node path")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("CONFIG_NODE")
                .setDatabaseId("NODE_PATH")
                .setMandatory(true)
                .setMaxSize(800)
                .setType(String.class);

    /**
     * Gets description field.
     *
     * @return the description field
     */
    public static String getDescriptionField()
    {
        return "nodePath";
    }

    /**
    * Create definitions map map.
    *
    * @return the map
    */
    @Override protected CaseInsensitiveHashMap<AttributeDefinition> createDefinitionsMap(){
        CaseInsensitiveHashMap<AttributeDefinition> map = new CaseInsensitiveHashMap<AttributeDefinition>();
        map.put(configSet.getName(),configSet);
        map.put(id.getName(),id);
        map.put(nodePath.getName(),nodePath);

        return map;
    }
}