package pt.digitalis.dif.dem.managers.impl.model.data;


import java.util.ArrayList;
import java.util.List;
import org.hibernate.Session;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.hibernate.HibernateUtil;
import pt.digitalis.dif.model.utils.AbstractBeanRelationsAttributes;
import pt.digitalis.dif.model.utils.IBeanAttributesDataSet;

/**
 * ConfigServerSet
* Generated on ORM Generator
* DIF build process for the Model layer
*
*/
@SuppressWarnings("serial")
public class ConfigServerSet extends AbstractBeanRelationsAttributes implements java.io.Serializable, IBeanAttributesDataSet<ConfigServerSet> {

    /**
    * Constant with the session factory ID
    */
    public static String SESSION_FACTORY_NAME = "DIFRepository";

    /** ConfigServerSet attributes enumeration */
    public static class Fields
    {
        /** id column */
        public static final String ID ="id";
        /** serverUid column */
        public static final String SERVERUID ="serverUid";
        /** isDefault column */
        public static final String ISDEFAULT ="isDefault";

        /**
         * List of existing fields
         *
         * @return list of field names
         */
        public static List<String> values()
        {
            ArrayList<String> list = new ArrayList<String>();
            list.add("id");
            list.add("serverUid");
            list.add("isDefault");

            return list;
        }
    }

    /** Field attributes */
    public static ConfigServerSetFieldAttributes FieldAttributes=new ConfigServerSetFieldAttributes();

    /**
    * @return the field attributes definitions
    */
    @Override public ConfigServerSetFieldAttributes getDefinitions()
    {
        return FieldAttributes;
    }

    /**
     * The Class Relations.
     */
    public class Relations extends AbstractBeanRelationsAttributes.AbstractRelations
    {

        /**
        * Instantiates a new relations.
        *
        * @param currentPath the current path
        */
        public Relations(String currentPath)
        {
            super(currentPath);
        }
        /**
         * configSet relation.
         *
         * @return the configSet bean relations attributes.
         */
        public ConfigSet.Relations configSet()
        {
            ConfigSet c = new ConfigSet();
            return c.new Relations(this.buildPath("configSet"));
        }

        /**
         * the ID path.
         *
         * @return the path
         */
        public String ID()
        {
            return buildPath(Fields.ID);
        }
        /**
         * the SERVERUID path.
         *
         * @return the path
         */
        public String SERVERUID()
        {
            return buildPath(Fields.SERVERUID);
        }
        /**
         * the ISDEFAULT path.
         *
         * @return the path
         */
        public String ISDEFAULT()
        {
            return buildPath(Fields.ISDEFAULT);
        }
    }

    /** The dummy obj. */
    private static ConfigServerSet dummyObj=new ConfigServerSet();

    /**
     * Get ConfigServerSet Relations .
     *
     * @return the relations
     */
    public static Relations FK()
    {
        return dummyObj.new Relations(null);
    }

    /**
    * Gets a new dataSet object for this bean
    *
    * @return the dataSet
    */
    public IDataSet<ConfigServerSet> getDataSet()
    {
        return getDataSetInstance();
    }

    /**
    * Gets a new dataSet object for this bean
    *
    * @return the dataSet
    */
    public static IDataSet<ConfigServerSet> getDataSetInstance()
    {
        return new HibernateDataSet<ConfigServerSet>(ConfigServerSet.class, HibernateUtil.getSessionFactory(SESSION_FACTORY_NAME),
            ConfigServerSet.getPKFieldListAsString(), ConfigServerSet.FieldAttributes);
    }

    /**
    * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeNoGraphNavigation(java.lang.String)
    */
    @Override protected Object getAttributeNoGraphNavigation(String attributeName)
    {
        if("id".equalsIgnoreCase(attributeName))
            return id;
        if("configSet".equalsIgnoreCase(attributeName))
            return configSet;
        if("serverUid".equalsIgnoreCase(attributeName))
            return serverUid;
        if("isDefault".equalsIgnoreCase(attributeName))
            return isDefault;

        return null;
    }

    /**
    * @see pt.digitalis.utils.common.IBeanAttributes#setAttribute(java.lang.String, java.lang.Object)
    */
    public void setAttribute(String attributeName,Object attributeValue)
    {
        if("id".equalsIgnoreCase(attributeName))
            id =(Long)attributeValue;
        if("configSet".equalsIgnoreCase(attributeName))
            configSet =(ConfigSet)attributeValue;
        if("serverUid".equalsIgnoreCase(attributeName))
            serverUid =(String)attributeValue;
        if("isDefault".equalsIgnoreCase(attributeName))
            isDefault =(Boolean)attributeValue;
    }

    // Fields

    /** id private attribute */
    private Long id;

    /** configSet private attribute */
    private ConfigSet configSet;

    /** serverUid private attribute */
    private String serverUid;

    /** isDefault private attribute */
    private boolean isDefault;

    /** The pojo's primary key field list names */
    private static List<String> pkFieldList;

    /**
     * Get the table fields that compose the PK
     *
     * @return the PK field list
     */
     public synchronized static List<String> getPKFieldList()
     {
         if (pkFieldList == null)
         {
             pkFieldList = new ArrayList<String>();
             pkFieldList.add("id");
         }

         return pkFieldList;
     }

    /**
     * Get the table fields that compose the PK as a comma separated field name list
     *
     * @return the PK field list as a string
     */
     public static String getPKFieldListAsString()
     {
         StringBuffer buffer = new StringBuffer();

         for (int i = 0; i < getPKFieldList().size(); i++)
         {
             if (i != 0)
                 buffer.append(",");

             buffer.append(getPKFieldList().get(i));
         }

         return buffer.toString();
     }

    /**
     * Gets description field.
     *
     * @return the description field
     */
    @Override
    public String getDescriptionField()
    {
        return FieldAttributes.getDescriptionField();
    }

    /**
     * Get the table fields that compose the PK
     *
     * @return the PK field list
     */
    @Override
    public List<String> getPKFields()
    {
        return getPKFieldList();
    }

    /**
     * Is composite PK.
     *
     * @return the boolean
     */
    @Override
    public boolean isCompositePK()
    {
        return this.getPKFieldList().size() > 1;
    }

    /**
     * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeAsString(java.lang.String)
     */
     @Override
     public String getAttributeAsString(String attributeName)
     {
        if (attributeName.contains("."))
        {
            return this.getAttributeAsStringParseBeanPath(attributeName);
        }
        else
        {
            Object value = getAttribute(attributeName);

            if (value == null)
                return "";
            else {
                return value.toString().trim();
            }
        }
     }

    // Constructors

    /**
     * default constructor
     */
    public ConfigServerSet() {
    }


    /**
     * full constructor
	 *
     * @param configSet the configSet
     * @param serverUid the serverUid
     * @param isDefault the isDefault
     */
    public ConfigServerSet(ConfigSet configSet, String serverUid, boolean isDefault) {
        this.configSet = configSet;
        this.serverUid = serverUid;
        this.isDefault = isDefault;
    }

    // Property accessors
    
    /**       
     * id getter method
     *
     * @return id method
     */
    public Long getId() {
        return this.id;
    }
    
    /**       
     * id setter method
     *
     * @param id the id
     *
     * @return ConfigServerSet modified instance
     */
    public ConfigServerSet setId(Long id) {
        this.id = id;
        
        return this;
    }
    /**       
     * configSet getter method
     *
     * @return configSet method
     */
    public ConfigSet getConfigSet() {
        return this.configSet;
    }
    
    /**       
     * configSet setter method
     *
     * @param configSet the configSet
     *
     * @return ConfigServerSet modified instance
     */
    public ConfigServerSet setConfigSet(ConfigSet configSet) {
        this.configSet = configSet;
        
        return this;
    }
    /**       
     * serverUid getter method
     *
     * @return serverUid method
     */
    public String getServerUid() {
        return this.serverUid;
    }
    
    /**       
     * serverUid setter method
     *
     * @param serverUid the serverUid
     *
     * @return ConfigServerSet modified instance
     */
    public ConfigServerSet setServerUid(String serverUid) {
        this.serverUid = serverUid;
        
        return this;
    }
    /**       
     * isDefault getter method
     *
     * @return isDefault method
     */
    public boolean isIsDefault() {
        return this.isDefault;
    }
    
    /**       
     * isDefault setter method
     *
     * @param isDefault the isDefault
     *
     * @return ConfigServerSet modified instance
     */
    public ConfigServerSet setIsDefault(boolean isDefault) {
        this.isDefault = isDefault;
        
        return this;
    }

    /**
     * configSet id getter method
     *
     * @return configSet id method
     */
    public Long getConfigSetId() {
        if (this.configSet == null)
            return null;
        else
            return this.configSet.getId();
    }

    /**
     * ConfigSet proxy setter method from id.
     *
     * @return ConfigServerSet modified instance
     */
    public ConfigServerSet setConfigSetProxyFromId(Long id)
    {
        if (id == null || id.equals(-1L))
            this.configSet = null;
        else
            this.configSet = ConfigSet.getProxy(id);

        return this;
    }

    /**
     * ConfigSet instance setter method from id.
     *
     * @return ConfigServerSet modified instance
     */
    public ConfigServerSet setConfigSetInstanceFromId(Long id)
    {
        if (id == null || id.equals(-1L))
            this.configSet = null;
        else
            this.configSet = ConfigSet.getInstance(id);

        return this;
    }

    /**
     * Creates a String representation of the ConfigServerSet object
     *
     * @return the compiled String
     */
    @Override
    public String toString() {
	    StringBuffer buffer = new StringBuffer();

        buffer.append(getClass().getName()).append("@").append(Integer.toHexString(hashCode())).append(" [");

        buffer.append("id").append("='").append(getId()).append("' ");			
        buffer.append("serverUid").append("='").append(getServerUid()).append("' ");			
        buffer.append("isDefault").append("='").append(isIsDefault()).append("' ");			
        buffer.append("]");
      
        return buffer.toString();
    }

    /**
     * Compares the String representation of the ConfigServerSet object
     *
     * @param other The object to compare to
     *
     * @return true of the objects are equal
     */
    public boolean equals(ConfigServerSet other) {
        	return this.toString().equals(other.toString());
    }
    /**
     * @see pt.digitalis.utils.common.IBeanAttributes#setAttributeFromString(java.lang.String, java.lang.String)
     */
    public void setAttributeFromString(String attributeName, String attributeValue) {
        if ("id".equalsIgnoreCase(attributeName))
            this.id = Long.valueOf(attributeValue);

        if ("serverUid".equalsIgnoreCase(attributeName))
        	this.serverUid = attributeValue;

        if ("isDefault".equalsIgnoreCase(attributeName))
            this.isDefault = Boolean.valueOf(attributeValue);

    }


    /**
     * Instanciates an Hibernate proxy data object (does not load it from the database, provides lazy load for that)
     *
     * @param session the session
     * @param id      the id
     *
     * @return the proxy
     */
    public static ConfigServerSet getProxy(Session session, Long id)
    {
        return(ConfigServerSet)session.load(ConfigServerSet.class,id);
    }

    /**
    * Instanciates an Hibernate proxy data object (does not load it from the database, provides lazy load for that)
    *
    * @param id      the id
    *
    * @return the proxy
    */
    public static ConfigServerSet getProxy(Long id)
    {
        Session session = HibernateUtil.getSessionFactory(SESSION_FACTORY_NAME).getCurrentSession();
        boolean wasActive = session.getTransaction().isActive();

        if (!wasActive)
            session.beginTransaction();

        ConfigServerSet result = (ConfigServerSet)session.load(ConfigServerSet.class,id);

        if (!wasActive)
            session.getTransaction().commit();

        return result;
    }


    /**
     * Instanciates an Hibernate data object
     *
     * @param session the session
     * @param id      the id
     *
     * @return the instance
     */
    public static ConfigServerSet getInstanceForSession(Session session, Long id)
    {
        return(ConfigServerSet)session.get(ConfigServerSet.class,id);
    }

    /**
    * Instanciates an Hibernate data object
    *
    * @param id      the id
    *
    * @return the instance
    */
    public static ConfigServerSet getInstance(Long id)
    {
        Session session = HibernateUtil.getSessionFactory(SESSION_FACTORY_NAME).getCurrentSession();
        boolean wasActive = session.getTransaction().isActive();

        if (!wasActive)
            session.beginTransaction();

        ConfigServerSet result = (ConfigServerSet)session.get(ConfigServerSet.class,id);

        if (!wasActive)
            session.getTransaction().commit();

        return result;
    }

}
