package pt.digitalis.dif.dem.managers.impl.model.data;

import pt.digitalis.utils.common.AttributeDefinition;
import pt.digitalis.dif.model.utils.AbstractBeanAttributesDefinition;

import java.sql.Timestamp;
import java.sql.Blob;
import java.util.Date;
import java.math.BigDecimal;

import java.util.Arrays;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pt.digitalis.utils.common.collections.CaseInsensitiveHashMap;

import org.hibernate.Session;


/**
 *  Field definitions for data object {@link ConfigServerSet}
 *
 * NOTE: This file is auto generated and will be overwritten in a future file generation.
 */
public class ConfigServerSetFieldAttributes extends AbstractBeanAttributesDefinition{

    /** configSet (Database column: CONFIG_SET_ID - The set ID) */
    static public AttributeDefinition configSet =
        new AttributeDefinition("configSet")
                .setDescription("The set ID")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("CONFIG_SERVER_SET")
                .setDatabaseId("CONFIG_SET_ID")
                .setMandatory(true)
                .setMaxSize(10)
                .setLovDataClass(pt.digitalis.dif.dem.managers.impl.model.data.ConfigSet.class)
                .setLovDataClassKey("id")
                .setLovDataClassDescription("name")
                .setType(pt.digitalis.dif.dem.managers.impl.model.data.ConfigSet.class);

    /** id (Database column: ID - ID) */
    static public AttributeDefinition id =
        new AttributeDefinition("id")
                .setDescription("ID")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("CONFIG_SERVER_SET")
                .setDatabaseId("ID")
                .setMandatory(true)
                .setMaxSize(10)
                .setType(Long.class);

    /** isDefault (Database column: IS_DEFAULT - If set is the default) */
    static public AttributeDefinition isDefault =
        new AttributeDefinition("isDefault")
                .setDescription("If set is the default")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("CONFIG_SERVER_SET")
                .setDatabaseId("IS_DEFAULT")
                .setMandatory(true)
                .setMaxSize(1)
                .setTreatAsBoolean(true)
                .setBooleanFalseValue("0")
                .setBooleanTrueValue("1")
                .setDefaultValue("0")
                .setLovFixedList(Arrays.asList(new String[]{"1","0"}))
                .setType(boolean.class);

    /** serverUid (Database column: SERVER_UID - The server unique ID) */
    static public AttributeDefinition serverUid =
        new AttributeDefinition("serverUid")
                .setDescription("The server unique ID")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("CONFIG_SERVER_SET")
                .setDatabaseId("SERVER_UID")
                .setMandatory(true)
                .setMaxSize(500)
                .setType(String.class);

    /**
     * Gets description field.
     *
     * @return the description field
     */
    public static String getDescriptionField()
    {
        return null;
    }

    /**
    * Create definitions map map.
    *
    * @return the map
    */
    @Override protected CaseInsensitiveHashMap<AttributeDefinition> createDefinitionsMap(){
        CaseInsensitiveHashMap<AttributeDefinition> map = new CaseInsensitiveHashMap<AttributeDefinition>();
        map.put(configSet.getName(),configSet);
        map.put(id.getName(),id);
        map.put(isDefault.getName(),isDefault);
        map.put(serverUid.getName(),serverUid);

        return map;
    }
}