package pt.digitalis.dif.dem.managers.impl.model.data;


import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hibernate.Session;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.hibernate.HibernateUtil;
import pt.digitalis.dif.model.utils.AbstractBeanRelationsAttributes;
import pt.digitalis.dif.model.utils.IBeanAttributesDataSet;

/**
 * ConfigSet
* Generated on ORM Generator
* DIF build process for the Model layer
*
*/
@SuppressWarnings("serial")
public class ConfigSet extends AbstractBeanRelationsAttributes implements java.io.Serializable, IBeanAttributesDataSet<ConfigSet> {

    /**
    * Constant with the session factory ID
    */
    public static String SESSION_FACTORY_NAME = "DIFRepository";

    /** ConfigSet attributes enumeration */
    public static class Fields
    {
        /** id column */
        public static final String ID ="id";
        /** name column */
        public static final String NAME ="name";
        /** description column */
        public static final String DESCRIPTION ="description";

        /**
         * List of existing fields
         *
         * @return list of field names
         */
        public static List<String> values()
        {
            ArrayList<String> list = new ArrayList<String>();
            list.add("id");
            list.add("name");
            list.add("description");

            return list;
        }
    }

    /** Field attributes */
    public static ConfigSetFieldAttributes FieldAttributes=new ConfigSetFieldAttributes();

    /**
    * @return the field attributes definitions
    */
    @Override public ConfigSetFieldAttributes getDefinitions()
    {
        return FieldAttributes;
    }

    /**
     * The Class Relations.
     */
    public class Relations extends AbstractBeanRelationsAttributes.AbstractRelations
    {

        /**
        * Instantiates a new relations.
        *
        * @param currentPath the current path
        */
        public Relations(String currentPath)
        {
            super(currentPath);
        }
        /**
         * configNodes relation.
         *
         * @return the configNodes bean relations attributes.
         */
        public ConfigNode.Relations configNodes()
        {
            ConfigNode c = new ConfigNode();
            return c.new Relations(this.buildPath("configNodes"));
        }

        /**
         * configServerSets relation.
         *
         * @return the configServerSets bean relations attributes.
         */
        public ConfigServerSet.Relations configServerSets()
        {
            ConfigServerSet c = new ConfigServerSet();
            return c.new Relations(this.buildPath("configServerSets"));
        }

        /**
         * the ID path.
         *
         * @return the path
         */
        public String ID()
        {
            return buildPath(Fields.ID);
        }
        /**
         * the NAME path.
         *
         * @return the path
         */
        public String NAME()
        {
            return buildPath(Fields.NAME);
        }
        /**
         * the DESCRIPTION path.
         *
         * @return the path
         */
        public String DESCRIPTION()
        {
            return buildPath(Fields.DESCRIPTION);
        }
    }

    /** The dummy obj. */
    private static ConfigSet dummyObj=new ConfigSet();

    /**
     * Get ConfigSet Relations .
     *
     * @return the relations
     */
    public static Relations FK()
    {
        return dummyObj.new Relations(null);
    }

    /**
    * Gets a new dataSet object for this bean
    *
    * @return the dataSet
    */
    public IDataSet<ConfigSet> getDataSet()
    {
        return getDataSetInstance();
    }

    /**
    * Gets a new dataSet object for this bean
    *
    * @return the dataSet
    */
    public static IDataSet<ConfigSet> getDataSetInstance()
    {
        return new HibernateDataSet<ConfigSet>(ConfigSet.class, HibernateUtil.getSessionFactory(SESSION_FACTORY_NAME),
            ConfigSet.getPKFieldListAsString(), ConfigSet.FieldAttributes);
    }

    /**
    * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeNoGraphNavigation(java.lang.String)
    */
    @Override protected Object getAttributeNoGraphNavigation(String attributeName)
    {
        if("id".equalsIgnoreCase(attributeName))
            return id;
        if("name".equalsIgnoreCase(attributeName))
            return name;
        if("description".equalsIgnoreCase(attributeName))
            return description;
        if("configNodes".equalsIgnoreCase(attributeName))
            return configNodes;
        if("configServerSets".equalsIgnoreCase(attributeName))
            return configServerSets;

        return null;
    }

    /**
    * @see pt.digitalis.utils.common.IBeanAttributes#setAttribute(java.lang.String, java.lang.Object)
    */
    public void setAttribute(String attributeName,Object attributeValue)
    {
        if("id".equalsIgnoreCase(attributeName))
            id =(Long)attributeValue;
        if("name".equalsIgnoreCase(attributeName))
            name =(String)attributeValue;
        if("description".equalsIgnoreCase(attributeName))
            description =(String)attributeValue;
        if("configNodes".equalsIgnoreCase(attributeName))
            configNodes =(Set<ConfigNode>)attributeValue;
        if("configServerSets".equalsIgnoreCase(attributeName))
            configServerSets =(Set<ConfigServerSet>)attributeValue;
    }

    // Fields

    /** id private attribute */
    private Long id;

    /** name private attribute */
    private String name;

    /** description private attribute */
    private String description;

    /** configNodes private attribute */
    private Set<ConfigNode> configNodes = new HashSet<ConfigNode>(0);

    /** configServerSets private attribute */
    private Set<ConfigServerSet> configServerSets = new HashSet<ConfigServerSet>(0);

    /** The pojo's primary key field list names */
    private static List<String> pkFieldList;

    /**
     * Get the table fields that compose the PK
     *
     * @return the PK field list
     */
     public synchronized static List<String> getPKFieldList()
     {
         if (pkFieldList == null)
         {
             pkFieldList = new ArrayList<String>();
             pkFieldList.add("id");
         }

         return pkFieldList;
     }

    /**
     * Get the table fields that compose the PK as a comma separated field name list
     *
     * @return the PK field list as a string
     */
     public static String getPKFieldListAsString()
     {
         StringBuffer buffer = new StringBuffer();

         for (int i = 0; i < getPKFieldList().size(); i++)
         {
             if (i != 0)
                 buffer.append(",");

             buffer.append(getPKFieldList().get(i));
         }

         return buffer.toString();
     }

    /**
     * Gets description field.
     *
     * @return the description field
     */
    @Override
    public String getDescriptionField()
    {
        return FieldAttributes.getDescriptionField();
    }

    /**
     * Get the table fields that compose the PK
     *
     * @return the PK field list
     */
    @Override
    public List<String> getPKFields()
    {
        return getPKFieldList();
    }

    /**
     * Is composite PK.
     *
     * @return the boolean
     */
    @Override
    public boolean isCompositePK()
    {
        return this.getPKFieldList().size() > 1;
    }

    /**
     * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeAsString(java.lang.String)
     */
     @Override
     public String getAttributeAsString(String attributeName)
     {
        if (attributeName.contains("."))
        {
            return this.getAttributeAsStringParseBeanPath(attributeName);
        }
        else
        {
            Object value = getAttribute(attributeName);

            if (value == null)
                return "";
            else {
                return value.toString().trim();
            }
        }
     }

    // Constructors

    /**
     * default constructor
     */
    public ConfigSet() {
    }

	/** 
	 * minimal constructor
	 *
     * @param name the name
    }
	 */
    public ConfigSet(String name) {
        this.name = name;
    }

    /**
     * full constructor
	 *
     * @param name the name
     * @param description the description
     * @param configNodes the configNodes
     * @param configServerSets the configServerSets
     */
    public ConfigSet(String name, String description, Set<ConfigNode> configNodes, Set<ConfigServerSet> configServerSets) {
        this.name = name;
        this.description = description;
        this.configNodes = configNodes;
        this.configServerSets = configServerSets;
    }

    // Property accessors
    
    /**       
     * id getter method
     *
     * @return id method
     */
    public Long getId() {
        return this.id;
    }
    
    /**       
     * id setter method
     *
     * @param id the id
     *
     * @return ConfigSet modified instance
     */
    public ConfigSet setId(Long id) {
        this.id = id;
        
        return this;
    }
    /**       
     * name getter method
     *
     * @return name method
     */
    public String getName() {
        return this.name;
    }
    
    /**       
     * name setter method
     *
     * @param name the name
     *
     * @return ConfigSet modified instance
     */
    public ConfigSet setName(String name) {
        this.name = name;
        
        return this;
    }
    /**       
     * description getter method
     *
     * @return description method
     */
    public String getDescription() {
        return this.description;
    }
    
    /**       
     * description setter method
     *
     * @param description the description
     *
     * @return ConfigSet modified instance
     */
    public ConfigSet setDescription(String description) {
        this.description = description;
        
        return this;
    }
    /**       
     * configNodes getter method
     *
     * @return configNodes method
     */
    public Set<ConfigNode> getConfigNodes() {
        return this.configNodes;
    }
    
    /**       
     * configNodes setter method
     *
     * @param configNodes the configNodes
     *
     * @return ConfigSet modified instance
     */
    public ConfigSet setConfigNodes(Set<ConfigNode> configNodes) {
        this.configNodes = configNodes;
        
        return this;
    }
    /**       
     * configServerSets getter method
     *
     * @return configServerSets method
     */
    public Set<ConfigServerSet> getConfigServerSets() {
        return this.configServerSets;
    }
    
    /**       
     * configServerSets setter method
     *
     * @param configServerSets the configServerSets
     *
     * @return ConfigSet modified instance
     */
    public ConfigSet setConfigServerSets(Set<ConfigServerSet> configServerSets) {
        this.configServerSets = configServerSets;
        
        return this;
    }


    /**
     * Creates a String representation of the ConfigSet object
     *
     * @return the compiled String
     */
    @Override
    public String toString() {
	    StringBuffer buffer = new StringBuffer();

        buffer.append(getClass().getName()).append("@").append(Integer.toHexString(hashCode())).append(" [");

        buffer.append("id").append("='").append(getId()).append("' ");			
        buffer.append("name").append("='").append(getName()).append("' ");			
        buffer.append("description").append("='").append(getDescription()).append("' ");			
        buffer.append("]");
      
        return buffer.toString();
    }

    /**
     * Compares the String representation of the ConfigSet object
     *
     * @param other The object to compare to
     *
     * @return true of the objects are equal
     */
    public boolean equals(ConfigSet other) {
        	return this.toString().equals(other.toString());
    }
    /**
     * @see pt.digitalis.utils.common.IBeanAttributes#setAttributeFromString(java.lang.String, java.lang.String)
     */
    public void setAttributeFromString(String attributeName, String attributeValue) {
        if ("id".equalsIgnoreCase(attributeName))
            this.id = Long.valueOf(attributeValue);

        if ("name".equalsIgnoreCase(attributeName))
        	this.name = attributeValue;

        if ("description".equalsIgnoreCase(attributeName))
        	this.description = attributeValue;

    }


    /**
     * Instanciates an Hibernate proxy data object (does not load it from the database, provides lazy load for that)
     *
     * @param session the session
     * @param id      the id
     *
     * @return the proxy
     */
    public static ConfigSet getProxy(Session session, Long id)
    {
        return(ConfigSet)session.load(ConfigSet.class,id);
    }

    /**
    * Instanciates an Hibernate proxy data object (does not load it from the database, provides lazy load for that)
    *
    * @param id      the id
    *
    * @return the proxy
    */
    public static ConfigSet getProxy(Long id)
    {
        Session session = HibernateUtil.getSessionFactory(SESSION_FACTORY_NAME).getCurrentSession();
        boolean wasActive = session.getTransaction().isActive();

        if (!wasActive)
            session.beginTransaction();

        ConfigSet result = (ConfigSet)session.load(ConfigSet.class,id);

        if (!wasActive)
            session.getTransaction().commit();

        return result;
    }


    /**
     * Instanciates an Hibernate data object
     *
     * @param session the session
     * @param id      the id
     *
     * @return the instance
     */
    public static ConfigSet getInstanceForSession(Session session, Long id)
    {
        return(ConfigSet)session.get(ConfigSet.class,id);
    }

    /**
    * Instanciates an Hibernate data object
    *
    * @param id      the id
    *
    * @return the instance
    */
    public static ConfigSet getInstance(Long id)
    {
        Session session = HibernateUtil.getSessionFactory(SESSION_FACTORY_NAME).getCurrentSession();
        boolean wasActive = session.getTransaction().isActive();

        if (!wasActive)
            session.beginTransaction();

        ConfigSet result = (ConfigSet)session.get(ConfigSet.class,id);

        if (!wasActive)
            session.getTransaction().commit();

        return result;
    }

}
