package pt.digitalis.dif.dem.managers.impl.model.data;

import pt.digitalis.utils.common.AttributeDefinition;
import pt.digitalis.dif.model.utils.AbstractBeanAttributesDefinition;

import java.sql.Timestamp;
import java.sql.Blob;
import java.util.Date;
import java.math.BigDecimal;

import java.util.Arrays;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pt.digitalis.utils.common.collections.CaseInsensitiveHashMap;

import org.hibernate.Session;


/**
 *  Field definitions for data object {@link ConfigSet}
 *
 * NOTE: This file is auto generated and will be overwritten in a future file generation.
 */
public class ConfigSetFieldAttributes extends AbstractBeanAttributesDefinition{

    /** description (Database column: DESCRIPTION - The set description) */
    static public AttributeDefinition description =
        new AttributeDefinition("description")
                .setDescription("The set description")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("CONFIG_SET")
                .setDatabaseId("DESCRIPTION")
                .setMandatory(false)
                .setMaxSize(4000)
                .setType(String.class);

    /** id (Database column: ID - ID) */
    static public AttributeDefinition id =
        new AttributeDefinition("id")
                .setDescription("ID")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("CONFIG_SET")
                .setDatabaseId("ID")
                .setMandatory(true)
                .setMaxSize(10)
                .setType(Long.class);

    /** name (Database column: NAME - The set name) */
    static public AttributeDefinition name =
        new AttributeDefinition("name")
                .setDescription("The set name")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("CONFIG_SET")
                .setDatabaseId("NAME")
                .setMandatory(true)
                .setMaxSize(500)
                .setType(String.class);

    /**
     * Gets description field.
     *
     * @return the description field
     */
    public static String getDescriptionField()
    {
        return "name";
    }

    /**
    * Create definitions map map.
    *
    * @return the map
    */
    @Override protected CaseInsensitiveHashMap<AttributeDefinition> createDefinitionsMap(){
        CaseInsensitiveHashMap<AttributeDefinition> map = new CaseInsensitiveHashMap<AttributeDefinition>();
        map.put(description.getName(),description);
        map.put(id.getName(),id);
        map.put(name.getName(),name);

        return map;
    }
}