package pt.digitalis.dif.dem.managers.impl.model.data;

import pt.digitalis.utils.common.AttributeDefinition;
import pt.digitalis.dif.model.utils.AbstractBeanAttributesDefinition;

import java.sql.Timestamp;
import java.sql.Blob;
import java.util.Date;
import java.math.BigDecimal;

import java.util.Arrays;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pt.digitalis.utils.common.collections.CaseInsensitiveHashMap;

import org.hibernate.Session;


/**
 *  Field definitions for data object {@link Configuration}
 *
 * NOTE: This file is auto generated and will be overwritten in a future file generation.
 */
public class ConfigurationFieldAttributes extends AbstractBeanAttributesDefinition{

    /** configNode (Database column: CONFIG_NODE_ID - Configuration node ID) */
    static public AttributeDefinition configNode =
        new AttributeDefinition("configNode")
                .setDescription("Configuration node ID")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("CONFIGURATION")
                .setDatabaseId("CONFIG_NODE_ID")
                .setMandatory(true)
                .setMaxSize(10)
                .setLovDataClass(pt.digitalis.dif.dem.managers.impl.model.data.ConfigNode.class)
                .setLovDataClassKey("id")
                .setLovDataClassDescription("nodePath")
                .setType(pt.digitalis.dif.dem.managers.impl.model.data.ConfigNode.class);

    /** id (Database column: ID - ID) */
    static public AttributeDefinition id =
        new AttributeDefinition("id")
                .setDescription("ID")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("CONFIGURATION")
                .setDatabaseId("ID")
                .setMandatory(true)
                .setMaxSize(10)
                .setType(Long.class);

    /** key (Database column: KEY - The configuration property key identifier) */
    static public AttributeDefinition key =
        new AttributeDefinition("key")
                .setDescription("The configuration property key identifier")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("CONFIGURATION")
                .setDatabaseId("KEY")
                .setMandatory(true)
                .setMaxSize(500)
                .setType(String.class);

    /** value (Database column: VALUE - The configuration property value) */
    static public AttributeDefinition value =
        new AttributeDefinition("value")
                .setDescription("The configuration property value")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("CONFIGURATION")
                .setDatabaseId("VALUE")
                .setMandatory(false)
                .setMaxSize(4000)
                .setType(String.class);

    /** valueXL (Database column: VALUE_X_L - The configuration property value if larger than 4000 in size) */
    static public AttributeDefinition valueXL =
        new AttributeDefinition("valueXL")
                .setDescription("The configuration property value if larger than 4000 in size")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("CONFIGURATION")
                .setDatabaseId("VALUE_X_L")
                .setMandatory(false)
                .setMaxSize(4000)
                .setType(String.class);

    /**
     * Gets description field.
     *
     * @return the description field
     */
    public static String getDescriptionField()
    {
        return null;
    }

    /**
    * Create definitions map map.
    *
    * @return the map
    */
    @Override protected CaseInsensitiveHashMap<AttributeDefinition> createDefinitionsMap(){
        CaseInsensitiveHashMap<AttributeDefinition> map = new CaseInsensitiveHashMap<AttributeDefinition>();
        map.put(configNode.getName(),configNode);
        map.put(id.getName(),id);
        map.put(key.getName(),key);
        map.put(value.getName(),value);
        map.put(valueXL.getName(),valueXL);

        return map;
    }
}