package pt.digitalis.dif.dem.managers.impl.model.data;

import pt.digitalis.utils.common.AttributeDefinition;
import pt.digitalis.dif.model.utils.AbstractBeanAttributesDefinition;

import java.sql.Timestamp;
import java.sql.Blob;
import java.util.Date;
import java.math.BigDecimal;

import java.util.Arrays;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pt.digitalis.utils.common.collections.CaseInsensitiveHashMap;

import org.hibernate.Session;


/**
 *  Field definitions for data object {@link Conversation}
 *
 * NOTE: This file is auto generated and will be overwritten in a future file generation.
 */
public class ConversationFieldAttributes extends AbstractBeanAttributesDefinition{

    /** businessProcessInstanceId (Database column: BUSINESS_PROCESS_INSTANCE_ID) */
    static public AttributeDefinition businessProcessInstanceId =
        new AttributeDefinition("businessProcessInstanceId")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("CONVERSATION")
                .setDatabaseId("BUSINESS_PROCESS_INSTANCE_ID")
                .setMandatory(false)
                .setMaxSize(100)
                .setType(String.class);

    /** businessProcessTypeId (Database column: BUSINESS_PROCESS_TYPE_ID) */
    static public AttributeDefinition businessProcessTypeId =
        new AttributeDefinition("businessProcessTypeId")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("CONVERSATION")
                .setDatabaseId("BUSINESS_PROCESS_TYPE_ID")
                .setMandatory(false)
                .setMaxSize(300)
                .setType(String.class);

    /** closeDate (Database column: CLOSE_DATE) */
    static public AttributeDefinition closeDate =
        new AttributeDefinition("closeDate")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("CONVERSATION")
                .setDatabaseId("CLOSE_DATE")
                .setMandatory(false)
                .setMaxSize(7)
                .setType(Timestamp.class);

    /** creationDate (Database column: CREATION_DATE) */
    static public AttributeDefinition creationDate =
        new AttributeDefinition("creationDate")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("CONVERSATION")
                .setDatabaseId("CREATION_DATE")
                .setMandatory(true)
                .setMaxSize(7)
                .setType(Timestamp.class);

    /** description (Database column: DESCRIPTION) */
    static public AttributeDefinition description =
        new AttributeDefinition("description")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("CONVERSATION")
                .setDatabaseId("DESCRIPTION")
                .setMandatory(false)
                .setMaxSize(1000)
                .setType(String.class);

    /** id (Database column: ID) */
    static public AttributeDefinition id =
        new AttributeDefinition("id")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("CONVERSATION")
                .setDatabaseId("ID")
                .setMandatory(true)
                .setMaxSize(22)
                .setType(Long.class);

    /** isOpen (Database column: IS_OPEN) */
    static public AttributeDefinition isOpen =
        new AttributeDefinition("isOpen")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("CONVERSATION")
                .setDatabaseId("IS_OPEN")
                .setMandatory(true)
                .setMaxSize(1)
                .setTreatAsBoolean(true)
                .setBooleanFalseValue("0")
                .setBooleanTrueValue("1")
                .setDefaultValue("0")
                .setLovFixedList(Arrays.asList(new String[]{"1","0"}))
                .setType(boolean.class);

    /**
     * Gets description field.
     *
     * @return the description field
     */
    public static String getDescriptionField()
    {
        return "description";
    }

    /**
    * Create definitions map map.
    *
    * @return the map
    */
    @Override protected CaseInsensitiveHashMap<AttributeDefinition> createDefinitionsMap(){
        CaseInsensitiveHashMap<AttributeDefinition> map = new CaseInsensitiveHashMap<AttributeDefinition>();
        map.put(businessProcessInstanceId.getName(),businessProcessInstanceId);
        map.put(businessProcessTypeId.getName(),businessProcessTypeId);
        map.put(closeDate.getName(),closeDate);
        map.put(creationDate.getName(),creationDate);
        map.put(description.getName(),description);
        map.put(id.getName(),id);
        map.put(isOpen.getName(),isOpen);

        return map;
    }
}