package pt.digitalis.dif.dem.managers.impl.model.data;


import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.Session;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.hibernate.HibernateUtil;
import pt.digitalis.dif.model.utils.AbstractBeanRelationsAttributes;
import pt.digitalis.dif.model.utils.IBeanAttributesDataSet;

/**
 * ConversationMessage
* Generated on ORM Generator
* DIF build process for the Model layer
*
*/
@SuppressWarnings("serial")
public class ConversationMessage extends AbstractBeanRelationsAttributes implements java.io.Serializable, IBeanAttributesDataSet<ConversationMessage> {

    /**
    * Constant with the session factory ID
    */
    public static String SESSION_FACTORY_NAME = "DIFRepository";

    /** ConversationMessage attributes enumeration */
    public static class Fields
    {
        /** id column */
        public static final String ID ="id";
        /** creationDate column */
        public static final String CREATIONDATE ="creationDate";
        /** message column */
        public static final String MESSAGE ="message";
        /** details column */
        public static final String DETAILS ="details";
        /** isPrivate column */
        public static final String ISPRIVATE ="isPrivate";
        /** userId column */
        public static final String USERID ="userId";
        /** userDescription column */
        public static final String USERDESCRIPTION ="userDescription";
        /** userBusinessId column */
        public static final String USERBUSINESSID ="userBusinessId";
        /** documentId column */
        public static final String DOCUMENTID ="documentId";
        /** messageType column */
        public static final String MESSAGETYPE ="messageType";
        /** isSystemMessage column */
        public static final String ISSYSTEMMESSAGE ="isSystemMessage";

        /**
         * List of existing fields
         *
         * @return list of field names
         */
        public static List<String> values()
        {
            ArrayList<String> list = new ArrayList<String>();
            list.add("id");
            list.add("creationDate");
            list.add("message");
            list.add("details");
            list.add("isPrivate");
            list.add("userId");
            list.add("userDescription");
            list.add("userBusinessId");
            list.add("documentId");
            list.add("messageType");
            list.add("isSystemMessage");

            return list;
        }
    }

    /** Field attributes */
    public static ConversationMessageFieldAttributes FieldAttributes=new ConversationMessageFieldAttributes();

    /**
    * @return the field attributes definitions
    */
    @Override public ConversationMessageFieldAttributes getDefinitions()
    {
        return FieldAttributes;
    }

    /**
     * The Class Relations.
     */
    public class Relations extends AbstractBeanRelationsAttributes.AbstractRelations
    {

        /**
        * Instantiates a new relations.
        *
        * @param currentPath the current path
        */
        public Relations(String currentPath)
        {
            super(currentPath);
        }
        /**
         * conversation relation.
         *
         * @return the conversation bean relations attributes.
         */
        public Conversation.Relations conversation()
        {
            Conversation c = new Conversation();
            return c.new Relations(this.buildPath("conversation"));
        }

        /**
         * the ID path.
         *
         * @return the path
         */
        public String ID()
        {
            return buildPath(Fields.ID);
        }
        /**
         * the CREATIONDATE path.
         *
         * @return the path
         */
        public String CREATIONDATE()
        {
            return buildPath(Fields.CREATIONDATE);
        }
        /**
         * the MESSAGE path.
         *
         * @return the path
         */
        public String MESSAGE()
        {
            return buildPath(Fields.MESSAGE);
        }
        /**
         * the DETAILS path.
         *
         * @return the path
         */
        public String DETAILS()
        {
            return buildPath(Fields.DETAILS);
        }
        /**
         * the ISPRIVATE path.
         *
         * @return the path
         */
        public String ISPRIVATE()
        {
            return buildPath(Fields.ISPRIVATE);
        }
        /**
         * the USERID path.
         *
         * @return the path
         */
        public String USERID()
        {
            return buildPath(Fields.USERID);
        }
        /**
         * the USERDESCRIPTION path.
         *
         * @return the path
         */
        public String USERDESCRIPTION()
        {
            return buildPath(Fields.USERDESCRIPTION);
        }
        /**
         * the USERBUSINESSID path.
         *
         * @return the path
         */
        public String USERBUSINESSID()
        {
            return buildPath(Fields.USERBUSINESSID);
        }
        /**
         * the DOCUMENTID path.
         *
         * @return the path
         */
        public String DOCUMENTID()
        {
            return buildPath(Fields.DOCUMENTID);
        }
        /**
         * the MESSAGETYPE path.
         *
         * @return the path
         */
        public String MESSAGETYPE()
        {
            return buildPath(Fields.MESSAGETYPE);
        }
        /**
         * the ISSYSTEMMESSAGE path.
         *
         * @return the path
         */
        public String ISSYSTEMMESSAGE()
        {
            return buildPath(Fields.ISSYSTEMMESSAGE);
        }
    }

    /** The dummy obj. */
    private static ConversationMessage dummyObj=new ConversationMessage();

    /**
     * Get ConversationMessage Relations .
     *
     * @return the relations
     */
    public static Relations FK()
    {
        return dummyObj.new Relations(null);
    }

    /**
    * Gets a new dataSet object for this bean
    *
    * @return the dataSet
    */
    public IDataSet<ConversationMessage> getDataSet()
    {
        return getDataSetInstance();
    }

    /**
    * Gets a new dataSet object for this bean
    *
    * @return the dataSet
    */
    public static IDataSet<ConversationMessage> getDataSetInstance()
    {
        return new HibernateDataSet<ConversationMessage>(ConversationMessage.class, HibernateUtil.getSessionFactory(SESSION_FACTORY_NAME),
            ConversationMessage.getPKFieldListAsString(), ConversationMessage.FieldAttributes);
    }

    /**
    * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeNoGraphNavigation(java.lang.String)
    */
    @Override protected Object getAttributeNoGraphNavigation(String attributeName)
    {
        if("id".equalsIgnoreCase(attributeName))
            return id;
        if("conversation".equalsIgnoreCase(attributeName))
            return conversation;
        if("creationDate".equalsIgnoreCase(attributeName))
            return creationDate;
        if("message".equalsIgnoreCase(attributeName))
            return message;
        if("details".equalsIgnoreCase(attributeName))
            return details;
        if("isPrivate".equalsIgnoreCase(attributeName))
            return isPrivate;
        if("userId".equalsIgnoreCase(attributeName))
            return userId;
        if("userDescription".equalsIgnoreCase(attributeName))
            return userDescription;
        if("userBusinessId".equalsIgnoreCase(attributeName))
            return userBusinessId;
        if("documentId".equalsIgnoreCase(attributeName))
            return documentId;
        if("messageType".equalsIgnoreCase(attributeName))
            return messageType;
        if("isSystemMessage".equalsIgnoreCase(attributeName))
            return isSystemMessage;

        return null;
    }

    /**
    * @see pt.digitalis.utils.common.IBeanAttributes#setAttribute(java.lang.String, java.lang.Object)
    */
    public void setAttribute(String attributeName,Object attributeValue)
    {
        if("id".equalsIgnoreCase(attributeName))
            id =(Long)attributeValue;
        if("conversation".equalsIgnoreCase(attributeName))
            conversation =(Conversation)attributeValue;
        if("creationDate".equalsIgnoreCase(attributeName))
            creationDate =(Timestamp)attributeValue;
        if("message".equalsIgnoreCase(attributeName))
            message =(String)attributeValue;
        if("details".equalsIgnoreCase(attributeName))
            details =(String)attributeValue;
        if("isPrivate".equalsIgnoreCase(attributeName))
            isPrivate =(Boolean)attributeValue;
        if("userId".equalsIgnoreCase(attributeName))
            userId =(String)attributeValue;
        if("userDescription".equalsIgnoreCase(attributeName))
            userDescription =(String)attributeValue;
        if("userBusinessId".equalsIgnoreCase(attributeName))
            userBusinessId =(String)attributeValue;
        if("documentId".equalsIgnoreCase(attributeName))
            documentId =(Long)attributeValue;
        if("messageType".equalsIgnoreCase(attributeName))
            messageType =(Character)attributeValue;
        if("isSystemMessage".equalsIgnoreCase(attributeName))
            isSystemMessage =(Boolean)attributeValue;
    }

    // Fields

    /** id private attribute */
    private Long id;

    /** conversation private attribute */
    private Conversation conversation;

    /** creationDate private attribute */
    private Timestamp creationDate;

    /** message private attribute */
    private String message;

    /** details private attribute */
    private String details;

    /** isPrivate private attribute */
    private boolean isPrivate;

    /** userId private attribute */
    private String userId;

    /** userDescription private attribute */
    private String userDescription;

    /** userBusinessId private attribute */
    private String userBusinessId;

    /** documentId private attribute */
    private Long documentId;

    /** messageType private attribute */
    private Character messageType;

    /** isSystemMessage private attribute */
    private boolean isSystemMessage;

    /** The pojo's primary key field list names */
    private static List<String> pkFieldList;

    /**
     * Get the table fields that compose the PK
     *
     * @return the PK field list
     */
     public synchronized static List<String> getPKFieldList()
     {
         if (pkFieldList == null)
         {
             pkFieldList = new ArrayList<String>();
             pkFieldList.add("id");
         }

         return pkFieldList;
     }

    /**
     * Get the table fields that compose the PK as a comma separated field name list
     *
     * @return the PK field list as a string
     */
     public static String getPKFieldListAsString()
     {
         StringBuffer buffer = new StringBuffer();

         for (int i = 0; i < getPKFieldList().size(); i++)
         {
             if (i != 0)
                 buffer.append(",");

             buffer.append(getPKFieldList().get(i));
         }

         return buffer.toString();
     }

    /**
     * Gets description field.
     *
     * @return the description field
     */
    @Override
    public String getDescriptionField()
    {
        return FieldAttributes.getDescriptionField();
    }

    /**
     * Get the table fields that compose the PK
     *
     * @return the PK field list
     */
    @Override
    public List<String> getPKFields()
    {
        return getPKFieldList();
    }

    /**
     * Is composite PK.
     *
     * @return the boolean
     */
    @Override
    public boolean isCompositePK()
    {
        return this.getPKFieldList().size() > 1;
    }

    /**
     * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeAsString(java.lang.String)
     */
     @Override
     public String getAttributeAsString(String attributeName)
     {
        if (attributeName.contains("."))
        {
            return this.getAttributeAsStringParseBeanPath(attributeName);
        }
        else
        {
            Object value = getAttribute(attributeName);

            if (value == null)
                return "";
            else {
                return value.toString().trim();
            }
        }
     }

    // Constructors

    /**
     * default constructor
     */
    public ConversationMessage() {
    }

	/** 
	 * minimal constructor
	 *
     * @param conversation the conversation
     * @param message the message
     * @param isPrivate the isPrivate
     * @param isSystemMessage the isSystemMessage
    }
	 */
    public ConversationMessage(Conversation conversation, String message, boolean isPrivate, boolean isSystemMessage) {
        this.conversation = conversation;
        this.message = message;
        this.isPrivate = isPrivate;
        this.isSystemMessage = isSystemMessage;
    }

    /**
     * full constructor
	 *
     * @param conversation the conversation
     * @param creationDate the creationDate
     * @param message the message
     * @param details the details
     * @param isPrivate the isPrivate
     * @param userId the userId
     * @param userDescription the userDescription
     * @param userBusinessId the userBusinessId
     * @param documentId the documentId
     * @param messageType the messageType
     * @param isSystemMessage the isSystemMessage
     */
    public ConversationMessage(Conversation conversation, Timestamp creationDate, String message, String details, boolean isPrivate, String userId, String userDescription, String userBusinessId, Long documentId, Character messageType, boolean isSystemMessage) {
        this.conversation = conversation;
        this.creationDate = creationDate;
        this.message = message;
        this.details = details;
        this.isPrivate = isPrivate;
        this.userId = userId;
        this.userDescription = userDescription;
        this.userBusinessId = userBusinessId;
        this.documentId = documentId;
        this.messageType = messageType;
        this.isSystemMessage = isSystemMessage;
    }

    // Property accessors
    
    /**       
     * id getter method
     *
     * @return id method
     */
    public Long getId() {
        return this.id;
    }
    
    /**       
     * id setter method
     *
     * @param id the id
     *
     * @return ConversationMessage modified instance
     */
    public ConversationMessage setId(Long id) {
        this.id = id;
        
        return this;
    }
    /**       
     * conversation getter method
     *
     * @return conversation method
     */
    public Conversation getConversation() {
        return this.conversation;
    }
    
    /**       
     * conversation setter method
     *
     * @param conversation the conversation
     *
     * @return ConversationMessage modified instance
     */
    public ConversationMessage setConversation(Conversation conversation) {
        this.conversation = conversation;
        
        return this;
    }
    /**       
     * creationDate getter method
     *
     * @return creationDate method
     */
    public Timestamp getCreationDate() {
        return this.creationDate;
    }
    
    /**       
     * creationDate setter method
     *
     * @param creationDate the creationDate
     *
     * @return ConversationMessage modified instance
     */
    public ConversationMessage setCreationDate(Timestamp creationDate) {
        this.creationDate = creationDate;
        
        return this;
    }
    /**       
     * message getter method
     *
     * @return message method
     */
    public String getMessage() {
        return this.message;
    }
    
    /**       
     * message setter method
     *
     * @param message the message
     *
     * @return ConversationMessage modified instance
     */
    public ConversationMessage setMessage(String message) {
        this.message = message;
        
        return this;
    }
    /**       
     * details getter method
     *
     * @return details method
     */
    public String getDetails() {
        return this.details;
    }
    
    /**       
     * details setter method
     *
     * @param details the details
     *
     * @return ConversationMessage modified instance
     */
    public ConversationMessage setDetails(String details) {
        this.details = details;
        
        return this;
    }
    /**       
     * isPrivate getter method
     *
     * @return isPrivate method
     */
    public boolean isIsPrivate() {
        return this.isPrivate;
    }
    
    /**       
     * isPrivate setter method
     *
     * @param isPrivate the isPrivate
     *
     * @return ConversationMessage modified instance
     */
    public ConversationMessage setIsPrivate(boolean isPrivate) {
        this.isPrivate = isPrivate;
        
        return this;
    }
    /**       
     * userId getter method
     *
     * @return userId method
     */
    public String getUserId() {
        return this.userId;
    }
    
    /**       
     * userId setter method
     *
     * @param userId the userId
     *
     * @return ConversationMessage modified instance
     */
    public ConversationMessage setUserId(String userId) {
        this.userId = userId;
        
        return this;
    }
    /**       
     * userDescription getter method
     *
     * @return userDescription method
     */
    public String getUserDescription() {
        return this.userDescription;
    }
    
    /**       
     * userDescription setter method
     *
     * @param userDescription the userDescription
     *
     * @return ConversationMessage modified instance
     */
    public ConversationMessage setUserDescription(String userDescription) {
        this.userDescription = userDescription;
        
        return this;
    }
    /**       
     * userBusinessId getter method
     *
     * @return userBusinessId method
     */
    public String getUserBusinessId() {
        return this.userBusinessId;
    }
    
    /**       
     * userBusinessId setter method
     *
     * @param userBusinessId the userBusinessId
     *
     * @return ConversationMessage modified instance
     */
    public ConversationMessage setUserBusinessId(String userBusinessId) {
        this.userBusinessId = userBusinessId;
        
        return this;
    }
    /**       
     * documentId getter method
     *
     * @return documentId method
     */
    public Long getDocumentId() {
        return this.documentId;
    }
    
    /**       
     * documentId setter method
     *
     * @param documentId the documentId
     *
     * @return ConversationMessage modified instance
     */
    public ConversationMessage setDocumentId(Long documentId) {
        this.documentId = documentId;
        
        return this;
    }
    /**       
     * messageType getter method
     *
     * @return messageType method
     */
    public Character getMessageType() {
        return this.messageType;
    }
    
    /**       
     * messageType setter method
     *
     * @param messageType the messageType
     *
     * @return ConversationMessage modified instance
     */
    public ConversationMessage setMessageType(Character messageType) {
        this.messageType = messageType;
        
        return this;
    }
    /**       
     * isSystemMessage getter method
     *
     * @return isSystemMessage method
     */
    public boolean isIsSystemMessage() {
        return this.isSystemMessage;
    }
    
    /**       
     * isSystemMessage setter method
     *
     * @param isSystemMessage the isSystemMessage
     *
     * @return ConversationMessage modified instance
     */
    public ConversationMessage setIsSystemMessage(boolean isSystemMessage) {
        this.isSystemMessage = isSystemMessage;
        
        return this;
    }

    /**
     * conversation id getter method
     *
     * @return conversation id method
     */
    public Long getConversationId() {
        if (this.conversation == null)
            return null;
        else
            return this.conversation.getId();
    }

    /**
     * Conversation proxy setter method from id.
     *
     * @return ConversationMessage modified instance
     */
    public ConversationMessage setConversationProxyFromId(Long id)
    {
        if (id == null || id.equals(-1L))
            this.conversation = null;
        else
            this.conversation = Conversation.getProxy(id);

        return this;
    }

    /**
     * Conversation instance setter method from id.
     *
     * @return ConversationMessage modified instance
     */
    public ConversationMessage setConversationInstanceFromId(Long id)
    {
        if (id == null || id.equals(-1L))
            this.conversation = null;
        else
            this.conversation = Conversation.getInstance(id);

        return this;
    }

    /**
     * Creates a String representation of the ConversationMessage object
     *
     * @return the compiled String
     */
    @Override
    public String toString() {
	    StringBuffer buffer = new StringBuffer();

        buffer.append(getClass().getName()).append("@").append(Integer.toHexString(hashCode())).append(" [");

        buffer.append("id").append("='").append(getId()).append("' ");			
        buffer.append("creationDate").append("='").append(getCreationDate()).append("' ");			
        buffer.append("message").append("='").append(getMessage()).append("' ");			
        buffer.append("details").append("='").append(getDetails()).append("' ");			
        buffer.append("isPrivate").append("='").append(isIsPrivate()).append("' ");			
        buffer.append("userId").append("='").append(getUserId()).append("' ");			
        buffer.append("userDescription").append("='").append(getUserDescription()).append("' ");			
        buffer.append("userBusinessId").append("='").append(getUserBusinessId()).append("' ");			
        buffer.append("documentId").append("='").append(getDocumentId()).append("' ");			
        buffer.append("messageType").append("='").append(getMessageType()).append("' ");			
        buffer.append("isSystemMessage").append("='").append(isIsSystemMessage()).append("' ");			
        buffer.append("]");
      
        return buffer.toString();
    }

    /**
     * Compares the String representation of the ConversationMessage object
     *
     * @param other The object to compare to
     *
     * @return true of the objects are equal
     */
    public boolean equals(ConversationMessage other) {
        	return this.toString().equals(other.toString());
    }
    /**
     * @see pt.digitalis.utils.common.IBeanAttributes#setAttributeFromString(java.lang.String, java.lang.String)
     */
    public void setAttributeFromString(String attributeName, String attributeValue) {
        if ("id".equalsIgnoreCase(attributeName))
            this.id = Long.valueOf(attributeValue);

        if ("creationDate".equalsIgnoreCase(attributeName))
            this.creationDate = Timestamp.valueOf(attributeValue);

        if ("message".equalsIgnoreCase(attributeName))
        	this.message = attributeValue;

        if ("details".equalsIgnoreCase(attributeName))
        	this.details = attributeValue;

        if ("isPrivate".equalsIgnoreCase(attributeName))
            this.isPrivate = Boolean.valueOf(attributeValue);

        if ("userId".equalsIgnoreCase(attributeName))
        	this.userId = attributeValue;

        if ("userDescription".equalsIgnoreCase(attributeName))
        	this.userDescription = attributeValue;

        if ("userBusinessId".equalsIgnoreCase(attributeName))
        	this.userBusinessId = attributeValue;

        if ("documentId".equalsIgnoreCase(attributeName))
            this.documentId = Long.valueOf(attributeValue);

        if ("messageType".equalsIgnoreCase(attributeName))
            if (attributeValue != null && attributeValue.length() > 0)
                this.messageType = attributeValue.charAt(0);

        if ("isSystemMessage".equalsIgnoreCase(attributeName))
            this.isSystemMessage = Boolean.valueOf(attributeValue);

    }


    /**
     * Instanciates an Hibernate proxy data object (does not load it from the database, provides lazy load for that)
     *
     * @param session the session
     * @param id      the id
     *
     * @return the proxy
     */
    public static ConversationMessage getProxy(Session session, Long id)
    {
        return(ConversationMessage)session.load(ConversationMessage.class,id);
    }

    /**
    * Instanciates an Hibernate proxy data object (does not load it from the database, provides lazy load for that)
    *
    * @param id      the id
    *
    * @return the proxy
    */
    public static ConversationMessage getProxy(Long id)
    {
        Session session = HibernateUtil.getSessionFactory(SESSION_FACTORY_NAME).getCurrentSession();
        boolean wasActive = session.getTransaction().isActive();

        if (!wasActive)
            session.beginTransaction();

        ConversationMessage result = (ConversationMessage)session.load(ConversationMessage.class,id);

        if (!wasActive)
            session.getTransaction().commit();

        return result;
    }


    /**
     * Instanciates an Hibernate data object
     *
     * @param session the session
     * @param id      the id
     *
     * @return the instance
     */
    public static ConversationMessage getInstanceForSession(Session session, Long id)
    {
        return(ConversationMessage)session.get(ConversationMessage.class,id);
    }

    /**
    * Instanciates an Hibernate data object
    *
    * @param id      the id
    *
    * @return the instance
    */
    public static ConversationMessage getInstance(Long id)
    {
        Session session = HibernateUtil.getSessionFactory(SESSION_FACTORY_NAME).getCurrentSession();
        boolean wasActive = session.getTransaction().isActive();

        if (!wasActive)
            session.beginTransaction();

        ConversationMessage result = (ConversationMessage)session.get(ConversationMessage.class,id);

        if (!wasActive)
            session.getTransaction().commit();

        return result;
    }

}
