package pt.digitalis.dif.dem.managers.impl.model.data;

import pt.digitalis.utils.common.AttributeDefinition;
import pt.digitalis.dif.model.utils.AbstractBeanAttributesDefinition;

import java.sql.Timestamp;
import java.sql.Blob;
import java.util.Date;
import java.math.BigDecimal;

import java.util.Arrays;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pt.digitalis.utils.common.collections.CaseInsensitiveHashMap;

import org.hibernate.Session;


/**
 *  Field definitions for data object {@link ConversationMessage}
 *
 * NOTE: This file is auto generated and will be overwritten in a future file generation.
 */
public class ConversationMessageFieldAttributes extends AbstractBeanAttributesDefinition{

    /** conversation (Database column: CONVERSATION_ID) */
    static public AttributeDefinition conversation =
        new AttributeDefinition("conversation")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("CONVERSATION_MESSAGE")
                .setDatabaseId("CONVERSATION_ID")
                .setMandatory(true)
                .setMaxSize(22)
                .setLovDataClass(pt.digitalis.dif.dem.managers.impl.model.data.Conversation.class)
                .setLovDataClassKey("id")
                .setLovDataClassDescription("description")
                .setType(pt.digitalis.dif.dem.managers.impl.model.data.Conversation.class);

    /** creationDate (Database column: CREATION_DATE) */
    static public AttributeDefinition creationDate =
        new AttributeDefinition("creationDate")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("CONVERSATION_MESSAGE")
                .setDatabaseId("CREATION_DATE")
                .setMandatory(false)
                .setMaxSize(7)
                .setType(Timestamp.class);

    /** details (Database column: DETAILS) */
    static public AttributeDefinition details =
        new AttributeDefinition("details")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("CONVERSATION_MESSAGE")
                .setDatabaseId("DETAILS")
                .setMandatory(false)
                .setMaxSize(4000)
                .setType(String.class);

    /** documentId (Database column: DOCUMENT_ID) */
    static public AttributeDefinition documentId =
        new AttributeDefinition("documentId")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("CONVERSATION_MESSAGE")
                .setDatabaseId("DOCUMENT_ID")
                .setMandatory(false)
                .setMaxSize(22)
                .setType(Long.class);

    /** id (Database column: ID) */
    static public AttributeDefinition id =
        new AttributeDefinition("id")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("CONVERSATION_MESSAGE")
                .setDatabaseId("ID")
                .setMandatory(true)
                .setMaxSize(22)
                .setType(Long.class);

    /** isPrivate (Database column: IS_PRIVATE) */
    static public AttributeDefinition isPrivate =
        new AttributeDefinition("isPrivate")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("CONVERSATION_MESSAGE")
                .setDatabaseId("IS_PRIVATE")
                .setMandatory(true)
                .setMaxSize(1)
                .setTreatAsBoolean(true)
                .setBooleanFalseValue("0")
                .setBooleanTrueValue("1")
                .setDefaultValue("0")
                .setLovFixedList(Arrays.asList(new String[]{"1","0"}))
                .setType(boolean.class);

    /** isSystemMessage (Database column: IS_SYSTEM_MESSAGE) */
    static public AttributeDefinition isSystemMessage =
        new AttributeDefinition("isSystemMessage")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("CONVERSATION_MESSAGE")
                .setDatabaseId("IS_SYSTEM_MESSAGE")
                .setMandatory(true)
                .setMaxSize(1)
                .setTreatAsBoolean(true)
                .setBooleanFalseValue("0")
                .setBooleanTrueValue("1")
                .setDefaultValue("0")
                .setLovFixedList(Arrays.asList(new String[]{"1","0"}))
                .setType(boolean.class);

    /** message (Database column: MESSAGE) */
    static public AttributeDefinition message =
        new AttributeDefinition("message")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("CONVERSATION_MESSAGE")
                .setDatabaseId("MESSAGE")
                .setMandatory(true)
                .setMaxSize(500)
                .setType(String.class);

    /** messageType (Database column: MESSAGE_TYPE) */
    static public AttributeDefinition messageType =
        new AttributeDefinition("messageType")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("CONVERSATION_MESSAGE")
                .setDatabaseId("MESSAGE_TYPE")
                .setMandatory(false)
                .setMaxSize(1)
                .setType(Character.class);

    /** userBusinessId (Database column: USER_BUSINESS_ID) */
    static public AttributeDefinition userBusinessId =
        new AttributeDefinition("userBusinessId")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("CONVERSATION_MESSAGE")
                .setDatabaseId("USER_BUSINESS_ID")
                .setMandatory(false)
                .setMaxSize(300)
                .setType(String.class);

    /** userDescription (Database column: USER_DESCRIPTION) */
    static public AttributeDefinition userDescription =
        new AttributeDefinition("userDescription")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("CONVERSATION_MESSAGE")
                .setDatabaseId("USER_DESCRIPTION")
                .setMandatory(false)
                .setMaxSize(500)
                .setType(String.class);

    /** userId (Database column: USER_ID) */
    static public AttributeDefinition userId =
        new AttributeDefinition("userId")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("CONVERSATION_MESSAGE")
                .setDatabaseId("USER_ID")
                .setMandatory(false)
                .setMaxSize(300)
                .setType(String.class);

    /**
     * Gets description field.
     *
     * @return the description field
     */
    public static String getDescriptionField()
    {
        return null;
    }

    /**
    * Create definitions map map.
    *
    * @return the map
    */
    @Override protected CaseInsensitiveHashMap<AttributeDefinition> createDefinitionsMap(){
        CaseInsensitiveHashMap<AttributeDefinition> map = new CaseInsensitiveHashMap<AttributeDefinition>();
        map.put(conversation.getName(),conversation);
        map.put(creationDate.getName(),creationDate);
        map.put(details.getName(),details);
        map.put(documentId.getName(),documentId);
        map.put(id.getName(),id);
        map.put(isPrivate.getName(),isPrivate);
        map.put(isSystemMessage.getName(),isSystemMessage);
        map.put(message.getName(),message);
        map.put(messageType.getName(),messageType);
        map.put(userBusinessId.getName(),userBusinessId);
        map.put(userDescription.getName(),userDescription);
        map.put(userId.getName(),userId);

        return map;
    }
}