package pt.digitalis.dif.dem.managers.impl.model.data;

import pt.digitalis.utils.common.AttributeDefinition;
import pt.digitalis.dif.model.utils.AbstractBeanAttributesDefinition;

import java.sql.Timestamp;
import java.sql.Blob;
import java.util.Date;
import java.math.BigDecimal;

import java.util.Arrays;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pt.digitalis.utils.common.collections.CaseInsensitiveHashMap;

import org.hibernate.Session;


/**
 *  Field definitions for data object {@link DashboardIndicator}
 *
 * NOTE: This file is auto generated and will be overwritten in a future file generation.
 */
public class DashboardIndicatorFieldAttributes extends AbstractBeanAttributesDefinition{

    /** dashboard (Database column: DASHBOARD_ID - The dashboard ID) */
    static public AttributeDefinition dashboard =
        new AttributeDefinition("dashboard")
                .setDescription("The dashboard ID")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("DASHBOARD_INDICATOR")
                .setDatabaseId("DASHBOARD_ID")
                .setMandatory(true)
                .setMaxSize(10)
                .setLovDataClass(pt.digitalis.dif.dem.managers.impl.model.data.Dashboard.class)
                .setLovDataClassKey("id")
                .setLovDataClassDescription("title")
                .setType(pt.digitalis.dif.dem.managers.impl.model.data.Dashboard.class);

    /** id (Database column: ID - ID column) */
    static public AttributeDefinition id =
        new AttributeDefinition("id")
                .setDescription("ID column")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("DASHBOARD_INDICATOR")
                .setDatabaseId("ID")
                .setMandatory(true)
                .setMaxSize(10)
                .setType(Long.class);

    /** indicator (Database column: INDICATOR_ID - The indicator ID) */
    static public AttributeDefinition indicator =
        new AttributeDefinition("indicator")
                .setDescription("The indicator ID")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("DASHBOARD_INDICATOR")
                .setDatabaseId("INDICATOR_ID")
                .setMandatory(true)
                .setMaxSize(10)
                .setLovDataClass(pt.digitalis.dif.dem.managers.impl.model.data.Indicator.class)
                .setLovDataClassKey("id")
                .setLovDataClassDescription("description")
                .setType(pt.digitalis.dif.dem.managers.impl.model.data.Indicator.class);

    /**
     * Gets description field.
     *
     * @return the description field
     */
    public static String getDescriptionField()
    {
        return null;
    }

    /**
    * Create definitions map map.
    *
    * @return the map
    */
    @Override protected CaseInsensitiveHashMap<AttributeDefinition> createDefinitionsMap(){
        CaseInsensitiveHashMap<AttributeDefinition> map = new CaseInsensitiveHashMap<AttributeDefinition>();
        map.put(dashboard.getName(),dashboard);
        map.put(id.getName(),id);
        map.put(indicator.getName(),indicator);

        return map;
    }
}