package pt.digitalis.dif.dem.managers.impl.model.data;

import pt.digitalis.utils.common.AttributeDefinition;
import pt.digitalis.dif.model.utils.AbstractBeanAttributesDefinition;

import java.sql.Timestamp;
import java.sql.Blob;
import java.util.Date;
import java.math.BigDecimal;

import java.util.Arrays;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pt.digitalis.utils.common.collections.CaseInsensitiveHashMap;

import org.hibernate.Session;


/**
 *  Field definitions for data object {@link DataConsent}
 *
 * NOTE: This file is auto generated and will be overwritten in a future file generation.
 */
public class DataConsentFieldAttributes extends AbstractBeanAttributesDefinition{

    /** businessId (Database column: BUSINESS_ID - Business UID that identifies this consent within the configuration) */
    static public AttributeDefinition businessId =
        new AttributeDefinition("businessId")
                .setDescription("Business UID that identifies this consent within the configuration")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("DATA_CONSENT")
                .setDatabaseId("BUSINESS_ID")
                .setMandatory(false)
                .setMaxSize(255)
                .setType(String.class);

    /** configId (Database column: CONFIG_ID - Configuration ID (each application can have a diferent set of consents)) */
    static public AttributeDefinition configId =
        new AttributeDefinition("configId")
                .setDescription("Configuration ID (each application can have a diferent set of consents)")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("DATA_CONSENT")
                .setDatabaseId("CONFIG_ID")
                .setMandatory(true)
                .setMaxSize(255)
                .setType(String.class);

    /** description (Database column: DESCRIPTION - A full description) */
    static public AttributeDefinition description =
        new AttributeDefinition("description")
                .setDescription("A full description")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("DATA_CONSENT")
                .setDatabaseId("DESCRIPTION")
                .setMandatory(false)
                .setMaxSize(4000)
                .setType(String.class);

    /** id (Database column: ID - ID) */
    static public AttributeDefinition id =
        new AttributeDefinition("id")
                .setDescription("ID")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("DATA_CONSENT")
                .setDatabaseId("ID")
                .setMandatory(true)
                .setMaxSize(10)
                .setType(Long.class);

    /** isAnsweredWhenDisabled (Database column: IS_ANSWERED_WHEN_DISABLED - Is considered anwsered when the consent is disabled.) */
    static public AttributeDefinition isAnsweredWhenDisabled =
        new AttributeDefinition("isAnsweredWhenDisabled")
                .setDescription("Is considered anwsered when the consent is disabled.")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("DATA_CONSENT")
                .setDatabaseId("IS_ANSWERED_WHEN_DISABLED")
                .setMandatory(true)
                .setMaxSize(1)
                .setTreatAsBoolean(true)
                .setBooleanFalseValue("0")
                .setBooleanTrueValue("1")
                .setDefaultValue("0")
                .setLovFixedList(Arrays.asList(new String[]{"1","0"}))
                .setType(boolean.class);

    /** isEnabled (Database column: IS_ENABLED - Is enabled) */
    static public AttributeDefinition isEnabled =
        new AttributeDefinition("isEnabled")
                .setDescription("Is enabled")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("DATA_CONSENT")
                .setDatabaseId("IS_ENABLED")
                .setMandatory(true)
                .setMaxSize(1)
                .setTreatAsBoolean(true)
                .setBooleanFalseValue("0")
                .setBooleanTrueValue("1")
                .setLovFixedList(Arrays.asList(new String[]{"1","0"}))
                .setType(boolean.class);

    /** isGlobal (Database column: IS_GLOBAL - Is global consent. Managed globally. If false will not be requested centrally.) */
    static public AttributeDefinition isGlobal =
        new AttributeDefinition("isGlobal")
                .setDescription("Is global consent. Managed globally. If false will not be requested centrally.")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("DATA_CONSENT")
                .setDatabaseId("IS_GLOBAL")
                .setMandatory(true)
                .setMaxSize(1)
                .setTreatAsBoolean(true)
                .setBooleanFalseValue("0")
                .setBooleanTrueValue("1")
                .setDefaultValue("1")
                .setLovFixedList(Arrays.asList(new String[]{"1","0"}))
                .setType(boolean.class);

    /** isMandatory (Database column: IS_MANDATORY - Is mandatory) */
    static public AttributeDefinition isMandatory =
        new AttributeDefinition("isMandatory")
                .setDescription("Is mandatory")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("DATA_CONSENT")
                .setDatabaseId("IS_MANDATORY")
                .setMandatory(true)
                .setMaxSize(1)
                .setTreatAsBoolean(true)
                .setBooleanFalseValue("0")
                .setBooleanTrueValue("1")
                .setLovFixedList(Arrays.asList(new String[]{"1","0"}))
                .setType(boolean.class);

    /** isMustConfirmBymail (Database column: IS_MUST_CONFIRM_BYMAIL - Must confirm acceptance by email) */
    static public AttributeDefinition isMustConfirmBymail =
        new AttributeDefinition("isMustConfirmBymail")
                .setDescription("Must confirm acceptance by email")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("DATA_CONSENT")
                .setDatabaseId("IS_MUST_CONFIRM_BYMAIL")
                .setMandatory(true)
                .setMaxSize(1)
                .setTreatAsBoolean(true)
                .setBooleanFalseValue("0")
                .setBooleanTrueValue("1")
                .setLovFixedList(Arrays.asList(new String[]{"1","0"}))
                .setType(boolean.class);

    /** isMustUploadProof (Database column: IS_MUST_UPLOAD_PROOF - Must confirm acceptance by signed document) */
    static public AttributeDefinition isMustUploadProof =
        new AttributeDefinition("isMustUploadProof")
                .setDescription("Must confirm acceptance by signed document")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("DATA_CONSENT")
                .setDatabaseId("IS_MUST_UPLOAD_PROOF")
                .setMandatory(true)
                .setMaxSize(1)
                .setTreatAsBoolean(true)
                .setBooleanFalseValue("0")
                .setBooleanTrueValue("1")
                .setLovFixedList(Arrays.asList(new String[]{"1","0"}))
                .setType(boolean.class);

    /** isProtected (Database column: IS_PROTECTED - Is protected) */
    static public AttributeDefinition isProtected =
        new AttributeDefinition("isProtected")
                .setDescription("Is protected")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("DATA_CONSENT")
                .setDatabaseId("IS_PROTECTED")
                .setMandatory(true)
                .setMaxSize(1)
                .setTreatAsBoolean(true)
                .setBooleanFalseValue("0")
                .setBooleanTrueValue("1")
                .setLovFixedList(Arrays.asList(new String[]{"1","0"}))
                .setType(boolean.class);

    /** profileId (Database column: PROFILE_ID - The destination profile for the consent) */
    static public AttributeDefinition profileId =
        new AttributeDefinition("profileId")
                .setDescription("The destination profile for the consent")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("DATA_CONSENT")
                .setDatabaseId("PROFILE_ID")
                .setMandatory(false)
                .setMaxSize(255)
                .setType(String.class);

    /** stageId (Database column: STAGE_ID - Stage ID for complex consent details) */
    static public AttributeDefinition stageId =
        new AttributeDefinition("stageId")
                .setDescription("Stage ID for complex consent details")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("DATA_CONSENT")
                .setDatabaseId("STAGE_ID")
                .setMandatory(false)
                .setMaxSize(500)
                .setType(String.class);

    /** templateDocumentId (Database column: TEMPLATE_DOCUMENT_ID - The proof template for the user to download and sign) */
    static public AttributeDefinition templateDocumentId =
        new AttributeDefinition("templateDocumentId")
                .setDescription("The proof template for the user to download and sign")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("DATA_CONSENT")
                .setDatabaseId("TEMPLATE_DOCUMENT_ID")
                .setMandatory(false)
                .setMaxSize(22)
                .setType(Long.class);

    /** title (Database column: TITLE - The title) */
    static public AttributeDefinition title =
        new AttributeDefinition("title")
                .setDescription("The title")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("DATA_CONSENT")
                .setDatabaseId("TITLE")
                .setMandatory(true)
                .setMaxSize(1000)
                .setType(String.class);

    /**
     * Gets description field.
     *
     * @return the description field
     */
    public static String getDescriptionField()
    {
        return "description";
    }

    /**
    * Create definitions map map.
    *
    * @return the map
    */
    @Override protected CaseInsensitiveHashMap<AttributeDefinition> createDefinitionsMap(){
        CaseInsensitiveHashMap<AttributeDefinition> map = new CaseInsensitiveHashMap<AttributeDefinition>();
        map.put(businessId.getName(),businessId);
        map.put(configId.getName(),configId);
        map.put(description.getName(),description);
        map.put(id.getName(),id);
        map.put(isAnsweredWhenDisabled.getName(),isAnsweredWhenDisabled);
        map.put(isEnabled.getName(),isEnabled);
        map.put(isGlobal.getName(),isGlobal);
        map.put(isMandatory.getName(),isMandatory);
        map.put(isMustConfirmBymail.getName(),isMustConfirmBymail);
        map.put(isMustUploadProof.getName(),isMustUploadProof);
        map.put(isProtected.getName(),isProtected);
        map.put(profileId.getName(),profileId);
        map.put(stageId.getName(),stageId);
        map.put(templateDocumentId.getName(),templateDocumentId);
        map.put(title.getName(),title);

        return map;
    }
}