package pt.digitalis.dif.dem.managers.impl.model.data;


import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hibernate.Session;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.hibernate.HibernateUtil;
import pt.digitalis.dif.model.utils.AbstractBeanRelationsAttributes;
import pt.digitalis.dif.model.utils.IBeanAttributesDataSet;

/**
 * DataConsentUser
* Generated on ORM Generator
* DIF build process for the Model layer
*
*/
@SuppressWarnings("serial")
public class DataConsentUser extends AbstractBeanRelationsAttributes implements java.io.Serializable, IBeanAttributesDataSet<DataConsentUser> {

    /**
    * Constant with the session factory ID
    */
    public static String SESSION_FACTORY_NAME = "DIFRepository";

    /** DataConsentUser attributes enumeration */
    public static class Fields
    {
        /** id column */
        public static final String ID ="id";
        /** configId column */
        public static final String CONFIGID ="configId";
        /** userId column */
        public static final String USERID ="userId";
        /** businessId column */
        public static final String BUSINESSID ="businessId";

        /**
         * List of existing fields
         *
         * @return list of field names
         */
        public static List<String> values()
        {
            ArrayList<String> list = new ArrayList<String>();
            list.add("id");
            list.add("configId");
            list.add("userId");
            list.add("businessId");

            return list;
        }
    }

    /** Field attributes */
    public static DataConsentUserFieldAttributes FieldAttributes=new DataConsentUserFieldAttributes();

    /**
    * @return the field attributes definitions
    */
    @Override public DataConsentUserFieldAttributes getDefinitions()
    {
        return FieldAttributes;
    }

    /**
     * The Class Relations.
     */
    public class Relations extends AbstractBeanRelationsAttributes.AbstractRelations
    {

        /**
        * Instantiates a new relations.
        *
        * @param currentPath the current path
        */
        public Relations(String currentPath)
        {
            super(currentPath);
        }
        /**
         * userDataConsents relation.
         *
         * @return the userDataConsents bean relations attributes.
         */
        public UserDataConsent.Relations userDataConsents()
        {
            UserDataConsent c = new UserDataConsent();
            return c.new Relations(this.buildPath("userDataConsents"));
        }

        /**
         * dataConsentReviews relation.
         *
         * @return the dataConsentReviews bean relations attributes.
         */
        public DataConsentReview.Relations dataConsentReviews()
        {
            DataConsentReview c = new DataConsentReview();
            return c.new Relations(this.buildPath("dataConsentReviews"));
        }

        /**
         * userDataRequests relation.
         *
         * @return the userDataRequests bean relations attributes.
         */
        public UserDataRequest.Relations userDataRequests()
        {
            UserDataRequest c = new UserDataRequest();
            return c.new Relations(this.buildPath("userDataRequests"));
        }

        /**
         * the ID path.
         *
         * @return the path
         */
        public String ID()
        {
            return buildPath(Fields.ID);
        }
        /**
         * the CONFIGID path.
         *
         * @return the path
         */
        public String CONFIGID()
        {
            return buildPath(Fields.CONFIGID);
        }
        /**
         * the USERID path.
         *
         * @return the path
         */
        public String USERID()
        {
            return buildPath(Fields.USERID);
        }
        /**
         * the BUSINESSID path.
         *
         * @return the path
         */
        public String BUSINESSID()
        {
            return buildPath(Fields.BUSINESSID);
        }
    }

    /** The dummy obj. */
    private static DataConsentUser dummyObj=new DataConsentUser();

    /**
     * Get DataConsentUser Relations .
     *
     * @return the relations
     */
    public static Relations FK()
    {
        return dummyObj.new Relations(null);
    }

    /**
    * Gets a new dataSet object for this bean
    *
    * @return the dataSet
    */
    public IDataSet<DataConsentUser> getDataSet()
    {
        return getDataSetInstance();
    }

    /**
    * Gets a new dataSet object for this bean
    *
    * @return the dataSet
    */
    public static IDataSet<DataConsentUser> getDataSetInstance()
    {
        return new HibernateDataSet<DataConsentUser>(DataConsentUser.class, HibernateUtil.getSessionFactory(SESSION_FACTORY_NAME),
            DataConsentUser.getPKFieldListAsString(), DataConsentUser.FieldAttributes);
    }

    /**
    * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeNoGraphNavigation(java.lang.String)
    */
    @Override protected Object getAttributeNoGraphNavigation(String attributeName)
    {
        if("id".equalsIgnoreCase(attributeName))
            return id;
        if("configId".equalsIgnoreCase(attributeName))
            return configId;
        if("userId".equalsIgnoreCase(attributeName))
            return userId;
        if("businessId".equalsIgnoreCase(attributeName))
            return businessId;
        if("userDataConsents".equalsIgnoreCase(attributeName))
            return userDataConsents;
        if("dataConsentReviews".equalsIgnoreCase(attributeName))
            return dataConsentReviews;
        if("userDataRequests".equalsIgnoreCase(attributeName))
            return userDataRequests;

        return null;
    }

    /**
    * @see pt.digitalis.utils.common.IBeanAttributes#setAttribute(java.lang.String, java.lang.Object)
    */
    public void setAttribute(String attributeName,Object attributeValue)
    {
        if("id".equalsIgnoreCase(attributeName))
            id =(Long)attributeValue;
        if("configId".equalsIgnoreCase(attributeName))
            configId =(String)attributeValue;
        if("userId".equalsIgnoreCase(attributeName))
            userId =(String)attributeValue;
        if("businessId".equalsIgnoreCase(attributeName))
            businessId =(String)attributeValue;
        if("userDataConsents".equalsIgnoreCase(attributeName))
            userDataConsents =(Set<UserDataConsent>)attributeValue;
        if("dataConsentReviews".equalsIgnoreCase(attributeName))
            dataConsentReviews =(Set<DataConsentReview>)attributeValue;
        if("userDataRequests".equalsIgnoreCase(attributeName))
            userDataRequests =(Set<UserDataRequest>)attributeValue;
    }

    // Fields

    /** id private attribute */
    private Long id;

    /** configId private attribute */
    private String configId;

    /** userId private attribute */
    private String userId;

    /** businessId private attribute */
    private String businessId;

    /** userDataConsents private attribute */
    private Set<UserDataConsent> userDataConsents = new HashSet<UserDataConsent>(0);

    /** dataConsentReviews private attribute */
    private Set<DataConsentReview> dataConsentReviews = new HashSet<DataConsentReview>(0);

    /** userDataRequests private attribute */
    private Set<UserDataRequest> userDataRequests = new HashSet<UserDataRequest>(0);

    /** The pojo's primary key field list names */
    private static List<String> pkFieldList;

    /**
     * Get the table fields that compose the PK
     *
     * @return the PK field list
     */
     public synchronized static List<String> getPKFieldList()
     {
         if (pkFieldList == null)
         {
             pkFieldList = new ArrayList<String>();
             pkFieldList.add("id");
         }

         return pkFieldList;
     }

    /**
     * Get the table fields that compose the PK as a comma separated field name list
     *
     * @return the PK field list as a string
     */
     public static String getPKFieldListAsString()
     {
         StringBuffer buffer = new StringBuffer();

         for (int i = 0; i < getPKFieldList().size(); i++)
         {
             if (i != 0)
                 buffer.append(",");

             buffer.append(getPKFieldList().get(i));
         }

         return buffer.toString();
     }

    /**
     * Gets description field.
     *
     * @return the description field
     */
    @Override
    public String getDescriptionField()
    {
        return FieldAttributes.getDescriptionField();
    }

    /**
     * Get the table fields that compose the PK
     *
     * @return the PK field list
     */
    @Override
    public List<String> getPKFields()
    {
        return getPKFieldList();
    }

    /**
     * Is composite PK.
     *
     * @return the boolean
     */
    @Override
    public boolean isCompositePK()
    {
        return this.getPKFieldList().size() > 1;
    }

    /**
     * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeAsString(java.lang.String)
     */
     @Override
     public String getAttributeAsString(String attributeName)
     {
        if (attributeName.contains("."))
        {
            return this.getAttributeAsStringParseBeanPath(attributeName);
        }
        else
        {
            Object value = getAttribute(attributeName);

            if (value == null)
                return "";
            else {
                return value.toString().trim();
            }
        }
     }

    // Constructors

    /**
     * default constructor
     */
    public DataConsentUser() {
    }

	/** 
	 * minimal constructor
	 *
     * @param configId the configId
     * @param userId the userId
    }
	 */
    public DataConsentUser(String configId, String userId) {
        this.configId = configId;
        this.userId = userId;
    }

    /**
     * full constructor
	 *
     * @param configId the configId
     * @param userId the userId
     * @param businessId the businessId
     * @param userDataConsents the userDataConsents
     * @param dataConsentReviews the dataConsentReviews
     * @param userDataRequests the userDataRequests
     */
    public DataConsentUser(String configId, String userId, String businessId, Set<UserDataConsent> userDataConsents, Set<DataConsentReview> dataConsentReviews, Set<UserDataRequest> userDataRequests) {
        this.configId = configId;
        this.userId = userId;
        this.businessId = businessId;
        this.userDataConsents = userDataConsents;
        this.dataConsentReviews = dataConsentReviews;
        this.userDataRequests = userDataRequests;
    }

    // Property accessors
    
    /**       
     * id getter method
     *
     * @return id method
     */
    public Long getId() {
        return this.id;
    }
    
    /**       
     * id setter method
     *
     * @param id the id
     *
     * @return DataConsentUser modified instance
     */
    public DataConsentUser setId(Long id) {
        this.id = id;
        
        return this;
    }
    /**       
     * configId getter method
     *
     * @return configId method
     */
    public String getConfigId() {
        return this.configId;
    }
    
    /**       
     * configId setter method
     *
     * @param configId the configId
     *
     * @return DataConsentUser modified instance
     */
    public DataConsentUser setConfigId(String configId) {
        this.configId = configId;
        
        return this;
    }
    /**       
     * userId getter method
     *
     * @return userId method
     */
    public String getUserId() {
        return this.userId;
    }
    
    /**       
     * userId setter method
     *
     * @param userId the userId
     *
     * @return DataConsentUser modified instance
     */
    public DataConsentUser setUserId(String userId) {
        this.userId = userId;
        
        return this;
    }
    /**       
     * businessId getter method
     *
     * @return businessId method
     */
    public String getBusinessId() {
        return this.businessId;
    }
    
    /**       
     * businessId setter method
     *
     * @param businessId the businessId
     *
     * @return DataConsentUser modified instance
     */
    public DataConsentUser setBusinessId(String businessId) {
        this.businessId = businessId;
        
        return this;
    }
    /**       
     * userDataConsents getter method
     *
     * @return userDataConsents method
     */
    public Set<UserDataConsent> getUserDataConsents() {
        return this.userDataConsents;
    }
    
    /**       
     * userDataConsents setter method
     *
     * @param userDataConsents the userDataConsents
     *
     * @return DataConsentUser modified instance
     */
    public DataConsentUser setUserDataConsents(Set<UserDataConsent> userDataConsents) {
        this.userDataConsents = userDataConsents;
        
        return this;
    }
    /**       
     * dataConsentReviews getter method
     *
     * @return dataConsentReviews method
     */
    public Set<DataConsentReview> getDataConsentReviews() {
        return this.dataConsentReviews;
    }
    
    /**       
     * dataConsentReviews setter method
     *
     * @param dataConsentReviews the dataConsentReviews
     *
     * @return DataConsentUser modified instance
     */
    public DataConsentUser setDataConsentReviews(Set<DataConsentReview> dataConsentReviews) {
        this.dataConsentReviews = dataConsentReviews;
        
        return this;
    }
    /**       
     * userDataRequests getter method
     *
     * @return userDataRequests method
     */
    public Set<UserDataRequest> getUserDataRequests() {
        return this.userDataRequests;
    }
    
    /**       
     * userDataRequests setter method
     *
     * @param userDataRequests the userDataRequests
     *
     * @return DataConsentUser modified instance
     */
    public DataConsentUser setUserDataRequests(Set<UserDataRequest> userDataRequests) {
        this.userDataRequests = userDataRequests;
        
        return this;
    }


    /**
     * Creates a String representation of the DataConsentUser object
     *
     * @return the compiled String
     */
    @Override
    public String toString() {
	    StringBuffer buffer = new StringBuffer();

        buffer.append(getClass().getName()).append("@").append(Integer.toHexString(hashCode())).append(" [");

        buffer.append("id").append("='").append(getId()).append("' ");			
        buffer.append("configId").append("='").append(getConfigId()).append("' ");			
        buffer.append("userId").append("='").append(getUserId()).append("' ");			
        buffer.append("businessId").append("='").append(getBusinessId()).append("' ");			
        buffer.append("]");
      
        return buffer.toString();
    }

    /**
     * Compares the String representation of the DataConsentUser object
     *
     * @param other The object to compare to
     *
     * @return true of the objects are equal
     */
    public boolean equals(DataConsentUser other) {
        	return this.toString().equals(other.toString());
    }
    /**
     * @see pt.digitalis.utils.common.IBeanAttributes#setAttributeFromString(java.lang.String, java.lang.String)
     */
    public void setAttributeFromString(String attributeName, String attributeValue) {
        if ("id".equalsIgnoreCase(attributeName))
            this.id = Long.valueOf(attributeValue);

        if ("configId".equalsIgnoreCase(attributeName))
        	this.configId = attributeValue;

        if ("userId".equalsIgnoreCase(attributeName))
        	this.userId = attributeValue;

        if ("businessId".equalsIgnoreCase(attributeName))
        	this.businessId = attributeValue;

    }


    /**
     * Instanciates an Hibernate proxy data object (does not load it from the database, provides lazy load for that)
     *
     * @param session the session
     * @param id      the id
     *
     * @return the proxy
     */
    public static DataConsentUser getProxy(Session session, Long id)
    {
        return(DataConsentUser)session.load(DataConsentUser.class,id);
    }

    /**
    * Instanciates an Hibernate proxy data object (does not load it from the database, provides lazy load for that)
    *
    * @param id      the id
    *
    * @return the proxy
    */
    public static DataConsentUser getProxy(Long id)
    {
        Session session = HibernateUtil.getSessionFactory(SESSION_FACTORY_NAME).getCurrentSession();
        boolean wasActive = session.getTransaction().isActive();

        if (!wasActive)
            session.beginTransaction();

        DataConsentUser result = (DataConsentUser)session.load(DataConsentUser.class,id);

        if (!wasActive)
            session.getTransaction().commit();

        return result;
    }


    /**
     * Instanciates an Hibernate data object
     *
     * @param session the session
     * @param id      the id
     *
     * @return the instance
     */
    public static DataConsentUser getInstanceForSession(Session session, Long id)
    {
        return(DataConsentUser)session.get(DataConsentUser.class,id);
    }

    /**
    * Instanciates an Hibernate data object
    *
    * @param id      the id
    *
    * @return the instance
    */
    public static DataConsentUser getInstance(Long id)
    {
        Session session = HibernateUtil.getSessionFactory(SESSION_FACTORY_NAME).getCurrentSession();
        boolean wasActive = session.getTransaction().isActive();

        if (!wasActive)
            session.beginTransaction();

        DataConsentUser result = (DataConsentUser)session.get(DataConsentUser.class,id);

        if (!wasActive)
            session.getTransaction().commit();

        return result;
    }

}
