package pt.digitalis.dif.dem.managers.impl.model.data;

import pt.digitalis.utils.common.AttributeDefinition;
import pt.digitalis.dif.model.utils.AbstractBeanAttributesDefinition;

import java.sql.Timestamp;
import java.sql.Blob;
import java.util.Date;
import java.math.BigDecimal;

import java.util.Arrays;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pt.digitalis.utils.common.collections.CaseInsensitiveHashMap;

import org.hibernate.Session;


/**
 *  Field definitions for data object {@link DataConsentUser}
 *
 * NOTE: This file is auto generated and will be overwritten in a future file generation.
 */
public class DataConsentUserFieldAttributes extends AbstractBeanAttributesDefinition{

    /** businessId (Database column: BUSINESS_ID - Business UID that identifies this user in the current business) */
    static public AttributeDefinition businessId =
        new AttributeDefinition("businessId")
                .setDescription("Business UID that identifies this user in the current business")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("DATA_CONSENT_USER")
                .setDatabaseId("BUSINESS_ID")
                .setMandatory(false)
                .setMaxSize(255)
                .setType(String.class);

    /** configId (Database column: CONFIG_ID - Configuration ID (each application can have a diferent set of consents)) */
    static public AttributeDefinition configId =
        new AttributeDefinition("configId")
                .setDescription("Configuration ID (each application can have a diferent set of consents)")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("DATA_CONSENT_USER")
                .setDatabaseId("CONFIG_ID")
                .setMandatory(true)
                .setMaxSize(255)
                .setType(String.class);

    /** id (Database column: ID - ID) */
    static public AttributeDefinition id =
        new AttributeDefinition("id")
                .setDescription("ID")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("DATA_CONSENT_USER")
                .setDatabaseId("ID")
                .setMandatory(true)
                .setMaxSize(10)
                .setType(Long.class);

    /** userId (Database column: USER_ID - User ID) */
    static public AttributeDefinition userId =
        new AttributeDefinition("userId")
                .setDescription("User ID")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("DATA_CONSENT_USER")
                .setDatabaseId("USER_ID")
                .setMandatory(true)
                .setMaxSize(255)
                .setType(String.class);

    /**
     * Gets description field.
     *
     * @return the description field
     */
    public static String getDescriptionField()
    {
        return null;
    }

    /**
    * Create definitions map map.
    *
    * @return the map
    */
    @Override protected CaseInsensitiveHashMap<AttributeDefinition> createDefinitionsMap(){
        CaseInsensitiveHashMap<AttributeDefinition> map = new CaseInsensitiveHashMap<AttributeDefinition>();
        map.put(businessId.getName(),businessId);
        map.put(configId.getName(),configId);
        map.put(id.getName(),id);
        map.put(userId.getName(),userId);

        return map;
    }
}