package pt.digitalis.dif.dem.managers.impl.model.data;


import java.util.ArrayList;
import java.util.List;
import org.hibernate.Session;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.hibernate.HibernateUtil;
import pt.digitalis.dif.model.utils.AbstractBeanRelationsAttributes;
import pt.digitalis.dif.model.utils.IBeanAttributesDataSet;

/**
 * DataIntegrationField
* Generated on ORM Generator
* DIF build process for the Model layer
*
*/
@SuppressWarnings("serial")
public class DataIntegrationField extends AbstractBeanRelationsAttributes implements java.io.Serializable, IBeanAttributesDataSet<DataIntegrationField> {

    /**
    * Constant with the session factory ID
    */
    public static String SESSION_FACTORY_NAME = "DIFRepository";

    /** DataIntegrationField attributes enumeration */
    public static class Fields
    {
        /** id column */
        public static final String ID ="id";
        /** fieldId column */
        public static final String FIELDID ="fieldId";
        /** value column */
        public static final String VALUE ="value";
        /** integrated column */
        public static final String INTEGRATED ="integrated";

        /**
         * List of existing fields
         *
         * @return list of field names
         */
        public static List<String> values()
        {
            ArrayList<String> list = new ArrayList<String>();
            list.add("id");
            list.add("fieldId");
            list.add("value");
            list.add("integrated");

            return list;
        }
    }

    /** Field attributes */
    public static DataIntegrationFieldFieldAttributes FieldAttributes=new DataIntegrationFieldFieldAttributes();

    /**
    * @return the field attributes definitions
    */
    @Override public DataIntegrationFieldFieldAttributes getDefinitions()
    {
        return FieldAttributes;
    }

    /**
     * The Class Relations.
     */
    public class Relations extends AbstractBeanRelationsAttributes.AbstractRelations
    {

        /**
        * Instantiates a new relations.
        *
        * @param currentPath the current path
        */
        public Relations(String currentPath)
        {
            super(currentPath);
        }
        /**
         * dataIntegrationRecordByRelationRecordId relation.
         *
         * @return the dataIntegrationRecordByRelationRecordId bean relations attributes.
         */
        public DataIntegrationRecord.Relations dataIntegrationRecordByRelationRecordId()
        {
            DataIntegrationRecord c = new DataIntegrationRecord();
            return c.new Relations(this.buildPath("dataIntegrationRecordByRelationRecordId"));
        }

        /**
         * dataIntegrationRecordByDataIntegrationRecordId relation.
         *
         * @return the dataIntegrationRecordByDataIntegrationRecordId bean relations attributes.
         */
        public DataIntegrationRecord.Relations dataIntegrationRecordByDataIntegrationRecordId()
        {
            DataIntegrationRecord c = new DataIntegrationRecord();
            return c.new Relations(this.buildPath("dataIntegrationRecordByDataIntegrationRecordId"));
        }

        /**
         * the ID path.
         *
         * @return the path
         */
        public String ID()
        {
            return buildPath(Fields.ID);
        }
        /**
         * the FIELDID path.
         *
         * @return the path
         */
        public String FIELDID()
        {
            return buildPath(Fields.FIELDID);
        }
        /**
         * the VALUE path.
         *
         * @return the path
         */
        public String VALUE()
        {
            return buildPath(Fields.VALUE);
        }
        /**
         * the INTEGRATED path.
         *
         * @return the path
         */
        public String INTEGRATED()
        {
            return buildPath(Fields.INTEGRATED);
        }
    }

    /** The dummy obj. */
    private static DataIntegrationField dummyObj=new DataIntegrationField();

    /**
     * Get DataIntegrationField Relations .
     *
     * @return the relations
     */
    public static Relations FK()
    {
        return dummyObj.new Relations(null);
    }

    /**
    * Gets a new dataSet object for this bean
    *
    * @return the dataSet
    */
    public IDataSet<DataIntegrationField> getDataSet()
    {
        return getDataSetInstance();
    }

    /**
    * Gets a new dataSet object for this bean
    *
    * @return the dataSet
    */
    public static IDataSet<DataIntegrationField> getDataSetInstance()
    {
        return new HibernateDataSet<DataIntegrationField>(DataIntegrationField.class, HibernateUtil.getSessionFactory(SESSION_FACTORY_NAME),
            DataIntegrationField.getPKFieldListAsString(), DataIntegrationField.FieldAttributes);
    }

    /**
    * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeNoGraphNavigation(java.lang.String)
    */
    @Override protected Object getAttributeNoGraphNavigation(String attributeName)
    {
        if("id".equalsIgnoreCase(attributeName))
            return id;
        if("dataIntegrationRecordByRelationRecordId".equalsIgnoreCase(attributeName))
            return dataIntegrationRecordByRelationRecordId;
        if("dataIntegrationRecordByDataIntegrationRecordId".equalsIgnoreCase(attributeName))
            return dataIntegrationRecordByDataIntegrationRecordId;
        if("fieldId".equalsIgnoreCase(attributeName))
            return fieldId;
        if("value".equalsIgnoreCase(attributeName))
            return value;
        if("integrated".equalsIgnoreCase(attributeName))
            return integrated;

        return null;
    }

    /**
    * @see pt.digitalis.utils.common.IBeanAttributes#setAttribute(java.lang.String, java.lang.Object)
    */
    public void setAttribute(String attributeName,Object attributeValue)
    {
        if("id".equalsIgnoreCase(attributeName))
            id =(Long)attributeValue;
        if("dataIntegrationRecordByRelationRecordId".equalsIgnoreCase(attributeName))
            dataIntegrationRecordByRelationRecordId =(DataIntegrationRecord)attributeValue;
        if("dataIntegrationRecordByDataIntegrationRecordId".equalsIgnoreCase(attributeName))
            dataIntegrationRecordByDataIntegrationRecordId =(DataIntegrationRecord)attributeValue;
        if("fieldId".equalsIgnoreCase(attributeName))
            fieldId =(String)attributeValue;
        if("value".equalsIgnoreCase(attributeName))
            value =(String)attributeValue;
        if("integrated".equalsIgnoreCase(attributeName))
            integrated =(Boolean)attributeValue;
    }

    // Fields

    /** id private attribute */
    private Long id;

    /** dataIntegrationRecordByRelationRecordId private attribute */
    private DataIntegrationRecord dataIntegrationRecordByRelationRecordId;

    /** dataIntegrationRecordByDataIntegrationRecordId private attribute */
    private DataIntegrationRecord dataIntegrationRecordByDataIntegrationRecordId;

    /** fieldId private attribute */
    private String fieldId;

    /** value private attribute */
    private String value;

    /** integrated private attribute */
    private boolean integrated;

    /** The pojo's primary key field list names */
    private static List<String> pkFieldList;

    /**
     * Get the table fields that compose the PK
     *
     * @return the PK field list
     */
     public synchronized static List<String> getPKFieldList()
     {
         if (pkFieldList == null)
         {
             pkFieldList = new ArrayList<String>();
             pkFieldList.add("id");
         }

         return pkFieldList;
     }

    /**
     * Get the table fields that compose the PK as a comma separated field name list
     *
     * @return the PK field list as a string
     */
     public static String getPKFieldListAsString()
     {
         StringBuffer buffer = new StringBuffer();

         for (int i = 0; i < getPKFieldList().size(); i++)
         {
             if (i != 0)
                 buffer.append(",");

             buffer.append(getPKFieldList().get(i));
         }

         return buffer.toString();
     }

    /**
     * Gets description field.
     *
     * @return the description field
     */
    @Override
    public String getDescriptionField()
    {
        return FieldAttributes.getDescriptionField();
    }

    /**
     * Get the table fields that compose the PK
     *
     * @return the PK field list
     */
    @Override
    public List<String> getPKFields()
    {
        return getPKFieldList();
    }

    /**
     * Is composite PK.
     *
     * @return the boolean
     */
    @Override
    public boolean isCompositePK()
    {
        return this.getPKFieldList().size() > 1;
    }

    /**
     * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeAsString(java.lang.String)
     */
     @Override
     public String getAttributeAsString(String attributeName)
     {
        if (attributeName.contains("."))
        {
            return this.getAttributeAsStringParseBeanPath(attributeName);
        }
        else
        {
            Object value = getAttribute(attributeName);

            if (value == null)
                return "";
            else {
                return value.toString().trim();
            }
        }
     }

    // Constructors

    /**
     * default constructor
     */
    public DataIntegrationField() {
    }

	/** 
	 * minimal constructor
	 *
     * @param dataIntegrationRecordByDataIntegrationRecordId the dataIntegrationRecordByDataIntegrationRecordId
     * @param fieldId the fieldId
     * @param integrated the integrated
    }
	 */
    public DataIntegrationField(DataIntegrationRecord dataIntegrationRecordByDataIntegrationRecordId, String fieldId, boolean integrated) {
        this.dataIntegrationRecordByDataIntegrationRecordId = dataIntegrationRecordByDataIntegrationRecordId;
        this.fieldId = fieldId;
        this.integrated = integrated;
    }

    /**
     * full constructor
	 *
     * @param dataIntegrationRecordByRelationRecordId the dataIntegrationRecordByRelationRecordId
     * @param dataIntegrationRecordByDataIntegrationRecordId the dataIntegrationRecordByDataIntegrationRecordId
     * @param fieldId the fieldId
     * @param value the value
     * @param integrated the integrated
     */
    public DataIntegrationField(DataIntegrationRecord dataIntegrationRecordByRelationRecordId, DataIntegrationRecord dataIntegrationRecordByDataIntegrationRecordId, String fieldId, String value, boolean integrated) {
        this.dataIntegrationRecordByRelationRecordId = dataIntegrationRecordByRelationRecordId;
        this.dataIntegrationRecordByDataIntegrationRecordId = dataIntegrationRecordByDataIntegrationRecordId;
        this.fieldId = fieldId;
        this.value = value;
        this.integrated = integrated;
    }

    // Property accessors
    
    /**       
     * id getter method
     *
     * @return id method
     */
    public Long getId() {
        return this.id;
    }
    
    /**       
     * id setter method
     *
     * @param id the id
     *
     * @return DataIntegrationField modified instance
     */
    public DataIntegrationField setId(Long id) {
        this.id = id;
        
        return this;
    }
    /**       
     * dataIntegrationRecordByRelationRecordId getter method
     *
     * @return dataIntegrationRecordByRelationRecordId method
     */
    public DataIntegrationRecord getDataIntegrationRecordByRelationRecordId() {
        return this.dataIntegrationRecordByRelationRecordId;
    }
    
    /**       
     * dataIntegrationRecordByRelationRecordId setter method
     *
     * @param dataIntegrationRecordByRelationRecordId the dataIntegrationRecordByRelationRecordId
     *
     * @return DataIntegrationField modified instance
     */
    public DataIntegrationField setDataIntegrationRecordByRelationRecordId(DataIntegrationRecord dataIntegrationRecordByRelationRecordId) {
        this.dataIntegrationRecordByRelationRecordId = dataIntegrationRecordByRelationRecordId;
        
        return this;
    }
    /**       
     * dataIntegrationRecordByDataIntegrationRecordId getter method
     *
     * @return dataIntegrationRecordByDataIntegrationRecordId method
     */
    public DataIntegrationRecord getDataIntegrationRecordByDataIntegrationRecordId() {
        return this.dataIntegrationRecordByDataIntegrationRecordId;
    }
    
    /**       
     * dataIntegrationRecordByDataIntegrationRecordId setter method
     *
     * @param dataIntegrationRecordByDataIntegrationRecordId the dataIntegrationRecordByDataIntegrationRecordId
     *
     * @return DataIntegrationField modified instance
     */
    public DataIntegrationField setDataIntegrationRecordByDataIntegrationRecordId(DataIntegrationRecord dataIntegrationRecordByDataIntegrationRecordId) {
        this.dataIntegrationRecordByDataIntegrationRecordId = dataIntegrationRecordByDataIntegrationRecordId;
        
        return this;
    }
    /**       
     * fieldId getter method
     *
     * @return fieldId method
     */
    public String getFieldId() {
        return this.fieldId;
    }
    
    /**       
     * fieldId setter method
     *
     * @param fieldId the fieldId
     *
     * @return DataIntegrationField modified instance
     */
    public DataIntegrationField setFieldId(String fieldId) {
        this.fieldId = fieldId;
        
        return this;
    }
    /**       
     * value getter method
     *
     * @return value method
     */
    public String getValue() {
        return this.value;
    }
    
    /**       
     * value setter method
     *
     * @param value the value
     *
     * @return DataIntegrationField modified instance
     */
    public DataIntegrationField setValue(String value) {
        this.value = value;
        
        return this;
    }
    /**       
     * integrated getter method
     *
     * @return integrated method
     */
    public boolean isIntegrated() {
        return this.integrated;
    }
    
    /**       
     * integrated setter method
     *
     * @param integrated the integrated
     *
     * @return DataIntegrationField modified instance
     */
    public DataIntegrationField setIntegrated(boolean integrated) {
        this.integrated = integrated;
        
        return this;
    }

    /**
     * dataIntegrationRecordByRelationRecordId id getter method
     *
     * @return dataIntegrationRecordByRelationRecordId id method
     */
    public Long getDataIntegrationRecordByRelationRecordIdId() {
        if (this.dataIntegrationRecordByRelationRecordId == null)
            return null;
        else
            return this.dataIntegrationRecordByRelationRecordId.getId();
    }

    /**
     * DataIntegrationRecord proxy setter method from id.
     *
     * @return DataIntegrationField modified instance
     */
    public DataIntegrationField setDataIntegrationRecordByRelationRecordIdProxyFromId(Long id)
    {
        if (id == null || id.equals(-1L))
            this.dataIntegrationRecordByRelationRecordId = null;
        else
            this.dataIntegrationRecordByRelationRecordId = DataIntegrationRecord.getProxy(id);

        return this;
    }

    /**
     * DataIntegrationRecord instance setter method from id.
     *
     * @return DataIntegrationField modified instance
     */
    public DataIntegrationField setDataIntegrationRecordByRelationRecordIdInstanceFromId(Long id)
    {
        if (id == null || id.equals(-1L))
            this.dataIntegrationRecordByRelationRecordId = null;
        else
            this.dataIntegrationRecordByRelationRecordId = DataIntegrationRecord.getInstance(id);

        return this;
    }
    /**
     * dataIntegrationRecordByDataIntegrationRecordId id getter method
     *
     * @return dataIntegrationRecordByDataIntegrationRecordId id method
     */
    public Long getDataIntegrationRecordByDataIntegrationRecordIdId() {
        if (this.dataIntegrationRecordByDataIntegrationRecordId == null)
            return null;
        else
            return this.dataIntegrationRecordByDataIntegrationRecordId.getId();
    }

    /**
     * DataIntegrationRecord proxy setter method from id.
     *
     * @return DataIntegrationField modified instance
     */
    public DataIntegrationField setDataIntegrationRecordByDataIntegrationRecordIdProxyFromId(Long id)
    {
        if (id == null || id.equals(-1L))
            this.dataIntegrationRecordByDataIntegrationRecordId = null;
        else
            this.dataIntegrationRecordByDataIntegrationRecordId = DataIntegrationRecord.getProxy(id);

        return this;
    }

    /**
     * DataIntegrationRecord instance setter method from id.
     *
     * @return DataIntegrationField modified instance
     */
    public DataIntegrationField setDataIntegrationRecordByDataIntegrationRecordIdInstanceFromId(Long id)
    {
        if (id == null || id.equals(-1L))
            this.dataIntegrationRecordByDataIntegrationRecordId = null;
        else
            this.dataIntegrationRecordByDataIntegrationRecordId = DataIntegrationRecord.getInstance(id);

        return this;
    }

    /**
     * Creates a String representation of the DataIntegrationField object
     *
     * @return the compiled String
     */
    @Override
    public String toString() {
	    StringBuffer buffer = new StringBuffer();

        buffer.append(getClass().getName()).append("@").append(Integer.toHexString(hashCode())).append(" [");

        buffer.append("id").append("='").append(getId()).append("' ");			
        buffer.append("fieldId").append("='").append(getFieldId()).append("' ");			
        buffer.append("value").append("='").append(getValue()).append("' ");			
        buffer.append("integrated").append("='").append(isIntegrated()).append("' ");			
        buffer.append("]");
      
        return buffer.toString();
    }

    /**
     * Compares the String representation of the DataIntegrationField object
     *
     * @param other The object to compare to
     *
     * @return true of the objects are equal
     */
    public boolean equals(DataIntegrationField other) {
        	return this.toString().equals(other.toString());
    }
    /**
     * @see pt.digitalis.utils.common.IBeanAttributes#setAttributeFromString(java.lang.String, java.lang.String)
     */
    public void setAttributeFromString(String attributeName, String attributeValue) {
        if ("id".equalsIgnoreCase(attributeName))
            this.id = Long.valueOf(attributeValue);

        if ("fieldId".equalsIgnoreCase(attributeName))
        	this.fieldId = attributeValue;

        if ("value".equalsIgnoreCase(attributeName))
        	this.value = attributeValue;

        if ("integrated".equalsIgnoreCase(attributeName))
            this.integrated = Boolean.valueOf(attributeValue);

    }


    /**
     * Instanciates an Hibernate proxy data object (does not load it from the database, provides lazy load for that)
     *
     * @param session the session
     * @param id      the id
     *
     * @return the proxy
     */
    public static DataIntegrationField getProxy(Session session, Long id)
    {
        return(DataIntegrationField)session.load(DataIntegrationField.class,id);
    }

    /**
    * Instanciates an Hibernate proxy data object (does not load it from the database, provides lazy load for that)
    *
    * @param id      the id
    *
    * @return the proxy
    */
    public static DataIntegrationField getProxy(Long id)
    {
        Session session = HibernateUtil.getSessionFactory(SESSION_FACTORY_NAME).getCurrentSession();
        boolean wasActive = session.getTransaction().isActive();

        if (!wasActive)
            session.beginTransaction();

        DataIntegrationField result = (DataIntegrationField)session.load(DataIntegrationField.class,id);

        if (!wasActive)
            session.getTransaction().commit();

        return result;
    }


    /**
     * Instanciates an Hibernate data object
     *
     * @param session the session
     * @param id      the id
     *
     * @return the instance
     */
    public static DataIntegrationField getInstanceForSession(Session session, Long id)
    {
        return(DataIntegrationField)session.get(DataIntegrationField.class,id);
    }

    /**
    * Instanciates an Hibernate data object
    *
    * @param id      the id
    *
    * @return the instance
    */
    public static DataIntegrationField getInstance(Long id)
    {
        Session session = HibernateUtil.getSessionFactory(SESSION_FACTORY_NAME).getCurrentSession();
        boolean wasActive = session.getTransaction().isActive();

        if (!wasActive)
            session.beginTransaction();

        DataIntegrationField result = (DataIntegrationField)session.get(DataIntegrationField.class,id);

        if (!wasActive)
            session.getTransaction().commit();

        return result;
    }

}
