package pt.digitalis.dif.dem.managers.impl.model.data;


import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.Session;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.hibernate.HibernateUtil;
import pt.digitalis.dif.model.utils.AbstractBeanRelationsAttributes;
import pt.digitalis.dif.model.utils.IBeanAttributesDataSet;

/**
 * EcommercePayments
* Generated on ORM Generator
* DIF build process for the Model layer
*
*/
@SuppressWarnings("serial")
public class EcommercePayments extends AbstractBeanRelationsAttributes implements java.io.Serializable, IBeanAttributesDataSet<EcommercePayments> {

    /**
    * Constant with the session factory ID
    */
    public static String SESSION_FACTORY_NAME = "DIFRepository";

    /** EcommercePayments attributes enumeration */
    public static class Fields
    {
        /** id column */
        public static final String ID ="id";
        /** businessId column */
        public static final String BUSINESSID ="businessId";
        /** creator column */
        public static final String CREATOR ="creator";
        /** businessContext column */
        public static final String BUSINESSCONTEXT ="businessContext";
        /** ecommerceProcessor column */
        public static final String ECOMMERCEPROCESSOR ="ecommerceProcessor";
        /** paymentValue column */
        public static final String PAYMENTVALUE ="paymentValue";
        /** status column */
        public static final String STATUS ="status";
        /** statusMessage column */
        public static final String STATUSMESSAGE ="statusMessage";
        /** securityToken column */
        public static final String SECURITYTOKEN ="securityToken";
        /** dateCreation column */
        public static final String DATECREATION ="dateCreation";
        /** dateReceived column */
        public static final String DATERECEIVED ="dateReceived";
        /** dateProcessed column */
        public static final String DATEPROCESSED ="dateProcessed";
        /** transactionDate column */
        public static final String TRANSACTIONDATE ="transactionDate";
        /** transactionId column */
        public static final String TRANSACTIONID ="transactionId";
        /** authorizationId column */
        public static final String AUTHORIZATIONID ="authorizationId";
        /** redirectUrl column */
        public static final String REDIRECTURL ="redirectUrl";
        /** configurationId column */
        public static final String CONFIGURATIONID ="configurationId";
        /** sentOnReport column */
        public static final String SENTONREPORT ="sentOnReport";
        /** paymentContext column */
        public static final String PAYMENTCONTEXT ="paymentContext";
        /** paymentFee column */
        public static final String PAYMENTFEE ="paymentFee";
        /** errorFriendlyUserMessage column */
        public static final String ERRORFRIENDLYUSERMESSAGE ="errorFriendlyUserMessage";

        /**
         * List of existing fields
         *
         * @return list of field names
         */
        public static List<String> values()
        {
            ArrayList<String> list = new ArrayList<String>();
            list.add("id");
            list.add("businessId");
            list.add("creator");
            list.add("businessContext");
            list.add("ecommerceProcessor");
            list.add("paymentValue");
            list.add("status");
            list.add("statusMessage");
            list.add("securityToken");
            list.add("dateCreation");
            list.add("dateReceived");
            list.add("dateProcessed");
            list.add("transactionDate");
            list.add("transactionId");
            list.add("authorizationId");
            list.add("redirectUrl");
            list.add("configurationId");
            list.add("sentOnReport");
            list.add("paymentContext");
            list.add("paymentFee");
            list.add("errorFriendlyUserMessage");

            return list;
        }
    }

    /** Field attributes */
    public static EcommercePaymentsFieldAttributes FieldAttributes=new EcommercePaymentsFieldAttributes();

    /**
    * @return the field attributes definitions
    */
    @Override public EcommercePaymentsFieldAttributes getDefinitions()
    {
        return FieldAttributes;
    }

    /**
     * The Class Relations.
     */
    public class Relations extends AbstractBeanRelationsAttributes.AbstractRelations
    {

        /**
        * Instantiates a new relations.
        *
        * @param currentPath the current path
        */
        public Relations(String currentPath)
        {
            super(currentPath);
        }
        /**
         * the ID path.
         *
         * @return the path
         */
        public String ID()
        {
            return buildPath(Fields.ID);
        }
        /**
         * the BUSINESSID path.
         *
         * @return the path
         */
        public String BUSINESSID()
        {
            return buildPath(Fields.BUSINESSID);
        }
        /**
         * the CREATOR path.
         *
         * @return the path
         */
        public String CREATOR()
        {
            return buildPath(Fields.CREATOR);
        }
        /**
         * the BUSINESSCONTEXT path.
         *
         * @return the path
         */
        public String BUSINESSCONTEXT()
        {
            return buildPath(Fields.BUSINESSCONTEXT);
        }
        /**
         * the ECOMMERCEPROCESSOR path.
         *
         * @return the path
         */
        public String ECOMMERCEPROCESSOR()
        {
            return buildPath(Fields.ECOMMERCEPROCESSOR);
        }
        /**
         * the PAYMENTVALUE path.
         *
         * @return the path
         */
        public String PAYMENTVALUE()
        {
            return buildPath(Fields.PAYMENTVALUE);
        }
        /**
         * the STATUS path.
         *
         * @return the path
         */
        public String STATUS()
        {
            return buildPath(Fields.STATUS);
        }
        /**
         * the STATUSMESSAGE path.
         *
         * @return the path
         */
        public String STATUSMESSAGE()
        {
            return buildPath(Fields.STATUSMESSAGE);
        }
        /**
         * the SECURITYTOKEN path.
         *
         * @return the path
         */
        public String SECURITYTOKEN()
        {
            return buildPath(Fields.SECURITYTOKEN);
        }
        /**
         * the DATECREATION path.
         *
         * @return the path
         */
        public String DATECREATION()
        {
            return buildPath(Fields.DATECREATION);
        }
        /**
         * the DATERECEIVED path.
         *
         * @return the path
         */
        public String DATERECEIVED()
        {
            return buildPath(Fields.DATERECEIVED);
        }
        /**
         * the DATEPROCESSED path.
         *
         * @return the path
         */
        public String DATEPROCESSED()
        {
            return buildPath(Fields.DATEPROCESSED);
        }
        /**
         * the TRANSACTIONDATE path.
         *
         * @return the path
         */
        public String TRANSACTIONDATE()
        {
            return buildPath(Fields.TRANSACTIONDATE);
        }
        /**
         * the TRANSACTIONID path.
         *
         * @return the path
         */
        public String TRANSACTIONID()
        {
            return buildPath(Fields.TRANSACTIONID);
        }
        /**
         * the AUTHORIZATIONID path.
         *
         * @return the path
         */
        public String AUTHORIZATIONID()
        {
            return buildPath(Fields.AUTHORIZATIONID);
        }
        /**
         * the REDIRECTURL path.
         *
         * @return the path
         */
        public String REDIRECTURL()
        {
            return buildPath(Fields.REDIRECTURL);
        }
        /**
         * the CONFIGURATIONID path.
         *
         * @return the path
         */
        public String CONFIGURATIONID()
        {
            return buildPath(Fields.CONFIGURATIONID);
        }
        /**
         * the SENTONREPORT path.
         *
         * @return the path
         */
        public String SENTONREPORT()
        {
            return buildPath(Fields.SENTONREPORT);
        }
        /**
         * the PAYMENTCONTEXT path.
         *
         * @return the path
         */
        public String PAYMENTCONTEXT()
        {
            return buildPath(Fields.PAYMENTCONTEXT);
        }
        /**
         * the PAYMENTFEE path.
         *
         * @return the path
         */
        public String PAYMENTFEE()
        {
            return buildPath(Fields.PAYMENTFEE);
        }
        /**
         * the ERRORFRIENDLYUSERMESSAGE path.
         *
         * @return the path
         */
        public String ERRORFRIENDLYUSERMESSAGE()
        {
            return buildPath(Fields.ERRORFRIENDLYUSERMESSAGE);
        }
    }

    /** The dummy obj. */
    private static EcommercePayments dummyObj=new EcommercePayments();

    /**
     * Get EcommercePayments Relations .
     *
     * @return the relations
     */
    public static Relations FK()
    {
        return dummyObj.new Relations(null);
    }

    /**
    * Gets a new dataSet object for this bean
    *
    * @return the dataSet
    */
    public IDataSet<EcommercePayments> getDataSet()
    {
        return getDataSetInstance();
    }

    /**
    * Gets a new dataSet object for this bean
    *
    * @return the dataSet
    */
    public static IDataSet<EcommercePayments> getDataSetInstance()
    {
        return new HibernateDataSet<EcommercePayments>(EcommercePayments.class, HibernateUtil.getSessionFactory(SESSION_FACTORY_NAME),
            EcommercePayments.getPKFieldListAsString(), EcommercePayments.FieldAttributes);
    }

    /**
    * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeNoGraphNavigation(java.lang.String)
    */
    @Override protected Object getAttributeNoGraphNavigation(String attributeName)
    {
        if("id".equalsIgnoreCase(attributeName))
            return id;
        if("businessId".equalsIgnoreCase(attributeName))
            return businessId;
        if("creator".equalsIgnoreCase(attributeName))
            return creator;
        if("businessContext".equalsIgnoreCase(attributeName))
            return businessContext;
        if("ecommerceProcessor".equalsIgnoreCase(attributeName))
            return ecommerceProcessor;
        if("paymentValue".equalsIgnoreCase(attributeName))
            return paymentValue;
        if("status".equalsIgnoreCase(attributeName))
            return status;
        if("statusMessage".equalsIgnoreCase(attributeName))
            return statusMessage;
        if("securityToken".equalsIgnoreCase(attributeName))
            return securityToken;
        if("dateCreation".equalsIgnoreCase(attributeName))
            return dateCreation;
        if("dateReceived".equalsIgnoreCase(attributeName))
            return dateReceived;
        if("dateProcessed".equalsIgnoreCase(attributeName))
            return dateProcessed;
        if("transactionDate".equalsIgnoreCase(attributeName))
            return transactionDate;
        if("transactionId".equalsIgnoreCase(attributeName))
            return transactionId;
        if("authorizationId".equalsIgnoreCase(attributeName))
            return authorizationId;
        if("redirectUrl".equalsIgnoreCase(attributeName))
            return redirectUrl;
        if("configurationId".equalsIgnoreCase(attributeName))
            return configurationId;
        if("sentOnReport".equalsIgnoreCase(attributeName))
            return sentOnReport;
        if("paymentContext".equalsIgnoreCase(attributeName))
            return paymentContext;
        if("paymentFee".equalsIgnoreCase(attributeName))
            return paymentFee;
        if("errorFriendlyUserMessage".equalsIgnoreCase(attributeName))
            return errorFriendlyUserMessage;

        return null;
    }

    /**
    * @see pt.digitalis.utils.common.IBeanAttributes#setAttribute(java.lang.String, java.lang.Object)
    */
    public void setAttribute(String attributeName,Object attributeValue)
    {
        if("id".equalsIgnoreCase(attributeName))
            id =(Long)attributeValue;
        if("businessId".equalsIgnoreCase(attributeName))
            businessId =(String)attributeValue;
        if("creator".equalsIgnoreCase(attributeName))
            creator =(String)attributeValue;
        if("businessContext".equalsIgnoreCase(attributeName))
            businessContext =(String)attributeValue;
        if("ecommerceProcessor".equalsIgnoreCase(attributeName))
            ecommerceProcessor =(String)attributeValue;
        if("paymentValue".equalsIgnoreCase(attributeName))
            paymentValue =(BigDecimal)attributeValue;
        if("status".equalsIgnoreCase(attributeName))
            status =(String)attributeValue;
        if("statusMessage".equalsIgnoreCase(attributeName))
            statusMessage =(String)attributeValue;
        if("securityToken".equalsIgnoreCase(attributeName))
            securityToken =(String)attributeValue;
        if("dateCreation".equalsIgnoreCase(attributeName))
            dateCreation =(Timestamp)attributeValue;
        if("dateReceived".equalsIgnoreCase(attributeName))
            dateReceived =(Timestamp)attributeValue;
        if("dateProcessed".equalsIgnoreCase(attributeName))
            dateProcessed =(Timestamp)attributeValue;
        if("transactionDate".equalsIgnoreCase(attributeName))
            transactionDate =(Timestamp)attributeValue;
        if("transactionId".equalsIgnoreCase(attributeName))
            transactionId =(String)attributeValue;
        if("authorizationId".equalsIgnoreCase(attributeName))
            authorizationId =(String)attributeValue;
        if("redirectUrl".equalsIgnoreCase(attributeName))
            redirectUrl =(String)attributeValue;
        if("configurationId".equalsIgnoreCase(attributeName))
            configurationId =(String)attributeValue;
        if("sentOnReport".equalsIgnoreCase(attributeName))
            sentOnReport =(Boolean)attributeValue;
        if("paymentContext".equalsIgnoreCase(attributeName))
            paymentContext =(String)attributeValue;
        if("paymentFee".equalsIgnoreCase(attributeName))
            paymentFee =(BigDecimal)attributeValue;
        if("errorFriendlyUserMessage".equalsIgnoreCase(attributeName))
            errorFriendlyUserMessage =(String)attributeValue;
    }

    // Fields

    /** id private attribute */
    private Long id;

    /** businessId private attribute */
    private String businessId;

    /** creator private attribute */
    private String creator;

    /** businessContext private attribute */
    private String businessContext;

    /** ecommerceProcessor private attribute */
    private String ecommerceProcessor;

    /** paymentValue private attribute */
    private BigDecimal paymentValue;

    /** status private attribute */
    private String status;

    /** statusMessage private attribute */
    private String statusMessage;

    /** securityToken private attribute */
    private String securityToken;

    /** dateCreation private attribute */
    private Timestamp dateCreation;

    /** dateReceived private attribute */
    private Timestamp dateReceived;

    /** dateProcessed private attribute */
    private Timestamp dateProcessed;

    /** transactionDate private attribute */
    private Timestamp transactionDate;

    /** transactionId private attribute */
    private String transactionId;

    /** authorizationId private attribute */
    private String authorizationId;

    /** redirectUrl private attribute */
    private String redirectUrl;

    /** configurationId private attribute */
    private String configurationId;

    /** sentOnReport private attribute */
    private boolean sentOnReport;

    /** paymentContext private attribute */
    private String paymentContext;

    /** paymentFee private attribute */
    private BigDecimal paymentFee;

    /** errorFriendlyUserMessage private attribute */
    private String errorFriendlyUserMessage;

    /** The pojo's primary key field list names */
    private static List<String> pkFieldList;

    /**
     * Get the table fields that compose the PK
     *
     * @return the PK field list
     */
     public synchronized static List<String> getPKFieldList()
     {
         if (pkFieldList == null)
         {
             pkFieldList = new ArrayList<String>();
             pkFieldList.add("id");
         }

         return pkFieldList;
     }

    /**
     * Get the table fields that compose the PK as a comma separated field name list
     *
     * @return the PK field list as a string
     */
     public static String getPKFieldListAsString()
     {
         StringBuffer buffer = new StringBuffer();

         for (int i = 0; i < getPKFieldList().size(); i++)
         {
             if (i != 0)
                 buffer.append(",");

             buffer.append(getPKFieldList().get(i));
         }

         return buffer.toString();
     }

    /**
     * Gets description field.
     *
     * @return the description field
     */
    @Override
    public String getDescriptionField()
    {
        return FieldAttributes.getDescriptionField();
    }

    /**
     * Get the table fields that compose the PK
     *
     * @return the PK field list
     */
    @Override
    public List<String> getPKFields()
    {
        return getPKFieldList();
    }

    /**
     * Is composite PK.
     *
     * @return the boolean
     */
    @Override
    public boolean isCompositePK()
    {
        return this.getPKFieldList().size() > 1;
    }

    /**
     * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeAsString(java.lang.String)
     */
     @Override
     public String getAttributeAsString(String attributeName)
     {
        if (attributeName.contains("."))
        {
            return this.getAttributeAsStringParseBeanPath(attributeName);
        }
        else
        {
            Object value = getAttribute(attributeName);

            if (value == null)
                return "";
            else {
                return value.toString().trim();
            }
        }
     }

    // Constructors

    /**
     * default constructor
     */
    public EcommercePayments() {
    }

	/** 
	 * minimal constructor
	 *
     * @param sentOnReport the sentOnReport
    }
	 */
    public EcommercePayments(boolean sentOnReport) {
        this.sentOnReport = sentOnReport;
    }

    /**
     * full constructor
	 *
     * @param businessId the businessId
     * @param creator the creator
     * @param businessContext the businessContext
     * @param ecommerceProcessor the ecommerceProcessor
     * @param paymentValue the paymentValue
     * @param status the status
     * @param statusMessage the statusMessage
     * @param securityToken the securityToken
     * @param dateCreation the dateCreation
     * @param dateReceived the dateReceived
     * @param dateProcessed the dateProcessed
     * @param transactionDate the transactionDate
     * @param transactionId the transactionId
     * @param authorizationId the authorizationId
     * @param redirectUrl the redirectUrl
     * @param configurationId the configurationId
     * @param sentOnReport the sentOnReport
     * @param paymentContext the paymentContext
     * @param paymentFee the paymentFee
     * @param errorFriendlyUserMessage the errorFriendlyUserMessage
     */
    public EcommercePayments(String businessId, String creator, String businessContext, String ecommerceProcessor, BigDecimal paymentValue, String status, String statusMessage, String securityToken, Timestamp dateCreation, Timestamp dateReceived, Timestamp dateProcessed, Timestamp transactionDate, String transactionId, String authorizationId, String redirectUrl, String configurationId, boolean sentOnReport, String paymentContext, BigDecimal paymentFee, String errorFriendlyUserMessage) {
        this.businessId = businessId;
        this.creator = creator;
        this.businessContext = businessContext;
        this.ecommerceProcessor = ecommerceProcessor;
        this.paymentValue = paymentValue;
        this.status = status;
        this.statusMessage = statusMessage;
        this.securityToken = securityToken;
        this.dateCreation = dateCreation;
        this.dateReceived = dateReceived;
        this.dateProcessed = dateProcessed;
        this.transactionDate = transactionDate;
        this.transactionId = transactionId;
        this.authorizationId = authorizationId;
        this.redirectUrl = redirectUrl;
        this.configurationId = configurationId;
        this.sentOnReport = sentOnReport;
        this.paymentContext = paymentContext;
        this.paymentFee = paymentFee;
        this.errorFriendlyUserMessage = errorFriendlyUserMessage;
    }

    // Property accessors
    
    /**       
     * id getter method
     *
     * @return id method
     */
    public Long getId() {
        return this.id;
    }
    
    /**       
     * id setter method
     *
     * @param id the id
     *
     * @return EcommercePayments modified instance
     */
    public EcommercePayments setId(Long id) {
        this.id = id;
        
        return this;
    }
    /**       
     * businessId getter method
     *
     * @return businessId method
     */
    public String getBusinessId() {
        return this.businessId;
    }
    
    /**       
     * businessId setter method
     *
     * @param businessId the businessId
     *
     * @return EcommercePayments modified instance
     */
    public EcommercePayments setBusinessId(String businessId) {
        this.businessId = businessId;
        
        return this;
    }
    /**       
     * creator getter method
     *
     * @return creator method
     */
    public String getCreator() {
        return this.creator;
    }
    
    /**       
     * creator setter method
     *
     * @param creator the creator
     *
     * @return EcommercePayments modified instance
     */
    public EcommercePayments setCreator(String creator) {
        this.creator = creator;
        
        return this;
    }
    /**       
     * businessContext getter method
     *
     * @return businessContext method
     */
    public String getBusinessContext() {
        return this.businessContext;
    }
    
    /**       
     * businessContext setter method
     *
     * @param businessContext the businessContext
     *
     * @return EcommercePayments modified instance
     */
    public EcommercePayments setBusinessContext(String businessContext) {
        this.businessContext = businessContext;
        
        return this;
    }
    /**       
     * ecommerceProcessor getter method
     *
     * @return ecommerceProcessor method
     */
    public String getEcommerceProcessor() {
        return this.ecommerceProcessor;
    }
    
    /**       
     * ecommerceProcessor setter method
     *
     * @param ecommerceProcessor the ecommerceProcessor
     *
     * @return EcommercePayments modified instance
     */
    public EcommercePayments setEcommerceProcessor(String ecommerceProcessor) {
        this.ecommerceProcessor = ecommerceProcessor;
        
        return this;
    }
    /**       
     * paymentValue getter method
     *
     * @return paymentValue method
     */
    public BigDecimal getPaymentValue() {
        return this.paymentValue;
    }
    
    /**       
     * paymentValue setter method
     *
     * @param paymentValue the paymentValue
     *
     * @return EcommercePayments modified instance
     */
    public EcommercePayments setPaymentValue(BigDecimal paymentValue) {
        this.paymentValue = paymentValue;
        
        return this;
    }
    /**       
     * status getter method
     *
     * @return status method
     */
    public String getStatus() {
        return this.status;
    }
    
    /**       
     * status setter method
     *
     * @param status the status
     *
     * @return EcommercePayments modified instance
     */
    public EcommercePayments setStatus(String status) {
        this.status = status;
        
        return this;
    }
    /**       
     * statusMessage getter method
     *
     * @return statusMessage method
     */
    public String getStatusMessage() {
        return this.statusMessage;
    }
    
    /**       
     * statusMessage setter method
     *
     * @param statusMessage the statusMessage
     *
     * @return EcommercePayments modified instance
     */
    public EcommercePayments setStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
        
        return this;
    }
    /**       
     * securityToken getter method
     *
     * @return securityToken method
     */
    public String getSecurityToken() {
        return this.securityToken;
    }
    
    /**       
     * securityToken setter method
     *
     * @param securityToken the securityToken
     *
     * @return EcommercePayments modified instance
     */
    public EcommercePayments setSecurityToken(String securityToken) {
        this.securityToken = securityToken;
        
        return this;
    }
    /**       
     * dateCreation getter method
     *
     * @return dateCreation method
     */
    public Timestamp getDateCreation() {
        return this.dateCreation;
    }
    
    /**       
     * dateCreation setter method
     *
     * @param dateCreation the dateCreation
     *
     * @return EcommercePayments modified instance
     */
    public EcommercePayments setDateCreation(Timestamp dateCreation) {
        this.dateCreation = dateCreation;
        
        return this;
    }
    /**       
     * dateReceived getter method
     *
     * @return dateReceived method
     */
    public Timestamp getDateReceived() {
        return this.dateReceived;
    }
    
    /**       
     * dateReceived setter method
     *
     * @param dateReceived the dateReceived
     *
     * @return EcommercePayments modified instance
     */
    public EcommercePayments setDateReceived(Timestamp dateReceived) {
        this.dateReceived = dateReceived;
        
        return this;
    }
    /**       
     * dateProcessed getter method
     *
     * @return dateProcessed method
     */
    public Timestamp getDateProcessed() {
        return this.dateProcessed;
    }
    
    /**       
     * dateProcessed setter method
     *
     * @param dateProcessed the dateProcessed
     *
     * @return EcommercePayments modified instance
     */
    public EcommercePayments setDateProcessed(Timestamp dateProcessed) {
        this.dateProcessed = dateProcessed;
        
        return this;
    }
    /**       
     * transactionDate getter method
     *
     * @return transactionDate method
     */
    public Timestamp getTransactionDate() {
        return this.transactionDate;
    }
    
    /**       
     * transactionDate setter method
     *
     * @param transactionDate the transactionDate
     *
     * @return EcommercePayments modified instance
     */
    public EcommercePayments setTransactionDate(Timestamp transactionDate) {
        this.transactionDate = transactionDate;
        
        return this;
    }
    /**       
     * transactionId getter method
     *
     * @return transactionId method
     */
    public String getTransactionId() {
        return this.transactionId;
    }
    
    /**       
     * transactionId setter method
     *
     * @param transactionId the transactionId
     *
     * @return EcommercePayments modified instance
     */
    public EcommercePayments setTransactionId(String transactionId) {
        this.transactionId = transactionId;
        
        return this;
    }
    /**       
     * authorizationId getter method
     *
     * @return authorizationId method
     */
    public String getAuthorizationId() {
        return this.authorizationId;
    }
    
    /**       
     * authorizationId setter method
     *
     * @param authorizationId the authorizationId
     *
     * @return EcommercePayments modified instance
     */
    public EcommercePayments setAuthorizationId(String authorizationId) {
        this.authorizationId = authorizationId;
        
        return this;
    }
    /**       
     * redirectUrl getter method
     *
     * @return redirectUrl method
     */
    public String getRedirectUrl() {
        return this.redirectUrl;
    }
    
    /**       
     * redirectUrl setter method
     *
     * @param redirectUrl the redirectUrl
     *
     * @return EcommercePayments modified instance
     */
    public EcommercePayments setRedirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
        
        return this;
    }
    /**       
     * configurationId getter method
     *
     * @return configurationId method
     */
    public String getConfigurationId() {
        return this.configurationId;
    }
    
    /**       
     * configurationId setter method
     *
     * @param configurationId the configurationId
     *
     * @return EcommercePayments modified instance
     */
    public EcommercePayments setConfigurationId(String configurationId) {
        this.configurationId = configurationId;
        
        return this;
    }
    /**       
     * sentOnReport getter method
     *
     * @return sentOnReport method
     */
    public boolean isSentOnReport() {
        return this.sentOnReport;
    }
    
    /**       
     * sentOnReport setter method
     *
     * @param sentOnReport the sentOnReport
     *
     * @return EcommercePayments modified instance
     */
    public EcommercePayments setSentOnReport(boolean sentOnReport) {
        this.sentOnReport = sentOnReport;
        
        return this;
    }
    /**       
     * paymentContext getter method
     *
     * @return paymentContext method
     */
    public String getPaymentContext() {
        return this.paymentContext;
    }
    
    /**       
     * paymentContext setter method
     *
     * @param paymentContext the paymentContext
     *
     * @return EcommercePayments modified instance
     */
    public EcommercePayments setPaymentContext(String paymentContext) {
        this.paymentContext = paymentContext;
        
        return this;
    }
    /**       
     * paymentFee getter method
     *
     * @return paymentFee method
     */
    public BigDecimal getPaymentFee() {
        return this.paymentFee;
    }
    
    /**       
     * paymentFee setter method
     *
     * @param paymentFee the paymentFee
     *
     * @return EcommercePayments modified instance
     */
    public EcommercePayments setPaymentFee(BigDecimal paymentFee) {
        this.paymentFee = paymentFee;
        
        return this;
    }
    /**       
     * errorFriendlyUserMessage getter method
     *
     * @return errorFriendlyUserMessage method
     */
    public String getErrorFriendlyUserMessage() {
        return this.errorFriendlyUserMessage;
    }
    
    /**       
     * errorFriendlyUserMessage setter method
     *
     * @param errorFriendlyUserMessage the errorFriendlyUserMessage
     *
     * @return EcommercePayments modified instance
     */
    public EcommercePayments setErrorFriendlyUserMessage(String errorFriendlyUserMessage) {
        this.errorFriendlyUserMessage = errorFriendlyUserMessage;
        
        return this;
    }


    /**
     * Creates a String representation of the EcommercePayments object
     *
     * @return the compiled String
     */
    @Override
    public String toString() {
	    StringBuffer buffer = new StringBuffer();

        buffer.append(getClass().getName()).append("@").append(Integer.toHexString(hashCode())).append(" [");

        buffer.append("id").append("='").append(getId()).append("' ");			
        buffer.append("businessId").append("='").append(getBusinessId()).append("' ");			
        buffer.append("creator").append("='").append(getCreator()).append("' ");			
        buffer.append("businessContext").append("='").append(getBusinessContext()).append("' ");			
        buffer.append("ecommerceProcessor").append("='").append(getEcommerceProcessor()).append("' ");			
        buffer.append("paymentValue").append("='").append(getPaymentValue()).append("' ");			
        buffer.append("status").append("='").append(getStatus()).append("' ");			
        buffer.append("statusMessage").append("='").append(getStatusMessage()).append("' ");			
        buffer.append("securityToken").append("='").append(getSecurityToken()).append("' ");			
        buffer.append("dateCreation").append("='").append(getDateCreation()).append("' ");			
        buffer.append("dateReceived").append("='").append(getDateReceived()).append("' ");			
        buffer.append("dateProcessed").append("='").append(getDateProcessed()).append("' ");			
        buffer.append("transactionDate").append("='").append(getTransactionDate()).append("' ");			
        buffer.append("transactionId").append("='").append(getTransactionId()).append("' ");			
        buffer.append("authorizationId").append("='").append(getAuthorizationId()).append("' ");			
        buffer.append("redirectUrl").append("='").append(getRedirectUrl()).append("' ");			
        buffer.append("configurationId").append("='").append(getConfigurationId()).append("' ");			
        buffer.append("sentOnReport").append("='").append(isSentOnReport()).append("' ");			
        buffer.append("paymentContext").append("='").append(getPaymentContext()).append("' ");			
        buffer.append("paymentFee").append("='").append(getPaymentFee()).append("' ");			
        buffer.append("errorFriendlyUserMessage").append("='").append(getErrorFriendlyUserMessage()).append("' ");			
        buffer.append("]");
      
        return buffer.toString();
    }

    /**
     * Compares the String representation of the EcommercePayments object
     *
     * @param other The object to compare to
     *
     * @return true of the objects are equal
     */
    public boolean equals(EcommercePayments other) {
        	return this.toString().equals(other.toString());
    }
    /**
     * @see pt.digitalis.utils.common.IBeanAttributes#setAttributeFromString(java.lang.String, java.lang.String)
     */
    public void setAttributeFromString(String attributeName, String attributeValue) {
        if ("id".equalsIgnoreCase(attributeName))
            this.id = Long.valueOf(attributeValue);

        if ("businessId".equalsIgnoreCase(attributeName))
        	this.businessId = attributeValue;

        if ("creator".equalsIgnoreCase(attributeName))
        	this.creator = attributeValue;

        if ("businessContext".equalsIgnoreCase(attributeName))
        	this.businessContext = attributeValue;

        if ("ecommerceProcessor".equalsIgnoreCase(attributeName))
        	this.ecommerceProcessor = attributeValue;

        if ("paymentValue".equalsIgnoreCase(attributeName))
	        this.paymentValue = new BigDecimal(attributeValue);

        if ("status".equalsIgnoreCase(attributeName))
        	this.status = attributeValue;

        if ("statusMessage".equalsIgnoreCase(attributeName))
        	this.statusMessage = attributeValue;

        if ("securityToken".equalsIgnoreCase(attributeName))
        	this.securityToken = attributeValue;

        if ("dateCreation".equalsIgnoreCase(attributeName))
            this.dateCreation = Timestamp.valueOf(attributeValue);

        if ("dateReceived".equalsIgnoreCase(attributeName))
            this.dateReceived = Timestamp.valueOf(attributeValue);

        if ("dateProcessed".equalsIgnoreCase(attributeName))
            this.dateProcessed = Timestamp.valueOf(attributeValue);

        if ("transactionDate".equalsIgnoreCase(attributeName))
            this.transactionDate = Timestamp.valueOf(attributeValue);

        if ("transactionId".equalsIgnoreCase(attributeName))
        	this.transactionId = attributeValue;

        if ("authorizationId".equalsIgnoreCase(attributeName))
        	this.authorizationId = attributeValue;

        if ("redirectUrl".equalsIgnoreCase(attributeName))
        	this.redirectUrl = attributeValue;

        if ("configurationId".equalsIgnoreCase(attributeName))
        	this.configurationId = attributeValue;

        if ("sentOnReport".equalsIgnoreCase(attributeName))
            this.sentOnReport = Boolean.valueOf(attributeValue);

        if ("paymentContext".equalsIgnoreCase(attributeName))
        	this.paymentContext = attributeValue;

        if ("paymentFee".equalsIgnoreCase(attributeName))
	        this.paymentFee = new BigDecimal(attributeValue);

        if ("errorFriendlyUserMessage".equalsIgnoreCase(attributeName))
        	this.errorFriendlyUserMessage = attributeValue;

    }


    /**
     * Instanciates an Hibernate proxy data object (does not load it from the database, provides lazy load for that)
     *
     * @param session the session
     * @param id      the id
     *
     * @return the proxy
     */
    public static EcommercePayments getProxy(Session session, Long id)
    {
        return(EcommercePayments)session.load(EcommercePayments.class,id);
    }

    /**
    * Instanciates an Hibernate proxy data object (does not load it from the database, provides lazy load for that)
    *
    * @param id      the id
    *
    * @return the proxy
    */
    public static EcommercePayments getProxy(Long id)
    {
        Session session = HibernateUtil.getSessionFactory(SESSION_FACTORY_NAME).getCurrentSession();
        boolean wasActive = session.getTransaction().isActive();

        if (!wasActive)
            session.beginTransaction();

        EcommercePayments result = (EcommercePayments)session.load(EcommercePayments.class,id);

        if (!wasActive)
            session.getTransaction().commit();

        return result;
    }


    /**
     * Instanciates an Hibernate data object
     *
     * @param session the session
     * @param id      the id
     *
     * @return the instance
     */
    public static EcommercePayments getInstanceForSession(Session session, Long id)
    {
        return(EcommercePayments)session.get(EcommercePayments.class,id);
    }

    /**
    * Instanciates an Hibernate data object
    *
    * @param id      the id
    *
    * @return the instance
    */
    public static EcommercePayments getInstance(Long id)
    {
        Session session = HibernateUtil.getSessionFactory(SESSION_FACTORY_NAME).getCurrentSession();
        boolean wasActive = session.getTransaction().isActive();

        if (!wasActive)
            session.beginTransaction();

        EcommercePayments result = (EcommercePayments)session.get(EcommercePayments.class,id);

        if (!wasActive)
            session.getTransaction().commit();

        return result;
    }

}
