package pt.digitalis.dif.dem.managers.impl.model.data;

import pt.digitalis.utils.common.AttributeDefinition;
import pt.digitalis.dif.model.utils.AbstractBeanAttributesDefinition;

import java.sql.Timestamp;
import java.sql.Blob;
import java.util.Date;
import java.math.BigDecimal;

import java.util.Arrays;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pt.digitalis.utils.common.collections.CaseInsensitiveHashMap;

import org.hibernate.Session;


/**
 *  Field definitions for data object {@link Event}
 *
 * NOTE: This file is auto generated and will be overwritten in a future file generation.
 */
public class EventFieldAttributes extends AbstractBeanAttributesDefinition{

    /** applicationId (Database column: APPLICATION_ID) */
    static public AttributeDefinition applicationId =
        new AttributeDefinition("applicationId")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("EVENT")
                .setDatabaseId("APPLICATION_ID")
                .setMandatory(false)
                .setMaxSize(100)
                .setType(String.class);

    /** attemptsToGiveUp (Database column: ATTEMPTS_TO_GIVE_UP) */
    static public AttributeDefinition attemptsToGiveUp =
        new AttributeDefinition("attemptsToGiveUp")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("EVENT")
                .setDatabaseId("ATTEMPTS_TO_GIVE_UP")
                .setMandatory(false)
                .setMaxSize(3)
                .setType(Long.class);

    /** businessId (Database column: BUSINESS_ID) */
    static public AttributeDefinition businessId =
        new AttributeDefinition("businessId")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("EVENT")
                .setDatabaseId("BUSINESS_ID")
                .setMandatory(false)
                .setMaxSize(255)
                .setType(String.class);

    /** categoryId (Database column: CATEGORY_ID) */
    static public AttributeDefinition categoryId =
        new AttributeDefinition("categoryId")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("EVENT")
                .setDatabaseId("CATEGORY_ID")
                .setMandatory(false)
                .setMaxSize(255)
                .setType(String.class);

    /** configId (Database column: CONFIG_ID) */
    static public AttributeDefinition configId =
        new AttributeDefinition("configId")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("EVENT")
                .setDatabaseId("CONFIG_ID")
                .setMandatory(true)
                .setMaxSize(255)
                .setType(String.class);

    /** eventDate (Database column: EVENT_DATE) */
    static public AttributeDefinition eventDate =
        new AttributeDefinition("eventDate")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("EVENT")
                .setDatabaseId("EVENT_DATE")
                .setMandatory(false)
                .setMaxSize(7)
                .setType(Timestamp.class);

    /** id (Database column: ID) */
    static public AttributeDefinition id =
        new AttributeDefinition("id")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("EVENT")
                .setDatabaseId("ID")
                .setMandatory(true)
                .setMaxSize(10)
                .setType(Long.class);

    /** payLoad (Database column: PAY_LOAD) */
    static public AttributeDefinition payLoad =
        new AttributeDefinition("payLoad")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("EVENT")
                .setDatabaseId("PAY_LOAD")
                .setMandatory(false)
                .setMaxSize(4000)
                .setType(String.class);

    /** publisherId (Database column: PUBLISHER_ID) */
    static public AttributeDefinition publisherId =
        new AttributeDefinition("publisherId")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("EVENT")
                .setDatabaseId("PUBLISHER_ID")
                .setMandatory(false)
                .setMaxSize(255)
                .setType(String.class);

    /** state (Database column: STATE) */
    static public AttributeDefinition state =
        new AttributeDefinition("state")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("EVENT")
                .setDatabaseId("STATE")
                .setMandatory(false)
                .setMaxSize(1)
                .setType(String.class);

    /** userIdThatTriggeredEvent (Database column: USER_ID_THAT_TRIGGERED_EVENT) */
    static public AttributeDefinition userIdThatTriggeredEvent =
        new AttributeDefinition("userIdThatTriggeredEvent")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("EVENT")
                .setDatabaseId("USER_ID_THAT_TRIGGERED_EVENT")
                .setMandatory(false)
                .setMaxSize(100)
                .setType(String.class);

    /**
     * Gets description field.
     *
     * @return the description field
     */
    public static String getDescriptionField()
    {
        return "configId";
    }

    /**
    * Create definitions map map.
    *
    * @return the map
    */
    @Override protected CaseInsensitiveHashMap<AttributeDefinition> createDefinitionsMap(){
        CaseInsensitiveHashMap<AttributeDefinition> map = new CaseInsensitiveHashMap<AttributeDefinition>();
        map.put(applicationId.getName(),applicationId);
        map.put(attemptsToGiveUp.getName(),attemptsToGiveUp);
        map.put(businessId.getName(),businessId);
        map.put(categoryId.getName(),categoryId);
        map.put(configId.getName(),configId);
        map.put(eventDate.getName(),eventDate);
        map.put(id.getName(),id);
        map.put(payLoad.getName(),payLoad);
        map.put(publisherId.getName(),publisherId);
        map.put(state.getName(),state);
        map.put(userIdThatTriggeredEvent.getName(),userIdThatTriggeredEvent);

        return map;
    }
}