package pt.digitalis.dif.dem.managers.impl.model.data;


import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hibernate.Session;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.hibernate.HibernateUtil;
import pt.digitalis.dif.model.utils.AbstractBeanRelationsAttributes;
import pt.digitalis.dif.model.utils.IBeanAttributesDataSet;

/**
 * FileBundle
* Generated on ORM Generator
* DIF build process for the Model layer
*
*/
@SuppressWarnings("serial")
public class FileBundle extends AbstractBeanRelationsAttributes implements java.io.Serializable, IBeanAttributesDataSet<FileBundle> {

    /**
    * Constant with the session factory ID
    */
    public static String SESSION_FACTORY_NAME = "DIFRepository";

    /** FileBundle attributes enumeration */
    public static class Fields
    {
        /** id column */
        public static final String ID ="id";
        /** name column */
        public static final String NAME ="name";
        /** businessProcessTypeId column */
        public static final String BUSINESSPROCESSTYPEID ="businessProcessTypeId";

        /**
         * List of existing fields
         *
         * @return list of field names
         */
        public static List<String> values()
        {
            ArrayList<String> list = new ArrayList<String>();
            list.add("id");
            list.add("name");
            list.add("businessProcessTypeId");

            return list;
        }
    }

    /** Field attributes */
    public static FileBundleFieldAttributes FieldAttributes=new FileBundleFieldAttributes();

    /**
    * @return the field attributes definitions
    */
    @Override public FileBundleFieldAttributes getDefinitions()
    {
        return FieldAttributes;
    }

    /**
     * The Class Relations.
     */
    public class Relations extends AbstractBeanRelationsAttributes.AbstractRelations
    {

        /**
        * Instantiates a new relations.
        *
        * @param currentPath the current path
        */
        public Relations(String currentPath)
        {
            super(currentPath);
        }
        /**
         * workflows relation.
         *
         * @return the workflows bean relations attributes.
         */
        public Workflow.Relations workflows()
        {
            Workflow c = new Workflow();
            return c.new Relations(this.buildPath("workflows"));
        }

        /**
         * fileBundleInstances relation.
         *
         * @return the fileBundleInstances bean relations attributes.
         */
        public FileBundleInstance.Relations fileBundleInstances()
        {
            FileBundleInstance c = new FileBundleInstance();
            return c.new Relations(this.buildPath("fileBundleInstances"));
        }

        /**
         * fileBundleFiles relation.
         *
         * @return the fileBundleFiles bean relations attributes.
         */
        public FileBundleFile.Relations fileBundleFiles()
        {
            FileBundleFile c = new FileBundleFile();
            return c.new Relations(this.buildPath("fileBundleFiles"));
        }

        /**
         * the ID path.
         *
         * @return the path
         */
        public String ID()
        {
            return buildPath(Fields.ID);
        }
        /**
         * the NAME path.
         *
         * @return the path
         */
        public String NAME()
        {
            return buildPath(Fields.NAME);
        }
        /**
         * the BUSINESSPROCESSTYPEID path.
         *
         * @return the path
         */
        public String BUSINESSPROCESSTYPEID()
        {
            return buildPath(Fields.BUSINESSPROCESSTYPEID);
        }
    }

    /** The dummy obj. */
    private static FileBundle dummyObj=new FileBundle();

    /**
     * Get FileBundle Relations .
     *
     * @return the relations
     */
    public static Relations FK()
    {
        return dummyObj.new Relations(null);
    }

    /**
    * Gets a new dataSet object for this bean
    *
    * @return the dataSet
    */
    public IDataSet<FileBundle> getDataSet()
    {
        return getDataSetInstance();
    }

    /**
    * Gets a new dataSet object for this bean
    *
    * @return the dataSet
    */
    public static IDataSet<FileBundle> getDataSetInstance()
    {
        return new HibernateDataSet<FileBundle>(FileBundle.class, HibernateUtil.getSessionFactory(SESSION_FACTORY_NAME),
            FileBundle.getPKFieldListAsString(), FileBundle.FieldAttributes);
    }

    /**
    * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeNoGraphNavigation(java.lang.String)
    */
    @Override protected Object getAttributeNoGraphNavigation(String attributeName)
    {
        if("id".equalsIgnoreCase(attributeName))
            return id;
        if("name".equalsIgnoreCase(attributeName))
            return name;
        if("businessProcessTypeId".equalsIgnoreCase(attributeName))
            return businessProcessTypeId;
        if("workflows".equalsIgnoreCase(attributeName))
            return workflows;
        if("fileBundleInstances".equalsIgnoreCase(attributeName))
            return fileBundleInstances;
        if("fileBundleFiles".equalsIgnoreCase(attributeName))
            return fileBundleFiles;

        return null;
    }

    /**
    * @see pt.digitalis.utils.common.IBeanAttributes#setAttribute(java.lang.String, java.lang.Object)
    */
    public void setAttribute(String attributeName,Object attributeValue)
    {
        if("id".equalsIgnoreCase(attributeName))
            id =(Long)attributeValue;
        if("name".equalsIgnoreCase(attributeName))
            name =(String)attributeValue;
        if("businessProcessTypeId".equalsIgnoreCase(attributeName))
            businessProcessTypeId =(String)attributeValue;
        if("workflows".equalsIgnoreCase(attributeName))
            workflows =(Set<Workflow>)attributeValue;
        if("fileBundleInstances".equalsIgnoreCase(attributeName))
            fileBundleInstances =(Set<FileBundleInstance>)attributeValue;
        if("fileBundleFiles".equalsIgnoreCase(attributeName))
            fileBundleFiles =(Set<FileBundleFile>)attributeValue;
    }

    // Fields

    /** id private attribute */
    private Long id;

    /** name private attribute */
    private String name;

    /** businessProcessTypeId private attribute */
    private String businessProcessTypeId;

    /** workflows private attribute */
    private Set<Workflow> workflows = new HashSet<Workflow>(0);

    /** fileBundleInstances private attribute */
    private Set<FileBundleInstance> fileBundleInstances = new HashSet<FileBundleInstance>(0);

    /** fileBundleFiles private attribute */
    private Set<FileBundleFile> fileBundleFiles = new HashSet<FileBundleFile>(0);

    /** The pojo's primary key field list names */
    private static List<String> pkFieldList;

    /**
     * Get the table fields that compose the PK
     *
     * @return the PK field list
     */
     public synchronized static List<String> getPKFieldList()
     {
         if (pkFieldList == null)
         {
             pkFieldList = new ArrayList<String>();
             pkFieldList.add("id");
         }

         return pkFieldList;
     }

    /**
     * Get the table fields that compose the PK as a comma separated field name list
     *
     * @return the PK field list as a string
     */
     public static String getPKFieldListAsString()
     {
         StringBuffer buffer = new StringBuffer();

         for (int i = 0; i < getPKFieldList().size(); i++)
         {
             if (i != 0)
                 buffer.append(",");

             buffer.append(getPKFieldList().get(i));
         }

         return buffer.toString();
     }

    /**
     * Gets description field.
     *
     * @return the description field
     */
    @Override
    public String getDescriptionField()
    {
        return FieldAttributes.getDescriptionField();
    }

    /**
     * Get the table fields that compose the PK
     *
     * @return the PK field list
     */
    @Override
    public List<String> getPKFields()
    {
        return getPKFieldList();
    }

    /**
     * Is composite PK.
     *
     * @return the boolean
     */
    @Override
    public boolean isCompositePK()
    {
        return this.getPKFieldList().size() > 1;
    }

    /**
     * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeAsString(java.lang.String)
     */
     @Override
     public String getAttributeAsString(String attributeName)
     {
        if (attributeName.contains("."))
        {
            return this.getAttributeAsStringParseBeanPath(attributeName);
        }
        else
        {
            Object value = getAttribute(attributeName);

            if (value == null)
                return "";
            else {
                return value.toString().trim();
            }
        }
     }

    // Constructors

    /**
     * default constructor
     */
    public FileBundle() {
    }


    /**
     * full constructor
	 *
     * @param name the name
     * @param businessProcessTypeId the businessProcessTypeId
     * @param workflows the workflows
     * @param fileBundleInstances the fileBundleInstances
     * @param fileBundleFiles the fileBundleFiles
     */
    public FileBundle(String name, String businessProcessTypeId, Set<Workflow> workflows, Set<FileBundleInstance> fileBundleInstances, Set<FileBundleFile> fileBundleFiles) {
        this.name = name;
        this.businessProcessTypeId = businessProcessTypeId;
        this.workflows = workflows;
        this.fileBundleInstances = fileBundleInstances;
        this.fileBundleFiles = fileBundleFiles;
    }

    // Property accessors
    
    /**       
     * id getter method
     *
     * @return id method
     */
    public Long getId() {
        return this.id;
    }
    
    /**       
     * id setter method
     *
     * @param id the id
     *
     * @return FileBundle modified instance
     */
    public FileBundle setId(Long id) {
        this.id = id;
        
        return this;
    }
    /**       
     * name getter method
     *
     * @return name method
     */
    public String getName() {
        return this.name;
    }
    
    /**       
     * name setter method
     *
     * @param name the name
     *
     * @return FileBundle modified instance
     */
    public FileBundle setName(String name) {
        this.name = name;
        
        return this;
    }
    /**       
     * businessProcessTypeId getter method
     *
     * @return businessProcessTypeId method
     */
    public String getBusinessProcessTypeId() {
        return this.businessProcessTypeId;
    }
    
    /**       
     * businessProcessTypeId setter method
     *
     * @param businessProcessTypeId the businessProcessTypeId
     *
     * @return FileBundle modified instance
     */
    public FileBundle setBusinessProcessTypeId(String businessProcessTypeId) {
        this.businessProcessTypeId = businessProcessTypeId;
        
        return this;
    }
    /**       
     * workflows getter method
     *
     * @return workflows method
     */
    public Set<Workflow> getWorkflows() {
        return this.workflows;
    }
    
    /**       
     * workflows setter method
     *
     * @param workflows the workflows
     *
     * @return FileBundle modified instance
     */
    public FileBundle setWorkflows(Set<Workflow> workflows) {
        this.workflows = workflows;
        
        return this;
    }
    /**       
     * fileBundleInstances getter method
     *
     * @return fileBundleInstances method
     */
    public Set<FileBundleInstance> getFileBundleInstances() {
        return this.fileBundleInstances;
    }
    
    /**       
     * fileBundleInstances setter method
     *
     * @param fileBundleInstances the fileBundleInstances
     *
     * @return FileBundle modified instance
     */
    public FileBundle setFileBundleInstances(Set<FileBundleInstance> fileBundleInstances) {
        this.fileBundleInstances = fileBundleInstances;
        
        return this;
    }
    /**       
     * fileBundleFiles getter method
     *
     * @return fileBundleFiles method
     */
    public Set<FileBundleFile> getFileBundleFiles() {
        return this.fileBundleFiles;
    }
    
    /**       
     * fileBundleFiles setter method
     *
     * @param fileBundleFiles the fileBundleFiles
     *
     * @return FileBundle modified instance
     */
    public FileBundle setFileBundleFiles(Set<FileBundleFile> fileBundleFiles) {
        this.fileBundleFiles = fileBundleFiles;
        
        return this;
    }


    /**
     * Creates a String representation of the FileBundle object
     *
     * @return the compiled String
     */
    @Override
    public String toString() {
	    StringBuffer buffer = new StringBuffer();

        buffer.append(getClass().getName()).append("@").append(Integer.toHexString(hashCode())).append(" [");

        buffer.append("id").append("='").append(getId()).append("' ");			
        buffer.append("name").append("='").append(getName()).append("' ");			
        buffer.append("businessProcessTypeId").append("='").append(getBusinessProcessTypeId()).append("' ");			
        buffer.append("]");
      
        return buffer.toString();
    }

    /**
     * Compares the String representation of the FileBundle object
     *
     * @param other The object to compare to
     *
     * @return true of the objects are equal
     */
    public boolean equals(FileBundle other) {
        	return this.toString().equals(other.toString());
    }
    /**
     * @see pt.digitalis.utils.common.IBeanAttributes#setAttributeFromString(java.lang.String, java.lang.String)
     */
    public void setAttributeFromString(String attributeName, String attributeValue) {
        if ("id".equalsIgnoreCase(attributeName))
            this.id = Long.valueOf(attributeValue);

        if ("name".equalsIgnoreCase(attributeName))
        	this.name = attributeValue;

        if ("businessProcessTypeId".equalsIgnoreCase(attributeName))
        	this.businessProcessTypeId = attributeValue;

    }


    /**
     * Instanciates an Hibernate proxy data object (does not load it from the database, provides lazy load for that)
     *
     * @param session the session
     * @param id      the id
     *
     * @return the proxy
     */
    public static FileBundle getProxy(Session session, Long id)
    {
        return(FileBundle)session.load(FileBundle.class,id);
    }

    /**
    * Instanciates an Hibernate proxy data object (does not load it from the database, provides lazy load for that)
    *
    * @param id      the id
    *
    * @return the proxy
    */
    public static FileBundle getProxy(Long id)
    {
        Session session = HibernateUtil.getSessionFactory(SESSION_FACTORY_NAME).getCurrentSession();
        boolean wasActive = session.getTransaction().isActive();

        if (!wasActive)
            session.beginTransaction();

        FileBundle result = (FileBundle)session.load(FileBundle.class,id);

        if (!wasActive)
            session.getTransaction().commit();

        return result;
    }


    /**
     * Instanciates an Hibernate data object
     *
     * @param session the session
     * @param id      the id
     *
     * @return the instance
     */
    public static FileBundle getInstanceForSession(Session session, Long id)
    {
        return(FileBundle)session.get(FileBundle.class,id);
    }

    /**
    * Instanciates an Hibernate data object
    *
    * @param id      the id
    *
    * @return the instance
    */
    public static FileBundle getInstance(Long id)
    {
        Session session = HibernateUtil.getSessionFactory(SESSION_FACTORY_NAME).getCurrentSession();
        boolean wasActive = session.getTransaction().isActive();

        if (!wasActive)
            session.beginTransaction();

        FileBundle result = (FileBundle)session.get(FileBundle.class,id);

        if (!wasActive)
            session.getTransaction().commit();

        return result;
    }

}
