package pt.digitalis.dif.dem.managers.impl.model.data;

import pt.digitalis.utils.common.AttributeDefinition;
import pt.digitalis.dif.model.utils.AbstractBeanAttributesDefinition;

import java.sql.Timestamp;
import java.sql.Blob;
import java.util.Date;
import java.math.BigDecimal;

import java.util.Arrays;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pt.digitalis.utils.common.collections.CaseInsensitiveHashMap;

import org.hibernate.Session;


/**
 *  Field definitions for data object {@link FileBundle}
 *
 * NOTE: This file is auto generated and will be overwritten in a future file generation.
 */
public class FileBundleFieldAttributes extends AbstractBeanAttributesDefinition{

    /** businessProcessTypeId (Database column: BUSINESS_PROCESS_TYPE_ID) */
    static public AttributeDefinition businessProcessTypeId =
        new AttributeDefinition("businessProcessTypeId")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("FILE_BUNDLE")
                .setDatabaseId("BUSINESS_PROCESS_TYPE_ID")
                .setMandatory(false)
                .setMaxSize(300)
                .setType(String.class);

    /** id (Database column: ID) */
    static public AttributeDefinition id =
        new AttributeDefinition("id")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("FILE_BUNDLE")
                .setDatabaseId("ID")
                .setMandatory(true)
                .setMaxSize(22)
                .setType(Long.class);

    /** name (Database column: NAME) */
    static public AttributeDefinition name =
        new AttributeDefinition("name")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("FILE_BUNDLE")
                .setDatabaseId("NAME")
                .setMandatory(false)
                .setMaxSize(300)
                .setType(String.class);

    /**
     * Gets description field.
     *
     * @return the description field
     */
    public static String getDescriptionField()
    {
        return "name";
    }

    /**
    * Create definitions map map.
    *
    * @return the map
    */
    @Override protected CaseInsensitiveHashMap<AttributeDefinition> createDefinitionsMap(){
        CaseInsensitiveHashMap<AttributeDefinition> map = new CaseInsensitiveHashMap<AttributeDefinition>();
        map.put(businessProcessTypeId.getName(),businessProcessTypeId);
        map.put(id.getName(),id);
        map.put(name.getName(),name);

        return map;
    }
}