package pt.digitalis.dif.dem.managers.impl.model.data;

import pt.digitalis.utils.common.AttributeDefinition;
import pt.digitalis.dif.model.utils.AbstractBeanAttributesDefinition;

import java.sql.Timestamp;
import java.sql.Blob;
import java.util.Date;
import java.math.BigDecimal;

import java.util.Arrays;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pt.digitalis.utils.common.collections.CaseInsensitiveHashMap;

import org.hibernate.Session;


/**
 *  Field definitions for data object {@link FileBundleHistory}
 *
 * NOTE: This file is auto generated and will be overwritten in a future file generation.
 */
public class FileBundleHistoryFieldAttributes extends AbstractBeanAttributesDefinition{

    /** deprecationDate (Database column: DEPRECATION_DATE) */
    static public AttributeDefinition deprecationDate =
        new AttributeDefinition("deprecationDate")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("FILE_BUNDLE_HISTORY")
                .setDatabaseId("DEPRECATION_DATE")
                .setMandatory(true)
                .setMaxSize(7)
                .setType(Timestamp.class);

    /** documentId (Database column: DOCUMENT_ID) */
    static public AttributeDefinition documentId =
        new AttributeDefinition("documentId")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("FILE_BUNDLE_HISTORY")
                .setDatabaseId("DOCUMENT_ID")
                .setMandatory(true)
                .setMaxSize(22)
                .setType(Long.class);

    /** id (Database column: ID) */
    static public AttributeDefinition id =
        new AttributeDefinition("id")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("FILE_BUNDLE_HISTORY")
                .setDatabaseId("ID")
                .setMandatory(true)
                .setMaxSize(22)
                .setType(Long.class);

    /** fileBundleInstanceFile (Database column: INSTANCE_FILE_ID) */
    static public AttributeDefinition fileBundleInstanceFile =
        new AttributeDefinition("fileBundleInstanceFile")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("FILE_BUNDLE_HISTORY")
                .setDatabaseId("INSTANCE_FILE_ID")
                .setMandatory(true)
                .setMaxSize(22)
                .setLovDataClass(pt.digitalis.dif.dem.managers.impl.model.data.FileBundleInstanceFile.class)
                .setLovDataClassKey("id")
                .setType(pt.digitalis.dif.dem.managers.impl.model.data.FileBundleInstanceFile.class);

    /** uploadDate (Database column: UPLOAD_DATE) */
    static public AttributeDefinition uploadDate =
        new AttributeDefinition("uploadDate")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("FILE_BUNDLE_HISTORY")
                .setDatabaseId("UPLOAD_DATE")
                .setMandatory(true)
                .setMaxSize(7)
                .setType(Timestamp.class);

    /** uploadUserId (Database column: UPLOAD_USER_ID) */
    static public AttributeDefinition uploadUserId =
        new AttributeDefinition("uploadUserId")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("FILE_BUNDLE_HISTORY")
                .setDatabaseId("UPLOAD_USER_ID")
                .setMandatory(true)
                .setMaxSize(300)
                .setType(String.class);

    /** version (Database column: VERSION) */
    static public AttributeDefinition version =
        new AttributeDefinition("version")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("FILE_BUNDLE_HISTORY")
                .setDatabaseId("VERSION")
                .setMandatory(true)
                .setMaxSize(5)
                .setType(Long.class);

    /**
     * Gets description field.
     *
     * @return the description field
     */
    public static String getDescriptionField()
    {
        return null;
    }

    /**
    * Create definitions map map.
    *
    * @return the map
    */
    @Override protected CaseInsensitiveHashMap<AttributeDefinition> createDefinitionsMap(){
        CaseInsensitiveHashMap<AttributeDefinition> map = new CaseInsensitiveHashMap<AttributeDefinition>();
        map.put(deprecationDate.getName(),deprecationDate);
        map.put(documentId.getName(),documentId);
        map.put(id.getName(),id);
        map.put(fileBundleInstanceFile.getName(),fileBundleInstanceFile);
        map.put(uploadDate.getName(),uploadDate);
        map.put(uploadUserId.getName(),uploadUserId);
        map.put(version.getName(),version);

        return map;
    }
}