package pt.digitalis.dif.dem.managers.impl.model.data;


import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hibernate.Session;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.hibernate.HibernateUtil;
import pt.digitalis.dif.model.utils.AbstractBeanRelationsAttributes;
import pt.digitalis.dif.model.utils.IBeanAttributesDataSet;

/**
 * FileType
* Generated on ORM Generator
* DIF build process for the Model layer
*
*/
@SuppressWarnings("serial")
public class FileType extends AbstractBeanRelationsAttributes implements java.io.Serializable, IBeanAttributesDataSet<FileType> {

    /**
    * Constant with the session factory ID
    */
    public static String SESSION_FACTORY_NAME = "DIFRepository";

    /** FileType attributes enumeration */
    public static class Fields
    {
        /** id column */
        public static final String ID ="id";
        /** name column */
        public static final String NAME ="name";
        /** description column */
        public static final String DESCRIPTION ="description";
        /** businessProcessTypeId column */
        public static final String BUSINESSPROCESSTYPEID ="businessProcessTypeId";
        /** mimeTypes column */
        public static final String MIMETYPES ="mimeTypes";
        /** maxFileSize column */
        public static final String MAXFILESIZE ="maxFileSize";
        /** templateDocumentId column */
        public static final String TEMPLATEDOCUMENTID ="templateDocumentId";

        /**
         * List of existing fields
         *
         * @return list of field names
         */
        public static List<String> values()
        {
            ArrayList<String> list = new ArrayList<String>();
            list.add("id");
            list.add("name");
            list.add("description");
            list.add("businessProcessTypeId");
            list.add("mimeTypes");
            list.add("maxFileSize");
            list.add("templateDocumentId");

            return list;
        }
    }

    /** Field attributes */
    public static FileTypeFieldAttributes FieldAttributes=new FileTypeFieldAttributes();

    /**
    * @return the field attributes definitions
    */
    @Override public FileTypeFieldAttributes getDefinitions()
    {
        return FieldAttributes;
    }

    /**
     * The Class Relations.
     */
    public class Relations extends AbstractBeanRelationsAttributes.AbstractRelations
    {

        /**
        * Instantiates a new relations.
        *
        * @param currentPath the current path
        */
        public Relations(String currentPath)
        {
            super(currentPath);
        }
        /**
         * fileTypeGenParameterses relation.
         *
         * @return the fileTypeGenParameterses bean relations attributes.
         */
        public FileTypeGenParameters.Relations fileTypeGenParameterses()
        {
            FileTypeGenParameters c = new FileTypeGenParameters();
            return c.new Relations(this.buildPath("fileTypeGenParameterses"));
        }

        /**
         * fileBundleFiles relation.
         *
         * @return the fileBundleFiles bean relations attributes.
         */
        public FileBundleFile.Relations fileBundleFiles()
        {
            FileBundleFile c = new FileBundleFile();
            return c.new Relations(this.buildPath("fileBundleFiles"));
        }

        /**
         * the ID path.
         *
         * @return the path
         */
        public String ID()
        {
            return buildPath(Fields.ID);
        }
        /**
         * the NAME path.
         *
         * @return the path
         */
        public String NAME()
        {
            return buildPath(Fields.NAME);
        }
        /**
         * the DESCRIPTION path.
         *
         * @return the path
         */
        public String DESCRIPTION()
        {
            return buildPath(Fields.DESCRIPTION);
        }
        /**
         * the BUSINESSPROCESSTYPEID path.
         *
         * @return the path
         */
        public String BUSINESSPROCESSTYPEID()
        {
            return buildPath(Fields.BUSINESSPROCESSTYPEID);
        }
        /**
         * the MIMETYPES path.
         *
         * @return the path
         */
        public String MIMETYPES()
        {
            return buildPath(Fields.MIMETYPES);
        }
        /**
         * the MAXFILESIZE path.
         *
         * @return the path
         */
        public String MAXFILESIZE()
        {
            return buildPath(Fields.MAXFILESIZE);
        }
        /**
         * the TEMPLATEDOCUMENTID path.
         *
         * @return the path
         */
        public String TEMPLATEDOCUMENTID()
        {
            return buildPath(Fields.TEMPLATEDOCUMENTID);
        }
    }

    /** The dummy obj. */
    private static FileType dummyObj=new FileType();

    /**
     * Get FileType Relations .
     *
     * @return the relations
     */
    public static Relations FK()
    {
        return dummyObj.new Relations(null);
    }

    /**
    * Gets a new dataSet object for this bean
    *
    * @return the dataSet
    */
    public IDataSet<FileType> getDataSet()
    {
        return getDataSetInstance();
    }

    /**
    * Gets a new dataSet object for this bean
    *
    * @return the dataSet
    */
    public static IDataSet<FileType> getDataSetInstance()
    {
        return new HibernateDataSet<FileType>(FileType.class, HibernateUtil.getSessionFactory(SESSION_FACTORY_NAME),
            FileType.getPKFieldListAsString(), FileType.FieldAttributes);
    }

    /**
    * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeNoGraphNavigation(java.lang.String)
    */
    @Override protected Object getAttributeNoGraphNavigation(String attributeName)
    {
        if("id".equalsIgnoreCase(attributeName))
            return id;
        if("name".equalsIgnoreCase(attributeName))
            return name;
        if("description".equalsIgnoreCase(attributeName))
            return description;
        if("businessProcessTypeId".equalsIgnoreCase(attributeName))
            return businessProcessTypeId;
        if("mimeTypes".equalsIgnoreCase(attributeName))
            return mimeTypes;
        if("maxFileSize".equalsIgnoreCase(attributeName))
            return maxFileSize;
        if("templateDocumentId".equalsIgnoreCase(attributeName))
            return templateDocumentId;
        if("fileTypeGenParameterses".equalsIgnoreCase(attributeName))
            return fileTypeGenParameterses;
        if("fileBundleFiles".equalsIgnoreCase(attributeName))
            return fileBundleFiles;

        return null;
    }

    /**
    * @see pt.digitalis.utils.common.IBeanAttributes#setAttribute(java.lang.String, java.lang.Object)
    */
    public void setAttribute(String attributeName,Object attributeValue)
    {
        if("id".equalsIgnoreCase(attributeName))
            id =(Long)attributeValue;
        if("name".equalsIgnoreCase(attributeName))
            name =(String)attributeValue;
        if("description".equalsIgnoreCase(attributeName))
            description =(String)attributeValue;
        if("businessProcessTypeId".equalsIgnoreCase(attributeName))
            businessProcessTypeId =(String)attributeValue;
        if("mimeTypes".equalsIgnoreCase(attributeName))
            mimeTypes =(String)attributeValue;
        if("maxFileSize".equalsIgnoreCase(attributeName))
            maxFileSize =(Long)attributeValue;
        if("templateDocumentId".equalsIgnoreCase(attributeName))
            templateDocumentId =(Long)attributeValue;
        if("fileTypeGenParameterses".equalsIgnoreCase(attributeName))
            fileTypeGenParameterses =(Set<FileTypeGenParameters>)attributeValue;
        if("fileBundleFiles".equalsIgnoreCase(attributeName))
            fileBundleFiles =(Set<FileBundleFile>)attributeValue;
    }

    // Fields

    /** id private attribute */
    private Long id;

    /** name private attribute */
    private String name;

    /** description private attribute */
    private String description;

    /** businessProcessTypeId private attribute */
    private String businessProcessTypeId;

    /** mimeTypes private attribute */
    private String mimeTypes;

    /** maxFileSize private attribute */
    private Long maxFileSize;

    /** templateDocumentId private attribute */
    private Long templateDocumentId;

    /** fileTypeGenParameterses private attribute */
    private Set<FileTypeGenParameters> fileTypeGenParameterses = new HashSet<FileTypeGenParameters>(0);

    /** fileBundleFiles private attribute */
    private Set<FileBundleFile> fileBundleFiles = new HashSet<FileBundleFile>(0);

    /** The pojo's primary key field list names */
    private static List<String> pkFieldList;

    /**
     * Get the table fields that compose the PK
     *
     * @return the PK field list
     */
     public synchronized static List<String> getPKFieldList()
     {
         if (pkFieldList == null)
         {
             pkFieldList = new ArrayList<String>();
             pkFieldList.add("id");
         }

         return pkFieldList;
     }

    /**
     * Get the table fields that compose the PK as a comma separated field name list
     *
     * @return the PK field list as a string
     */
     public static String getPKFieldListAsString()
     {
         StringBuffer buffer = new StringBuffer();

         for (int i = 0; i < getPKFieldList().size(); i++)
         {
             if (i != 0)
                 buffer.append(",");

             buffer.append(getPKFieldList().get(i));
         }

         return buffer.toString();
     }

    /**
     * Gets description field.
     *
     * @return the description field
     */
    @Override
    public String getDescriptionField()
    {
        return FieldAttributes.getDescriptionField();
    }

    /**
     * Get the table fields that compose the PK
     *
     * @return the PK field list
     */
    @Override
    public List<String> getPKFields()
    {
        return getPKFieldList();
    }

    /**
     * Is composite PK.
     *
     * @return the boolean
     */
    @Override
    public boolean isCompositePK()
    {
        return this.getPKFieldList().size() > 1;
    }

    /**
     * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeAsString(java.lang.String)
     */
     @Override
     public String getAttributeAsString(String attributeName)
     {
        if (attributeName.contains("."))
        {
            return this.getAttributeAsStringParseBeanPath(attributeName);
        }
        else
        {
            Object value = getAttribute(attributeName);

            if (value == null)
                return "";
            else {
                return value.toString().trim();
            }
        }
     }

    // Constructors

    /**
     * default constructor
     */
    public FileType() {
    }

	/** 
	 * minimal constructor
	 *
     * @param name the name
    }
	 */
    public FileType(String name) {
        this.name = name;
    }

    /**
     * full constructor
	 *
     * @param name the name
     * @param description the description
     * @param businessProcessTypeId the businessProcessTypeId
     * @param mimeTypes the mimeTypes
     * @param maxFileSize the maxFileSize
     * @param templateDocumentId the templateDocumentId
     * @param fileTypeGenParameterses the fileTypeGenParameterses
     * @param fileBundleFiles the fileBundleFiles
     */
    public FileType(String name, String description, String businessProcessTypeId, String mimeTypes, Long maxFileSize, Long templateDocumentId, Set<FileTypeGenParameters> fileTypeGenParameterses, Set<FileBundleFile> fileBundleFiles) {
        this.name = name;
        this.description = description;
        this.businessProcessTypeId = businessProcessTypeId;
        this.mimeTypes = mimeTypes;
        this.maxFileSize = maxFileSize;
        this.templateDocumentId = templateDocumentId;
        this.fileTypeGenParameterses = fileTypeGenParameterses;
        this.fileBundleFiles = fileBundleFiles;
    }

    // Property accessors
    
    /**       
     * id getter method
     *
     * @return id method
     */
    public Long getId() {
        return this.id;
    }
    
    /**       
     * id setter method
     *
     * @param id the id
     *
     * @return FileType modified instance
     */
    public FileType setId(Long id) {
        this.id = id;
        
        return this;
    }
    /**       
     * name getter method
     *
     * @return name method
     */
    public String getName() {
        return this.name;
    }
    
    /**       
     * name setter method
     *
     * @param name the name
     *
     * @return FileType modified instance
     */
    public FileType setName(String name) {
        this.name = name;
        
        return this;
    }
    /**       
     * description getter method
     *
     * @return description method
     */
    public String getDescription() {
        return this.description;
    }
    
    /**       
     * description setter method
     *
     * @param description the description
     *
     * @return FileType modified instance
     */
    public FileType setDescription(String description) {
        this.description = description;
        
        return this;
    }
    /**       
     * businessProcessTypeId getter method
     *
     * @return businessProcessTypeId method
     */
    public String getBusinessProcessTypeId() {
        return this.businessProcessTypeId;
    }
    
    /**       
     * businessProcessTypeId setter method
     *
     * @param businessProcessTypeId the businessProcessTypeId
     *
     * @return FileType modified instance
     */
    public FileType setBusinessProcessTypeId(String businessProcessTypeId) {
        this.businessProcessTypeId = businessProcessTypeId;
        
        return this;
    }
    /**       
     * mimeTypes getter method
     *
     * @return mimeTypes method
     */
    public String getMimeTypes() {
        return this.mimeTypes;
    }
    
    /**       
     * mimeTypes setter method
     *
     * @param mimeTypes the mimeTypes
     *
     * @return FileType modified instance
     */
    public FileType setMimeTypes(String mimeTypes) {
        this.mimeTypes = mimeTypes;
        
        return this;
    }
    /**       
     * maxFileSize getter method
     *
     * @return maxFileSize method
     */
    public Long getMaxFileSize() {
        return this.maxFileSize;
    }
    
    /**       
     * maxFileSize setter method
     *
     * @param maxFileSize the maxFileSize
     *
     * @return FileType modified instance
     */
    public FileType setMaxFileSize(Long maxFileSize) {
        this.maxFileSize = maxFileSize;
        
        return this;
    }
    /**       
     * templateDocumentId getter method
     *
     * @return templateDocumentId method
     */
    public Long getTemplateDocumentId() {
        return this.templateDocumentId;
    }
    
    /**       
     * templateDocumentId setter method
     *
     * @param templateDocumentId the templateDocumentId
     *
     * @return FileType modified instance
     */
    public FileType setTemplateDocumentId(Long templateDocumentId) {
        this.templateDocumentId = templateDocumentId;
        
        return this;
    }
    /**       
     * fileTypeGenParameterses getter method
     *
     * @return fileTypeGenParameterses method
     */
    public Set<FileTypeGenParameters> getFileTypeGenParameterses() {
        return this.fileTypeGenParameterses;
    }
    
    /**       
     * fileTypeGenParameterses setter method
     *
     * @param fileTypeGenParameterses the fileTypeGenParameterses
     *
     * @return FileType modified instance
     */
    public FileType setFileTypeGenParameterses(Set<FileTypeGenParameters> fileTypeGenParameterses) {
        this.fileTypeGenParameterses = fileTypeGenParameterses;
        
        return this;
    }
    /**       
     * fileBundleFiles getter method
     *
     * @return fileBundleFiles method
     */
    public Set<FileBundleFile> getFileBundleFiles() {
        return this.fileBundleFiles;
    }
    
    /**       
     * fileBundleFiles setter method
     *
     * @param fileBundleFiles the fileBundleFiles
     *
     * @return FileType modified instance
     */
    public FileType setFileBundleFiles(Set<FileBundleFile> fileBundleFiles) {
        this.fileBundleFiles = fileBundleFiles;
        
        return this;
    }


    /**
     * Creates a String representation of the FileType object
     *
     * @return the compiled String
     */
    @Override
    public String toString() {
	    StringBuffer buffer = new StringBuffer();

        buffer.append(getClass().getName()).append("@").append(Integer.toHexString(hashCode())).append(" [");

        buffer.append("id").append("='").append(getId()).append("' ");			
        buffer.append("name").append("='").append(getName()).append("' ");			
        buffer.append("description").append("='").append(getDescription()).append("' ");			
        buffer.append("businessProcessTypeId").append("='").append(getBusinessProcessTypeId()).append("' ");			
        buffer.append("mimeTypes").append("='").append(getMimeTypes()).append("' ");			
        buffer.append("maxFileSize").append("='").append(getMaxFileSize()).append("' ");			
        buffer.append("templateDocumentId").append("='").append(getTemplateDocumentId()).append("' ");			
        buffer.append("]");
      
        return buffer.toString();
    }

    /**
     * Compares the String representation of the FileType object
     *
     * @param other The object to compare to
     *
     * @return true of the objects are equal
     */
    public boolean equals(FileType other) {
        	return this.toString().equals(other.toString());
    }
    /**
     * @see pt.digitalis.utils.common.IBeanAttributes#setAttributeFromString(java.lang.String, java.lang.String)
     */
    public void setAttributeFromString(String attributeName, String attributeValue) {
        if ("id".equalsIgnoreCase(attributeName))
            this.id = Long.valueOf(attributeValue);

        if ("name".equalsIgnoreCase(attributeName))
        	this.name = attributeValue;

        if ("description".equalsIgnoreCase(attributeName))
        	this.description = attributeValue;

        if ("businessProcessTypeId".equalsIgnoreCase(attributeName))
        	this.businessProcessTypeId = attributeValue;

        if ("mimeTypes".equalsIgnoreCase(attributeName))
        	this.mimeTypes = attributeValue;

        if ("maxFileSize".equalsIgnoreCase(attributeName))
            this.maxFileSize = Long.valueOf(attributeValue);

        if ("templateDocumentId".equalsIgnoreCase(attributeName))
            this.templateDocumentId = Long.valueOf(attributeValue);

    }


    /**
     * Instanciates an Hibernate proxy data object (does not load it from the database, provides lazy load for that)
     *
     * @param session the session
     * @param id      the id
     *
     * @return the proxy
     */
    public static FileType getProxy(Session session, Long id)
    {
        return(FileType)session.load(FileType.class,id);
    }

    /**
    * Instanciates an Hibernate proxy data object (does not load it from the database, provides lazy load for that)
    *
    * @param id      the id
    *
    * @return the proxy
    */
    public static FileType getProxy(Long id)
    {
        Session session = HibernateUtil.getSessionFactory(SESSION_FACTORY_NAME).getCurrentSession();
        boolean wasActive = session.getTransaction().isActive();

        if (!wasActive)
            session.beginTransaction();

        FileType result = (FileType)session.load(FileType.class,id);

        if (!wasActive)
            session.getTransaction().commit();

        return result;
    }


    /**
     * Instanciates an Hibernate data object
     *
     * @param session the session
     * @param id      the id
     *
     * @return the instance
     */
    public static FileType getInstanceForSession(Session session, Long id)
    {
        return(FileType)session.get(FileType.class,id);
    }

    /**
    * Instanciates an Hibernate data object
    *
    * @param id      the id
    *
    * @return the instance
    */
    public static FileType getInstance(Long id)
    {
        Session session = HibernateUtil.getSessionFactory(SESSION_FACTORY_NAME).getCurrentSession();
        boolean wasActive = session.getTransaction().isActive();

        if (!wasActive)
            session.beginTransaction();

        FileType result = (FileType)session.get(FileType.class,id);

        if (!wasActive)
            session.getTransaction().commit();

        return result;
    }

}
