package pt.digitalis.dif.dem.managers.impl.model.data;

import pt.digitalis.utils.common.AttributeDefinition;
import pt.digitalis.dif.model.utils.AbstractBeanAttributesDefinition;

import java.sql.Timestamp;
import java.sql.Blob;
import java.util.Date;
import java.math.BigDecimal;

import java.util.Arrays;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pt.digitalis.utils.common.collections.CaseInsensitiveHashMap;

import org.hibernate.Session;


/**
 *  Field definitions for data object {@link JasperReportTemplate}
 *
 * NOTE: This file is auto generated and will be overwritten in a future file generation.
 */
public class JasperReportTemplateFieldAttributes extends AbstractBeanAttributesDefinition{

    /** businessId (Database column: BUSINESS_ID) */
    static public AttributeDefinition businessId =
        new AttributeDefinition("businessId")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("JASPER_REPORT_TEMPLATE")
                .setDatabaseId("BUSINESS_ID")
                .setMandatory(false)
                .setMaxSize(255)
                .setType(String.class);

    /** configId (Database column: CONFIG_ID - Configuration ID (each application can have a diferent set of templates)) */
    static public AttributeDefinition configId =
        new AttributeDefinition("configId")
                .setDescription("Configuration ID (each application can have a diferent set of templates)")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("JASPER_REPORT_TEMPLATE")
                .setDatabaseId("CONFIG_ID")
                .setMandatory(true)
                .setMaxSize(255)
                .setType(String.class);

    /** description (Database column: DESCRIPTION - A full description) */
    static public AttributeDefinition description =
        new AttributeDefinition("description")
                .setDescription("A full description")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("JASPER_REPORT_TEMPLATE")
                .setDatabaseId("DESCRIPTION")
                .setMandatory(false)
                .setMaxSize(4000)
                .setType(String.class);

    /** id (Database column: ID - ID) */
    static public AttributeDefinition id =
        new AttributeDefinition("id")
                .setDescription("ID")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("JASPER_REPORT_TEMPLATE")
                .setDatabaseId("ID")
                .setMandatory(true)
                .setMaxSize(10)
                .setType(Long.class);

    /** isEnabled (Database column: IS_ENABLED - Is enabled) */
    static public AttributeDefinition isEnabled =
        new AttributeDefinition("isEnabled")
                .setDescription("Is enabled")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("JASPER_REPORT_TEMPLATE")
                .setDatabaseId("IS_ENABLED")
                .setMandatory(true)
                .setMaxSize(1)
                .setTreatAsBoolean(true)
                .setBooleanFalseValue("0")
                .setBooleanTrueValue("1")
                .setLovFixedList(Arrays.asList(new String[]{"1","0"}))
                .setType(boolean.class);

    /** logExecution (Database column: LOG_EXECUTION - If the report executions should be logged.) */
    static public AttributeDefinition logExecution =
        new AttributeDefinition("logExecution")
                .setDescription("If the report executions should be logged.")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("JASPER_REPORT_TEMPLATE")
                .setDatabaseId("LOG_EXECUTION")
                .setMandatory(true)
                .setMaxSize(1)
                .setTreatAsBoolean(true)
                .setBooleanFalseValue("0")
                .setBooleanTrueValue("1")
                .setLovFixedList(Arrays.asList(new String[]{"1","0"}))
                .setType(boolean.class);

    /** logFileResult (Database column: LOG_FILE_RESULT - If the report file output should be logged.) */
    static public AttributeDefinition logFileResult =
        new AttributeDefinition("logFileResult")
                .setDescription("If the report file output should be logged.")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("JASPER_REPORT_TEMPLATE")
                .setDatabaseId("LOG_FILE_RESULT")
                .setMandatory(true)
                .setMaxSize(1)
                .setTreatAsBoolean(true)
                .setBooleanFalseValue("0")
                .setBooleanTrueValue("1")
                .setLovFixedList(Arrays.asList(new String[]{"1","0"}))
                .setType(boolean.class);

    /** jasperReportTemplateFile (Database column: TEMPLATE_FILE_ID - The jasper report template file) */
    static public AttributeDefinition jasperReportTemplateFile =
        new AttributeDefinition("jasperReportTemplateFile")
                .setDescription("The jasper report template file")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("JASPER_REPORT_TEMPLATE")
                .setDatabaseId("TEMPLATE_FILE_ID")
                .setMandatory(false)
                .setMaxSize(10)
                .setType(pt.digitalis.dif.dem.managers.impl.model.data.JasperReportTemplateFile.class);

    /** templatePath (Database column: TEMPLATE_PATH - The jasper report template path) */
    static public AttributeDefinition templatePath =
        new AttributeDefinition("templatePath")
                .setDescription("The jasper report template path")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("JASPER_REPORT_TEMPLATE")
                .setDatabaseId("TEMPLATE_PATH")
                .setMandatory(false)
                .setMaxSize(1000)
                .setType(String.class);

    /** title (Database column: TITLE - The title) */
    static public AttributeDefinition title =
        new AttributeDefinition("title")
                .setDescription("The title")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("JASPER_REPORT_TEMPLATE")
                .setDatabaseId("TITLE")
                .setMandatory(true)
                .setMaxSize(500)
                .setType(String.class);

    /** type (Database column: TYPE - The template type 1=TemplatePathOnServer,2=TemplateUploadedFiles) */
    static public AttributeDefinition type =
        new AttributeDefinition("type")
                .setDescription("The template type 1=TemplatePathOnServer,2=TemplateUploadedFiles")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("JASPER_REPORT_TEMPLATE")
                .setDatabaseId("TYPE")
                .setMandatory(true)
                .setMaxSize(2)
                .setType(Long.class);

    /**
     * Gets description field.
     *
     * @return the description field
     */
    public static String getDescriptionField()
    {
        return "description";
    }

    /**
    * Create definitions map map.
    *
    * @return the map
    */
    @Override protected CaseInsensitiveHashMap<AttributeDefinition> createDefinitionsMap(){
        CaseInsensitiveHashMap<AttributeDefinition> map = new CaseInsensitiveHashMap<AttributeDefinition>();
        map.put(businessId.getName(),businessId);
        map.put(configId.getName(),configId);
        map.put(description.getName(),description);
        map.put(id.getName(),id);
        map.put(isEnabled.getName(),isEnabled);
        map.put(logExecution.getName(),logExecution);
        map.put(logFileResult.getName(),logFileResult);
        map.put(jasperReportTemplateFile.getName(),jasperReportTemplateFile);
        map.put(templatePath.getName(),templatePath);
        map.put(title.getName(),title);
        map.put(type.getName(),type);

        return map;
    }
}