package pt.digitalis.dif.dem.managers.impl.model.data;


import java.util.ArrayList;
import java.util.List;
import org.hibernate.Session;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.hibernate.HibernateUtil;
import pt.digitalis.dif.model.utils.AbstractBeanRelationsAttributes;
import pt.digitalis.dif.model.utils.IBeanAttributesDataSet;

/**
 * JasperReportTemplateParam
* Generated on ORM Generator
* DIF build process for the Model layer
*
*/
@SuppressWarnings("serial")
public class JasperReportTemplateParam extends AbstractBeanRelationsAttributes implements java.io.Serializable, IBeanAttributesDataSet<JasperReportTemplateParam> {

    /**
    * Constant with the session factory ID
    */
    public static String SESSION_FACTORY_NAME = "DIFRepository";

    /** JasperReportTemplateParam attributes enumeration */
    public static class Fields
    {
        /** id column */
        public static final String ID ="id";
        /** parameterId column */
        public static final String PARAMETERID ="parameterId";
        /** parameterName column */
        public static final String PARAMETERNAME ="parameterName";
        /** parameterOptionsType column */
        public static final String PARAMETEROPTIONSTYPE ="parameterOptionsType";
        /** parameterOptionsList column */
        public static final String PARAMETEROPTIONSLIST ="parameterOptionsList";
        /** parameterOptionsSql column */
        public static final String PARAMETEROPTIONSSQL ="parameterOptionsSql";
        /** isEnabled column */
        public static final String ISENABLED ="isEnabled";

        /**
         * List of existing fields
         *
         * @return list of field names
         */
        public static List<String> values()
        {
            ArrayList<String> list = new ArrayList<String>();
            list.add("id");
            list.add("parameterId");
            list.add("parameterName");
            list.add("parameterOptionsType");
            list.add("parameterOptionsList");
            list.add("parameterOptionsSql");
            list.add("isEnabled");

            return list;
        }
    }

    /** Field attributes */
    public static JasperReportTemplateParamFieldAttributes FieldAttributes=new JasperReportTemplateParamFieldAttributes();

    /**
    * @return the field attributes definitions
    */
    @Override public JasperReportTemplateParamFieldAttributes getDefinitions()
    {
        return FieldAttributes;
    }

    /**
     * The Class Relations.
     */
    public class Relations extends AbstractBeanRelationsAttributes.AbstractRelations
    {

        /**
        * Instantiates a new relations.
        *
        * @param currentPath the current path
        */
        public Relations(String currentPath)
        {
            super(currentPath);
        }
        /**
         * jasperReportTemplate relation.
         *
         * @return the jasperReportTemplate bean relations attributes.
         */
        public JasperReportTemplate.Relations jasperReportTemplate()
        {
            JasperReportTemplate c = new JasperReportTemplate();
            return c.new Relations(this.buildPath("jasperReportTemplate"));
        }

        /**
         * the ID path.
         *
         * @return the path
         */
        public String ID()
        {
            return buildPath(Fields.ID);
        }
        /**
         * the PARAMETERID path.
         *
         * @return the path
         */
        public String PARAMETERID()
        {
            return buildPath(Fields.PARAMETERID);
        }
        /**
         * the PARAMETERNAME path.
         *
         * @return the path
         */
        public String PARAMETERNAME()
        {
            return buildPath(Fields.PARAMETERNAME);
        }
        /**
         * the PARAMETEROPTIONSTYPE path.
         *
         * @return the path
         */
        public String PARAMETEROPTIONSTYPE()
        {
            return buildPath(Fields.PARAMETEROPTIONSTYPE);
        }
        /**
         * the PARAMETEROPTIONSLIST path.
         *
         * @return the path
         */
        public String PARAMETEROPTIONSLIST()
        {
            return buildPath(Fields.PARAMETEROPTIONSLIST);
        }
        /**
         * the PARAMETEROPTIONSSQL path.
         *
         * @return the path
         */
        public String PARAMETEROPTIONSSQL()
        {
            return buildPath(Fields.PARAMETEROPTIONSSQL);
        }
        /**
         * the ISENABLED path.
         *
         * @return the path
         */
        public String ISENABLED()
        {
            return buildPath(Fields.ISENABLED);
        }
    }

    /** The dummy obj. */
    private static JasperReportTemplateParam dummyObj=new JasperReportTemplateParam();

    /**
     * Get JasperReportTemplateParam Relations .
     *
     * @return the relations
     */
    public static Relations FK()
    {
        return dummyObj.new Relations(null);
    }

    /**
    * Gets a new dataSet object for this bean
    *
    * @return the dataSet
    */
    public IDataSet<JasperReportTemplateParam> getDataSet()
    {
        return getDataSetInstance();
    }

    /**
    * Gets a new dataSet object for this bean
    *
    * @return the dataSet
    */
    public static IDataSet<JasperReportTemplateParam> getDataSetInstance()
    {
        return new HibernateDataSet<JasperReportTemplateParam>(JasperReportTemplateParam.class, HibernateUtil.getSessionFactory(SESSION_FACTORY_NAME),
            JasperReportTemplateParam.getPKFieldListAsString(), JasperReportTemplateParam.FieldAttributes);
    }

    /**
    * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeNoGraphNavigation(java.lang.String)
    */
    @Override protected Object getAttributeNoGraphNavigation(String attributeName)
    {
        if("id".equalsIgnoreCase(attributeName))
            return id;
        if("jasperReportTemplate".equalsIgnoreCase(attributeName))
            return jasperReportTemplate;
        if("parameterId".equalsIgnoreCase(attributeName))
            return parameterId;
        if("parameterName".equalsIgnoreCase(attributeName))
            return parameterName;
        if("parameterOptionsType".equalsIgnoreCase(attributeName))
            return parameterOptionsType;
        if("parameterOptionsList".equalsIgnoreCase(attributeName))
            return parameterOptionsList;
        if("parameterOptionsSql".equalsIgnoreCase(attributeName))
            return parameterOptionsSql;
        if("isEnabled".equalsIgnoreCase(attributeName))
            return isEnabled;

        return null;
    }

    /**
    * @see pt.digitalis.utils.common.IBeanAttributes#setAttribute(java.lang.String, java.lang.Object)
    */
    public void setAttribute(String attributeName,Object attributeValue)
    {
        if("id".equalsIgnoreCase(attributeName))
            id =(Long)attributeValue;
        if("jasperReportTemplate".equalsIgnoreCase(attributeName))
            jasperReportTemplate =(JasperReportTemplate)attributeValue;
        if("parameterId".equalsIgnoreCase(attributeName))
            parameterId =(String)attributeValue;
        if("parameterName".equalsIgnoreCase(attributeName))
            parameterName =(String)attributeValue;
        if("parameterOptionsType".equalsIgnoreCase(attributeName))
            parameterOptionsType =(Long)attributeValue;
        if("parameterOptionsList".equalsIgnoreCase(attributeName))
            parameterOptionsList =(String)attributeValue;
        if("parameterOptionsSql".equalsIgnoreCase(attributeName))
            parameterOptionsSql =(String)attributeValue;
        if("isEnabled".equalsIgnoreCase(attributeName))
            isEnabled =(Boolean)attributeValue;
    }

    // Fields

    /** id private attribute */
    private Long id;

    /** jasperReportTemplate private attribute */
    private JasperReportTemplate jasperReportTemplate;

    /** parameterId private attribute */
    private String parameterId;

    /** parameterName private attribute */
    private String parameterName;

    /** parameterOptionsType private attribute */
    private Long parameterOptionsType;

    /** parameterOptionsList private attribute */
    private String parameterOptionsList;

    /** parameterOptionsSql private attribute */
    private String parameterOptionsSql;

    /** isEnabled private attribute */
    private boolean isEnabled;

    /** The pojo's primary key field list names */
    private static List<String> pkFieldList;

    /**
     * Get the table fields that compose the PK
     *
     * @return the PK field list
     */
     public synchronized static List<String> getPKFieldList()
     {
         if (pkFieldList == null)
         {
             pkFieldList = new ArrayList<String>();
             pkFieldList.add("id");
         }

         return pkFieldList;
     }

    /**
     * Get the table fields that compose the PK as a comma separated field name list
     *
     * @return the PK field list as a string
     */
     public static String getPKFieldListAsString()
     {
         StringBuffer buffer = new StringBuffer();

         for (int i = 0; i < getPKFieldList().size(); i++)
         {
             if (i != 0)
                 buffer.append(",");

             buffer.append(getPKFieldList().get(i));
         }

         return buffer.toString();
     }

    /**
     * Gets description field.
     *
     * @return the description field
     */
    @Override
    public String getDescriptionField()
    {
        return FieldAttributes.getDescriptionField();
    }

    /**
     * Get the table fields that compose the PK
     *
     * @return the PK field list
     */
    @Override
    public List<String> getPKFields()
    {
        return getPKFieldList();
    }

    /**
     * Is composite PK.
     *
     * @return the boolean
     */
    @Override
    public boolean isCompositePK()
    {
        return this.getPKFieldList().size() > 1;
    }

    /**
     * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeAsString(java.lang.String)
     */
     @Override
     public String getAttributeAsString(String attributeName)
     {
        if (attributeName.contains("."))
        {
            return this.getAttributeAsStringParseBeanPath(attributeName);
        }
        else
        {
            Object value = getAttribute(attributeName);

            if (value == null)
                return "";
            else {
                return value.toString().trim();
            }
        }
     }

    // Constructors

    /**
     * default constructor
     */
    public JasperReportTemplateParam() {
    }

	/** 
	 * minimal constructor
	 *
     * @param jasperReportTemplate the jasperReportTemplate
     * @param parameterId the parameterId
     * @param parameterName the parameterName
     * @param parameterOptionsType the parameterOptionsType
     * @param isEnabled the isEnabled
    }
	 */
    public JasperReportTemplateParam(JasperReportTemplate jasperReportTemplate, String parameterId, String parameterName, Long parameterOptionsType, boolean isEnabled) {
        this.jasperReportTemplate = jasperReportTemplate;
        this.parameterId = parameterId;
        this.parameterName = parameterName;
        this.parameterOptionsType = parameterOptionsType;
        this.isEnabled = isEnabled;
    }

    /**
     * full constructor
	 *
     * @param jasperReportTemplate the jasperReportTemplate
     * @param parameterId the parameterId
     * @param parameterName the parameterName
     * @param parameterOptionsType the parameterOptionsType
     * @param parameterOptionsList the parameterOptionsList
     * @param parameterOptionsSql the parameterOptionsSql
     * @param isEnabled the isEnabled
     */
    public JasperReportTemplateParam(JasperReportTemplate jasperReportTemplate, String parameterId, String parameterName, Long parameterOptionsType, String parameterOptionsList, String parameterOptionsSql, boolean isEnabled) {
        this.jasperReportTemplate = jasperReportTemplate;
        this.parameterId = parameterId;
        this.parameterName = parameterName;
        this.parameterOptionsType = parameterOptionsType;
        this.parameterOptionsList = parameterOptionsList;
        this.parameterOptionsSql = parameterOptionsSql;
        this.isEnabled = isEnabled;
    }

    // Property accessors
    
    /**       
     * id getter method
     *
     * @return id method
     */
    public Long getId() {
        return this.id;
    }
    
    /**       
     * id setter method
     *
     * @param id the id
     *
     * @return JasperReportTemplateParam modified instance
     */
    public JasperReportTemplateParam setId(Long id) {
        this.id = id;
        
        return this;
    }
    /**       
     * jasperReportTemplate getter method
     *
     * @return jasperReportTemplate method
     */
    public JasperReportTemplate getJasperReportTemplate() {
        return this.jasperReportTemplate;
    }
    
    /**       
     * jasperReportTemplate setter method
     *
     * @param jasperReportTemplate the jasperReportTemplate
     *
     * @return JasperReportTemplateParam modified instance
     */
    public JasperReportTemplateParam setJasperReportTemplate(JasperReportTemplate jasperReportTemplate) {
        this.jasperReportTemplate = jasperReportTemplate;
        
        return this;
    }
    /**       
     * parameterId getter method
     *
     * @return parameterId method
     */
    public String getParameterId() {
        return this.parameterId;
    }
    
    /**       
     * parameterId setter method
     *
     * @param parameterId the parameterId
     *
     * @return JasperReportTemplateParam modified instance
     */
    public JasperReportTemplateParam setParameterId(String parameterId) {
        this.parameterId = parameterId;
        
        return this;
    }
    /**       
     * parameterName getter method
     *
     * @return parameterName method
     */
    public String getParameterName() {
        return this.parameterName;
    }
    
    /**       
     * parameterName setter method
     *
     * @param parameterName the parameterName
     *
     * @return JasperReportTemplateParam modified instance
     */
    public JasperReportTemplateParam setParameterName(String parameterName) {
        this.parameterName = parameterName;
        
        return this;
    }
    /**       
     * parameterOptionsType getter method
     *
     * @return parameterOptionsType method
     */
    public Long getParameterOptionsType() {
        return this.parameterOptionsType;
    }
    
    /**       
     * parameterOptionsType setter method
     *
     * @param parameterOptionsType the parameterOptionsType
     *
     * @return JasperReportTemplateParam modified instance
     */
    public JasperReportTemplateParam setParameterOptionsType(Long parameterOptionsType) {
        this.parameterOptionsType = parameterOptionsType;
        
        return this;
    }
    /**       
     * parameterOptionsList getter method
     *
     * @return parameterOptionsList method
     */
    public String getParameterOptionsList() {
        return this.parameterOptionsList;
    }
    
    /**       
     * parameterOptionsList setter method
     *
     * @param parameterOptionsList the parameterOptionsList
     *
     * @return JasperReportTemplateParam modified instance
     */
    public JasperReportTemplateParam setParameterOptionsList(String parameterOptionsList) {
        this.parameterOptionsList = parameterOptionsList;
        
        return this;
    }
    /**       
     * parameterOptionsSql getter method
     *
     * @return parameterOptionsSql method
     */
    public String getParameterOptionsSql() {
        return this.parameterOptionsSql;
    }
    
    /**       
     * parameterOptionsSql setter method
     *
     * @param parameterOptionsSql the parameterOptionsSql
     *
     * @return JasperReportTemplateParam modified instance
     */
    public JasperReportTemplateParam setParameterOptionsSql(String parameterOptionsSql) {
        this.parameterOptionsSql = parameterOptionsSql;
        
        return this;
    }
    /**       
     * isEnabled getter method
     *
     * @return isEnabled method
     */
    public boolean isIsEnabled() {
        return this.isEnabled;
    }
    
    /**       
     * isEnabled setter method
     *
     * @param isEnabled the isEnabled
     *
     * @return JasperReportTemplateParam modified instance
     */
    public JasperReportTemplateParam setIsEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
        
        return this;
    }

    /**
     * jasperReportTemplate id getter method
     *
     * @return jasperReportTemplate id method
     */
    public Long getJasperReportTemplateId() {
        if (this.jasperReportTemplate == null)
            return null;
        else
            return this.jasperReportTemplate.getId();
    }

    /**
     * JasperReportTemplate proxy setter method from id.
     *
     * @return JasperReportTemplateParam modified instance
     */
    public JasperReportTemplateParam setJasperReportTemplateProxyFromId(Long id)
    {
        if (id == null || id.equals(-1L))
            this.jasperReportTemplate = null;
        else
            this.jasperReportTemplate = JasperReportTemplate.getProxy(id);

        return this;
    }

    /**
     * JasperReportTemplate instance setter method from id.
     *
     * @return JasperReportTemplateParam modified instance
     */
    public JasperReportTemplateParam setJasperReportTemplateInstanceFromId(Long id)
    {
        if (id == null || id.equals(-1L))
            this.jasperReportTemplate = null;
        else
            this.jasperReportTemplate = JasperReportTemplate.getInstance(id);

        return this;
    }

    /**
     * Creates a String representation of the JasperReportTemplateParam object
     *
     * @return the compiled String
     */
    @Override
    public String toString() {
	    StringBuffer buffer = new StringBuffer();

        buffer.append(getClass().getName()).append("@").append(Integer.toHexString(hashCode())).append(" [");

        buffer.append("id").append("='").append(getId()).append("' ");			
        buffer.append("parameterId").append("='").append(getParameterId()).append("' ");			
        buffer.append("parameterName").append("='").append(getParameterName()).append("' ");			
        buffer.append("parameterOptionsType").append("='").append(getParameterOptionsType()).append("' ");			
        buffer.append("parameterOptionsList").append("='").append(getParameterOptionsList()).append("' ");			
        buffer.append("parameterOptionsSql").append("='").append(getParameterOptionsSql()).append("' ");			
        buffer.append("isEnabled").append("='").append(isIsEnabled()).append("' ");			
        buffer.append("]");
      
        return buffer.toString();
    }

    /**
     * Compares the String representation of the JasperReportTemplateParam object
     *
     * @param other The object to compare to
     *
     * @return true of the objects are equal
     */
    public boolean equals(JasperReportTemplateParam other) {
        	return this.toString().equals(other.toString());
    }
    /**
     * @see pt.digitalis.utils.common.IBeanAttributes#setAttributeFromString(java.lang.String, java.lang.String)
     */
    public void setAttributeFromString(String attributeName, String attributeValue) {
        if ("id".equalsIgnoreCase(attributeName))
            this.id = Long.valueOf(attributeValue);

        if ("parameterId".equalsIgnoreCase(attributeName))
        	this.parameterId = attributeValue;

        if ("parameterName".equalsIgnoreCase(attributeName))
        	this.parameterName = attributeValue;

        if ("parameterOptionsType".equalsIgnoreCase(attributeName))
            this.parameterOptionsType = Long.valueOf(attributeValue);

        if ("parameterOptionsList".equalsIgnoreCase(attributeName))
        	this.parameterOptionsList = attributeValue;

        if ("parameterOptionsSql".equalsIgnoreCase(attributeName))
        	this.parameterOptionsSql = attributeValue;

        if ("isEnabled".equalsIgnoreCase(attributeName))
            this.isEnabled = Boolean.valueOf(attributeValue);

    }


    /**
     * Instanciates an Hibernate proxy data object (does not load it from the database, provides lazy load for that)
     *
     * @param session the session
     * @param id      the id
     *
     * @return the proxy
     */
    public static JasperReportTemplateParam getProxy(Session session, Long id)
    {
        return(JasperReportTemplateParam)session.load(JasperReportTemplateParam.class,id);
    }

    /**
    * Instanciates an Hibernate proxy data object (does not load it from the database, provides lazy load for that)
    *
    * @param id      the id
    *
    * @return the proxy
    */
    public static JasperReportTemplateParam getProxy(Long id)
    {
        Session session = HibernateUtil.getSessionFactory(SESSION_FACTORY_NAME).getCurrentSession();
        boolean wasActive = session.getTransaction().isActive();

        if (!wasActive)
            session.beginTransaction();

        JasperReportTemplateParam result = (JasperReportTemplateParam)session.load(JasperReportTemplateParam.class,id);

        if (!wasActive)
            session.getTransaction().commit();

        return result;
    }


    /**
     * Instanciates an Hibernate data object
     *
     * @param session the session
     * @param id      the id
     *
     * @return the instance
     */
    public static JasperReportTemplateParam getInstanceForSession(Session session, Long id)
    {
        return(JasperReportTemplateParam)session.get(JasperReportTemplateParam.class,id);
    }

    /**
    * Instanciates an Hibernate data object
    *
    * @param id      the id
    *
    * @return the instance
    */
    public static JasperReportTemplateParam getInstance(Long id)
    {
        Session session = HibernateUtil.getSessionFactory(SESSION_FACTORY_NAME).getCurrentSession();
        boolean wasActive = session.getTransaction().isActive();

        if (!wasActive)
            session.beginTransaction();

        JasperReportTemplateParam result = (JasperReportTemplateParam)session.get(JasperReportTemplateParam.class,id);

        if (!wasActive)
            session.getTransaction().commit();

        return result;
    }

}
