package pt.digitalis.dif.dem.managers.impl.model.data;

import pt.digitalis.utils.common.AttributeDefinition;
import pt.digitalis.dif.model.utils.AbstractBeanAttributesDefinition;

import java.sql.Timestamp;
import java.sql.Blob;
import java.util.Date;
import java.math.BigDecimal;

import java.util.Arrays;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pt.digitalis.utils.common.collections.CaseInsensitiveHashMap;

import org.hibernate.Session;


/**
 *  Field definitions for data object {@link Manager}
 *
 * NOTE: This file is auto generated and will be overwritten in a future file generation.
 */
public class ManagerFieldAttributes extends AbstractBeanAttributesDefinition{

    /** id (Database column: ID - ID column) */
    static public AttributeDefinition id =
        new AttributeDefinition("id")
                .setDescription("ID column")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("MANAGER")
                .setDatabaseId("ID")
                .setMandatory(true)
                .setMaxSize(10)
                .setType(Long.class);

    /** uniqueId (Database column: UNIQUE_ID - Business unique ID) */
    static public AttributeDefinition uniqueId =
        new AttributeDefinition("uniqueId")
                .setDescription("Business unique ID")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("MANAGER")
                .setDatabaseId("UNIQUE_ID")
                .setMandatory(true)
                .setMaxSize(200)
                .setType(String.class);

    /**
     * Gets description field.
     *
     * @return the description field
     */
    public static String getDescriptionField()
    {
        return "uniqueId";
    }

    /**
    * Create definitions map map.
    *
    * @return the map
    */
    @Override protected CaseInsensitiveHashMap<AttributeDefinition> createDefinitionsMap(){
        CaseInsensitiveHashMap<AttributeDefinition> map = new CaseInsensitiveHashMap<AttributeDefinition>();
        map.put(id.getName(),id);
        map.put(uniqueId.getName(),uniqueId);

        return map;
    }
}