package pt.digitalis.dif.dem.managers.impl.model.data;

import pt.digitalis.utils.common.AttributeDefinition;
import pt.digitalis.dif.model.utils.AbstractBeanAttributesDefinition;

import java.sql.Timestamp;
import java.sql.Blob;
import java.util.Date;
import java.math.BigDecimal;

import java.util.Arrays;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pt.digitalis.utils.common.collections.CaseInsensitiveHashMap;

import org.hibernate.Session;


/**
 *  Field definitions for data object {@link PersistentAction}
 *
 * NOTE: This file is auto generated and will be overwritten in a future file generation.
 */
public class PersistentActionFieldAttributes extends AbstractBeanAttributesDefinition{

    /** actionId (Database column: ACTION_ID - ACTION INTERNAL ID) */
    static public AttributeDefinition actionId =
        new AttributeDefinition("actionId")
                .setDescription("ACTION INTERNAL ID")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("PERSISTENT_ACTION")
                .setDatabaseId("ACTION_ID")
                .setMandatory(false)
                .setMaxSize(22)
                .setType(Long.class);

    /** id (Database column: ID - O IDENTIFICADOR UNICO DA ACTION NA BD) */
    static public AttributeDefinition id =
        new AttributeDefinition("id")
                .setDescription("O IDENTIFICADOR UNICO DA ACTION NA BD")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("PERSISTENT_ACTION")
                .setDatabaseId("ID")
                .setMandatory(true)
                .setMaxSize(22)
                .setType(Long.class);

    /** objectAction (Database column: OBJECT_ACTION - O OBJECTO ACTION SERIALIZED) */
    static public AttributeDefinition objectAction =
        new AttributeDefinition("objectAction")
                .setDescription("O OBJECTO ACTION SERIALIZED")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("PERSISTENT_ACTION")
                .setDatabaseId("OBJECT_ACTION")
                .setMandatory(true)
                .setMaxSize(4000)
                .setType(Blob.class);

    /** poolName (Database column: POOL_NAME - O NOME UNICO DA POOL QUE CRIOU A ACTION) */
    static public AttributeDefinition poolName =
        new AttributeDefinition("poolName")
                .setDescription("O NOME UNICO DA POOL QUE CRIOU A ACTION")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("PERSISTENT_ACTION")
                .setDatabaseId("POOL_NAME")
                .setMandatory(false)
                .setMaxSize(250)
                .setType(String.class);

    /**
     * Gets description field.
     *
     * @return the description field
     */
    public static String getDescriptionField()
    {
        return null;
    }

    /**
    * Create definitions map map.
    *
    * @return the map
    */
    @Override protected CaseInsensitiveHashMap<AttributeDefinition> createDefinitionsMap(){
        CaseInsensitiveHashMap<AttributeDefinition> map = new CaseInsensitiveHashMap<AttributeDefinition>();
        map.put(actionId.getName(),actionId);
        map.put(id.getName(),id);
        map.put(objectAction.getName(),objectAction);
        map.put(poolName.getName(),poolName);

        return map;
    }
}