package pt.digitalis.dif.dem.managers.impl.model.data;


import java.util.ArrayList;
import java.util.List;
import org.hibernate.Session;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.hibernate.HibernateUtil;
import pt.digitalis.dif.model.utils.AbstractBeanRelationsAttributes;
import pt.digitalis.dif.model.utils.IBeanAttributesDataSet;

/**
 * ReportInstanceAreaSql
* Generated on ORM Generator
* DIF build process for the Model layer
*
*/
@SuppressWarnings("serial")
public class ReportInstanceAreaSql extends AbstractBeanRelationsAttributes implements java.io.Serializable, IBeanAttributesDataSet<ReportInstanceAreaSql> {

    /**
    * Constant with the session factory ID
    */
    public static String SESSION_FACTORY_NAME = "DIFRepository";

    /** ReportInstanceAreaSql attributes enumeration */
    public static class Fields
    {
        /** id column */
        public static final String ID ="id";
        /** name column */
        public static final String NAME ="name";
        /** sql column */
        public static final String SQL ="sql";

        /**
         * List of existing fields
         *
         * @return list of field names
         */
        public static List<String> values()
        {
            ArrayList<String> list = new ArrayList<String>();
            list.add("id");
            list.add("name");
            list.add("sql");

            return list;
        }
    }

    /** Field attributes */
    public static ReportInstanceAreaSqlFieldAttributes FieldAttributes=new ReportInstanceAreaSqlFieldAttributes();

    /**
    * @return the field attributes definitions
    */
    @Override public ReportInstanceAreaSqlFieldAttributes getDefinitions()
    {
        return FieldAttributes;
    }

    /**
     * The Class Relations.
     */
    public class Relations extends AbstractBeanRelationsAttributes.AbstractRelations
    {

        /**
        * Instantiates a new relations.
        *
        * @param currentPath the current path
        */
        public Relations(String currentPath)
        {
            super(currentPath);
        }
        /**
         * sqlDataSource relation.
         *
         * @return the sqlDataSource bean relations attributes.
         */
        public SqlDataSource.Relations sqlDataSource()
        {
            SqlDataSource c = new SqlDataSource();
            return c.new Relations(this.buildPath("sqlDataSource"));
        }

        /**
         * reportInstanceArea relation.
         *
         * @return the reportInstanceArea bean relations attributes.
         */
        public ReportInstanceArea.Relations reportInstanceArea()
        {
            ReportInstanceArea c = new ReportInstanceArea();
            return c.new Relations(this.buildPath("reportInstanceArea"));
        }

        /**
         * the ID path.
         *
         * @return the path
         */
        public String ID()
        {
            return buildPath(Fields.ID);
        }
        /**
         * the NAME path.
         *
         * @return the path
         */
        public String NAME()
        {
            return buildPath(Fields.NAME);
        }
        /**
         * the SQL path.
         *
         * @return the path
         */
        public String SQL()
        {
            return buildPath(Fields.SQL);
        }
    }

    /** The dummy obj. */
    private static ReportInstanceAreaSql dummyObj=new ReportInstanceAreaSql();

    /**
     * Get ReportInstanceAreaSql Relations .
     *
     * @return the relations
     */
    public static Relations FK()
    {
        return dummyObj.new Relations(null);
    }

    /**
    * Gets a new dataSet object for this bean
    *
    * @return the dataSet
    */
    public IDataSet<ReportInstanceAreaSql> getDataSet()
    {
        return getDataSetInstance();
    }

    /**
    * Gets a new dataSet object for this bean
    *
    * @return the dataSet
    */
    public static IDataSet<ReportInstanceAreaSql> getDataSetInstance()
    {
        return new HibernateDataSet<ReportInstanceAreaSql>(ReportInstanceAreaSql.class, HibernateUtil.getSessionFactory(SESSION_FACTORY_NAME),
            ReportInstanceAreaSql.getPKFieldListAsString(), ReportInstanceAreaSql.FieldAttributes);
    }

    /**
    * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeNoGraphNavigation(java.lang.String)
    */
    @Override protected Object getAttributeNoGraphNavigation(String attributeName)
    {
        if("id".equalsIgnoreCase(attributeName))
            return id;
        if("sqlDataSource".equalsIgnoreCase(attributeName))
            return sqlDataSource;
        if("reportInstanceArea".equalsIgnoreCase(attributeName))
            return reportInstanceArea;
        if("name".equalsIgnoreCase(attributeName))
            return name;
        if("sql".equalsIgnoreCase(attributeName))
            return sql;

        return null;
    }

    /**
    * @see pt.digitalis.utils.common.IBeanAttributes#setAttribute(java.lang.String, java.lang.Object)
    */
    public void setAttribute(String attributeName,Object attributeValue)
    {
        if("id".equalsIgnoreCase(attributeName))
            id =(Long)attributeValue;
        if("sqlDataSource".equalsIgnoreCase(attributeName))
            sqlDataSource =(SqlDataSource)attributeValue;
        if("reportInstanceArea".equalsIgnoreCase(attributeName))
            reportInstanceArea =(ReportInstanceArea)attributeValue;
        if("name".equalsIgnoreCase(attributeName))
            name =(String)attributeValue;
        if("sql".equalsIgnoreCase(attributeName))
            sql =(String)attributeValue;
    }

    // Fields

    /** id private attribute */
    private Long id;

    /** sqlDataSource private attribute */
    private SqlDataSource sqlDataSource;

    /** reportInstanceArea private attribute */
    private ReportInstanceArea reportInstanceArea;

    /** name private attribute */
    private String name;

    /** sql private attribute */
    private String sql;

    /** The pojo's primary key field list names */
    private static List<String> pkFieldList;

    /**
     * Get the table fields that compose the PK
     *
     * @return the PK field list
     */
     public synchronized static List<String> getPKFieldList()
     {
         if (pkFieldList == null)
         {
             pkFieldList = new ArrayList<String>();
             pkFieldList.add("id");
         }

         return pkFieldList;
     }

    /**
     * Get the table fields that compose the PK as a comma separated field name list
     *
     * @return the PK field list as a string
     */
     public static String getPKFieldListAsString()
     {
         StringBuffer buffer = new StringBuffer();

         for (int i = 0; i < getPKFieldList().size(); i++)
         {
             if (i != 0)
                 buffer.append(",");

             buffer.append(getPKFieldList().get(i));
         }

         return buffer.toString();
     }

    /**
     * Gets description field.
     *
     * @return the description field
     */
    @Override
    public String getDescriptionField()
    {
        return FieldAttributes.getDescriptionField();
    }

    /**
     * Get the table fields that compose the PK
     *
     * @return the PK field list
     */
    @Override
    public List<String> getPKFields()
    {
        return getPKFieldList();
    }

    /**
     * Is composite PK.
     *
     * @return the boolean
     */
    @Override
    public boolean isCompositePK()
    {
        return this.getPKFieldList().size() > 1;
    }

    /**
     * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeAsString(java.lang.String)
     */
     @Override
     public String getAttributeAsString(String attributeName)
     {
        if (attributeName.contains("."))
        {
            return this.getAttributeAsStringParseBeanPath(attributeName);
        }
        else
        {
            Object value = getAttribute(attributeName);

            if (value == null)
                return "";
            else {
                return value.toString().trim();
            }
        }
     }

    // Constructors

    /**
     * default constructor
     */
    public ReportInstanceAreaSql() {
    }

	/** 
	 * minimal constructor
	 *
     * @param reportInstanceArea the reportInstanceArea
     * @param name the name
     * @param sql the sql
    }
	 */
    public ReportInstanceAreaSql(ReportInstanceArea reportInstanceArea, String name, String sql) {
        this.reportInstanceArea = reportInstanceArea;
        this.name = name;
        this.sql = sql;
    }

    /**
     * full constructor
	 *
     * @param sqlDataSource the sqlDataSource
     * @param reportInstanceArea the reportInstanceArea
     * @param name the name
     * @param sql the sql
     */
    public ReportInstanceAreaSql(SqlDataSource sqlDataSource, ReportInstanceArea reportInstanceArea, String name, String sql) {
        this.sqlDataSource = sqlDataSource;
        this.reportInstanceArea = reportInstanceArea;
        this.name = name;
        this.sql = sql;
    }

    // Property accessors
    
    /**       
     * id getter method
     *
     * @return id method
     */
    public Long getId() {
        return this.id;
    }
    
    /**       
     * id setter method
     *
     * @param id the id
     *
     * @return ReportInstanceAreaSql modified instance
     */
    public ReportInstanceAreaSql setId(Long id) {
        this.id = id;
        
        return this;
    }
    /**       
     * sqlDataSource getter method
     *
     * @return sqlDataSource method
     */
    public SqlDataSource getSqlDataSource() {
        return this.sqlDataSource;
    }
    
    /**       
     * sqlDataSource setter method
     *
     * @param sqlDataSource the sqlDataSource
     *
     * @return ReportInstanceAreaSql modified instance
     */
    public ReportInstanceAreaSql setSqlDataSource(SqlDataSource sqlDataSource) {
        this.sqlDataSource = sqlDataSource;
        
        return this;
    }
    /**       
     * reportInstanceArea getter method
     *
     * @return reportInstanceArea method
     */
    public ReportInstanceArea getReportInstanceArea() {
        return this.reportInstanceArea;
    }
    
    /**       
     * reportInstanceArea setter method
     *
     * @param reportInstanceArea the reportInstanceArea
     *
     * @return ReportInstanceAreaSql modified instance
     */
    public ReportInstanceAreaSql setReportInstanceArea(ReportInstanceArea reportInstanceArea) {
        this.reportInstanceArea = reportInstanceArea;
        
        return this;
    }
    /**       
     * name getter method
     *
     * @return name method
     */
    public String getName() {
        return this.name;
    }
    
    /**       
     * name setter method
     *
     * @param name the name
     *
     * @return ReportInstanceAreaSql modified instance
     */
    public ReportInstanceAreaSql setName(String name) {
        this.name = name;
        
        return this;
    }
    /**       
     * sql getter method
     *
     * @return sql method
     */
    public String getSql() {
        return this.sql;
    }
    
    /**       
     * sql setter method
     *
     * @param sql the sql
     *
     * @return ReportInstanceAreaSql modified instance
     */
    public ReportInstanceAreaSql setSql(String sql) {
        this.sql = sql;
        
        return this;
    }

    /**
     * sqlDataSource id getter method
     *
     * @return sqlDataSource id method
     */
    public Long getSqlDataSourceId() {
        if (this.sqlDataSource == null)
            return null;
        else
            return this.sqlDataSource.getId();
    }

    /**
     * SqlDataSource proxy setter method from id.
     *
     * @return ReportInstanceAreaSql modified instance
     */
    public ReportInstanceAreaSql setSqlDataSourceProxyFromId(Long id)
    {
        if (id == null || id.equals(-1L))
            this.sqlDataSource = null;
        else
            this.sqlDataSource = SqlDataSource.getProxy(id);

        return this;
    }

    /**
     * SqlDataSource instance setter method from id.
     *
     * @return ReportInstanceAreaSql modified instance
     */
    public ReportInstanceAreaSql setSqlDataSourceInstanceFromId(Long id)
    {
        if (id == null || id.equals(-1L))
            this.sqlDataSource = null;
        else
            this.sqlDataSource = SqlDataSource.getInstance(id);

        return this;
    }
    /**
     * reportInstanceArea id getter method
     *
     * @return reportInstanceArea id method
     */
    public Long getReportInstanceAreaId() {
        if (this.reportInstanceArea == null)
            return null;
        else
            return this.reportInstanceArea.getId();
    }

    /**
     * ReportInstanceArea proxy setter method from id.
     *
     * @return ReportInstanceAreaSql modified instance
     */
    public ReportInstanceAreaSql setReportInstanceAreaProxyFromId(Long id)
    {
        if (id == null || id.equals(-1L))
            this.reportInstanceArea = null;
        else
            this.reportInstanceArea = ReportInstanceArea.getProxy(id);

        return this;
    }

    /**
     * ReportInstanceArea instance setter method from id.
     *
     * @return ReportInstanceAreaSql modified instance
     */
    public ReportInstanceAreaSql setReportInstanceAreaInstanceFromId(Long id)
    {
        if (id == null || id.equals(-1L))
            this.reportInstanceArea = null;
        else
            this.reportInstanceArea = ReportInstanceArea.getInstance(id);

        return this;
    }

    /**
     * Creates a String representation of the ReportInstanceAreaSql object
     *
     * @return the compiled String
     */
    @Override
    public String toString() {
	    StringBuffer buffer = new StringBuffer();

        buffer.append(getClass().getName()).append("@").append(Integer.toHexString(hashCode())).append(" [");

        buffer.append("id").append("='").append(getId()).append("' ");			
        buffer.append("name").append("='").append(getName()).append("' ");			
        buffer.append("sql").append("='").append(getSql()).append("' ");			
        buffer.append("]");
      
        return buffer.toString();
    }

    /**
     * Compares the String representation of the ReportInstanceAreaSql object
     *
     * @param other The object to compare to
     *
     * @return true of the objects are equal
     */
    public boolean equals(ReportInstanceAreaSql other) {
        	return this.toString().equals(other.toString());
    }
    /**
     * @see pt.digitalis.utils.common.IBeanAttributes#setAttributeFromString(java.lang.String, java.lang.String)
     */
    public void setAttributeFromString(String attributeName, String attributeValue) {
        if ("id".equalsIgnoreCase(attributeName))
            this.id = Long.valueOf(attributeValue);

        if ("name".equalsIgnoreCase(attributeName))
        	this.name = attributeValue;

        if ("sql".equalsIgnoreCase(attributeName))
        	this.sql = attributeValue;

    }


    /**
     * Instanciates an Hibernate proxy data object (does not load it from the database, provides lazy load for that)
     *
     * @param session the session
     * @param id      the id
     *
     * @return the proxy
     */
    public static ReportInstanceAreaSql getProxy(Session session, Long id)
    {
        return(ReportInstanceAreaSql)session.load(ReportInstanceAreaSql.class,id);
    }

    /**
    * Instanciates an Hibernate proxy data object (does not load it from the database, provides lazy load for that)
    *
    * @param id      the id
    *
    * @return the proxy
    */
    public static ReportInstanceAreaSql getProxy(Long id)
    {
        Session session = HibernateUtil.getSessionFactory(SESSION_FACTORY_NAME).getCurrentSession();
        boolean wasActive = session.getTransaction().isActive();

        if (!wasActive)
            session.beginTransaction();

        ReportInstanceAreaSql result = (ReportInstanceAreaSql)session.load(ReportInstanceAreaSql.class,id);

        if (!wasActive)
            session.getTransaction().commit();

        return result;
    }


    /**
     * Instanciates an Hibernate data object
     *
     * @param session the session
     * @param id      the id
     *
     * @return the instance
     */
    public static ReportInstanceAreaSql getInstanceForSession(Session session, Long id)
    {
        return(ReportInstanceAreaSql)session.get(ReportInstanceAreaSql.class,id);
    }

    /**
    * Instanciates an Hibernate data object
    *
    * @param id      the id
    *
    * @return the instance
    */
    public static ReportInstanceAreaSql getInstance(Long id)
    {
        Session session = HibernateUtil.getSessionFactory(SESSION_FACTORY_NAME).getCurrentSession();
        boolean wasActive = session.getTransaction().isActive();

        if (!wasActive)
            session.beginTransaction();

        ReportInstanceAreaSql result = (ReportInstanceAreaSql)session.get(ReportInstanceAreaSql.class,id);

        if (!wasActive)
            session.getTransaction().commit();

        return result;
    }

}
