package pt.digitalis.dif.dem.managers.impl.model.data;

import pt.digitalis.utils.common.AttributeDefinition;
import pt.digitalis.dif.model.utils.AbstractBeanAttributesDefinition;

import java.sql.Timestamp;
import java.sql.Blob;
import java.util.Date;
import java.math.BigDecimal;

import java.util.Arrays;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pt.digitalis.utils.common.collections.CaseInsensitiveHashMap;

import org.hibernate.Session;


/**
 *  Field definitions for data object {@link ReportInstanceAreaSql}
 *
 * NOTE: This file is auto generated and will be overwritten in a future file generation.
 */
public class ReportInstanceAreaSqlFieldAttributes extends AbstractBeanAttributesDefinition{

    /** id (Database column: ID - ID column) */
    static public AttributeDefinition id =
        new AttributeDefinition("id")
                .setDescription("ID column")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("REPORT_INSTANCE_AREA_SQL")
                .setDatabaseId("ID")
                .setMandatory(true)
                .setMaxSize(10)
                .setType(Long.class);

    /** name (Database column: NAME - the sql business name) */
    static public AttributeDefinition name =
        new AttributeDefinition("name")
                .setDescription("the sql business name")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("REPORT_INSTANCE_AREA_SQL")
                .setDatabaseId("NAME")
                .setMandatory(true)
                .setMaxSize(100)
                .setType(String.class);

    /** reportInstanceArea (Database column: REPORT_INSTANCE_AREA_ID - the report instance area ID) */
    static public AttributeDefinition reportInstanceArea =
        new AttributeDefinition("reportInstanceArea")
                .setDescription("the report instance area ID")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("REPORT_INSTANCE_AREA_SQL")
                .setDatabaseId("REPORT_INSTANCE_AREA_ID")
                .setMandatory(true)
                .setMaxSize(10)
                .setLovDataClass(pt.digitalis.dif.dem.managers.impl.model.data.ReportInstanceArea.class)
                .setLovDataClassKey("id")
                .setLovDataClassDescription("title")
                .setType(pt.digitalis.dif.dem.managers.impl.model.data.ReportInstanceArea.class);

    /** sql (Database column: SQL - the SQL query) */
    static public AttributeDefinition sql =
        new AttributeDefinition("sql")
                .setDescription("the SQL query")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("REPORT_INSTANCE_AREA_SQL")
                .setDatabaseId("SQL")
                .setMandatory(true)
                .setMaxSize(4000)
                .setType(String.class);

    /** sqlDataSource (Database column: SQL_DATA_SOURCE_ID - the data source ID) */
    static public AttributeDefinition sqlDataSource =
        new AttributeDefinition("sqlDataSource")
                .setDescription("the data source ID")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("REPORT_INSTANCE_AREA_SQL")
                .setDatabaseId("SQL_DATA_SOURCE_ID")
                .setMandatory(false)
                .setMaxSize(10)
                .setLovDataClass(pt.digitalis.dif.dem.managers.impl.model.data.SqlDataSource.class)
                .setLovDataClassKey("id")
                .setLovDataClassDescription("name")
                .setType(pt.digitalis.dif.dem.managers.impl.model.data.SqlDataSource.class);

    /**
     * Gets description field.
     *
     * @return the description field
     */
    public static String getDescriptionField()
    {
        return null;
    }

    /**
    * Create definitions map map.
    *
    * @return the map
    */
    @Override protected CaseInsensitiveHashMap<AttributeDefinition> createDefinitionsMap(){
        CaseInsensitiveHashMap<AttributeDefinition> map = new CaseInsensitiveHashMap<AttributeDefinition>();
        map.put(id.getName(),id);
        map.put(name.getName(),name);
        map.put(reportInstanceArea.getName(),reportInstanceArea);
        map.put(sql.getName(),sql);
        map.put(sqlDataSource.getName(),sqlDataSource);

        return map;
    }
}