package pt.digitalis.dif.dem.managers.impl.model.data;


import java.util.ArrayList;
import java.util.List;
import org.hibernate.Session;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.hibernate.HibernateUtil;
import pt.digitalis.dif.model.utils.AbstractBeanRelationsAttributes;
import pt.digitalis.dif.model.utils.IBeanAttributesDataSet;

/**
 * ReportInstanceAreaTrans
* Generated on ORM Generator
* DIF build process for the Model layer
*
*/
@SuppressWarnings("serial")
public class ReportInstanceAreaTrans extends AbstractBeanRelationsAttributes implements java.io.Serializable, IBeanAttributesDataSet<ReportInstanceAreaTrans> {

    /**
    * Constant with the session factory ID
    */
    public static String SESSION_FACTORY_NAME = "DIFRepository";

    /** ReportInstanceAreaTrans attributes enumeration */
    public static class Fields
    {
        /** id column */
        public static final String ID ="id";
        /** language column */
        public static final String LANGUAGE ="language";
        /** content column */
        public static final String CONTENT ="content";
        /** title column */
        public static final String TITLE ="title";

        /**
         * List of existing fields
         *
         * @return list of field names
         */
        public static List<String> values()
        {
            ArrayList<String> list = new ArrayList<String>();
            list.add("id");
            list.add("language");
            list.add("content");
            list.add("title");

            return list;
        }
    }

    /** Field attributes */
    public static ReportInstanceAreaTransFieldAttributes FieldAttributes=new ReportInstanceAreaTransFieldAttributes();

    /**
    * @return the field attributes definitions
    */
    @Override public ReportInstanceAreaTransFieldAttributes getDefinitions()
    {
        return FieldAttributes;
    }

    /**
     * The Class Relations.
     */
    public class Relations extends AbstractBeanRelationsAttributes.AbstractRelations
    {

        /**
        * Instantiates a new relations.
        *
        * @param currentPath the current path
        */
        public Relations(String currentPath)
        {
            super(currentPath);
        }
        /**
         * reportInstanceArea relation.
         *
         * @return the reportInstanceArea bean relations attributes.
         */
        public ReportInstanceArea.Relations reportInstanceArea()
        {
            ReportInstanceArea c = new ReportInstanceArea();
            return c.new Relations(this.buildPath("reportInstanceArea"));
        }

        /**
         * the ID path.
         *
         * @return the path
         */
        public String ID()
        {
            return buildPath(Fields.ID);
        }
        /**
         * the LANGUAGE path.
         *
         * @return the path
         */
        public String LANGUAGE()
        {
            return buildPath(Fields.LANGUAGE);
        }
        /**
         * the CONTENT path.
         *
         * @return the path
         */
        public String CONTENT()
        {
            return buildPath(Fields.CONTENT);
        }
        /**
         * the TITLE path.
         *
         * @return the path
         */
        public String TITLE()
        {
            return buildPath(Fields.TITLE);
        }
    }

    /** The dummy obj. */
    private static ReportInstanceAreaTrans dummyObj=new ReportInstanceAreaTrans();

    /**
     * Get ReportInstanceAreaTrans Relations .
     *
     * @return the relations
     */
    public static Relations FK()
    {
        return dummyObj.new Relations(null);
    }

    /**
    * Gets a new dataSet object for this bean
    *
    * @return the dataSet
    */
    public IDataSet<ReportInstanceAreaTrans> getDataSet()
    {
        return getDataSetInstance();
    }

    /**
    * Gets a new dataSet object for this bean
    *
    * @return the dataSet
    */
    public static IDataSet<ReportInstanceAreaTrans> getDataSetInstance()
    {
        return new HibernateDataSet<ReportInstanceAreaTrans>(ReportInstanceAreaTrans.class, HibernateUtil.getSessionFactory(SESSION_FACTORY_NAME),
            ReportInstanceAreaTrans.getPKFieldListAsString(), ReportInstanceAreaTrans.FieldAttributes);
    }

    /**
    * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeNoGraphNavigation(java.lang.String)
    */
    @Override protected Object getAttributeNoGraphNavigation(String attributeName)
    {
        if("id".equalsIgnoreCase(attributeName))
            return id;
        if("reportInstanceArea".equalsIgnoreCase(attributeName))
            return reportInstanceArea;
        if("language".equalsIgnoreCase(attributeName))
            return language;
        if("content".equalsIgnoreCase(attributeName))
            return content;
        if("title".equalsIgnoreCase(attributeName))
            return title;

        return null;
    }

    /**
    * @see pt.digitalis.utils.common.IBeanAttributes#setAttribute(java.lang.String, java.lang.Object)
    */
    public void setAttribute(String attributeName,Object attributeValue)
    {
        if("id".equalsIgnoreCase(attributeName))
            id =(Long)attributeValue;
        if("reportInstanceArea".equalsIgnoreCase(attributeName))
            reportInstanceArea =(ReportInstanceArea)attributeValue;
        if("language".equalsIgnoreCase(attributeName))
            language =(String)attributeValue;
        if("content".equalsIgnoreCase(attributeName))
            content =(String)attributeValue;
        if("title".equalsIgnoreCase(attributeName))
            title =(String)attributeValue;
    }

    // Fields

    /** id private attribute */
    private Long id;

    /** reportInstanceArea private attribute */
    private ReportInstanceArea reportInstanceArea;

    /** language private attribute */
    private String language;

    /** content private attribute */
    private String content;

    /** title private attribute */
    private String title;

    /** The pojo's primary key field list names */
    private static List<String> pkFieldList;

    /**
     * Get the table fields that compose the PK
     *
     * @return the PK field list
     */
     public synchronized static List<String> getPKFieldList()
     {
         if (pkFieldList == null)
         {
             pkFieldList = new ArrayList<String>();
             pkFieldList.add("id");
         }

         return pkFieldList;
     }

    /**
     * Get the table fields that compose the PK as a comma separated field name list
     *
     * @return the PK field list as a string
     */
     public static String getPKFieldListAsString()
     {
         StringBuffer buffer = new StringBuffer();

         for (int i = 0; i < getPKFieldList().size(); i++)
         {
             if (i != 0)
                 buffer.append(",");

             buffer.append(getPKFieldList().get(i));
         }

         return buffer.toString();
     }

    /**
     * Gets description field.
     *
     * @return the description field
     */
    @Override
    public String getDescriptionField()
    {
        return FieldAttributes.getDescriptionField();
    }

    /**
     * Get the table fields that compose the PK
     *
     * @return the PK field list
     */
    @Override
    public List<String> getPKFields()
    {
        return getPKFieldList();
    }

    /**
     * Is composite PK.
     *
     * @return the boolean
     */
    @Override
    public boolean isCompositePK()
    {
        return this.getPKFieldList().size() > 1;
    }

    /**
     * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeAsString(java.lang.String)
     */
     @Override
     public String getAttributeAsString(String attributeName)
     {
        if (attributeName.contains("."))
        {
            return this.getAttributeAsStringParseBeanPath(attributeName);
        }
        else
        {
            Object value = getAttribute(attributeName);

            if (value == null)
                return "";
            else {
                return value.toString().trim();
            }
        }
     }

    // Constructors

    /**
     * default constructor
     */
    public ReportInstanceAreaTrans() {
    }

	/** 
	 * minimal constructor
	 *
     * @param reportInstanceArea the reportInstanceArea
     * @param content the content
     * @param title the title
    }
	 */
    public ReportInstanceAreaTrans(ReportInstanceArea reportInstanceArea, String content, String title) {
        this.reportInstanceArea = reportInstanceArea;
        this.content = content;
        this.title = title;
    }

    /**
     * full constructor
	 *
     * @param reportInstanceArea the reportInstanceArea
     * @param language the language
     * @param content the content
     * @param title the title
     */
    public ReportInstanceAreaTrans(ReportInstanceArea reportInstanceArea, String language, String content, String title) {
        this.reportInstanceArea = reportInstanceArea;
        this.language = language;
        this.content = content;
        this.title = title;
    }

    // Property accessors
    
    /**       
     * id getter method
     *
     * @return id method
     */
    public Long getId() {
        return this.id;
    }
    
    /**       
     * id setter method
     *
     * @param id the id
     *
     * @return ReportInstanceAreaTrans modified instance
     */
    public ReportInstanceAreaTrans setId(Long id) {
        this.id = id;
        
        return this;
    }
    /**       
     * reportInstanceArea getter method
     *
     * @return reportInstanceArea method
     */
    public ReportInstanceArea getReportInstanceArea() {
        return this.reportInstanceArea;
    }
    
    /**       
     * reportInstanceArea setter method
     *
     * @param reportInstanceArea the reportInstanceArea
     *
     * @return ReportInstanceAreaTrans modified instance
     */
    public ReportInstanceAreaTrans setReportInstanceArea(ReportInstanceArea reportInstanceArea) {
        this.reportInstanceArea = reportInstanceArea;
        
        return this;
    }
    /**       
     * language getter method
     *
     * @return language method
     */
    public String getLanguage() {
        return this.language;
    }
    
    /**       
     * language setter method
     *
     * @param language the language
     *
     * @return ReportInstanceAreaTrans modified instance
     */
    public ReportInstanceAreaTrans setLanguage(String language) {
        this.language = language;
        
        return this;
    }
    /**       
     * content getter method
     *
     * @return content method
     */
    public String getContent() {
        return this.content;
    }
    
    /**       
     * content setter method
     *
     * @param content the content
     *
     * @return ReportInstanceAreaTrans modified instance
     */
    public ReportInstanceAreaTrans setContent(String content) {
        this.content = content;
        
        return this;
    }
    /**       
     * title getter method
     *
     * @return title method
     */
    public String getTitle() {
        return this.title;
    }
    
    /**       
     * title setter method
     *
     * @param title the title
     *
     * @return ReportInstanceAreaTrans modified instance
     */
    public ReportInstanceAreaTrans setTitle(String title) {
        this.title = title;
        
        return this;
    }

    /**
     * reportInstanceArea id getter method
     *
     * @return reportInstanceArea id method
     */
    public Long getReportInstanceAreaId() {
        if (this.reportInstanceArea == null)
            return null;
        else
            return this.reportInstanceArea.getId();
    }

    /**
     * ReportInstanceArea proxy setter method from id.
     *
     * @return ReportInstanceAreaTrans modified instance
     */
    public ReportInstanceAreaTrans setReportInstanceAreaProxyFromId(Long id)
    {
        if (id == null || id.equals(-1L))
            this.reportInstanceArea = null;
        else
            this.reportInstanceArea = ReportInstanceArea.getProxy(id);

        return this;
    }

    /**
     * ReportInstanceArea instance setter method from id.
     *
     * @return ReportInstanceAreaTrans modified instance
     */
    public ReportInstanceAreaTrans setReportInstanceAreaInstanceFromId(Long id)
    {
        if (id == null || id.equals(-1L))
            this.reportInstanceArea = null;
        else
            this.reportInstanceArea = ReportInstanceArea.getInstance(id);

        return this;
    }

    /**
     * Creates a String representation of the ReportInstanceAreaTrans object
     *
     * @return the compiled String
     */
    @Override
    public String toString() {
	    StringBuffer buffer = new StringBuffer();

        buffer.append(getClass().getName()).append("@").append(Integer.toHexString(hashCode())).append(" [");

        buffer.append("id").append("='").append(getId()).append("' ");			
        buffer.append("language").append("='").append(getLanguage()).append("' ");			
        buffer.append("content").append("='").append(getContent()).append("' ");			
        buffer.append("title").append("='").append(getTitle()).append("' ");			
        buffer.append("]");
      
        return buffer.toString();
    }

    /**
     * Compares the String representation of the ReportInstanceAreaTrans object
     *
     * @param other The object to compare to
     *
     * @return true of the objects are equal
     */
    public boolean equals(ReportInstanceAreaTrans other) {
        	return this.toString().equals(other.toString());
    }
    /**
     * @see pt.digitalis.utils.common.IBeanAttributes#setAttributeFromString(java.lang.String, java.lang.String)
     */
    public void setAttributeFromString(String attributeName, String attributeValue) {
        if ("id".equalsIgnoreCase(attributeName))
            this.id = Long.valueOf(attributeValue);

        if ("language".equalsIgnoreCase(attributeName))
        	this.language = attributeValue;

        if ("content".equalsIgnoreCase(attributeName))
        	this.content = attributeValue;

        if ("title".equalsIgnoreCase(attributeName))
        	this.title = attributeValue;

    }


    /**
     * Instanciates an Hibernate proxy data object (does not load it from the database, provides lazy load for that)
     *
     * @param session the session
     * @param id      the id
     *
     * @return the proxy
     */
    public static ReportInstanceAreaTrans getProxy(Session session, Long id)
    {
        return(ReportInstanceAreaTrans)session.load(ReportInstanceAreaTrans.class,id);
    }

    /**
    * Instanciates an Hibernate proxy data object (does not load it from the database, provides lazy load for that)
    *
    * @param id      the id
    *
    * @return the proxy
    */
    public static ReportInstanceAreaTrans getProxy(Long id)
    {
        Session session = HibernateUtil.getSessionFactory(SESSION_FACTORY_NAME).getCurrentSession();
        boolean wasActive = session.getTransaction().isActive();

        if (!wasActive)
            session.beginTransaction();

        ReportInstanceAreaTrans result = (ReportInstanceAreaTrans)session.load(ReportInstanceAreaTrans.class,id);

        if (!wasActive)
            session.getTransaction().commit();

        return result;
    }


    /**
     * Instanciates an Hibernate data object
     *
     * @param session the session
     * @param id      the id
     *
     * @return the instance
     */
    public static ReportInstanceAreaTrans getInstanceForSession(Session session, Long id)
    {
        return(ReportInstanceAreaTrans)session.get(ReportInstanceAreaTrans.class,id);
    }

    /**
    * Instanciates an Hibernate data object
    *
    * @param id      the id
    *
    * @return the instance
    */
    public static ReportInstanceAreaTrans getInstance(Long id)
    {
        Session session = HibernateUtil.getSessionFactory(SESSION_FACTORY_NAME).getCurrentSession();
        boolean wasActive = session.getTransaction().isActive();

        if (!wasActive)
            session.beginTransaction();

        ReportInstanceAreaTrans result = (ReportInstanceAreaTrans)session.get(ReportInstanceAreaTrans.class,id);

        if (!wasActive)
            session.getTransaction().commit();

        return result;
    }

}
