package pt.digitalis.dif.dem.managers.impl.model.data;


import java.sql.Blob;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hibernate.Session;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.hibernate.HibernateUtil;
import pt.digitalis.dif.model.utils.AbstractBeanRelationsAttributes;
import pt.digitalis.dif.model.utils.IBeanAttributesDataSet;

/**
 * ReportTemplate
* Generated on ORM Generator
* DIF build process for the Model layer
*
*/
@SuppressWarnings("serial")
public class ReportTemplate extends AbstractBeanRelationsAttributes implements java.io.Serializable, IBeanAttributesDataSet<ReportTemplate> {

    /**
    * Constant with the session factory ID
    */
    public static String SESSION_FACTORY_NAME = "DIFRepository";

    /** ReportTemplate attributes enumeration */
    public static class Fields
    {
        /** id column */
        public static final String ID ="id";
        /** name column */
        public static final String NAME ="name";
        /** description column */
        public static final String DESCRIPTION ="description";
        /** type column */
        public static final String TYPE ="type";
        /** enabled column */
        public static final String ENABLED ="enabled";
        /** templateUrl column */
        public static final String TEMPLATEURL ="templateUrl";
        /** templateFiles column */
        public static final String TEMPLATEFILES ="templateFiles";
        /** contextClassId column */
        public static final String CONTEXTCLASSID ="contextClassId";

        /**
         * List of existing fields
         *
         * @return list of field names
         */
        public static List<String> values()
        {
            ArrayList<String> list = new ArrayList<String>();
            list.add("id");
            list.add("name");
            list.add("description");
            list.add("type");
            list.add("enabled");
            list.add("templateUrl");
            list.add("templateFiles");
            list.add("contextClassId");

            return list;
        }
    }

    /** Field attributes */
    public static ReportTemplateFieldAttributes FieldAttributes=new ReportTemplateFieldAttributes();

    /**
    * @return the field attributes definitions
    */
    @Override public ReportTemplateFieldAttributes getDefinitions()
    {
        return FieldAttributes;
    }

    /**
     * The Class Relations.
     */
    public class Relations extends AbstractBeanRelationsAttributes.AbstractRelations
    {

        /**
        * Instantiates a new relations.
        *
        * @param currentPath the current path
        */
        public Relations(String currentPath)
        {
            super(currentPath);
        }
        /**
         * reportInstances relation.
         *
         * @return the reportInstances bean relations attributes.
         */
        public ReportInstance.Relations reportInstances()
        {
            ReportInstance c = new ReportInstance();
            return c.new Relations(this.buildPath("reportInstances"));
        }

        /**
         * reportTemplateAreas relation.
         *
         * @return the reportTemplateAreas bean relations attributes.
         */
        public ReportTemplateArea.Relations reportTemplateAreas()
        {
            ReportTemplateArea c = new ReportTemplateArea();
            return c.new Relations(this.buildPath("reportTemplateAreas"));
        }

        /**
         * the ID path.
         *
         * @return the path
         */
        public String ID()
        {
            return buildPath(Fields.ID);
        }
        /**
         * the NAME path.
         *
         * @return the path
         */
        public String NAME()
        {
            return buildPath(Fields.NAME);
        }
        /**
         * the DESCRIPTION path.
         *
         * @return the path
         */
        public String DESCRIPTION()
        {
            return buildPath(Fields.DESCRIPTION);
        }
        /**
         * the TYPE path.
         *
         * @return the path
         */
        public String TYPE()
        {
            return buildPath(Fields.TYPE);
        }
        /**
         * the ENABLED path.
         *
         * @return the path
         */
        public String ENABLED()
        {
            return buildPath(Fields.ENABLED);
        }
        /**
         * the TEMPLATEURL path.
         *
         * @return the path
         */
        public String TEMPLATEURL()
        {
            return buildPath(Fields.TEMPLATEURL);
        }
        /**
         * the TEMPLATEFILES path.
         *
         * @return the path
         */
        public String TEMPLATEFILES()
        {
            return buildPath(Fields.TEMPLATEFILES);
        }
        /**
         * the CONTEXTCLASSID path.
         *
         * @return the path
         */
        public String CONTEXTCLASSID()
        {
            return buildPath(Fields.CONTEXTCLASSID);
        }
    }

    /** The dummy obj. */
    private static ReportTemplate dummyObj=new ReportTemplate();

    /**
     * Get ReportTemplate Relations .
     *
     * @return the relations
     */
    public static Relations FK()
    {
        return dummyObj.new Relations(null);
    }

    /**
    * Gets a new dataSet object for this bean
    *
    * @return the dataSet
    */
    public IDataSet<ReportTemplate> getDataSet()
    {
        return getDataSetInstance();
    }

    /**
    * Gets a new dataSet object for this bean
    *
    * @return the dataSet
    */
    public static IDataSet<ReportTemplate> getDataSetInstance()
    {
        return new HibernateDataSet<ReportTemplate>(ReportTemplate.class, HibernateUtil.getSessionFactory(SESSION_FACTORY_NAME),
            ReportTemplate.getPKFieldListAsString(), ReportTemplate.FieldAttributes);
    }

    /**
    * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeNoGraphNavigation(java.lang.String)
    */
    @Override protected Object getAttributeNoGraphNavigation(String attributeName)
    {
        if("id".equalsIgnoreCase(attributeName))
            return id;
        if("name".equalsIgnoreCase(attributeName))
            return name;
        if("description".equalsIgnoreCase(attributeName))
            return description;
        if("type".equalsIgnoreCase(attributeName))
            return type;
        if("enabled".equalsIgnoreCase(attributeName))
            return enabled;
        if("templateUrl".equalsIgnoreCase(attributeName))
            return templateUrl;
        if("templateFiles".equalsIgnoreCase(attributeName))
            return templateFiles;
        if("contextClassId".equalsIgnoreCase(attributeName))
            return contextClassId;
        if("reportInstances".equalsIgnoreCase(attributeName))
            return reportInstances;
        if("reportTemplateAreas".equalsIgnoreCase(attributeName))
            return reportTemplateAreas;

        return null;
    }

    /**
    * @see pt.digitalis.utils.common.IBeanAttributes#setAttribute(java.lang.String, java.lang.Object)
    */
    public void setAttribute(String attributeName,Object attributeValue)
    {
        if("id".equalsIgnoreCase(attributeName))
            id =(Long)attributeValue;
        if("name".equalsIgnoreCase(attributeName))
            name =(String)attributeValue;
        if("description".equalsIgnoreCase(attributeName))
            description =(String)attributeValue;
        if("type".equalsIgnoreCase(attributeName))
            type =(String)attributeValue;
        if("enabled".equalsIgnoreCase(attributeName))
            enabled =(Boolean)attributeValue;
        if("templateUrl".equalsIgnoreCase(attributeName))
            templateUrl =(String)attributeValue;
        if("templateFiles".equalsIgnoreCase(attributeName))
            templateFiles =(Blob)attributeValue;
        if("contextClassId".equalsIgnoreCase(attributeName))
            contextClassId =(String)attributeValue;
        if("reportInstances".equalsIgnoreCase(attributeName))
            reportInstances =(Set<ReportInstance>)attributeValue;
        if("reportTemplateAreas".equalsIgnoreCase(attributeName))
            reportTemplateAreas =(Set<ReportTemplateArea>)attributeValue;
    }

    // Fields

    /** id private attribute */
    private Long id;

    /** name private attribute */
    private String name;

    /** description private attribute */
    private String description;

    /** type private attribute */
    private String type;

    /** enabled private attribute */
    private boolean enabled;

    /** templateUrl private attribute */
    private String templateUrl;

    /** templateFiles private attribute */
    private Blob templateFiles;

    /** contextClassId private attribute */
    private String contextClassId;

    /** reportInstances private attribute */
    private Set<ReportInstance> reportInstances = new HashSet<ReportInstance>(0);

    /** reportTemplateAreas private attribute */
    private Set<ReportTemplateArea> reportTemplateAreas = new HashSet<ReportTemplateArea>(0);

    /** The pojo's primary key field list names */
    private static List<String> pkFieldList;

    /**
     * Get the table fields that compose the PK
     *
     * @return the PK field list
     */
     public synchronized static List<String> getPKFieldList()
     {
         if (pkFieldList == null)
         {
             pkFieldList = new ArrayList<String>();
             pkFieldList.add("id");
         }

         return pkFieldList;
     }

    /**
     * Get the table fields that compose the PK as a comma separated field name list
     *
     * @return the PK field list as a string
     */
     public static String getPKFieldListAsString()
     {
         StringBuffer buffer = new StringBuffer();

         for (int i = 0; i < getPKFieldList().size(); i++)
         {
             if (i != 0)
                 buffer.append(",");

             buffer.append(getPKFieldList().get(i));
         }

         return buffer.toString();
     }

    /**
     * Gets description field.
     *
     * @return the description field
     */
    @Override
    public String getDescriptionField()
    {
        return FieldAttributes.getDescriptionField();
    }

    /**
     * Get the table fields that compose the PK
     *
     * @return the PK field list
     */
    @Override
    public List<String> getPKFields()
    {
        return getPKFieldList();
    }

    /**
     * Is composite PK.
     *
     * @return the boolean
     */
    @Override
    public boolean isCompositePK()
    {
        return this.getPKFieldList().size() > 1;
    }

    /**
     * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeAsString(java.lang.String)
     */
     @Override
     public String getAttributeAsString(String attributeName)
     {
        if (attributeName.contains("."))
        {
            return this.getAttributeAsStringParseBeanPath(attributeName);
        }
        else
        {
            Object value = getAttribute(attributeName);

            if (value == null)
                return "";
            else {
                return value.toString().trim();
            }
        }
     }

    // Constructors

    /**
     * default constructor
     */
    public ReportTemplate() {
    }

	/** 
	 * minimal constructor
	 *
     * @param name the name
     * @param type the type
     * @param enabled the enabled
    }
	 */
    public ReportTemplate(String name, String type, boolean enabled) {
        this.name = name;
        this.type = type;
        this.enabled = enabled;
    }

    /**
     * full constructor
	 *
     * @param name the name
     * @param description the description
     * @param type the type
     * @param enabled the enabled
     * @param templateUrl the templateUrl
     * @param templateFiles the templateFiles
     * @param contextClassId the contextClassId
     * @param reportInstances the reportInstances
     * @param reportTemplateAreas the reportTemplateAreas
     */
    public ReportTemplate(String name, String description, String type, boolean enabled, String templateUrl, Blob templateFiles, String contextClassId, Set<ReportInstance> reportInstances, Set<ReportTemplateArea> reportTemplateAreas) {
        this.name = name;
        this.description = description;
        this.type = type;
        this.enabled = enabled;
        this.templateUrl = templateUrl;
        this.templateFiles = templateFiles;
        this.contextClassId = contextClassId;
        this.reportInstances = reportInstances;
        this.reportTemplateAreas = reportTemplateAreas;
    }

    // Property accessors
    
    /**       
     * id getter method
     *
     * @return id method
     */
    public Long getId() {
        return this.id;
    }
    
    /**       
     * id setter method
     *
     * @param id the id
     *
     * @return ReportTemplate modified instance
     */
    public ReportTemplate setId(Long id) {
        this.id = id;
        
        return this;
    }
    /**       
     * name getter method
     *
     * @return name method
     */
    public String getName() {
        return this.name;
    }
    
    /**       
     * name setter method
     *
     * @param name the name
     *
     * @return ReportTemplate modified instance
     */
    public ReportTemplate setName(String name) {
        this.name = name;
        
        return this;
    }
    /**       
     * description getter method
     *
     * @return description method
     */
    public String getDescription() {
        return this.description;
    }
    
    /**       
     * description setter method
     *
     * @param description the description
     *
     * @return ReportTemplate modified instance
     */
    public ReportTemplate setDescription(String description) {
        this.description = description;
        
        return this;
    }
    /**       
     * type getter method
     *
     * @return type method
     */
    public String getType() {
        return this.type;
    }
    
    /**       
     * type setter method
     *
     * @param type the type
     *
     * @return ReportTemplate modified instance
     */
    public ReportTemplate setType(String type) {
        this.type = type;
        
        return this;
    }
    /**       
     * enabled getter method
     *
     * @return enabled method
     */
    public boolean isEnabled() {
        return this.enabled;
    }
    
    /**       
     * enabled setter method
     *
     * @param enabled the enabled
     *
     * @return ReportTemplate modified instance
     */
    public ReportTemplate setEnabled(boolean enabled) {
        this.enabled = enabled;
        
        return this;
    }
    /**       
     * templateUrl getter method
     *
     * @return templateUrl method
     */
    public String getTemplateUrl() {
        return this.templateUrl;
    }
    
    /**       
     * templateUrl setter method
     *
     * @param templateUrl the templateUrl
     *
     * @return ReportTemplate modified instance
     */
    public ReportTemplate setTemplateUrl(String templateUrl) {
        this.templateUrl = templateUrl;
        
        return this;
    }
    /**       
     * templateFiles getter method
     *
     * @return templateFiles method
     */
    public Blob getTemplateFiles() {
        return this.templateFiles;
    }
    
    /**       
     * templateFiles setter method
     *
     * @param templateFiles the templateFiles
     *
     * @return ReportTemplate modified instance
     */
    public ReportTemplate setTemplateFiles(Blob templateFiles) {
        this.templateFiles = templateFiles;
        
        return this;
    }
    /**       
     * contextClassId getter method
     *
     * @return contextClassId method
     */
    public String getContextClassId() {
        return this.contextClassId;
    }
    
    /**       
     * contextClassId setter method
     *
     * @param contextClassId the contextClassId
     *
     * @return ReportTemplate modified instance
     */
    public ReportTemplate setContextClassId(String contextClassId) {
        this.contextClassId = contextClassId;
        
        return this;
    }
    /**       
     * reportInstances getter method
     *
     * @return reportInstances method
     */
    public Set<ReportInstance> getReportInstances() {
        return this.reportInstances;
    }
    
    /**       
     * reportInstances setter method
     *
     * @param reportInstances the reportInstances
     *
     * @return ReportTemplate modified instance
     */
    public ReportTemplate setReportInstances(Set<ReportInstance> reportInstances) {
        this.reportInstances = reportInstances;
        
        return this;
    }
    /**       
     * reportTemplateAreas getter method
     *
     * @return reportTemplateAreas method
     */
    public Set<ReportTemplateArea> getReportTemplateAreas() {
        return this.reportTemplateAreas;
    }
    
    /**       
     * reportTemplateAreas setter method
     *
     * @param reportTemplateAreas the reportTemplateAreas
     *
     * @return ReportTemplate modified instance
     */
    public ReportTemplate setReportTemplateAreas(Set<ReportTemplateArea> reportTemplateAreas) {
        this.reportTemplateAreas = reportTemplateAreas;
        
        return this;
    }


    /**
     * Creates a String representation of the ReportTemplate object
     *
     * @return the compiled String
     */
    @Override
    public String toString() {
	    StringBuffer buffer = new StringBuffer();

        buffer.append(getClass().getName()).append("@").append(Integer.toHexString(hashCode())).append(" [");

        buffer.append("id").append("='").append(getId()).append("' ");			
        buffer.append("name").append("='").append(getName()).append("' ");			
        buffer.append("description").append("='").append(getDescription()).append("' ");			
        buffer.append("type").append("='").append(getType()).append("' ");			
        buffer.append("enabled").append("='").append(isEnabled()).append("' ");			
        buffer.append("templateUrl").append("='").append(getTemplateUrl()).append("' ");			
        buffer.append("templateFiles").append("='").append(getTemplateFiles()).append("' ");			
        buffer.append("contextClassId").append("='").append(getContextClassId()).append("' ");			
        buffer.append("]");
      
        return buffer.toString();
    }

    /**
     * Compares the String representation of the ReportTemplate object
     *
     * @param other The object to compare to
     *
     * @return true of the objects are equal
     */
    public boolean equals(ReportTemplate other) {
        	return this.toString().equals(other.toString());
    }
    /**
     * @see pt.digitalis.utils.common.IBeanAttributes#setAttributeFromString(java.lang.String, java.lang.String)
     */
    public void setAttributeFromString(String attributeName, String attributeValue) {
        if ("id".equalsIgnoreCase(attributeName))
            this.id = Long.valueOf(attributeValue);

        if ("name".equalsIgnoreCase(attributeName))
        	this.name = attributeValue;

        if ("description".equalsIgnoreCase(attributeName))
        	this.description = attributeValue;

        if ("type".equalsIgnoreCase(attributeName))
        	this.type = attributeValue;

        if ("enabled".equalsIgnoreCase(attributeName))
            this.enabled = Boolean.valueOf(attributeValue);

        if ("templateUrl".equalsIgnoreCase(attributeName))
        	this.templateUrl = attributeValue;

        if ("contextClassId".equalsIgnoreCase(attributeName))
        	this.contextClassId = attributeValue;

    }


    /**
     * Instanciates an Hibernate proxy data object (does not load it from the database, provides lazy load for that)
     *
     * @param session the session
     * @param id      the id
     *
     * @return the proxy
     */
    public static ReportTemplate getProxy(Session session, Long id)
    {
        return(ReportTemplate)session.load(ReportTemplate.class,id);
    }

    /**
    * Instanciates an Hibernate proxy data object (does not load it from the database, provides lazy load for that)
    *
    * @param id      the id
    *
    * @return the proxy
    */
    public static ReportTemplate getProxy(Long id)
    {
        Session session = HibernateUtil.getSessionFactory(SESSION_FACTORY_NAME).getCurrentSession();
        boolean wasActive = session.getTransaction().isActive();

        if (!wasActive)
            session.beginTransaction();

        ReportTemplate result = (ReportTemplate)session.load(ReportTemplate.class,id);

        if (!wasActive)
            session.getTransaction().commit();

        return result;
    }


    /**
     * Instanciates an Hibernate data object
     *
     * @param session the session
     * @param id      the id
     *
     * @return the instance
     */
    public static ReportTemplate getInstanceForSession(Session session, Long id)
    {
        return(ReportTemplate)session.get(ReportTemplate.class,id);
    }

    /**
    * Instanciates an Hibernate data object
    *
    * @param id      the id
    *
    * @return the instance
    */
    public static ReportTemplate getInstance(Long id)
    {
        Session session = HibernateUtil.getSessionFactory(SESSION_FACTORY_NAME).getCurrentSession();
        boolean wasActive = session.getTransaction().isActive();

        if (!wasActive)
            session.beginTransaction();

        ReportTemplate result = (ReportTemplate)session.get(ReportTemplate.class,id);

        if (!wasActive)
            session.getTransaction().commit();

        return result;
    }

}
