package pt.digitalis.dif.dem.managers.impl.model.data;

import pt.digitalis.utils.common.AttributeDefinition;
import pt.digitalis.dif.model.utils.AbstractBeanAttributesDefinition;

import java.sql.Timestamp;
import java.sql.Blob;
import java.util.Date;
import java.math.BigDecimal;

import java.util.Arrays;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pt.digitalis.utils.common.collections.CaseInsensitiveHashMap;

import org.hibernate.Session;


/**
 *  Field definitions for data object {@link ReportTemplate}
 *
 * NOTE: This file is auto generated and will be overwritten in a future file generation.
 */
public class ReportTemplateFieldAttributes extends AbstractBeanAttributesDefinition{

    /** contextClassId (Database column: CONTEXT_CLASS_ID - the id of the context class implementation to provide resources and rules to this report) */
    static public AttributeDefinition contextClassId =
        new AttributeDefinition("contextClassId")
                .setDescription("the id of the context class implementation to provide resources and rules to this report")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("REPORT_TEMPLATE")
                .setDatabaseId("CONTEXT_CLASS_ID")
                .setMandatory(false)
                .setMaxSize(100)
                .setType(String.class);

    /** description (Database column: DESCRIPTION - the report description) */
    static public AttributeDefinition description =
        new AttributeDefinition("description")
                .setDescription("the report description")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("REPORT_TEMPLATE")
                .setDatabaseId("DESCRIPTION")
                .setMandatory(false)
                .setMaxSize(2000)
                .setType(String.class);

    /** enabled (Database column: ENABLED - is the report is enabled) */
    static public AttributeDefinition enabled =
        new AttributeDefinition("enabled")
                .setDescription("is the report is enabled")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("REPORT_TEMPLATE")
                .setDatabaseId("ENABLED")
                .setMandatory(true)
                .setMaxSize(1)
                .setTreatAsBoolean(true)
                .setBooleanFalseValue("0")
                .setBooleanTrueValue("1")
                .setLovFixedList(Arrays.asList(new String[]{"1","0"}))
                .setType(boolean.class);

    /** id (Database column: ID - ID column) */
    static public AttributeDefinition id =
        new AttributeDefinition("id")
                .setDescription("ID column")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("REPORT_TEMPLATE")
                .setDatabaseId("ID")
                .setMandatory(true)
                .setMaxSize(10)
                .setType(Long.class);

    /** name (Database column: NAME - The report name) */
    static public AttributeDefinition name =
        new AttributeDefinition("name")
                .setDescription("The report name")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("REPORT_TEMPLATE")
                .setDatabaseId("NAME")
                .setMandatory(true)
                .setMaxSize(200)
                .setType(String.class);

    /** templateFiles (Database column: TEMPLATE_FILES - a zip file with the report template and it's assets) */
    static public AttributeDefinition templateFiles =
        new AttributeDefinition("templateFiles")
                .setDescription("a zip file with the report template and it's assets")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("REPORT_TEMPLATE")
                .setDatabaseId("TEMPLATE_FILES")
                .setMandatory(false)
                .setMaxSize(4000)
                .setType(Blob.class);

    /** templateUrl (Database column: TEMPLATE_URL - the report template URL) */
    static public AttributeDefinition templateUrl =
        new AttributeDefinition("templateUrl")
                .setDescription("the report template URL")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("REPORT_TEMPLATE")
                .setDatabaseId("TEMPLATE_URL")
                .setMandatory(false)
                .setMaxSize(2000)
                .setType(String.class);

    /** type (Database column: TYPE - the report type) */
    static public AttributeDefinition type =
        new AttributeDefinition("type")
                .setDescription("the report type")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("REPORT_TEMPLATE")
                .setDatabaseId("TYPE")
                .setMandatory(true)
                .setMaxSize(2)
                .setType(String.class);

    /**
     * Gets description field.
     *
     * @return the description field
     */
    public static String getDescriptionField()
    {
        return "name";
    }

    /**
    * Create definitions map map.
    *
    * @return the map
    */
    @Override protected CaseInsensitiveHashMap<AttributeDefinition> createDefinitionsMap(){
        CaseInsensitiveHashMap<AttributeDefinition> map = new CaseInsensitiveHashMap<AttributeDefinition>();
        map.put(contextClassId.getName(),contextClassId);
        map.put(description.getName(),description);
        map.put(enabled.getName(),enabled);
        map.put(id.getName(),id);
        map.put(name.getName(),name);
        map.put(templateFiles.getName(),templateFiles);
        map.put(templateUrl.getName(),templateUrl);
        map.put(type.getName(),type);

        return map;
    }
}