package pt.digitalis.dif.dem.managers.impl.model.data;


import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.Session;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.hibernate.HibernateUtil;
import pt.digitalis.dif.model.utils.AbstractBeanRelationsAttributes;
import pt.digitalis.dif.model.utils.IBeanAttributesDataSet;

/**
 * ServerActivityLog
* Generated on ORM Generator
* DIF build process for the Model layer
*
*/
@SuppressWarnings("serial")
public class ServerActivityLog extends AbstractBeanRelationsAttributes implements java.io.Serializable, IBeanAttributesDataSet<ServerActivityLog> {

    /**
    * Constant with the session factory ID
    */
    public static String SESSION_FACTORY_NAME = "DIFRepository";

    /** ServerActivityLog attributes enumeration */
    public static class Fields
    {
        /** id column */
        public static final String ID ="id";
        /** bootTime column */
        public static final String BOOTTIME ="bootTime";
        /** lastSync column */
        public static final String LASTSYNC ="lastSync";

        /**
         * List of existing fields
         *
         * @return list of field names
         */
        public static List<String> values()
        {
            ArrayList<String> list = new ArrayList<String>();
            list.add("id");
            list.add("bootTime");
            list.add("lastSync");

            return list;
        }
    }

    /** Field attributes */
    public static ServerActivityLogFieldAttributes FieldAttributes=new ServerActivityLogFieldAttributes();

    /**
    * @return the field attributes definitions
    */
    @Override public ServerActivityLogFieldAttributes getDefinitions()
    {
        return FieldAttributes;
    }

    /**
     * The Class Relations.
     */
    public class Relations extends AbstractBeanRelationsAttributes.AbstractRelations
    {

        /**
        * Instantiates a new relations.
        *
        * @param currentPath the current path
        */
        public Relations(String currentPath)
        {
            super(currentPath);
        }
        /**
         * server relation.
         *
         * @return the server bean relations attributes.
         */
        public Server.Relations server()
        {
            Server c = new Server();
            return c.new Relations(this.buildPath("server"));
        }

        /**
         * the ID path.
         *
         * @return the path
         */
        public String ID()
        {
            return buildPath(Fields.ID);
        }
        /**
         * the BOOTTIME path.
         *
         * @return the path
         */
        public String BOOTTIME()
        {
            return buildPath(Fields.BOOTTIME);
        }
        /**
         * the LASTSYNC path.
         *
         * @return the path
         */
        public String LASTSYNC()
        {
            return buildPath(Fields.LASTSYNC);
        }
    }

    /** The dummy obj. */
    private static ServerActivityLog dummyObj=new ServerActivityLog();

    /**
     * Get ServerActivityLog Relations .
     *
     * @return the relations
     */
    public static Relations FK()
    {
        return dummyObj.new Relations(null);
    }

    /**
    * Gets a new dataSet object for this bean
    *
    * @return the dataSet
    */
    public IDataSet<ServerActivityLog> getDataSet()
    {
        return getDataSetInstance();
    }

    /**
    * Gets a new dataSet object for this bean
    *
    * @return the dataSet
    */
    public static IDataSet<ServerActivityLog> getDataSetInstance()
    {
        return new HibernateDataSet<ServerActivityLog>(ServerActivityLog.class, HibernateUtil.getSessionFactory(SESSION_FACTORY_NAME),
            ServerActivityLog.getPKFieldListAsString(), ServerActivityLog.FieldAttributes);
    }

    /**
    * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeNoGraphNavigation(java.lang.String)
    */
    @Override protected Object getAttributeNoGraphNavigation(String attributeName)
    {
        if("id".equalsIgnoreCase(attributeName))
            return id;
        if("server".equalsIgnoreCase(attributeName))
            return server;
        if("bootTime".equalsIgnoreCase(attributeName))
            return bootTime;
        if("lastSync".equalsIgnoreCase(attributeName))
            return lastSync;

        return null;
    }

    /**
    * @see pt.digitalis.utils.common.IBeanAttributes#setAttribute(java.lang.String, java.lang.Object)
    */
    public void setAttribute(String attributeName,Object attributeValue)
    {
        if("id".equalsIgnoreCase(attributeName))
            id =(Long)attributeValue;
        if("server".equalsIgnoreCase(attributeName))
            server =(Server)attributeValue;
        if("bootTime".equalsIgnoreCase(attributeName))
            bootTime =(Timestamp)attributeValue;
        if("lastSync".equalsIgnoreCase(attributeName))
            lastSync =(Timestamp)attributeValue;
    }

    // Fields

    /** id private attribute */
    private Long id;

    /** server private attribute */
    private Server server;

    /** bootTime private attribute */
    private Timestamp bootTime;

    /** lastSync private attribute */
    private Timestamp lastSync;

    /** The pojo's primary key field list names */
    private static List<String> pkFieldList;

    /**
     * Get the table fields that compose the PK
     *
     * @return the PK field list
     */
     public synchronized static List<String> getPKFieldList()
     {
         if (pkFieldList == null)
         {
             pkFieldList = new ArrayList<String>();
             pkFieldList.add("id");
         }

         return pkFieldList;
     }

    /**
     * Get the table fields that compose the PK as a comma separated field name list
     *
     * @return the PK field list as a string
     */
     public static String getPKFieldListAsString()
     {
         StringBuffer buffer = new StringBuffer();

         for (int i = 0; i < getPKFieldList().size(); i++)
         {
             if (i != 0)
                 buffer.append(",");

             buffer.append(getPKFieldList().get(i));
         }

         return buffer.toString();
     }

    /**
     * Gets description field.
     *
     * @return the description field
     */
    @Override
    public String getDescriptionField()
    {
        return FieldAttributes.getDescriptionField();
    }

    /**
     * Get the table fields that compose the PK
     *
     * @return the PK field list
     */
    @Override
    public List<String> getPKFields()
    {
        return getPKFieldList();
    }

    /**
     * Is composite PK.
     *
     * @return the boolean
     */
    @Override
    public boolean isCompositePK()
    {
        return this.getPKFieldList().size() > 1;
    }

    /**
     * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeAsString(java.lang.String)
     */
     @Override
     public String getAttributeAsString(String attributeName)
     {
        if (attributeName.contains("."))
        {
            return this.getAttributeAsStringParseBeanPath(attributeName);
        }
        else
        {
            Object value = getAttribute(attributeName);

            if (value == null)
                return "";
            else {
                return value.toString().trim();
            }
        }
     }

    // Constructors

    /**
     * default constructor
     */
    public ServerActivityLog() {
    }


    /**
     * full constructor
	 *
     * @param server the server
     * @param bootTime the bootTime
     * @param lastSync the lastSync
     */
    public ServerActivityLog(Server server, Timestamp bootTime, Timestamp lastSync) {
        this.server = server;
        this.bootTime = bootTime;
        this.lastSync = lastSync;
    }

    // Property accessors
    
    /**       
     * id getter method
     *
     * @return id method
     */
    public Long getId() {
        return this.id;
    }
    
    /**       
     * id setter method
     *
     * @param id the id
     *
     * @return ServerActivityLog modified instance
     */
    public ServerActivityLog setId(Long id) {
        this.id = id;
        
        return this;
    }
    /**       
     * server getter method
     *
     * @return server method
     */
    public Server getServer() {
        return this.server;
    }
    
    /**       
     * server setter method
     *
     * @param server the server
     *
     * @return ServerActivityLog modified instance
     */
    public ServerActivityLog setServer(Server server) {
        this.server = server;
        
        return this;
    }
    /**       
     * bootTime getter method
     *
     * @return bootTime method
     */
    public Timestamp getBootTime() {
        return this.bootTime;
    }
    
    /**       
     * bootTime setter method
     *
     * @param bootTime the bootTime
     *
     * @return ServerActivityLog modified instance
     */
    public ServerActivityLog setBootTime(Timestamp bootTime) {
        this.bootTime = bootTime;
        
        return this;
    }
    /**       
     * lastSync getter method
     *
     * @return lastSync method
     */
    public Timestamp getLastSync() {
        return this.lastSync;
    }
    
    /**       
     * lastSync setter method
     *
     * @param lastSync the lastSync
     *
     * @return ServerActivityLog modified instance
     */
    public ServerActivityLog setLastSync(Timestamp lastSync) {
        this.lastSync = lastSync;
        
        return this;
    }

    /**
     * server id getter method
     *
     * @return server id method
     */
    public Long getServerId() {
        if (this.server == null)
            return null;
        else
            return this.server.getId();
    }

    /**
     * Server proxy setter method from id.
     *
     * @return ServerActivityLog modified instance
     */
    public ServerActivityLog setServerProxyFromId(Long id)
    {
        if (id == null || id.equals(-1L))
            this.server = null;
        else
            this.server = Server.getProxy(id);

        return this;
    }

    /**
     * Server instance setter method from id.
     *
     * @return ServerActivityLog modified instance
     */
    public ServerActivityLog setServerInstanceFromId(Long id)
    {
        if (id == null || id.equals(-1L))
            this.server = null;
        else
            this.server = Server.getInstance(id);

        return this;
    }

    /**
     * Creates a String representation of the ServerActivityLog object
     *
     * @return the compiled String
     */
    @Override
    public String toString() {
	    StringBuffer buffer = new StringBuffer();

        buffer.append(getClass().getName()).append("@").append(Integer.toHexString(hashCode())).append(" [");

        buffer.append("id").append("='").append(getId()).append("' ");			
        buffer.append("bootTime").append("='").append(getBootTime()).append("' ");			
        buffer.append("lastSync").append("='").append(getLastSync()).append("' ");			
        buffer.append("]");
      
        return buffer.toString();
    }

    /**
     * Compares the String representation of the ServerActivityLog object
     *
     * @param other The object to compare to
     *
     * @return true of the objects are equal
     */
    public boolean equals(ServerActivityLog other) {
        	return this.toString().equals(other.toString());
    }
    /**
     * @see pt.digitalis.utils.common.IBeanAttributes#setAttributeFromString(java.lang.String, java.lang.String)
     */
    public void setAttributeFromString(String attributeName, String attributeValue) {
        if ("id".equalsIgnoreCase(attributeName))
            this.id = Long.valueOf(attributeValue);

        if ("bootTime".equalsIgnoreCase(attributeName))
            this.bootTime = Timestamp.valueOf(attributeValue);

        if ("lastSync".equalsIgnoreCase(attributeName))
            this.lastSync = Timestamp.valueOf(attributeValue);

    }


    /**
     * Instanciates an Hibernate proxy data object (does not load it from the database, provides lazy load for that)
     *
     * @param session the session
     * @param id      the id
     *
     * @return the proxy
     */
    public static ServerActivityLog getProxy(Session session, Long id)
    {
        return(ServerActivityLog)session.load(ServerActivityLog.class,id);
    }

    /**
    * Instanciates an Hibernate proxy data object (does not load it from the database, provides lazy load for that)
    *
    * @param id      the id
    *
    * @return the proxy
    */
    public static ServerActivityLog getProxy(Long id)
    {
        Session session = HibernateUtil.getSessionFactory(SESSION_FACTORY_NAME).getCurrentSession();
        boolean wasActive = session.getTransaction().isActive();

        if (!wasActive)
            session.beginTransaction();

        ServerActivityLog result = (ServerActivityLog)session.load(ServerActivityLog.class,id);

        if (!wasActive)
            session.getTransaction().commit();

        return result;
    }


    /**
     * Instanciates an Hibernate data object
     *
     * @param session the session
     * @param id      the id
     *
     * @return the instance
     */
    public static ServerActivityLog getInstanceForSession(Session session, Long id)
    {
        return(ServerActivityLog)session.get(ServerActivityLog.class,id);
    }

    /**
    * Instanciates an Hibernate data object
    *
    * @param id      the id
    *
    * @return the instance
    */
    public static ServerActivityLog getInstance(Long id)
    {
        Session session = HibernateUtil.getSessionFactory(SESSION_FACTORY_NAME).getCurrentSession();
        boolean wasActive = session.getTransaction().isActive();

        if (!wasActive)
            session.beginTransaction();

        ServerActivityLog result = (ServerActivityLog)session.get(ServerActivityLog.class,id);

        if (!wasActive)
            session.getTransaction().commit();

        return result;
    }

}
