package pt.digitalis.dif.dem.managers.impl.model.data;

import pt.digitalis.utils.common.AttributeDefinition;
import pt.digitalis.dif.model.utils.AbstractBeanAttributesDefinition;

import java.sql.Timestamp;
import java.sql.Blob;
import java.util.Date;
import java.math.BigDecimal;

import java.util.Arrays;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pt.digitalis.utils.common.collections.CaseInsensitiveHashMap;

import org.hibernate.Session;


/**
 *  Field definitions for data object {@link ServerActivityLog}
 *
 * NOTE: This file is auto generated and will be overwritten in a future file generation.
 */
public class ServerActivityLogFieldAttributes extends AbstractBeanAttributesDefinition{

    /** bootTime (Database column: BOOT_TIME - Server startup time stamp) */
    static public AttributeDefinition bootTime =
        new AttributeDefinition("bootTime")
                .setDescription("Server startup time stamp")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("SERVER_ACTIVITY_LOG")
                .setDatabaseId("BOOT_TIME")
                .setMandatory(true)
                .setMaxSize(7)
                .setType(Timestamp.class);

    /** id (Database column: ID - ID) */
    static public AttributeDefinition id =
        new AttributeDefinition("id")
                .setDescription("ID")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("SERVER_ACTIVITY_LOG")
                .setDatabaseId("ID")
                .setMandatory(true)
                .setMaxSize(10)
                .setType(Long.class);

    /** lastSync (Database column: LAST_SYNC - Last sync done by the server) */
    static public AttributeDefinition lastSync =
        new AttributeDefinition("lastSync")
                .setDescription("Last sync done by the server")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("SERVER_ACTIVITY_LOG")
                .setDatabaseId("LAST_SYNC")
                .setMandatory(true)
                .setMaxSize(7)
                .setType(Timestamp.class);

    /** server (Database column: SERVER_ID - The server ID) */
    static public AttributeDefinition server =
        new AttributeDefinition("server")
                .setDescription("The server ID")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("SERVER_ACTIVITY_LOG")
                .setDatabaseId("SERVER_ID")
                .setMandatory(true)
                .setMaxSize(10)
                .setLovDataClass(pt.digitalis.dif.dem.managers.impl.model.data.Server.class)
                .setLovDataClassKey("id")
                .setLovDataClassDescription("name")
                .setType(pt.digitalis.dif.dem.managers.impl.model.data.Server.class);

    /**
     * Gets description field.
     *
     * @return the description field
     */
    public static String getDescriptionField()
    {
        return null;
    }

    /**
    * Create definitions map map.
    *
    * @return the map
    */
    @Override protected CaseInsensitiveHashMap<AttributeDefinition> createDefinitionsMap(){
        CaseInsensitiveHashMap<AttributeDefinition> map = new CaseInsensitiveHashMap<AttributeDefinition>();
        map.put(bootTime.getName(),bootTime);
        map.put(id.getName(),id);
        map.put(lastSync.getName(),lastSync);
        map.put(server.getName(),server);

        return map;
    }
}